/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.element.spi.AbstractSpatialElement;
import iskallia.vault.client.gui.framework.element.spi.IGuiEventElement;
import iskallia.vault.client.gui.framework.element.spi.IRenderedElement;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import java.awt.Color;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class ColorPickerElement
extends AbstractSpatialElement<ColorPickerElement>
implements IRenderedElement,
IGuiEventElement {
    private float hue = 0.0f;
    private float saturation = 1.0f;
    private float brightness = 1.0f;
    private boolean visible = true;
    private boolean initialized = false;
    private boolean hueSliderDragging = false;
    private boolean colorPlaneDragging = false;
    private final Consumer<Color> onColorChanged;
    private final Supplier<Color> colorSupplier;
    private ISpatial hueSpatial;
    private ISpatial colorPlaneSpatial;
    private ISpatial previewSpatial;
    private final int HUE_BAR_WIDTH = 15;
    private final int PREVIEW_HEIGHT = 15;
    private final int PADDING = 2;

    public ColorPickerElement(ISpatial spatial, Supplier<Color> colorSupplier, Consumer<Color> onColorChanged) {
        super(spatial);
        this.colorSupplier = colorSupplier;
        this.onColorChanged = onColorChanged;
        this.updateSubElementBounds();
        this.updateHSBFromColor(colorSupplier.get());
    }

    private void updateHSBFromColor(Color color) {
        if (color != null) {
            float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            this.hue = hsb[0];
            this.saturation = hsb[1];
            this.brightness = hsb[2];
        }
    }

    public void updateFromColor(Color color) {
        if (color != null) {
            this.updateHSBFromColor(color);
        }
    }

    private void updateSubElementBounds() {
        ISpatial mainSpatial = this.getWorldSpatial();
        int x = mainSpatial.x();
        int y = mainSpatial.y();
        int width = mainSpatial.width();
        int height = mainSpatial.height();
        int z = mainSpatial.z();
        int colorPlaneWidth = width - 15 - 2;
        int colorPlaneHeight = height - 15 - 2;
        this.colorPlaneSpatial = Spatials.positionXYZ(x, y, z).size(colorPlaneWidth, colorPlaneHeight);
        this.hueSpatial = Spatials.positionXYZ(x + colorPlaneWidth + 2, y, z).size(15, colorPlaneHeight);
        this.previewSpatial = Spatials.positionXYZ(x, y + colorPlaneHeight + 2, z).size(width, 15);
    }

    private Color getColorFromHSB() {
        return new Color(Color.HSBtoRGB(this.hue, this.saturation, this.brightness));
    }

    private void updateColor() {
        this.onColorChanged.accept(this.getColorFromHSB());
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        ISpatial spatial = this.getWorldSpatial();
        if (mouseX >= (double)spatial.x() && mouseX < (double)(spatial.x() + spatial.width()) && mouseY >= (double)spatial.y() && mouseY < (double)(spatial.y() + spatial.height())) {
            return true;
        }
        return this.colorPlaneSpatial.contains(mouseX, mouseY) || this.hueSpatial.contains(mouseX, mouseY) || this.previewSpatial.contains(mouseX, mouseY);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int buttonIndex) {
        if (!this.isVisible()) {
            return false;
        }
        if (this.hueSpatial.contains(mouseX, mouseY)) {
            this.hueSliderDragging = true;
            this.updateHueFromMouse(mouseY);
            this.playClickSound();
            return true;
        }
        if (this.colorPlaneSpatial.contains(mouseX, mouseY)) {
            this.colorPlaneDragging = true;
            this.updateSaturationBrightnessFromMouse(mouseX, mouseY);
            this.playClickSound();
            return true;
        }
        return this.containsMouse(mouseX, mouseY);
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int buttonIndex) {
        boolean wasDragging = this.hueSliderDragging || this.colorPlaneDragging;
        this.hueSliderDragging = false;
        this.colorPlaneDragging = false;
        if (wasDragging) {
            this.playClickSound();
            return true;
        }
        return this.containsMouse(mouseX, mouseY);
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int buttonIndex, double dragX, double dragY) {
        if (this.hueSliderDragging) {
            this.updateHueFromMouse(mouseY);
            return true;
        }
        if (this.colorPlaneDragging) {
            this.updateSaturationBrightnessFromMouse(mouseX, mouseY);
            return true;
        }
        return false;
    }

    private void updateHueFromMouse(double mouseY) {
        float relativeY = (float)(mouseY - (double)this.hueSpatial.y()) / (float)this.hueSpatial.height();
        this.hue = 1.0f - Mth.m_14036_((float)relativeY, (float)0.0f, (float)1.0f);
        this.updateColor();
    }

    private void updateSaturationBrightnessFromMouse(double mouseX, double mouseY) {
        float relativeX = (float)(mouseX - (double)this.colorPlaneSpatial.x()) / (float)this.colorPlaneSpatial.width();
        float relativeY = (float)(mouseY - (double)this.colorPlaneSpatial.y()) / (float)this.colorPlaneSpatial.height();
        this.saturation = Mth.m_14036_((float)relativeX, (float)0.0f, (float)1.0f);
        this.brightness = 1.0f - Mth.m_14036_((float)relativeY, (float)0.0f, (float)1.0f);
        this.updateColor();
    }

    private void playClickSound() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
    }

    @Override
    public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.initialized) {
            this.updateSubElementBounds();
            this.initialized = true;
            return;
        }
        IMutableSpatial borderSpatial = Spatials.copy(this.getWorldSpatial());
        ScreenRenderers.getImmediate().renderColoredQuad(poseStack, -10066330, borderSpatial);
        this.renderColorPlane(poseStack);
        this.renderHueBar(poseStack);
        this.renderColorPreview(poseStack);
        this.renderSelectors(poseStack);
        this.updateSubElementBounds();
    }

    private void renderColorPlane(PoseStack poseStack) {
        int width = this.colorPlaneSpatial.width();
        int height = this.colorPlaneSpatial.height();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float s = (float)x / (float)width;
                float b = 1.0f - (float)y / (float)height;
                Color pixelColor = new Color(Color.HSBtoRGB(this.hue, s, b));
                IMutableSpatial pixelSpatial = Spatials.positionXYZ(this.colorPlaneSpatial.x() + x, this.colorPlaneSpatial.y() + y, this.colorPlaneSpatial.z()).size(1, 1);
                ScreenRenderers.getImmediate().renderColoredQuad(poseStack, pixelColor.getRGB(), pixelSpatial);
            }
        }
    }

    private void renderHueBar(PoseStack poseStack) {
        int height = this.hueSpatial.height();
        for (int y = 0; y < height; ++y) {
            float h = 1.0f - (float)y / (float)height;
            Color hueColor = new Color(Color.HSBtoRGB(h, 1.0f, 1.0f));
            IMutableSpatial barSegmentSpatial = Spatials.positionXYZ(this.hueSpatial.x(), this.hueSpatial.y() + y, this.hueSpatial.z()).size(this.hueSpatial.width(), 1);
            ScreenRenderers.getImmediate().renderColoredQuad(poseStack, hueColor.getRGB(), barSegmentSpatial);
        }
    }

    private void renderColorPreview(PoseStack poseStack) {
        Color currentColor = this.getColorFromHSB();
        ScreenRenderers.getImmediate().renderColoredQuad(poseStack, currentColor.getRGB(), this.previewSpatial);
    }

    private void renderSelectors(PoseStack poseStack) {
        int hueY = this.hueSpatial.y() + (int)((1.0f - this.hue) * (float)this.hueSpatial.height());
        IMutableSpatial hueSelector = Spatials.positionXYZ(this.hueSpatial.x() - 2, hueY - 1, this.hueSpatial.z() + 1).size(this.hueSpatial.width() + 4, 3);
        ScreenRenderers.getImmediate().renderColoredQuad(poseStack, Color.BLACK.getRGB(), hueSelector);
        ScreenRenderers.getImmediate().renderColoredQuad(poseStack, Color.WHITE.getRGB(), Spatials.positionXYZ(hueSelector.x() + 1, hueSelector.y() + 1, hueSelector.z() + 1).size(hueSelector.width() - 2, hueSelector.height() - 2));
        int sbX = this.colorPlaneSpatial.x() + (int)(this.saturation * (float)this.colorPlaneSpatial.width());
        int sbY = this.colorPlaneSpatial.y() + (int)((1.0f - this.brightness) * (float)this.colorPlaneSpatial.height());
        IMutableSpatial sbSelectorH = Spatials.positionXYZ(sbX - 2, sbY - 1, this.colorPlaneSpatial.z() + 1).size(5, 3);
        IMutableSpatial sbSelectorV = Spatials.positionXYZ(sbX - 1, sbY - 2, this.colorPlaneSpatial.z() + 1).size(3, 5);
        ScreenRenderers.getImmediate().renderColoredQuad(poseStack, Color.BLACK.getRGB(), sbSelectorH);
        ScreenRenderers.getImmediate().renderColoredQuad(poseStack, Color.BLACK.getRGB(), sbSelectorV);
        ScreenRenderers.getImmediate().renderColoredQuad(poseStack, Color.WHITE.getRGB(), Spatials.positionXYZ(sbSelectorH.x() + 1, sbSelectorH.y() + 1, sbSelectorH.z() + 1).size(sbSelectorH.width() - 2, sbSelectorH.height() - 2));
        ScreenRenderers.getImmediate().renderColoredQuad(poseStack, Color.WHITE.getRGB(), Spatials.positionXYZ(sbSelectorV.x() + 1, sbSelectorV.y() + 1, sbSelectorV.z() + 1).size(sbSelectorV.width() - 2, sbSelectorV.height() - 2));
    }

    public Color getCurrentColor() {
        return this.getColorFromHSB();
    }
}

