/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.block.TransmogTableBlock;
import iskallia.vault.client.gui.framework.element.FakeItemSlotElement;
import iskallia.vault.client.gui.framework.element.ScrollableItemStackSelectorElement;
import iskallia.vault.client.gui.framework.render.TooltipDirection;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.dynamodel.DynamicModel;
import iskallia.vault.dynamodel.model.armor.ArmorPieceModel;
import iskallia.vault.dynamodel.registry.DynamicModelRegistry;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.util.IskalliaDevs;
import iskallia.vault.util.SideOnlyFixer;
import iskallia.vault.util.function.ObservableSupplier;
import iskallia.vault.www.Reward;
import iskallia.vault.www.RewardsManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class DiscoveredModelSelectElement<E extends DiscoveredModelSelectElement<E>>
extends ScrollableItemStackSelectorElement<E, TransmogModelEntry> {
    protected int columns;
    protected ObservableSupplier<ItemStack> gearItem;
    protected ObservableSupplier<Set<ResourceLocation>> discoveredModelIds;

    public DiscoveredModelSelectElement(ISpatial spatial, int columns, Supplier<ItemStack> gearItem, ObservableSupplier<Set<ResourceLocation>> discoveredModelIds, Consumer<ResourceLocation> onModelSelected) {
        super((ISpatial)Spatials.copy(spatial), columns, new DiscoveredModelSelectorModel(ObservableSupplier.of(gearItem, SideOnlyFixer::stackEqualExact), discoveredModelIds, onModelSelected));
        this.columns = columns;
        this.gearItem = ObservableSupplier.of(gearItem, SideOnlyFixer::stackEqualExact);
        this.discoveredModelIds = discoveredModelIds;
    }

    @Override
    public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.render(renderer, poseStack, mouseX, mouseY, partialTick);
        this.gearItem.ifChanged(item -> {
            this.verticalScrollBarElement.setValue(0.0f);
            this.refreshElements();
        });
        this.discoveredModelIds.ifChanged(models -> this.refreshElements());
    }

    public static class DiscoveredModelSelectorModel
    extends ScrollableItemStackSelectorElement.SelectorModel<TransmogModelEntry> {
        private final ObservableSupplier<ItemStack> usedItem;
        private final ObservableSupplier<Set<ResourceLocation>> discoveredModelIds;
        private final Consumer<ResourceLocation> onModelSelected;

        public DiscoveredModelSelectorModel(ObservableSupplier<ItemStack> usedItem, ObservableSupplier<Set<ResourceLocation>> discoveredModelIds, Consumer<ResourceLocation> onModelSelected) {
            this.usedItem = usedItem;
            this.discoveredModelIds = discoveredModelIds;
            this.onModelSelected = onModelSelected;
        }

        @Override
        public List<TransmogModelEntry> getEntries() {
            ItemStack stack = this.usedItem.get();
            Item item = stack.m_41720_();
            if (!(item instanceof VaultGearItem)) {
                return Collections.emptyList();
            }
            VaultGearItem vaultGearItem = (VaultGearItem)item;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return Collections.emptyList();
            }
            Set<ResourceLocation> discoveredIds = this.discoveredModelIds.get();
            return ModDynamicModels.REGISTRIES.getAssociatedRegistry(vaultGearItem.getItem()).map(arg_0 -> this.lambda$getEntries$3(discoveredIds, stack, (Player)player, vaultGearItem, arg_0)).orElse(Collections.emptyList());
        }

        private Reward.ArmorPiece getRewardType(VaultGearItem item) {
            if (item == ModItems.SWORD) {
                return Reward.ArmorPiece.SWORD;
            }
            if (item == ModItems.AXE) {
                return Reward.ArmorPiece.AXE;
            }
            if (item == ModItems.WAND) {
                return Reward.ArmorPiece.WAND;
            }
            if (item == ModItems.FOCUS) {
                return Reward.ArmorPiece.FOCUS;
            }
            if (item == ModItems.SHIELD) {
                return Reward.ArmorPiece.SHIELD;
            }
            if (item == ModItems.MAGNET) {
                return Reward.ArmorPiece.MAGNET;
            }
            return Reward.ArmorPiece.ARMOR;
        }

        private ItemStack makeModelItem(VaultGearItem item, ResourceLocation modelId) {
            ItemStack stack = item.defaultItem();
            VaultGearData gearData = VaultGearData.read(stack);
            gearData.setState(VaultGearState.IDENTIFIED);
            gearData.createOrReplaceAttributeValue(ModGearAttributes.GEAR_MODEL, modelId);
            gearData.write(stack);
            return stack;
        }

        @Override
        public void onSelect(FakeItemSlotElement<?> slot, TransmogModelEntry entry) {
            super.onSelect(slot, entry);
            this.onModelSelected.accept(entry.getModelId());
        }

        private /* synthetic */ List lambda$getEntries$3(Set discoveredIds, ItemStack stack, Player player, VaultGearItem vaultGearItem, DynamicModelRegistry modelRegistry) {
            ArrayList<ResourceLocation> modelIds = new ArrayList<ResourceLocation>(modelRegistry.getIds());
            modelIds.sort((id1, id2) -> {
                VaultGearRarity rarity2;
                boolean special2;
                boolean discovered2;
                boolean discovered1 = discoveredIds.contains(id1);
                if (discovered1 != (discovered2 = discoveredIds.contains(id2))) {
                    return discovered1 ? -1 : 1;
                }
                boolean special1 = ModConfigs.GEAR_MODEL_ROLL_RARITIES.canAppearNormally(stack, (ResourceLocation)id1);
                if (special1 != (special2 = ModConfigs.GEAR_MODEL_ROLL_RARITIES.canAppearNormally(stack, (ResourceLocation)id2))) {
                    return special1 ? -1 : 1;
                }
                VaultGearRarity rarity1 = ModConfigs.GEAR_MODEL_ROLL_RARITIES.getRarityOf(stack, (ResourceLocation)id1);
                if (rarity1 != (rarity2 = ModConfigs.GEAR_MODEL_ROLL_RARITIES.getRarityOf(stack, (ResourceLocation)id2))) {
                    return Integer.compare(rarity1.ordinal(), rarity2.ordinal());
                }
                String name1 = modelRegistry.get((ResourceLocation)id1).map(DynamicModel::getDisplayName).orElse("");
                String name2 = modelRegistry.get((ResourceLocation)id2).map(DynamicModel::getDisplayName).orElse("");
                return name1.compareTo(name2);
            });
            Reward rewards = RewardsManager.getInstance().getRewardData(player.m_142081_());
            Reward.ArmorPiece rewardType = this.getRewardType(vaultGearItem);
            boolean dev = IskalliaDevs.isDeveloper(player.m_142081_());
            return modelIds.stream().map(modelRegistry::get).filter(Optional::isPresent).map(Optional::get).filter(model -> {
                ArmorPieceModel armorPieceModel;
                if (model instanceof ArmorPieceModel ? !(armorPieceModel = (ArmorPieceModel)model).getArmorModel().getModelProperties().doesAllowTransmogrification() : !model.getModelProperties().doesAllowTransmogrification()) {
                    return false;
                }
                if (model.getModelProperties().doesRequireRewards() && !dev) {
                    return rewards.hasModel(rewardType, model.getId());
                }
                return true;
            }).map(model -> new TransmogModelEntry(this.makeModelItem(vaultGearItem, model.getId()), !TransmogTableBlock.canTransmogModel(player, discoveredIds, model.getId()), (DynamicModel)model)).toList();
        }
    }

    public static class TransmogModelEntry
    extends ScrollableItemStackSelectorElement.ItemSelectorEntry {
        private final DynamicModel model;

        public TransmogModelEntry(ItemStack displayStack, boolean isDisabled, DynamicModel model) {
            super(displayStack, isDisabled);
            this.model = model;
        }

        public ResourceLocation getModelId() {
            return this.model.getId();
        }

        @Override
        public void adjustSlot(FakeItemSlotElement<?> slot) {
            slot.tooltip((tooltipRenderer, poseStack, mouseX, mouseY, tooltipFlag) -> {
                Item patt9746$temp = this.getDisplayStack().m_41720_();
                if (!(patt9746$temp instanceof VaultGearItem)) {
                    return true;
                }
                VaultGearItem vaultGearItem = (VaultGearItem)patt9746$temp;
                VaultGearRarity rarity = ModConfigs.GEAR_MODEL_ROLL_RARITIES.getRarityOf(this.getDisplayStack(), this.model.getId());
                if (this.isDisabled()) {
                    tooltipRenderer.renderTooltip(poseStack, (Component)new TextComponent("Undiscovered").m_130948_(Style.f_131099_.m_131148_(rarity.getColor()).m_131155_(Boolean.valueOf(true))), mouseX, mouseY, TooltipDirection.RIGHT);
                    return true;
                }
                TextComponent cmp = new TextComponent(this.model.getDisplayName());
                cmp.m_130948_(Style.f_131099_.m_131148_(rarity.getColor()));
                tooltipRenderer.renderTooltip(poseStack, (Component)cmp, mouseX, mouseY, TooltipDirection.RIGHT);
                return true;
            });
        }
    }
}

