/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import iskallia.vault.VaultMod;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ContainerElement;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.NineSliceButtonElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.VerticalScrollClipContainer;
import iskallia.vault.client.gui.framework.screen.layout.ScreenLayout;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class DropdownElement<E extends DropdownElement<E>>
extends ContainerElement<E> {
    private final NineSliceElement<?> mainButtonBg;
    private final LabelElement<?> mainButtonLabel;
    private final DropdownListElement<?> listElement;
    private boolean isExpanded = false;
    private String selectedValue;
    private final Consumer<String> onSelect;
    private final List<String> options;

    public DropdownElement(ISpatial spatial, List<String> options, Consumer<String> onSelect) {
        super(spatial);
        this.options = options;
        this.onSelect = onSelect;
        this.selectedValue = options.isEmpty() ? "" : options.get(0);
        this.mainButtonBg = new NineSliceElement(Spatials.positionXY(0, 0).size(spatial.width(), 15), ScreenTextures.INSET_BLACK_BACKGROUND);
        int n = spatial.width() / 2 - Minecraft.m_91087_().f_91062_.m_92895_(this.selectedValue) / 2;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        this.mainButtonLabel = new LabelElement((IPosition)Spatials.positionXYZ(n, 7 - 9 / 2, 1).size(spatial.width(), 15), (Component)new TextComponent(this.selectedValue).m_130940_(ChatFormatting.WHITE), LabelTextStyle.defaultStyle().center());
        this.listElement = new DropdownListElement((ISpatial)Spatials.positionXYZ(0, 15, 10).size(spatial.width(), Math.min(options.size() * 20, 100)), options, this::selectOption);
        this.addElement(this.mainButtonBg);
        this.addElement(this.mainButtonLabel);
        this.listElement.setVisible(false);
        this.addElement(this.listElement);
    }

    private void toggleDropdown() {
        this.isExpanded = !this.isExpanded;
        this.listElement.setVisible(this.isExpanded);
        ScreenLayout.requestLayout();
    }

    private void selectOption(String option) {
        this.selectedValue = option;
        VaultMod.LOGGER.info("Selected option: {}", (Object)option);
        this.onSelect.accept(option);
        this.toggleDropdown();
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int buttonIndex) {
        if (this.mainButtonBg.getWorldSpatial().contains(mouseX, mouseY)) {
            this.toggleDropdown();
            return true;
        }
        if (this.listElement.onMouseClicked(mouseX, mouseY, buttonIndex)) {
            return true;
        }
        return super.onMouseClicked(mouseX, mouseY, buttonIndex);
    }

    private static class DropdownListElement<E extends DropdownListElement<E>>
    extends VerticalScrollClipContainer<E> {
        public DropdownListElement(ISpatial spatial, List<String> options, Consumer<String> onSelect) {
            super(spatial);
            int y = 0;
            for (String option : options) {
                Object button = new NineSliceButtonElement(Spatials.positionXYZ(0, y, 1).size(this.innerWidth(), 20), ScreenTextures.BUTTON_EMPTY_GREEN_TEXTURES, () -> {
                    VaultMod.LOGGER.info("Selected option: {}", (Object)option);
                    onSelect.accept(option);
                }).label(() -> new TextComponent(option), LabelTextStyle.defaultStyle().center());
                ((NineSliceButtonElement)button).setDisabled(false);
                this.addElement(button);
                y += 20;
            }
        }
    }
}

