/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ElasticContainerElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.render.NineSlice;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.dynamodel.model.armor.ArmorLayers;
import iskallia.vault.dynamodel.model.armor.ArmorPieceModel;
import iskallia.vault.dynamodel.registry.DynamicModelRegistry;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.renderer.VaultArmorRenderProperties;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.item.gear.VaultArmorItem;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GearModelPreviewElement<E extends GearModelPreviewElement<E>>
extends ElasticContainerElement<E> {
    protected Supplier<ItemStack> gearStack;

    public GearModelPreviewElement(IPosition position, ISize size, Supplier<ItemStack> gearStack) {
        this(position, size, gearStack, ScreenTextures.INSET_BLACK_BACKGROUND);
    }

    public GearModelPreviewElement(IPosition position, ISize size, Supplier<ItemStack> gearStack, @Nullable NineSlice.TextureRegion region) {
        super(Spatials.positionXYZ(position).size(size));
        this.gearStack = gearStack;
        if (region != null) {
            this.addElement(new NineSliceElement(Spatials.size(size), region));
        }
    }

    @Override
    public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.render(renderer, poseStack, mouseX, mouseY, partialTick);
        ItemStack itemStack = this.gearStack.get();
        Item item = itemStack.m_41720_();
        if (item instanceof VaultArmorItem) {
            poseStack.m_85836_();
            this.renderArmorPiece(itemStack);
            poseStack.m_85849_();
        } else {
            this.renderItemStack(itemStack);
        }
    }

    private void renderArmorPiece(ItemStack armorStack) {
        VaultGearData gearData;
        ArmorPieceModel armorPiece;
        Minecraft minecraft = Minecraft.m_91087_();
        MultiBufferSource.BufferSource multiBufferSource = minecraft.m_91269_().m_110104_();
        ISpatial worldSpatial = this.getWorldSpatial();
        int playerRenderX = worldSpatial.x() + worldSpatial.width() / 2;
        int playerRenderY = worldSpatial.y() + (worldSpatial.height() - 16);
        PoseStack poseStack2 = new PoseStack();
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack modelPoseStack = RenderSystem.m_157191_();
        modelPoseStack.m_85836_();
        modelPoseStack.m_85837_((double)playerRenderX, (double)playerRenderY, 350.0);
        modelPoseStack.m_85841_(16.0f, 16.0f, 16.0f);
        RenderSystem.m_157182_();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        double rotation = -90.0 * ((double)System.currentTimeMillis() / 1000.0) % 360.0 * (Math.PI / 180);
        poseStack2.m_85845_(Quaternion.m_175228_((float)-0.3925f, (float)((float)rotation), (float)0.0f));
        Optional<DynamicModelRegistry<?>> modelRegistry = ModDynamicModels.REGISTRIES.getAssociatedRegistry(armorStack.m_41720_());
        if (modelRegistry.isPresent() && (armorPiece = (ArmorPieceModel)(gearData = VaultGearData.read(armorStack)).getFirstValue(ModGearAttributes.GEAR_MODEL).flatMap(modelId -> ((DynamicModelRegistry)modelRegistry.get()).get((ResourceLocation)modelId)).filter(gearModel -> gearModel instanceof ArmorPieceModel).orElse(null)) != null) {
            VaultArmorItem vaultArmorItem = VaultArmorItem.forSlot(armorPiece.getEquipmentSlot());
            ArmorLayers.BaseLayer baseLayer = VaultArmorRenderProperties.BAKED_LAYERS.get(armorPiece.getId());
            String baseTexture = vaultArmorItem.getArmorTexture(armorStack, null, armorPiece.getEquipmentSlot(), null);
            String overlayTexture = vaultArmorItem.getArmorTexture(armorStack, null, armorPiece.getEquipmentSlot(), "overlay");
            poseStack2.m_85837_(0.0, -2.0, 0.0);
            poseStack2.m_85841_(1.5f, 1.5f, 1.5f);
            EquipmentSlot intendedSlot = vaultArmorItem.getGearType(armorStack).getEquipmentSlot();
            if (intendedSlot == EquipmentSlot.HEAD) {
                poseStack2.m_85837_(0.0, 0.65, 0.0);
            } else if (intendedSlot == EquipmentSlot.LEGS) {
                poseStack2.m_85837_(0.0, -0.3, 0.0);
            } else if (intendedSlot == EquipmentSlot.FEET) {
                poseStack2.m_85837_(0.0, -0.9, 0.0);
            }
            if (baseTexture != null) {
                VertexConsumer baseVertexConsumer = multiBufferSource.m_6299_(baseLayer.m_103119_(new ResourceLocation(baseTexture)));
                baseLayer.m_7695_(poseStack2, baseVertexConsumer, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            if (overlayTexture != null) {
                VertexConsumer overlayVertexConsumer = multiBufferSource.m_6299_(baseLayer.m_103119_(new ResourceLocation(overlayTexture)));
                baseLayer.m_7695_(poseStack2, overlayVertexConsumer, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
        bufferSource.m_109911_();
        RenderSystem.m_69482_();
        modelPoseStack.m_85849_();
        RenderSystem.m_157182_();
    }

    private void renderItemStack(ItemStack itemStack) {
        Minecraft minecraft = Minecraft.m_91087_();
        ISpatial worldSpatial = this.getWorldSpatial();
        int playerRenderX = worldSpatial.x() + worldSpatial.width() / 2;
        int playerRenderY = worldSpatial.y() + worldSpatial.height() / 2;
        BakedModel bakedModel = minecraft.m_91291_().m_174264_(itemStack, null, null, 0);
        PoseStack poseStack2 = new PoseStack();
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        posestack.m_85837_((double)playerRenderX, (double)playerRenderY, 350.0);
        posestack.m_85841_(32.0f, -32.0f, 32.0f);
        RenderSystem.m_157182_();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        double rotat = -90.0 * ((double)System.currentTimeMillis() / 1000.0) % 360.0 * 0.01745329238474369;
        poseStack2.m_85845_(Quaternion.m_175228_((float)0.3925f, (float)((float)rotat), (float)0.0f));
        Lighting.m_84930_();
        minecraft.m_91291_().m_115143_(itemStack, ItemTransforms.TransformType.GUI, false, poseStack2, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, bakedModel);
        bufferSource.m_109911_();
        RenderSystem.m_69482_();
        posestack.m_85849_();
        RenderSystem.m_157182_();
    }
}

