/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import com.mojang.blaze3d.platform.InputConstants;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ButtonElement;
import iskallia.vault.client.gui.framework.render.Tooltips;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.container.VaultJewelApplicationStationContainer;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModGearAttributes;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class JewelApplicationButtonElement<E extends JewelApplicationButtonElement<E>>
extends ButtonElement<E> {
    public JewelApplicationButtonElement(IPosition position, Runnable onClick, VaultJewelApplicationStationContainer container) {
        super(position, ScreenTextures.BUTTON_CRAFT_TEXTURES, onClick);
        this.tooltip(Tooltips.multi(() -> {
            long window = Minecraft.m_91087_().m_91268_().m_85439_();
            boolean shiftDown = InputConstants.m_84830_((long)window, (int)340) || InputConstants.m_84830_((long)window, (int)344);
            ItemStack inputItem = ItemStack.f_41583_;
            Slot inputSlot = container.m_38853_(36);
            if (!inputSlot.m_7993_().m_41619_()) {
                inputItem = inputSlot.m_7993_();
            }
            boolean hasInput = !inputItem.m_41619_();
            ArrayList<Object> tooltip = new ArrayList<Object>();
            if (hasInput) {
                VaultGearData toolData = VaultGearData.read(container.getTileEntity().getToolItem());
                int capacity = toolData.getFirstValue(ModGearAttributes.TOOL_CAPACITY).orElse(0);
                if (!container.getTileEntity().getJewels().isEmpty()) {
                    if (capacity >= container.getTileEntity().getTotalSizeInJewels()) {
                        tooltip.add(new TextComponent("Apply all Jewels"));
                        tooltip.add(new TextComponent(""));
                    }
                    tooltip.add(new TextComponent("Capacity: ").m_7220_((Component)new TextComponent("" + capacity).m_130948_(Style.f_131099_.m_178520_(16757593))).m_7220_((Component)new TextComponent(" (-" + container.getTileEntity().getTotalSizeInJewels() + ")").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED))));
                }
                if (capacity < container.getTileEntity().getTotalSizeInJewels()) {
                    tooltip.add(new TextComponent("Requires a larger capacity").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
                }
            } else {
                tooltip.add(new TextComponent("Requires a Tool").m_130940_(ChatFormatting.RED));
            }
            if (container.getTileEntity().getTotalSizeInJewels() < 0 || container.getTileEntity().getJewels().isEmpty()) {
                tooltip.add(new TextComponent("Requires at least one Jewel").m_130940_(ChatFormatting.RED));
            }
            return tooltip;
        }));
    }
}

