/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.framework.element.spi.AbstractSpatialElement;
import iskallia.vault.client.gui.framework.element.spi.IRenderedElement;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.screen.layout.ScreenLayout;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelAutoResize;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.framework.text.TextBorder;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import org.jetbrains.annotations.NotNull;

public class LabelElement<E extends LabelElement<E>>
extends AbstractSpatialElement<E>
implements IRenderedElement {
    protected Component component;
    protected Supplier<Component> componentSupplier;
    protected final LabelTextStyle labelTextStyle;
    protected LabelAutoResize autoResize;
    protected boolean visible;

    public LabelElement(IPosition position, LabelTextStyle.Builder labelTextStyle) {
        Objects.requireNonNull(TextBorder.DEFAULT_FONT.get());
        this(position, (ISize)Spatials.height((int)(9.0f * labelTextStyle.textScale())), (Component)new TextComponent(""), labelTextStyle);
    }

    public LabelElement(IPosition position, Component component, LabelTextStyle.Builder labelTextStyle) {
        IMutableSpatial iMutableSpatial = Spatials.width((int)((float)TextBorder.DEFAULT_FONT.get().m_92724_(component.m_7532_()) * labelTextStyle.textScale()));
        Objects.requireNonNull(TextBorder.DEFAULT_FONT.get());
        this(position, (ISize)iMutableSpatial.height((int)(9.0f * labelTextStyle.textScale())), component, labelTextStyle);
    }

    public LabelElement(IPosition position, Supplier<Component> componentSupplier, LabelTextStyle.Builder labelTextStyle) {
        Objects.requireNonNull(TextBorder.DEFAULT_FONT.get());
        this(position, (ISize)Spatials.height((int)(9.0f * labelTextStyle.textScale())), componentSupplier, labelTextStyle);
    }

    public LabelElement(IPosition position, ISize size, LabelTextStyle.Builder labelTextStyle) {
        this(position, size, (Component)new TextComponent(""), labelTextStyle);
    }

    public LabelElement(IPosition position, ISize size, Component component, LabelTextStyle.Builder labelTextStyle) {
        super(Spatials.positionXYZ(position).size(size));
        this.component = component;
        this.componentSupplier = null;
        this.labelTextStyle = labelTextStyle.build();
        this.autoResize = LabelAutoResize.HEIGHT;
        this.setVisible(true);
    }

    public LabelElement(IPosition position, ISize size, Supplier<Component> componentSupplier, LabelTextStyle.Builder labelTextStyle) {
        super(Spatials.positionXYZ(position).size(size));
        this.component = null;
        this.componentSupplier = componentSupplier;
        this.labelTextStyle = labelTextStyle.build();
        this.autoResize = LabelAutoResize.HEIGHT;
        this.setVisible(true);
    }

    public void setAutoResize(LabelAutoResize autoResize) {
        this.autoResize = autoResize;
    }

    @Override
    protected void layoutSelf(ISize screen, ISpatial gui, ISpatial parent) {
        super.layoutSelf(screen, gui, parent);
        Component currentComponent = this.getComponent();
        if (this.autoResize.isWidth()) {
            this.worldSpatial.width((int)((float)Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)currentComponent) * this.getTextStyle().textScale()));
        }
        if (this.autoResize.isHeight()) {
            this.worldSpatial.height(this.getTextStyle().getLabelHeight(currentComponent, this.width()));
        }
    }

    public void set(String text) {
        this.set((Component)new TextComponent(text));
    }

    public void set(Component component) {
        this.component = component;
        this.componentSupplier = null;
        ScreenLayout.requestLayout();
    }

    public void setSupplier(Supplier<Component> componentSupplier) {
        this.component = null;
        this.componentSupplier = componentSupplier;
        ScreenLayout.requestLayout();
    }

    public Component getComponent() {
        if (this.componentSupplier != null) {
            return this.componentSupplier.get();
        }
        return this.component;
    }

    public LabelTextStyle getTextStyle() {
        return this.labelTextStyle;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        Component currentComponent = this.getComponent();
        float scale = this.getTextStyle().textScale();
        poseStack.m_85836_();
        int width = this.getWorldSpatial().width();
        poseStack.m_85837_((double)this.getWorldSpatial().x(), (double)this.getWorldSpatial().y(), (double)this.getWorldSpatial().z());
        poseStack.m_85841_(scale, scale, 1.0f);
        this.getTextStyle().textBorder().render(renderer, poseStack, currentComponent, this.getTextStyle().textWrap(), this.getTextStyle().textAlign(), 0, 0, 0, (int)((float)this.getWorldSpatial().width() / scale));
        poseStack.m_85849_();
    }
}

