/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ScrollableListSelectorElement;
import iskallia.vault.client.gui.framework.element.SelectableButtonElement;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.framework.text.TextAlign;
import iskallia.vault.client.gui.framework.text.TextWrap;
import iskallia.vault.config.gear.VaultGearWorkbenchConfig;
import iskallia.vault.container.modifier.DiscoverableModifier;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.util.TextComponentUtils;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ModifierDiscoverySelectorElement
extends ScrollableListSelectorElement<ModifierDiscoverySelectorElement, DiscoverableModifier, ModifierDiscoveryElement> {
    public ModifierDiscoverySelectorElement(ISpatial spatial, List<DiscoverableModifier> gearModifiers) {
        super((ISpatial)Spatials.copy(spatial).width(ScreenTextures.BUTTON_MODIFIER_DISCOVERY_TEXTURES.button().width()), new ModifierDiscoverySelectorModel(gearModifiers));
        this.verticalScrollBarElement.setVisible(false);
    }

    public void onSelect(Consumer<DiscoverableModifier> fn) {
        ScrollableListSelectorElement.SelectorModel selectorModel = this.getSelectorModel();
        if (selectorModel instanceof ModifierDiscoverySelectorModel) {
            ModifierDiscoverySelectorModel selModel = (ModifierDiscoverySelectorModel)selectorModel;
            selModel.whenSelected(cfg -> {
                ModifierDiscoveryElement option = (ModifierDiscoveryElement)selModel.getSelectedElement();
                if (option != null) {
                    fn.accept(option.discoverableModifier);
                }
            });
        }
    }

    public static class ModifierDiscoverySelectorModel
    extends ScrollableListSelectorElement.SelectorModel<ModifierDiscoveryElement, DiscoverableModifier> {
        private final List<DiscoverableModifier> gearModifiers;

        public ModifierDiscoverySelectorModel(List<DiscoverableModifier> gearModifiers) {
            this.gearModifiers = gearModifiers;
        }

        @Override
        public List<DiscoverableModifier> getEntries() {
            return this.gearModifiers;
        }

        @Override
        public ModifierDiscoveryElement createSelectable(ISpatial spatial, DiscoverableModifier entry) {
            return new ModifierDiscoveryElement(spatial, entry);
        }
    }

    public static class ModifierDiscoveryElement
    extends SelectableButtonElement<ModifierDiscoveryElement> {
        private final DiscoverableModifier discoverableModifier;
        @Nullable
        private final VaultGearModifier<?> displayModifier;
        private final LabelTextStyle textStyle;

        public ModifierDiscoveryElement(IPosition position, DiscoverableModifier discoverableModifier) {
            super(position, ScreenTextures.BUTTON_MODIFIER_DISCOVERY_TEXTURES, () -> {});
            this.discoverableModifier = discoverableModifier;
            this.displayModifier = VaultGearWorkbenchConfig.getConfig(discoverableModifier.item()).map(c -> c.getConfig(discoverableModifier.modifierId())).flatMap(VaultGearWorkbenchConfig.CraftableModifierConfig::createModifier).orElse(null);
            this.textStyle = LabelTextStyle.defaultStyle().shadow().build();
        }

        @Override
        public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            super.render(renderer, poseStack, mouseX, mouseY, partialTick);
            ItemStack stack = new ItemStack((ItemLike)this.discoverableModifier.item());
            boolean strikeThrough = this.discoverableModifier.discovered();
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, 1.0);
            this.getModifierDescription().ifPresent(cfgDisplay -> {
                MutableComponent itemDisplay = new TextComponent("(").m_130946_(stack.m_41786_().getString()).m_7220_((Component)new TextComponent(")")).m_130940_(ChatFormatting.GRAY);
                if (strikeThrough) {
                    TextComponentUtils.applyStyle((Component)cfgDisplay, Style.f_131099_.m_178522_(Boolean.valueOf(true)));
                    TextComponentUtils.applyStyle((Component)itemDisplay, Style.f_131099_.m_178522_(Boolean.valueOf(true)));
                }
                this.textStyle.textBorder().render(renderer, poseStack, (Component)cfgDisplay, TextWrap.wrap(), TextAlign.LEFT, this.worldSpatial.x() + 4, this.worldSpatial.y() + 3, this.worldSpatial.z(), this.worldSpatial.width());
                this.textStyle.textBorder().render(renderer, poseStack, (Component)itemDisplay, TextWrap.wrap(), TextAlign.LEFT, this.worldSpatial.x() + 4, this.worldSpatial.y() + 15, this.worldSpatial.z(), this.worldSpatial.width());
            });
            poseStack.m_85849_();
        }

        public Optional<MutableComponent> getModifierDescription() {
            return this.displayModifier == null ? Optional.empty() : this.displayModifier.getConfigDisplay(new ItemStack((ItemLike)this.discoverableModifier.item()));
        }
    }
}

