/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.framework.element.spi.AbstractSpatialElement;
import iskallia.vault.client.gui.framework.element.spi.IRenderedElement;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.util.SkinProfile;
import iskallia.vault.util.function.ObservableSupplier;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerFaceElement<E extends PlayerFaceElement<E>>
extends AbstractSpatialElement<E>
implements IRenderedElement {
    public static final int DEFAULT_WIDTH = 12;
    public static final int DEFAULT_HEIGHT = 12;
    private final ObservableSupplier<String> playerNameObserver;
    private final SkinProfile skinProfile;
    private boolean visible;

    public PlayerFaceElement(IPosition position, Supplier<String> playerName) {
        this(position, Spatials.size(12, 12), playerName);
    }

    public PlayerFaceElement(IPosition position, ISize size, Supplier<String> playerName) {
        super(Spatials.positionXYZ(position).size(size));
        this.setVisible(true);
        this.skinProfile = new SkinProfile();
        this.playerNameObserver = ObservableSupplier.of(playerName, Objects::equals);
    }

    @Nullable
    public static String getLocalPlayerName() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            return player.m_5446_().getString();
        }
        return null;
    }

    public Optional<String> getPlayerName() {
        return Optional.ofNullable(this.skinProfile.getLatestNickname());
    }

    protected void onPlayerNameChanged(@Nullable String playerName) {
        this.skinProfile.updateSkin(playerName);
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.playerNameObserver.ifChanged(this::onPlayerNameChanged);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.skinProfile.getLocationSkin());
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, (double)this.worldSpatial.z());
        GuiComponent.m_93160_((PoseStack)poseStack, (int)this.worldSpatial.x(), (int)this.worldSpatial.y(), (int)this.worldSpatial.width(), (int)this.worldSpatial.height(), (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
        GuiComponent.m_93160_((PoseStack)poseStack, (int)this.worldSpatial.x(), (int)this.worldSpatial.y(), (int)this.worldSpatial.width(), (int)this.worldSpatial.height(), (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
        poseStack.m_85849_();
    }
}

