/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.spi.AbstractSpatialElement;
import iskallia.vault.client.gui.framework.element.spi.IGuiEventElement;
import iskallia.vault.client.gui.framework.element.spi.IRenderedElement;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class ScalableSliderElement
extends AbstractSpatialElement<ScalableSliderElement>
implements IRenderedElement,
IGuiEventElement {
    protected boolean visible = true;
    protected boolean clickHeld;
    protected float percent;
    protected Consumer<Float> onValueChanged;

    public ScalableSliderElement(ISpatial spatial, Consumer<Float> onValueChanged) {
        super(spatial);
        this.onValueChanged = onValueChanged;
    }

    public void setValue(float value) {
        this.percent = Mth.m_14036_((float)value, (float)0.0f, (float)1.0f);
        this.onValueChanged.accept(Float.valueOf(this.percent));
    }

    private void setValueFromMouse(double mouseX) {
        this.setValue(((float)mouseX - (float)(this.getWorldSpatial().x() + 2)) / ((float)this.getWorldSpatial().width() - 4.0f));
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int buttonIndex) {
        if (this.containsMouse(mouseX, mouseY)) {
            this.clickHeld = true;
            int minX = this.x() + 2;
            int maxX = this.x() + this.width() - 2;
            this.setValueFromMouse((float)Mth.m_14008_((double)mouseX, (double)minX, (double)maxX));
        }
        return IGuiEventElement.super.m_6375_(mouseX, mouseY, buttonIndex);
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int buttonIndex) {
        if (this.clickHeld) {
            int minX = this.x() + 2;
            int maxX = this.x() + this.width() - 2;
            this.setValueFromMouse((float)Mth.m_14008_((double)mouseX, (double)minX, (double)maxX));
            this.clickHeld = false;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
        }
        return IGuiEventElement.super.m_6348_(mouseX, mouseY, buttonIndex);
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int buttonIndex, double dragX, double dragY) {
        if (!this.m_5953_(mouseX, mouseY)) {
            this.m_6348_(mouseX, mouseY, buttonIndex);
        }
        if (this.clickHeld) {
            int minX = this.x() + 2;
            int maxX = this.x() + this.width() - 2;
            this.setValueFromMouse((float)Mth.m_14008_((double)mouseX, (double)minX, (double)maxX));
        }
        return IGuiEventElement.super.m_7979_(mouseX, mouseY, buttonIndex, dragX, dragY);
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        ISpatial spatial = this.getWorldSpatial();
        ScreenTextures.SLIDER_BAR_SLICES.blit(poseStack, spatial.x(), spatial.y(), spatial.z(), spatial.width(), spatial.height());
        int yOffset = -Math.max((10 - spatial.height()) / 2, 0);
        int x = (int)((float)spatial.x() + this.percent * (float)(spatial.width() - 4));
        if (this.m_5953_(mouseX, mouseY) || this.clickHeld) {
            renderer.render(ScreenTextures.SLIDER_SMALL_HOVER, poseStack, x, spatial.y() + yOffset, spatial.z(), 4, 10);
        } else {
            renderer.render(ScreenTextures.SLIDER_SMALL, poseStack, x, spatial.y() + yOffset, spatial.z(), 4, 10);
        }
    }
}

