/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ContainerElement;
import iskallia.vault.client.gui.framework.element.NineSliceButtonElement;
import iskallia.vault.client.gui.framework.element.VerticalScrollClipContainer;
import iskallia.vault.client.gui.framework.render.TooltipDirection;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.render.spi.ITooltipRenderer;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.render.DropdownDirection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SideDropdownElement<E extends SideDropdownElement<E>>
extends ContainerElement<E> {
    private final NineSliceButtonElement<?> mainButton;
    private final VerticalScrollClipContainer<?> listContainer;
    private final DropdownDirection direction;
    private boolean expanded = false;
    private String selectedValue;
    private final List<String> options;
    private final Consumer<String> onSelect;
    @Nullable
    private final List<Component> tooltip;

    public SideDropdownElement(ISpatial spatial, String label, List<String> options, Consumer<String> onSelect, DropdownDirection direction, @Nullable List<Component> tooltip) {
        super(spatial);
        this.options = options;
        this.onSelect = onSelect;
        this.direction = direction;
        this.tooltip = tooltip;
        this.selectedValue = options.isEmpty() ? "" : options.get(0);
        int width = spatial.width();
        int height = spatial.height();
        int listWidth = width;
        int listHeight = Math.min(options.size() * 20, 100);
        this.mainButton = new NineSliceButtonElement(Spatials.positionXYZ(0, 0, 5).size(width, height), ScreenTextures.BUTTON_EMPTY_TEXTURES, this::toggle);
        this.mainButton.label(() -> new TextComponent(label + ": " + this.selectedValue), LabelTextStyle.shadow().center());
        this.addElement(this.mainButton);
        int offsetX = direction == DropdownDirection.RIGHT ? width : -listWidth;
        this.listContainer = new VerticalScrollClipContainer(Spatials.positionXYZ(offsetX, 0, 10).size(listWidth, listHeight));
        this.listContainer.setVisible(false);
        int yPos = 0;
        for (String opt : options) {
            NineSliceButtonElement optionButton = new NineSliceButtonElement(Spatials.positionXYZ(0, yPos, 11).size(listWidth, 20), ScreenTextures.BUTTON_EMPTY_TEXTURES, () -> {
                this.selectedValue = opt;
                this.onSelect.accept(opt);
                this.toggle();
            });
            optionButton.label(() -> new TextComponent(opt), LabelTextStyle.shadow().center());
            this.listContainer.addElement(optionButton);
            yPos += 20;
        }
        this.addElement(this.listContainer);
    }

    private void toggle() {
        this.expanded = !this.expanded;
        this.listContainer.setVisible(this.expanded);
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int buttonIndex) {
        if (this.mainButton.onMouseClicked(mouseX, mouseY, buttonIndex)) {
            return true;
        }
        if (this.expanded && super.onMouseClicked(mouseX, mouseY, buttonIndex)) {
            return true;
        }
        if (this.expanded) {
            boolean insideList;
            int gx = this.getWorldSpatial().x();
            int gy = this.getWorldSpatial().y();
            int w = this.getWorldSpatial().width();
            int h = this.getWorldSpatial().height();
            int lx = gx + (this.direction == DropdownDirection.RIGHT ? w : -this.listContainer.getWorldSpatial().width());
            int ly = gy;
            int lw = this.listContainer.getWorldSpatial().width();
            int lh = this.listContainer.getWorldSpatial().height();
            boolean insideMain = mouseX >= (double)gx && mouseX < (double)(gx + w) && mouseY >= (double)gy && mouseY < (double)(gy + h);
            boolean bl = insideList = mouseX >= (double)lx && mouseX < (double)(lx + lw) && mouseY >= (double)ly && mouseY < (double)(ly + lh);
            if (!insideMain && !insideList) {
                this.toggle();
                return true;
            }
        }
        return false;
    }

    @Override
    public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.render(renderer, poseStack, mouseX, mouseY, partialTick);
    }

    @Override
    public boolean renderTooltip(ITooltipRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY) {
        if (this.tooltip != null && !this.tooltip.isEmpty() && this.mainButton.isVisible() && this.mainButton.containsMouse(mouseX, mouseY)) {
            renderer.renderComponentTooltip(poseStack, this.tooltip, mouseX, mouseY, TooltipDirection.RIGHT);
            return true;
        }
        return false;
    }
}

