/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.spi.AbstractSpatialElement;
import iskallia.vault.client.gui.framework.element.spi.IGuiEventElement;
import iskallia.vault.client.gui.framework.element.spi.IRenderedElement;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.framework.text.TextAlign;
import iskallia.vault.client.gui.framework.text.TextBorder;
import iskallia.vault.client.gui.framework.text.TextWrap;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class SliderElement
extends AbstractSpatialElement<SliderElement>
implements IRenderedElement,
IGuiEventElement {
    protected boolean visible = true;
    protected Supplier<Component> message;
    protected LabelTextStyle textStyle;
    protected Supplier<Float> value;
    protected boolean clickHeld;
    protected Consumer<Float> onValueChanged;
    protected boolean hidePercentage;

    public SliderElement(ISpatial spatial, Supplier<Component> message, Supplier<Float> value, Consumer<Float> onValueChanged) {
        this(spatial, message, LabelTextStyle.shadow().center(), value, onValueChanged);
    }

    public SliderElement(ISpatial spatial, Supplier<Component> message, LabelTextStyle.Builder style, Supplier<Float> value, Consumer<Float> onValueChanged) {
        super(spatial);
        this.message = message;
        this.textStyle = style.build();
        this.value = value;
        this.onValueChanged = onValueChanged;
    }

    public void setValue(float value) {
        this.value = () -> Float.valueOf((float)Mth.m_14008_((double)value, (double)0.0, (double)1.0));
        this.onValueChanged.accept(this.value.get());
    }

    private void setValueFromMouse(double mouseX) {
        this.setValue(((float)mouseX - (float)(this.getWorldSpatial().x() + 4)) / ((float)this.getWorldSpatial().width() - 8.0f));
    }

    public SliderElement hidePercentage(boolean hidden) {
        this.hidePercentage = hidden;
        return this;
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int buttonIndex) {
        if (this.containsMouse(mouseX, mouseY)) {
            this.clickHeld = true;
            int minX = this.x() + 4;
            int maxX = this.x() + this.width() - 4;
            this.setValueFromMouse((float)Mth.m_14008_((double)mouseX, (double)minX, (double)maxX));
        }
        return IGuiEventElement.super.m_6375_(mouseX, mouseY, buttonIndex);
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int buttonIndex) {
        if (this.clickHeld) {
            int minX = this.x() + 4;
            int maxX = this.x() + this.width() - 4;
            this.setValueFromMouse((float)Mth.m_14008_((double)mouseX, (double)minX, (double)maxX));
            this.clickHeld = false;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
        }
        return IGuiEventElement.super.m_6348_(mouseX, mouseY, buttonIndex);
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int buttonIndex, double dragX, double dragY) {
        if (!this.m_5953_(mouseX, mouseY)) {
            this.m_6348_(mouseX, mouseY, buttonIndex);
        }
        if (this.clickHeld) {
            int minX = this.x() + 4;
            int maxX = this.x() + this.width() - 4;
            this.setValueFromMouse((float)Mth.m_14008_((double)mouseX, (double)minX, (double)maxX));
        }
        return IGuiEventElement.super.m_7979_(mouseX, mouseY, buttonIndex, dragX, dragY);
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public Component getComponent() {
        return this.message.get();
    }

    @Override
    public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        int x;
        ISpatial spatial = this.getWorldSpatial();
        renderer.render(ScreenTextures.SLIDER_BACKGROUND, poseStack, spatial.x(), spatial.y(), spatial.z(), spatial.width(), spatial.height());
        int minX = this.x();
        int maxX = this.x() + this.width() - 8;
        int n = x = this.clickHeld && this.m_5953_(mouseX, mouseY) ? Mth.m_14045_((int)(mouseX - 4), (int)minX, (int)maxX) : (int)((float)spatial.x() + this.value.get().floatValue() * (float)(this.width() - 8));
        if (this.m_5953_(mouseX, mouseY) || this.clickHeld) {
            renderer.render(ScreenTextures.SLIDER_HOVER, poseStack, x, spatial.y(), spatial.z(), 8, spatial.height());
        } else {
            renderer.render(ScreenTextures.SLIDER, poseStack, x, spatial.y(), spatial.z(), 8, spatial.height());
        }
        TextBorder.ITextBorder iTextBorder = this.textStyle.textBorder();
        Object object = this.hidePercentage ? this.getComponent() : this.getComponent().m_6881_().m_130946_(String.format(": %s%%", (int)(this.value.get().floatValue() * 100.0f)));
        TextWrap.ITextWrap iTextWrap = this.textStyle.textWrap();
        TextAlign.ITextAlign iTextAlign = this.textStyle.textAlign();
        int n2 = this.getWorldSpatial().x();
        int n3 = this.getWorldSpatial().y() + spatial.height() / 2;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        iTextBorder.render(renderer, poseStack, (Component)object, iTextWrap, iTextAlign, n2, n3 - 9 / 2, this.getWorldSpatial().z() + 1, this.getWorldSpatial().width());
    }
}

