/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.element.spi.AbstractSpatialElement;
import iskallia.vault.client.gui.framework.element.spi.IRenderedElement;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import org.jetbrains.annotations.NotNull;

public class TextureAtlasElement<E extends TextureAtlasElement<E>>
extends AbstractSpatialElement<E>
implements IRenderedElement {
    private final TextureAtlasRegion textureAtlasRegion;
    private boolean visible;
    private float xScale = 1.0f;
    private float yScale = 1.0f;

    public TextureAtlasElement(TextureAtlasRegion textureAtlasRegion) {
        this(IPosition.ZERO, textureAtlasRegion);
    }

    public TextureAtlasElement(IPosition position, TextureAtlasRegion textureAtlasRegion) {
        this(position, Spatials.size(textureAtlasRegion), textureAtlasRegion);
    }

    public TextureAtlasElement(IPosition position, ISize size, TextureAtlasRegion textureAtlasRegion) {
        super(Spatials.positionXYZ(position).size(size));
        this.textureAtlasRegion = textureAtlasRegion;
        this.setVisible(true);
    }

    public TextureAtlasElement<E> scale(float x, float y) {
        this.xScale = x;
        this.yScale = y;
        return this;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        poseStack.m_85836_();
        if (this.xScale != 1.0f || this.yScale != 1.0f) {
            poseStack.m_85837_((double)((float)this.worldSpatial.x() * (1.0f - this.xScale)), (double)((float)this.worldSpatial.y() * (1.0f - this.yScale)), 0.0);
            poseStack.m_85841_(this.xScale, this.yScale, 1.0f);
        }
        renderer.render(this.textureAtlasRegion, poseStack, (IPosition)this.worldSpatial);
        poseStack.m_85849_();
    }
}

