/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ContainerElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.spi.IRenderedElement;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class VerticalBarElement<E extends VerticalBarElement<E>>
extends ContainerElement<E>
implements IRenderedElement {
    protected final ISpatial barSpatial;
    private final Supplier<TextureAtlasRegion> barTexture;
    private final Supplier<Integer> colorSupplier;
    private final Supplier<Float> barFillPercentSupplier;

    public VerticalBarElement(ISpatial spatial, Supplier<TextureAtlasRegion> barTexture, int color, Supplier<Float> fillPercent) {
        this(spatial, barTexture, () -> color, fillPercent);
    }

    public VerticalBarElement(ISpatial spatial, Supplier<TextureAtlasRegion> barTexture, Supplier<Integer> colorSupplier, Supplier<Float> barFillPercentSupplier) {
        super(spatial);
        this.barSpatial = Spatials.positionXY(spatial.x() + 1, spatial.y() + 1).size(spatial.width() - 2, spatial.height() - 2);
        this.barTexture = barTexture;
        this.colorSupplier = colorSupplier;
        this.barFillPercentSupplier = barFillPercentSupplier;
        this.addElement((NineSliceElement)new NineSliceElement(Spatials.zero(), ScreenTextures.INSET_GREY_BACKGROUND).layout((screen, gui, parent, world) -> world.size(parent)));
    }

    protected float getFillPercent() {
        return this.barFillPercentSupplier.get().floatValue();
    }

    protected int getColor() {
        return this.colorSupplier.get();
    }

    @Override
    public void render(IElementRenderer renderer, @Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.render(renderer, poseStack, mouseX, mouseY, partialTick);
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, 5.0);
        int color = this.getColor();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float fillPercent = this.getFillPercent();
        int fillHeight = Math.round((float)this.barSpatial.height() * fillPercent);
        TextureAtlasRegion texture = this.barTexture.get();
        TextureAtlasSprite sprite = texture.getSprite();
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)1.0f);
        IMutableSpatial barFillSpatial = Spatials.copySize(this.barSpatial).positionXY(this.worldSpatial).translateXY(1, 1).translateY(this.barSpatial.height() - fillHeight).height(fillHeight);
        renderer.render(texture, poseStack, barFillSpatial.x(), barFillSpatial.y(), barFillSpatial.z(), barFillSpatial.width(), barFillSpatial.height(), sprite.m_118409_(), sprite.m_118410_(), sprite.m_118412_() - (sprite.m_118412_() - sprite.m_118411_()) * ((float)fillHeight / (float)this.barSpatial.height()), sprite.m_118412_());
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }
}

