/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.element.VerticalBarElement;
import iskallia.vault.client.gui.framework.render.TooltipDirection;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.render.spi.ITooltipRenderer;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class VerticalSegmentedBarElement<E extends VerticalSegmentedBarElement<E, S>, S extends BarSegment>
extends VerticalBarElement<E> {
    private final Map<Float, S> segmentMap = new TreeMap(Comparator.reverseOrder());

    public VerticalSegmentedBarElement(ISpatial spatial, Supplier<TextureAtlasRegion> barTexture, Supplier<Float> fillPercent) {
        super(spatial, barTexture, Color.WHITE::getRGB, fillPercent);
    }

    public void addSegment(float percent, S segment) {
        this.segmentMap.put(Float.valueOf(percent), segment);
    }

    @Override
    protected int getColor() {
        return this.getCurrentSegment().map(BarSegment::getColor).orElse(super.getColor());
    }

    public Optional<S> getNextSegment() {
        BarSegment previousSegment = null;
        float fillPercent = this.getFillPercent();
        for (Float key : this.segmentMap.keySet()) {
            if (key.floatValue() <= fillPercent) {
                return Optional.ofNullable(previousSegment);
            }
            previousSegment = (BarSegment)this.segmentMap.get(key);
        }
        return Optional.ofNullable(previousSegment);
    }

    public Optional<S> getCurrentSegment() {
        float fillPercent = this.getFillPercent();
        for (Float key : this.segmentMap.keySet()) {
            if (!(key.floatValue() <= fillPercent)) continue;
            return Optional.of((BarSegment)this.segmentMap.get(key));
        }
        return Optional.empty();
    }

    @Override
    public boolean onHoverTooltip(ITooltipRenderer tooltipRenderer, @Nonnull PoseStack poseStack, int mouseX, int mouseY, TooltipFlag tooltipFlag) {
        List tooltip = this.getCurrentSegment().map(BarSegment::getTooltipComponents).orElseGet(Collections::emptyList);
        if (!tooltip.isEmpty()) {
            ArrayList<Component> renderTooltip = new ArrayList<Component>(tooltip);
            List nextTooltip = this.getNextSegment().map(BarSegment::getTooltipComponents).orElseGet(Collections::emptyList);
            if (!nextTooltip.isEmpty()) {
                renderTooltip.add(TextComponent.f_131282_);
                this.getCurrentSegment().ifPresent(segment -> renderTooltip.add(segment.getNextComponentDescriptor()));
                renderTooltip.addAll(nextTooltip);
            }
            tooltipRenderer.renderTooltip(poseStack, renderTooltip, mouseX, mouseY, ItemStack.f_41583_, TooltipDirection.RIGHT);
            return true;
        }
        return super.onHoverTooltip(tooltipRenderer, poseStack, mouseX, mouseY, tooltipFlag);
    }

    @Override
    public void render(IElementRenderer renderer, @Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.render(renderer, poseStack, mouseX, mouseY, partialTick);
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, 10.0);
        this.segmentMap.forEach((percent, segment) -> {
            if (percent.floatValue() <= 0.0f) {
                return;
            }
            int percentOffset = this.barSpatial.height() - Math.round((float)this.barSpatial.height() * percent.floatValue());
            renderer.renderColoredQuad(poseStack, 0x27000000, Spatials.positionXY(this.worldSpatial.x() + 1, this.worldSpatial.y() + percentOffset).size(this.barSpatial.width(), 1));
        });
        poseStack.m_85849_();
        RenderSystem.m_69461_();
    }

    public static class BarSegment {
        private final int color;

        public BarSegment(int color) {
            this.color = color;
        }

        protected int getColor() {
            return this.color;
        }

        protected Component getNextComponentDescriptor() {
            return new TextComponent("Next:").m_130940_(ChatFormatting.BOLD);
        }

        protected List<Component> getTooltipComponents() {
            return Collections.emptyList();
        }
    }
}

