/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.element;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import iskallia.vault.client.gui.framework.element.ElasticContainerElement;
import iskallia.vault.client.gui.framework.element.spi.AbstractSpatialElement;
import iskallia.vault.client.gui.framework.element.spi.IGuiEventElement;
import iskallia.vault.client.gui.framework.render.NineSlice;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class VerticalTextTabElement<E extends VerticalTextTabElement<E>>
extends ElasticContainerElement<E> {
    private LabelTextStyle textStyle = LabelTextStyle.defaultStyle().build();
    private final NineSlice.TextureRegion activeBackground;
    private final NineSlice.TextureRegion inactiveBackground;
    private final List<SelectableTab> tabs;
    private SelectableTab selectedTab = null;

    public VerticalTextTabElement(ISpatial offset, List<TabInfo> tabs, NineSlice.TextureRegion activeBackground, NineSlice.TextureRegion inactiveBackground) {
        super(VerticalTextTabElement.computeSize(offset, tabs));
        this.activeBackground = activeBackground;
        this.inactiveBackground = inactiveBackground;
        this.tabs = VerticalTextTabElement.makeTabs(offset, tabs);
        this.tabs.forEach(tab -> {
            tab.parent = this;
            this.addElement(tab);
        });
        this.tabs.stream().findFirst().ifPresent(this::selectTab);
    }

    private static ISpatial computeSize(ISpatial offset, List<TabInfo> tabs) {
        IMutableSpatial spatial = Spatials.copyPosition(offset);
        for (TabInfo tab : tabs) {
            ISpatial tabBox = SelectableTab.getSize(tab.text, Minecraft.m_91087_().f_91062_);
            spatial.width(Math.max(spatial.width(), tabBox.width()));
            spatial.height(spatial.height() + tabBox.height());
        }
        return spatial;
    }

    private static List<SelectableTab> makeTabs(ISpatial spatial, List<TabInfo> tabs) {
        IMutableSpatial offset = Spatials.copyPosition(spatial);
        ArrayList<SelectableTab> tabElements = new ArrayList<SelectableTab>();
        for (TabInfo info : tabs) {
            ISpatial tabBox = SelectableTab.getSize(info.text, Minecraft.m_91087_().f_91062_);
            SelectableTab tab = new SelectableTab(Spatials.copyPosition(offset).size(tabBox), info.text, info.onSelect, info.onDeselect);
            tabElements.add(tab);
            offset.translateY(tabBox.height());
        }
        return tabElements;
    }

    public void setTextStyle(LabelTextStyle textStyle) {
        this.textStyle = textStyle;
    }

    public void selectTab(SelectableTab tab) {
        if (!this.tabs.contains(tab)) {
            return;
        }
        if (this.selectedTab != null) {
            this.selectedTab.onDeselect.run();
        }
        this.selectedTab = tab;
        this.selectedTab.onSelect.run();
    }

    public SelectableTab getSelectedTab() {
        return this.selectedTab;
    }

    @Override
    public void render(IElementRenderer renderer, @Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.render(renderer, poseStack, mouseX, mouseY, partialTick);
        ISpatial offset = this.getWorldSpatial();
        for (SelectableTab tab : this.tabs) {
            ISpatial tabBox = tab.getWorldSpatial();
            poseStack.m_85836_();
            poseStack.m_85837_((double)offset.x(), (double)offset.y(), (double)offset.z());
            if (tab == this.selectedTab) {
                poseStack.m_85837_(0.0, 0.0, 100.0);
                renderer.render(this.activeBackground, poseStack, Spatials.size(tabBox));
            } else {
                poseStack.m_85837_(0.0, 0.0, -100.0);
                renderer.render(this.inactiveBackground, poseStack, Spatials.size(tabBox));
            }
            poseStack.m_85836_();
            poseStack.m_85837_(5.0, (double)(tabBox.height() - 5), 0.0);
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(-90.0f));
            this.textStyle.textBorder().render(renderer, poseStack, (Component)tab.getText().m_6881_().m_130948_(Style.f_131099_.m_178520_(-12632257)), this.textStyle.textWrap(), this.textStyle.textAlign(), 0, 0, 0, Integer.MAX_VALUE);
            poseStack.m_85849_();
            poseStack.m_85849_();
            offset = Spatials.copy(offset).translateY(tabBox.height());
        }
    }

    private boolean onSelect(SelectableTab tab) {
        this.selectTab(tab);
        return true;
    }

    private static class SelectableTab
    extends AbstractSpatialElement<SelectableTab>
    implements IGuiEventElement {
        VerticalTextTabElement<?> parent = null;
        private final MutableComponent text;
        final Runnable onSelect;
        final Runnable onDeselect;

        public SelectableTab(ISpatial spatial, MutableComponent text, Runnable onSelect, Runnable onDeselect) {
            super(spatial);
            this.text = text;
            this.onSelect = onSelect;
            this.onDeselect = onDeselect;
        }

        void moveTo(ISpatial offset) {
            this.worldSpatial.positionXYZ(offset);
        }

        public MutableComponent getText() {
            return this.text;
        }

        public static ISpatial getSize(MutableComponent text, Font font) {
            int textWidth = font.m_92852_((FormattedText)text);
            Objects.requireNonNull(font);
            IMutableSpatial textBox = Spatials.size(9, textWidth);
            return Spatials.size(textBox.width() + 8, textBox.height() + 9);
        }

        @Override
        public boolean onMouseClicked(double mouseX, double mouseY, int buttonIndex) {
            if (this.parent != null) {
                return this.parent.onSelect(this);
            }
            return IGuiEventElement.super.onMouseClicked(mouseX, mouseY, buttonIndex);
        }
    }

    public record TabInfo(MutableComponent text, Runnable onSelect, Runnable onDeselect) {
        public TabInfo(MutableComponent text, Runnable onSelect) {
            this(text, onSelect, () -> {});
        }
    }
}

