/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.framework.element.spi.ElementStore;
import iskallia.vault.client.gui.framework.element.spi.IElement;
import iskallia.vault.client.gui.framework.element.spi.ILayoutElement;
import iskallia.vault.client.gui.framework.element.spi.IRenderedElement;
import iskallia.vault.client.gui.framework.element.spi.IUpdateableElement;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractElementOverlay
implements IIngameOverlay {
    protected final ElementStore elementStore;
    protected final IElementRenderer elementRenderer;
    protected final Map<IElement, Integer> elementRefreshRates;
    protected final Map<IElement, Integer> elementTickCounters;
    protected boolean needsLayout;

    public AbstractElementOverlay(IElementRenderer elementRenderer) {
        this.elementRenderer = elementRenderer;
        this.elementStore = new ElementStore();
        this.elementRefreshRates = new HashMap<IElement, Integer>();
        this.elementTickCounters = new HashMap<IElement, Integer>();
        this.needsLayout = true;
    }

    public void render(ForgeIngameGui gui, PoseStack poseStack, float partialTick, int width, int height) {
        if (this.needsLayout) {
            this.layout(Spatials.zero());
            this.needsLayout = false;
        }
        this.updateElements();
        this.renderElements(poseStack, width, height, partialTick);
    }

    protected void updateElements() {
        for (Map.Entry<IElement, Integer> entry : this.elementRefreshRates.entrySet()) {
            IElement element = entry.getKey();
            int refreshRate = entry.getValue();
            int currentTicks = this.elementTickCounters.getOrDefault(element, 0);
            if (currentTicks >= refreshRate) {
                if (element instanceof IUpdateableElement) {
                    IUpdateableElement updateElement = (IUpdateableElement)element;
                    updateElement.onUpdate();
                }
                this.elementTickCounters.put(element, 0);
                continue;
            }
            this.elementTickCounters.put(element, currentTicks + 1);
        }
    }

    protected void renderElements(@Nonnull PoseStack poseStack, int width, int height, float partialTick) {
        this.elementRenderer.beginFrame();
        RenderSystem.m_69482_();
        this.elementRenderer.begin();
        for (IRenderedElement element : this.elementStore.getRenderedElementList()) {
            if (!element.isVisible()) continue;
            element.render(this.elementRenderer, poseStack, width / 2, height / 2, partialTick);
        }
        this.elementRenderer.end();
        RenderSystem.m_69465_();
        this.elementRenderer.endFrame();
    }

    protected void layout(ISpatial parentSpatial) {
        IMutableSpatial screenSize = Spatials.size(Minecraft.m_91087_().m_91268_().m_85445_(), Minecraft.m_91087_().m_91268_().m_85446_());
        for (ILayoutElement<?> element : this.elementStore.getLayoutElementList()) {
            element.onLayout(screenSize, parentSpatial, parentSpatial);
        }
    }

    public void requestLayout() {
        this.needsLayout = true;
    }

    protected <E extends IElement> E addElement(E element) {
        return this.addElement(element, 20);
    }

    protected <E extends IElement> E addElement(E element, int refreshRateTicks) {
        E addedElement = this.elementStore.addElement(element);
        this.elementRefreshRates.put(addedElement, refreshRateTicks);
        this.elementTickCounters.put(addedElement, 0);
        return addedElement;
    }

    protected void removeElement(IElement element) {
        this.elementStore.removeElement(element);
        this.elementRefreshRates.remove(element);
        this.elementTickCounters.remove(element);
    }

    protected void removeAllElements() {
        this.elementStore.removeAllElements();
        this.elementRefreshRates.clear();
        this.elementTickCounters.clear();
    }
}

