/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import iskallia.vault.client.atlas.IMultiBuffer;
import iskallia.vault.client.atlas.ITextureAtlas;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import java.util.function.Supplier;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public final class NineSlice {
    public static TextureRegion region(Supplier<ITextureAtlas> atlasSupplier, ResourceLocation resourceLocation, Slices slices) {
        return TextureRegion.of(atlasSupplier, resourceLocation, slices);
    }

    public static TextureRegion region(Supplier<ITextureAtlas> atlasSupplier, ResourceLocation resourceLocation, Slices slices, CenterDrawMode drawMode) {
        return TextureRegion.of(atlasSupplier, resourceLocation, slices, drawMode);
    }

    public static TextureRegion region(Supplier<ITextureAtlas> atlasSupplier, ResourceLocation resourceLocation, Slices slices, CenterDrawMode drawMode, FrameDrawMode frameDrawMode) {
        return TextureRegion.of(atlasSupplier, resourceLocation, slices, drawMode, frameDrawMode);
    }

    public static Slices slice(int left, int right, int top, int bottom) {
        return Slices.of(left, right, top, bottom);
    }

    public static void buffer(IMultiBuffer buffer, PoseStack poseStack, int posX, int posY, int posZ, int width, int height, TextureRegion textureRegion) {
        NineSlice.buffer(buffer.getFor(textureRegion.getSprite().m_118414_().m_118330_()), poseStack, posX, posY, posZ, width, height, textureRegion);
    }

    public static void buffer(IMultiBuffer buffer, PoseStack poseStack, int posX, int posY, int posZ, int width, int height, Slices slices, TextureAtlasSprite sprite, CenterDrawMode drawMode, FrameDrawMode frameDrawMode) {
        NineSlice.buffer(buffer.getFor(sprite.m_118414_().m_118330_()), poseStack, posX, posY, posZ, width, height, slices, sprite, drawMode, frameDrawMode);
    }

    public static void buffer(VertexConsumer vertexConsumer, PoseStack poseStack, int posX, int posY, int posZ, int width, int height, TextureRegion textureRegion) {
        TextureAtlasSprite sprite = textureRegion.getSprite();
        NineSlice.buffer(vertexConsumer, poseStack, posX, posY, posZ, width, height, textureRegion.slices.left, textureRegion.slices.right, textureRegion.slices.top, textureRegion.slices.bottom, sprite.m_118405_(), sprite.m_118408_(), sprite.m_118409_(), sprite.m_118410_(), sprite.m_118411_(), sprite.m_118412_(), textureRegion.drawMode(), textureRegion.frameDrawMode());
    }

    public static void buffer(VertexConsumer vertexConsumer, PoseStack poseStack, int posX, int posY, int posZ, int width, int height, Slices slices, iskallia.vault.client.render.TextureRegion region, int atlasWidth, int atlasHeight, CenterDrawMode drawMode, FrameDrawMode frameDrawMode) {
        NineSlice.buffer(vertexConsumer, poseStack, posX, posY, posZ, width, height, slices.left, slices.right, slices.top, slices.bottom, region.width(), region.height(), (float)region.x() / (float)atlasWidth, (float)(region.x() + region.width()) / (float)atlasWidth, (float)region.y() / (float)atlasWidth, (float)(region.y() + region.height()) / (float)atlasHeight, drawMode, frameDrawMode);
    }

    public static void buffer(VertexConsumer vertexConsumer, PoseStack poseStack, int posX, int posY, int posZ, int width, int height, Slices slices, TextureAtlasSprite sprite, CenterDrawMode drawMode, FrameDrawMode frameDrawMode) {
        NineSlice.buffer(vertexConsumer, poseStack, posX, posY, posZ, width, height, slices.left, slices.right, slices.top, slices.bottom, sprite.m_118405_(), sprite.m_118408_(), sprite.m_118409_(), sprite.m_118410_(), sprite.m_118411_(), sprite.m_118412_(), drawMode, frameDrawMode);
    }

    public static void buffer(VertexConsumer vertexConsumer, PoseStack poseStack, int posX, int posY, int posZ, int width, int height, int sliceLeftWidth, int sliceRightWidth, int sliceTopHeight, int sliceBottomHeight, int spriteWidth, int spriteHeight, float u0, float u1, float v0, float v1, CenterDrawMode drawMode, FrameDrawMode frameDrawMode) {
        float pU = (u1 - u0) / (float)spriteWidth;
        float pV = (v1 - v0) / (float)spriteHeight;
        float topV1 = v0 + (float)sliceTopHeight * pV;
        float leftU1 = u0 + (float)sliceLeftWidth * pU;
        float rightU0 = u1 - (float)sliceRightWidth * pU;
        float bottomV0 = v1 - (float)sliceBottomHeight * pV;
        float middleU0 = u0 + (float)(sliceLeftWidth + 1) * pU;
        float middleU1 = u1 - (float)(sliceRightWidth + 1) * pU;
        float middleV0 = v0 + (float)(sliceTopHeight + 1) * pV;
        float middleV1 = v1 - (float)(sliceBottomHeight + 1) * pV;
        float leftX = posX + sliceLeftWidth;
        float rightX = posX + width - sliceRightWidth;
        float topY = posY + sliceTopHeight;
        float bottomY = posY + height - sliceBottomHeight;
        float middleWidth = rightX - leftX;
        float middleHeight = bottomY - topY;
        int spriteMiddleWidth = spriteWidth - sliceLeftWidth - sliceRightWidth - 2;
        int spriteMiddleHeight = spriteHeight - sliceTopHeight - sliceBottomHeight - 2;
        NineSlice.bufferQuad(vertexConsumer, poseStack, posX, posY, posZ, sliceLeftWidth, sliceTopHeight, u0, leftU1, v0, topV1);
        NineSlice.bufferQuad(vertexConsumer, poseStack, rightX, posY, posZ, sliceRightWidth, sliceTopHeight, rightU0, u1, v0, topV1);
        NineSlice.bufferQuad(vertexConsumer, poseStack, posX, bottomY, posZ, sliceLeftWidth, sliceBottomHeight, u0, leftU1, bottomV0, v1);
        NineSlice.bufferQuad(vertexConsumer, poseStack, rightX, bottomY, posZ, sliceRightWidth, sliceBottomHeight, rightU0, u1, bottomV0, v1);
        if (frameDrawMode == FrameDrawMode.Stretched) {
            NineSlice.bufferQuad(vertexConsumer, poseStack, leftX, posY, posZ, middleWidth, sliceTopHeight, middleU0, middleU1, v0, topV1);
            NineSlice.bufferQuad(vertexConsumer, poseStack, leftX, bottomY, posZ, middleWidth, sliceBottomHeight, middleU0, middleU1, bottomV0, v1);
            NineSlice.bufferQuad(vertexConsumer, poseStack, posX, topY, posZ, sliceLeftWidth, middleHeight, u0, leftU1, middleV0, middleV1);
            NineSlice.bufferQuad(vertexConsumer, poseStack, rightX, topY, posZ, sliceRightWidth, middleHeight, rightU0, u1, middleV0, middleV1);
        } else if (frameDrawMode == FrameDrawMode.Tiled) {
            for (float topStepX = leftX; topStepX < rightX; topStepX += (float)spriteMiddleWidth) {
                float topWidth = Math.min((float)spriteMiddleWidth, rightX - topStepX);
                float topU1 = middleU0 + topWidth / (float)spriteMiddleWidth * (middleU1 - middleU0);
                NineSlice.bufferQuadBounded(vertexConsumer, poseStack, topStepX, posY, posZ, topWidth, sliceTopHeight, middleU0, topU1, v0, topV1, leftX, rightX, posY, posY + sliceTopHeight);
            }
            for (float bottomStepX = leftX; bottomStepX < rightX; bottomStepX += (float)spriteMiddleWidth) {
                float bottomWidth = Math.min((float)spriteMiddleWidth, rightX - bottomStepX);
                float bottomU1 = middleU0 + bottomWidth / (float)spriteMiddleWidth * (middleU1 - middleU0);
                NineSlice.bufferQuadBounded(vertexConsumer, poseStack, bottomStepX, bottomY, posZ, bottomWidth, sliceBottomHeight, middleU0, bottomU1, bottomV0, v1, leftX, rightX, bottomY, bottomY + (float)sliceBottomHeight);
            }
            for (float leftStepY = topY; leftStepY < bottomY; leftStepY += (float)spriteMiddleHeight) {
                float leftHeight = Math.min((float)spriteMiddleHeight, bottomY - leftStepY);
                float leftV1 = middleV0 + leftHeight / (float)spriteMiddleHeight * (middleV1 - middleV0);
                NineSlice.bufferQuadBounded(vertexConsumer, poseStack, posX, leftStepY, posZ, sliceLeftWidth, leftHeight, u0, leftU1, middleV0, leftV1, posX, posX + sliceLeftWidth, topY, bottomY);
            }
            for (float rightStepY = topY; rightStepY < bottomY; rightStepY += (float)spriteMiddleHeight) {
                float rightHeight = Math.min((float)spriteMiddleHeight, bottomY - rightStepY);
                float rightV1 = middleV0 + rightHeight / (float)spriteMiddleHeight * (middleV1 - middleV0);
                NineSlice.bufferQuadBounded(vertexConsumer, poseStack, rightX, rightStepY, posZ, sliceRightWidth, rightHeight, rightU0, u1, middleV0, rightV1, rightX, rightX + (float)sliceRightWidth, topY, bottomY);
            }
        } else {
            throw new UnsupportedOperationException("Unsupported nine-slice frame draw mode: " + frameDrawMode.toString());
        }
        if (drawMode == CenterDrawMode.Stretched) {
            NineSlice.bufferQuad(vertexConsumer, poseStack, leftX, topY, posZ, middleWidth, middleHeight, middleU0, middleU1, middleV0, middleV1);
        } else if (drawMode == CenterDrawMode.Tiled) {
            int cols = Mth.m_14167_((float)(middleWidth / (float)spriteMiddleWidth));
            int rows = Mth.m_14167_((float)(middleHeight / (float)spriteMiddleHeight));
            for (int x = 0; x < cols; ++x) {
                for (int y = 0; y < rows; ++y) {
                    float mX = leftX + (float)(x * spriteMiddleWidth);
                    float mY = topY + (float)(y * spriteMiddleHeight);
                    NineSlice.bufferQuadBounded(vertexConsumer, poseStack, mX, mY, posZ, spriteMiddleWidth, spriteMiddleHeight, middleU0, middleU1, middleV0, middleV1, leftX, leftX + middleWidth, topY, topY + middleHeight);
                }
            }
        } else {
            throw new UnsupportedOperationException("Unsupported nine-slice draw mode: " + drawMode.toString());
        }
    }

    private static void bufferQuad(VertexConsumer vertexConsumer, PoseStack poseStack, float x, float y, float z, float width, float height, float u0, float u1, float v0, float v1) {
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        vertexConsumer.m_85982_(matrix, x, y + height, z).m_7421_(u0, v1).m_5752_();
        vertexConsumer.m_85982_(matrix, x + width, y + height, z).m_7421_(u1, v1).m_5752_();
        vertexConsumer.m_85982_(matrix, x + width, y, z).m_7421_(u1, v0).m_5752_();
        vertexConsumer.m_85982_(matrix, x, y, z).m_7421_(u0, v0).m_5752_();
    }

    private static void bufferQuadBounded(VertexConsumer vertexConsumer, PoseStack poseStack, float x, float y, float z, float width, float height, float u0, float u1, float v0, float v1, float xMin, float xMax, float yMin, float yMax) {
        if (Mth.m_14033_((float)xMin, (float)xMax) || Mth.m_14033_((float)yMin, (float)yMax)) {
            return;
        }
        if (x > xMax || x + width < xMin || y > yMax || y + height < yMin) {
            return;
        }
        float du = u1 - u0;
        float dv = v1 - v0;
        float x0 = Math.max(x, xMin);
        float x1 = Math.min(x + width, xMax);
        float y0 = Math.max(y, yMin);
        float y1 = Math.min(y + height, yMax);
        float cu0 = (x0 - x) / width * du + u0;
        float cu1 = cu0 + (x1 - x0) / width * du;
        float cv0 = (y0 - y) / height * dv + v0;
        float cv1 = cv0 + (y1 - y0) / height * dv;
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        vertexConsumer.m_85982_(matrix, x0, y1, z).m_7421_(cu0, cv1).m_5752_();
        vertexConsumer.m_85982_(matrix, x1, y1, z).m_7421_(cu1, cv1).m_5752_();
        vertexConsumer.m_85982_(matrix, x1, y0, z).m_7421_(cu1, cv0).m_5752_();
        vertexConsumer.m_85982_(matrix, x0, y0, z).m_7421_(cu0, cv0).m_5752_();
    }

    private NineSlice() {
    }

    public record TextureRegion(Supplier<ITextureAtlas> atlas, ResourceLocation resourceLocation, Slices slices, CenterDrawMode drawMode, FrameDrawMode frameDrawMode) {
        public static TextureRegion of(Supplier<ITextureAtlas> atlasSupplier, ResourceLocation resourceLocation, Slices slices) {
            return TextureRegion.of(atlasSupplier, resourceLocation, slices, CenterDrawMode.Stretched);
        }

        public static TextureRegion of(Supplier<ITextureAtlas> atlasSupplier, ResourceLocation resourceLocation, Slices slices, CenterDrawMode drawMode) {
            return TextureRegion.of(atlasSupplier, resourceLocation, slices, drawMode, FrameDrawMode.Stretched);
        }

        public static TextureRegion of(Supplier<ITextureAtlas> atlasSupplier, ResourceLocation resourceLocation, Slices slices, CenterDrawMode drawMode, FrameDrawMode frameDrawMode) {
            return new TextureRegion(atlasSupplier, resourceLocation, slices, drawMode, frameDrawMode);
        }

        public TextureAtlasSprite getSprite() {
            return this.atlas.get().getSprite(this.resourceLocation);
        }

        public void blit(PoseStack poseStack, int posX, int posY, int posZ, int width, int height) {
            ITextureAtlas atlas = this.atlas.get();
            RenderSystem.m_157456_((int)0, (ResourceLocation)atlas.getAtlasResourceLocation());
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            NineSlice.buffer((VertexConsumer)bufferBuilder, poseStack, posX, posY, posZ, width, height, this);
            bufferBuilder.m_85721_();
            BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
        }

        public void buffer(VertexConsumer vertexConsumer, PoseStack poseStack, int posX, int posY, int posZ, int width, int height) {
            NineSlice.buffer(vertexConsumer, poseStack, posX, posY, posZ, width, height, this);
        }

        public void buffer(VertexConsumer vertexConsumer, PoseStack poseStack, ISpatial spatial) {
            NineSlice.buffer(vertexConsumer, poseStack, spatial.x(), spatial.y(), spatial.z(), spatial.width(), spatial.height(), this);
        }

        public void buffer(IMultiBuffer buffer, PoseStack poseStack, int posX, int posY, int posZ, int width, int height) {
            NineSlice.buffer(buffer.getFor(this.atlas().get().getAtlasResourceLocation()), poseStack, posX, posY, posZ, width, height, this);
        }

        public void buffer(IMultiBuffer buffer, PoseStack poseStack, ISpatial spatial) {
            NineSlice.buffer(buffer.getFor(this.atlas().get().getAtlasResourceLocation()), poseStack, spatial.x(), spatial.y(), spatial.z(), spatial.width(), spatial.height(), this);
        }
    }

    public record Slices(int left, int right, int top, int bottom) {
        public static Slices of(int left, int right, int top, int bottom) {
            return new Slices(left, right, top, bottom);
        }
    }

    public static enum CenterDrawMode {
        Stretched,
        Tiled;

    }

    public static enum FrameDrawMode {
        Stretched,
        Tiled;

    }
}

