/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import iskallia.vault.client.atlas.IMultiBuffer;
import iskallia.vault.client.atlas.ITextureAtlas;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import java.util.function.Supplier;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public final class ThreeSliceHorizontal {
    public static TextureRegion region(Supplier<ITextureAtlas> atlasSupplier, ResourceLocation resourceLocation, Slices slices) {
        return TextureRegion.of(atlasSupplier, resourceLocation, slices);
    }

    public static TextureRegion region(Supplier<ITextureAtlas> atlasSupplier, ResourceLocation resourceLocation, Slices slices, DrawMode drawMode) {
        return TextureRegion.of(atlasSupplier, resourceLocation, slices, drawMode);
    }

    public static Slices slice(int left, int right) {
        return Slices.of(left, right);
    }

    public static void buffer(IMultiBuffer buffer, PoseStack poseStack, int posX, int posY, int posZ, int width, int height, TextureRegion textureRegion) {
        ThreeSliceHorizontal.buffer(buffer.getFor(textureRegion.getSprite().m_118414_().m_118330_()), poseStack, posX, posY, posZ, width, height, textureRegion);
    }

    public static void buffer(IMultiBuffer buffer, PoseStack poseStack, int posX, int posY, int posZ, int width, int height, Slices slices, TextureAtlasSprite sprite, DrawMode drawMode) {
        ThreeSliceHorizontal.buffer(buffer.getFor(sprite.m_118414_().m_118330_()), poseStack, posX, posY, posZ, width, height, slices, sprite, drawMode);
    }

    public static void buffer(VertexConsumer vertexConsumer, PoseStack poseStack, int posX, int posY, int posZ, int width, int height, TextureRegion textureRegion) {
        TextureAtlasSprite sprite = textureRegion.getSprite();
        ThreeSliceHorizontal.buffer(vertexConsumer, poseStack, posX, posY, posZ, width, height, textureRegion.slices.left, textureRegion.slices.right, sprite.m_118405_(), sprite.m_118408_(), sprite.m_118409_(), sprite.m_118410_(), sprite.m_118411_(), sprite.m_118412_(), textureRegion.drawMode());
    }

    public static void buffer(VertexConsumer vertexConsumer, PoseStack poseStack, int posX, int posY, int posZ, int width, int height, Slices slices, iskallia.vault.client.render.TextureRegion region, int atlasWidth, int atlasHeight, DrawMode drawMode) {
        ThreeSliceHorizontal.buffer(vertexConsumer, poseStack, posX, posY, posZ, width, height, slices.left, slices.right, region.width(), region.height(), (float)region.x() / (float)atlasWidth, (float)(region.x() + region.width()) / (float)atlasWidth, (float)region.y() / (float)atlasWidth, (float)(region.y() + region.height()) / (float)atlasHeight, drawMode);
    }

    public static void buffer(VertexConsumer vertexConsumer, PoseStack poseStack, int posX, int posY, int posZ, int width, int height, Slices slices, TextureAtlasSprite sprite, DrawMode drawMode) {
        ThreeSliceHorizontal.buffer(vertexConsumer, poseStack, posX, posY, posZ, width, height, slices.left, slices.right, sprite.m_118405_(), sprite.m_118408_(), sprite.m_118409_(), sprite.m_118410_(), sprite.m_118411_(), sprite.m_118412_(), drawMode);
    }

    public static void buffer(VertexConsumer vertexConsumer, PoseStack poseStack, int posX, int posY, int posZ, int width, int height, int sliceLeftWidth, int sliceRightWidth, int spriteWidth, int spriteHeight, float u0, float u1, float v0, float v1, DrawMode drawMode) {
        float pU = (u1 - u0) / (float)spriteWidth;
        float pV = (v1 - v0) / (float)spriteHeight;
        float leftU1 = u0 + (float)sliceLeftWidth * pU;
        float rightU0 = u1 - (float)sliceRightWidth * pU;
        float middleU0 = u0 + (float)(sliceLeftWidth + 1) * pU;
        float middleU1 = u1 - (float)(sliceRightWidth + 1) * pU;
        float leftX = posX + sliceLeftWidth;
        float rightX = posX + width - sliceRightWidth;
        float middleWidth = rightX - leftX;
        int spriteMiddleWidth = spriteWidth - sliceLeftWidth - sliceRightWidth - 2;
        ThreeSliceHorizontal.bufferQuad(vertexConsumer, poseStack, posX, posY, posZ, sliceLeftWidth, height, u0, leftU1, v0, v1);
        ThreeSliceHorizontal.bufferQuad(vertexConsumer, poseStack, rightX, posY, posZ, sliceRightWidth, height, rightU0, u1, v0, v1);
        if (drawMode == DrawMode.Stretched) {
            ThreeSliceHorizontal.bufferQuad(vertexConsumer, poseStack, leftX, posY, posZ, middleWidth, height, middleU0, middleU1, v0, v1);
        } else if (drawMode == DrawMode.Tiled) {
            for (float stepX = leftX; stepX < rightX; stepX += (float)spriteMiddleWidth) {
                float tileWidth = Math.min((float)spriteMiddleWidth, rightX - stepX);
                float tileU1 = middleU0 + tileWidth / (float)spriteMiddleWidth * (middleU1 - middleU0);
                ThreeSliceHorizontal.bufferQuadBounded(vertexConsumer, poseStack, stepX, posY, posZ, tileWidth, height, middleU0, tileU1, v0, v1, leftX, rightX, posY, posY + height);
            }
        } else {
            throw new UnsupportedOperationException("Unsupported three-horizontal-slice frame draw mode: " + drawMode.toString());
        }
    }

    private static void bufferQuad(VertexConsumer vertexConsumer, PoseStack poseStack, float x, float y, float z, float width, float height, float u0, float u1, float v0, float v1) {
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        vertexConsumer.m_85982_(matrix, x, y + height, z).m_7421_(u0, v1).m_5752_();
        vertexConsumer.m_85982_(matrix, x + width, y + height, z).m_7421_(u1, v1).m_5752_();
        vertexConsumer.m_85982_(matrix, x + width, y, z).m_7421_(u1, v0).m_5752_();
        vertexConsumer.m_85982_(matrix, x, y, z).m_7421_(u0, v0).m_5752_();
    }

    private static void bufferQuadBounded(VertexConsumer vertexConsumer, PoseStack poseStack, float x, float y, float z, float width, float height, float u0, float u1, float v0, float v1, float xMin, float xMax, float yMin, float yMax) {
        if (Mth.m_14033_((float)xMin, (float)xMax) || Mth.m_14033_((float)yMin, (float)yMax)) {
            return;
        }
        if (x > xMax || x + width < xMin || y > yMax || y + height < yMin) {
            return;
        }
        float du = u1 - u0;
        float dv = v1 - v0;
        float x0 = Math.max(x, xMin);
        float x1 = Math.min(x + width, xMax);
        float y0 = Math.max(y, yMin);
        float y1 = Math.min(y + height, yMax);
        float cu0 = (x0 - x) / width * du + u0;
        float cu1 = cu0 + (x1 - x0) / width * du;
        float cv0 = (y0 - y) / height * dv + v0;
        float cv1 = cv0 + (y1 - y0) / height * dv;
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        vertexConsumer.m_85982_(matrix, x0, y1, z).m_7421_(cu0, cv1).m_5752_();
        vertexConsumer.m_85982_(matrix, x1, y1, z).m_7421_(cu1, cv1).m_5752_();
        vertexConsumer.m_85982_(matrix, x1, y0, z).m_7421_(cu1, cv0).m_5752_();
        vertexConsumer.m_85982_(matrix, x0, y0, z).m_7421_(cu0, cv0).m_5752_();
    }

    private ThreeSliceHorizontal() {
    }

    public record TextureRegion(Supplier<ITextureAtlas> atlas, ResourceLocation resourceLocation, Slices slices, DrawMode drawMode) {
        public static TextureRegion of(Supplier<ITextureAtlas> atlasSupplier, ResourceLocation resourceLocation, Slices slices) {
            return TextureRegion.of(atlasSupplier, resourceLocation, slices, DrawMode.Stretched);
        }

        public static TextureRegion of(Supplier<ITextureAtlas> atlasSupplier, ResourceLocation resourceLocation, Slices slices, DrawMode drawMode) {
            return new TextureRegion(atlasSupplier, resourceLocation, slices, drawMode);
        }

        public TextureAtlasSprite getSprite() {
            return this.atlas.get().getSprite(this.resourceLocation);
        }

        public void blit(PoseStack poseStack, int posX, int posY, int posZ, int width, int height) {
            ITextureAtlas atlas = this.atlas.get();
            RenderSystem.m_157456_((int)0, (ResourceLocation)atlas.getAtlasResourceLocation());
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            ThreeSliceHorizontal.buffer((VertexConsumer)bufferBuilder, poseStack, posX, posY, posZ, width, height, this);
            bufferBuilder.m_85721_();
            BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
        }

        public void buffer(VertexConsumer vertexConsumer, PoseStack poseStack, int posX, int posY, int posZ, int width, int height) {
            ThreeSliceHorizontal.buffer(vertexConsumer, poseStack, posX, posY, posZ, width, height, this);
        }

        public void buffer(VertexConsumer vertexConsumer, PoseStack poseStack, ISpatial spatial) {
            ThreeSliceHorizontal.buffer(vertexConsumer, poseStack, spatial.x(), spatial.y(), spatial.z(), spatial.width(), spatial.height(), this);
        }

        public void buffer(IMultiBuffer buffer, PoseStack poseStack, int posX, int posY, int posZ, int width, int height) {
            ThreeSliceHorizontal.buffer(buffer.getFor(this.atlas().get().getAtlasResourceLocation()), poseStack, posX, posY, posZ, width, height, this);
        }

        public void buffer(IMultiBuffer buffer, PoseStack poseStack, ISpatial spatial) {
            ThreeSliceHorizontal.buffer(buffer.getFor(this.atlas().get().getAtlasResourceLocation()), poseStack, spatial.x(), spatial.y(), spatial.z(), spatial.width(), spatial.height(), this);
        }
    }

    public record Slices(int left, int right) {
        public static Slices of(int left, int right) {
            return new Slices(left, right);
        }
    }

    public static enum DrawMode {
        Stretched,
        Tiled;

    }
}

