/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.element.spi.ElementStore;
import iskallia.vault.client.gui.framework.element.spi.IElement;
import iskallia.vault.client.gui.framework.element.spi.IGuiEventElement;
import iskallia.vault.client.gui.framework.element.spi.ILayoutElement;
import iskallia.vault.client.gui.framework.element.spi.ILayoutStrategy;
import iskallia.vault.client.gui.framework.element.spi.IRenderedElement;
import iskallia.vault.client.gui.framework.element.spi.ISpatialElement;
import iskallia.vault.client.gui.framework.element.spi.ITooltipElement;
import iskallia.vault.client.gui.framework.element.spi.IUpdateableElement;
import iskallia.vault.client.gui.framework.render.spi.IDebugRenderer;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.render.spi.ITooltipRenderer;
import iskallia.vault.client.gui.framework.render.spi.ITooltipRendererFactory;
import iskallia.vault.client.gui.framework.screen.layout.IGuiScale;
import iskallia.vault.client.gui.framework.screen.layout.ILayoutScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractElementContainerScreen<C extends AbstractContainerMenu>
extends AbstractContainerScreen<C>
implements ILayoutScreen,
IGuiScale {
    protected final ElementStore elementStore;
    protected final IElementRenderer elementRenderer;
    protected final ITooltipRenderer tooltipRenderer;
    protected final Map<IElement, Integer> elementRefreshRates;
    protected final Map<IElement, Integer> elementTickCounters;
    protected IDebugRenderer debugRenderer;
    protected boolean needsLayout;

    public AbstractElementContainerScreen(C container, Inventory inventory, Component title, IElementRenderer elementRenderer, ITooltipRendererFactory<AbstractElementContainerScreen<C>> tooltipRendererFactory) {
        super(container, inventory, title);
        this.elementRenderer = elementRenderer;
        this.elementStore = new ElementStore();
        this.tooltipRenderer = tooltipRendererFactory.create(this);
        this.debugRenderer = ScreenRenderers.getDebugNone();
        this.elementRefreshRates = new HashMap<IElement, Integer>();
        this.elementTickCounters = new HashMap<IElement, Integer>();
        this.needsLayout = true;
    }

    protected void setGuiSize(ISize size) {
        this.f_97726_ = size.width();
        this.f_97727_ = size.height();
    }

    protected ISpatial getGuiSpatial() {
        return Spatials.positionXY(this.getGuiLeft(), this.getGuiTop()).size(this.getXSize(), this.getYSize()).unmodifiableView();
    }

    protected ISize getScreenSize() {
        return Spatials.size(this.f_96543_, this.f_96544_).unmodifiableView();
    }

    public ITooltipRenderer getTooltipRenderer() {
        return this.tooltipRenderer;
    }

    protected <E extends IElement> E addElement(E element) {
        return this.addElement(element, 1);
    }

    protected <E extends IElement> E addElement(E element, int refreshRateTicks) {
        E addedElement = this.elementStore.addElement(element);
        this.elementRefreshRates.put(addedElement, refreshRateTicks);
        this.elementTickCounters.put(addedElement, 0);
        return addedElement;
    }

    protected void addElements(IElement element, IElement ... elements) {
        this.addElement(element);
        for (IElement e : elements) {
            this.addElement(e);
        }
    }

    protected void removeElement(IElement element) {
        this.elementStore.removeElement(element);
        this.elementRefreshRates.remove(element);
        this.elementTickCounters.remove(element);
    }

    protected void removeAllElements() {
        this.elementStore.removeAllElements();
        this.elementRefreshRates.clear();
        this.elementTickCounters.clear();
    }

    @Override
    public void requestLayout() {
        this.needsLayout = true;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.requestLayout();
    }

    protected void layout(ISpatial parentSpatial) {
        for (ILayoutElement<?> element : this.elementStore.getLayoutElementList()) {
            element.onLayout(this.getScreenSize(), this.getGuiSpatial(), parentSpatial);
        }
    }

    protected void m_7286_(@Nonnull PoseStack matrixStack, float partialTicks, int x, int y) {
    }

    protected void m_7027_(@Nonnull PoseStack matrixStack, int x, int y) {
    }

    public void m_6305_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.needsLayout) {
            this.layout(Spatials.zero());
            this.needsLayout = false;
        }
        this.renderBackgroundFill(poseStack);
        this.renderElements(poseStack, mouseX, mouseY, partialTick);
        this.renderSlotItems(poseStack, mouseX, mouseY, partialTick);
        this.renderDebug(poseStack);
        this.renderTooltips(poseStack, mouseX, mouseY);
    }

    protected void renderBackgroundFill(@Nonnull PoseStack poseStack) {
        RenderSystem.m_69465_();
        this.m_93179_(poseStack, 0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
        MinecraftForge.EVENT_BUS.post((Event)new ScreenEvent.BackgroundDrawnEvent((Screen)this, poseStack));
    }

    protected void renderElements(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.elementRenderer.beginFrame();
        RenderSystem.m_69482_();
        this.elementRenderer.begin();
        for (IRenderedElement element : this.elementStore.getRenderedElementList()) {
            if (!element.isVisible()) continue;
            element.render(this.elementRenderer, poseStack, mouseX, mouseY, partialTick);
        }
        this.elementRenderer.end();
        RenderSystem.m_69465_();
        this.elementRenderer.endFrame();
    }

    protected void renderSlotItems(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    protected void updateElements() {
        for (Map.Entry<IElement, Integer> entry : this.elementRefreshRates.entrySet()) {
            IElement element = entry.getKey();
            int refreshRate = entry.getValue();
            int ticks = this.elementTickCounters.getOrDefault(element, 0);
            if (ticks >= refreshRate) {
                if (element instanceof IUpdateableElement) {
                    IUpdateableElement updateableElement = (IUpdateableElement)element;
                    updateableElement.onUpdate();
                }
                this.elementTickCounters.put(element, 0);
                continue;
            }
            this.elementTickCounters.put(element, ticks + 1);
        }
    }

    protected void enableDebugRendering() {
        this.debugRenderer = ScreenRenderers.getDebugBuffered();
    }

    protected void renderDebug(@Nonnull PoseStack poseStack) {
        this.debugRenderer.begin();
        RenderSystem.m_69465_();
        for (ISpatialElement element : this.elementStore.getSpatialElementList()) {
            element.renderDebug(this.debugRenderer, poseStack);
        }
        this.debugRenderer.end();
    }

    protected void renderTooltips(@Nonnull PoseStack poseStack, int mouseX, int mouseY) {
        if (!this.f_97732_.m_142621_().m_41619_()) {
            return;
        }
        if (!this.renderHoveredSlotTooltips(poseStack, mouseX, mouseY)) {
            this.renderElementTooltips(poseStack, mouseX, mouseY);
        }
    }

    protected boolean renderHoveredSlotTooltips(@Nonnull PoseStack poseStack, int mouseX, int mouseY) {
        if (this.f_97734_ != null && this.f_97734_.m_6657_()) {
            this.m_6057_(poseStack, this.f_97734_.m_7993_(), mouseX, mouseY);
            return true;
        }
        return false;
    }

    protected boolean renderElementTooltips(@NotNull PoseStack poseStack, int mouseX, int mouseY) {
        for (ITooltipElement element : this.elementStore.getTooltipElementList()) {
            if (!element.renderTooltip(this.tooltipRenderer, poseStack, mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    protected ILayoutStrategy translateWorldSpatial() {
        return (screen, gui, parent, world) -> world.translateXY(this.getGuiSpatial());
    }

    @Nonnull
    public List<? extends GuiEventListener> m_6702_() {
        return this.elementStore.getGuiEventElementList();
    }

    @Nonnull
    public Optional<GuiEventListener> m_94729_(double mouseX, double mouseY) {
        for (GuiEventListener listener : this.m_6702_()) {
            IElement element;
            if (!(listener instanceof IElement) || !(element = (IElement)listener).isEnabled() || !listener.m_5953_(mouseX, mouseY)) continue;
            return Optional.of(listener);
        }
        return Optional.empty();
    }

    public void m_94757_(double mouseX, double mouseY) {
        for (IGuiEventElement element : this.elementStore.getGuiEventElementList()) {
            element.m_94757_(mouseX, mouseY);
        }
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        super.m_7979_(mouseX, mouseY, button, dragX, dragY);
        return this.m_7222_() != null && this.m_7282_() && button == 0 && this.m_7222_().m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    protected void m_181908_() {
        super.m_181908_();
        this.updateElements();
    }
}

