/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.framework.screen;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.element.spi.ElementStore;
import iskallia.vault.client.gui.framework.element.spi.IElement;
import iskallia.vault.client.gui.framework.element.spi.IGuiEventElement;
import iskallia.vault.client.gui.framework.element.spi.ILayoutElement;
import iskallia.vault.client.gui.framework.element.spi.ILayoutStrategy;
import iskallia.vault.client.gui.framework.element.spi.IRenderedElement;
import iskallia.vault.client.gui.framework.element.spi.ISpatialElement;
import iskallia.vault.client.gui.framework.element.spi.ITooltipElement;
import iskallia.vault.client.gui.framework.render.spi.IDebugRenderer;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.render.spi.ITooltipRenderer;
import iskallia.vault.client.gui.framework.render.spi.ITooltipRendererFactory;
import iskallia.vault.client.gui.framework.screen.layout.IGuiScale;
import iskallia.vault.client.gui.framework.screen.layout.ILayoutScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractElementScreen
extends Screen
implements ILayoutScreen,
IGuiScale {
    protected final ElementStore elementStore;
    protected final IElementRenderer elementRenderer;
    protected final ITooltipRenderer tooltipRenderer;
    protected IDebugRenderer debugRenderer;
    protected int imageWidth = 176;
    protected int imageHeight = 166;
    protected int leftPos;
    protected int topPos;
    protected boolean needsLayout;

    public AbstractElementScreen(Component title, IElementRenderer elementRenderer, ITooltipRendererFactory<AbstractElementScreen> tooltipRendererFactory) {
        super(title);
        this.elementRenderer = elementRenderer;
        this.elementStore = new ElementStore();
        this.tooltipRenderer = tooltipRendererFactory.create(this);
        this.debugRenderer = ScreenRenderers.getDebugNone();
        Window window = Minecraft.m_91087_().m_91268_();
        this.leftPos = window.m_85447_() + window.m_85441_() / 2 - this.imageWidth / 2;
        this.topPos = window.m_85448_() + window.m_85442_() / 2 - this.imageHeight / 2;
    }

    public int getGuiLeft() {
        return this.leftPos;
    }

    public int getGuiTop() {
        return this.topPos;
    }

    public int getXSize() {
        return this.imageWidth;
    }

    public int getYSize() {
        return this.imageHeight;
    }

    protected void setGuiSize(ISize size) {
        this.imageWidth = size.width();
        this.imageHeight = size.height();
    }

    protected ISpatial getGuiSpatial() {
        return Spatials.positionXY(this.getGuiLeft(), this.getGuiTop()).size(this.getXSize(), this.getYSize()).unmodifiableView();
    }

    protected ISize getScreenSize() {
        return Spatials.size(this.f_96543_, this.f_96544_).unmodifiableView();
    }

    public ITooltipRenderer getTooltipRenderer() {
        return this.tooltipRenderer;
    }

    protected <E extends IElement> E addElement(E element) {
        return this.elementStore.addElement(element);
    }

    protected void addElements(IElement element, IElement ... elements) {
        this.addElement(element);
        for (IElement e : elements) {
            this.addElement(e);
        }
    }

    protected void removeElement(IElement element) {
        this.elementStore.removeElement(element);
    }

    protected void removeAllElements() {
        this.elementStore.removeAllElements();
    }

    @Override
    public void requestLayout() {
        this.needsLayout = true;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.requestLayout();
        this.leftPos = this.f_96543_ / 2 - this.imageWidth / 2;
        this.topPos = this.f_96544_ / 2 - this.imageHeight / 2;
    }

    protected void layout(ISpatial parentSpatial) {
        for (ILayoutElement<?> element : this.elementStore.getLayoutElementList()) {
            element.onLayout(this.getScreenSize(), this.getGuiSpatial(), parentSpatial);
        }
    }

    @Nonnull
    protected ILayoutStrategy translateWorldSpatial() {
        return (screen, gui, parent, world) -> world.translateXY(this.getGuiSpatial());
    }

    public void m_6305_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.needsLayout) {
            this.layout(Spatials.zero());
            this.needsLayout = false;
        }
        this.renderBackgroundFill(poseStack);
        this.renderElements(poseStack, mouseX, mouseY, partialTick);
        this.renderSlotItems(poseStack, mouseX, mouseY, partialTick);
        this.renderDebug(poseStack);
        this.renderTooltips(poseStack, mouseX, mouseY);
    }

    protected void renderBackgroundFill(@Nonnull PoseStack poseStack) {
        RenderSystem.m_69465_();
        this.m_93179_(poseStack, 0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
        MinecraftForge.EVENT_BUS.post((Event)new ScreenEvent.BackgroundDrawnEvent((Screen)this, poseStack));
    }

    protected void renderElements(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.elementRenderer.beginFrame();
        RenderSystem.m_69482_();
        this.elementRenderer.begin();
        for (IRenderedElement element : this.elementStore.getRenderedElementList()) {
            if (!element.isVisible()) continue;
            element.render(this.elementRenderer, poseStack, mouseX, mouseY, partialTick);
        }
        this.elementRenderer.end();
        RenderSystem.m_69465_();
        this.elementRenderer.endFrame();
    }

    protected void renderSlotItems(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    protected void enableDebugRendering() {
        this.debugRenderer = ScreenRenderers.getDebugBuffered();
    }

    protected void renderDebug(@Nonnull PoseStack poseStack) {
        this.debugRenderer.begin();
        RenderSystem.m_69465_();
        for (ISpatialElement element : this.elementStore.getSpatialElementList()) {
            element.renderDebug(this.debugRenderer, poseStack);
        }
        this.debugRenderer.end();
    }

    protected void renderTooltips(@Nonnull PoseStack poseStack, int mouseX, int mouseY) {
        this.renderElementTooltips(poseStack, mouseX, mouseY);
    }

    protected boolean renderElementTooltips(@NotNull PoseStack poseStack, int mouseX, int mouseY) {
        for (ITooltipElement element : this.elementStore.getTooltipElementList()) {
            if (!element.renderTooltip(this.tooltipRenderer, poseStack, mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public List<? extends GuiEventListener> m_6702_() {
        return this.elementStore.getGuiEventElementList();
    }

    @Nonnull
    public Optional<GuiEventListener> m_94729_(double mouseX, double mouseY) {
        for (GuiEventListener guiEventListener : this.m_6702_()) {
            IElement element;
            if (!(guiEventListener instanceof IElement) || !(element = (IElement)guiEventListener).isEnabled() || !guiEventListener.m_5953_(mouseX, mouseY)) continue;
            return Optional.of(guiEventListener);
        }
        return Optional.empty();
    }

    public void m_94757_(double mouseX, double mouseY) {
        for (IGuiEventElement element : this.elementStore.getGuiEventElementList()) {
            element.m_94757_(mouseX, mouseY);
        }
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        super.m_7979_(mouseX, mouseY, button, dragX, dragY);
        return this.m_7222_() != null && this.m_7282_() && (button == 0 || button == 1) && this.m_7222_().m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        for (GuiEventListener guiEventListener : this.m_6702_()) {
            if (!guiEventListener.m_6375_(pMouseX, pMouseY, pButton)) continue;
            this.m_7522_(guiEventListener);
            if (pButton == 0 || pButton == 1) {
                this.m_7897_(true);
            }
            return true;
        }
        return false;
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        for (GuiEventListener guiEventListener : this.m_6702_()) {
            if (!guiEventListener.m_6348_(pMouseX, pMouseY, pButton)) continue;
            this.m_7897_(false);
            return true;
        }
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }
}

