/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.helper;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.awt.Rectangle;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.lwjgl.opengl.GL11;

public class UIHelper {
    public static final ResourceLocation UI_RESOURCE = new ResourceLocation("the_vault", "textures/gui/ability_tree.png");
    private static final OverflowHiddenMode OVERFLOW_HIDDEN_MODE = OverflowHiddenMode.DEPTH;
    private static final int[] LINE_BREAK_VALUES = new int[]{0, 10, -10, 25, -25};

    public static void renderOverflowHidden(PoseStack matrixStack, Consumer<PoseStack> backgroundRenderer, Consumer<PoseStack> innerRenderer) {
        if (OVERFLOW_HIDDEN_MODE == OverflowHiddenMode.STENCIL) {
            Minecraft.m_91087_().m_91385_().enableStencil();
            GL11.glEnable((int)2960);
            matrixStack.m_85836_();
            RenderSystem.m_69465_();
            RenderSystem.m_69421_((int)1024, (boolean)false);
            RenderSystem.m_69432_((int)0);
            RenderSystem.m_69931_((int)7680, (int)7680, (int)7681);
            RenderSystem.m_69925_((int)519, (int)1, (int)255);
            RenderSystem.m_69929_((int)255);
            backgroundRenderer.accept(matrixStack);
            RenderSystem.m_69925_((int)514, (int)1, (int)255);
            RenderSystem.m_69929_((int)0);
            innerRenderer.accept(matrixStack);
            RenderSystem.m_69465_();
            matrixStack.m_85849_();
            GL11.glDisable((int)2960);
        } else if (OVERFLOW_HIDDEN_MODE == OverflowHiddenMode.DEPTH) {
            matrixStack.m_85836_();
            RenderSystem.m_69482_();
            matrixStack.m_85837_(0.0, 0.0, 950.0);
            RenderSystem.m_69444_((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            GuiComponent.m_93172_((PoseStack)matrixStack, (int)4680, (int)2260, (int)-4680, (int)-2260, (int)-16777216);
            RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            matrixStack.m_85837_(0.0, 0.0, -950.0);
            RenderSystem.m_69456_((int)518);
            backgroundRenderer.accept(matrixStack);
            RenderSystem.m_69456_((int)515);
            innerRenderer.accept(matrixStack);
            RenderSystem.m_69456_((int)518);
            matrixStack.m_85837_(0.0, 0.0, -950.0);
            RenderSystem.m_69444_((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            GuiComponent.m_93172_((PoseStack)matrixStack, (int)4680, (int)2260, (int)-4680, (int)-2260, (int)-16777216);
            RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            matrixStack.m_85837_(0.0, 0.0, 950.0);
            RenderSystem.m_69456_((int)515);
            RenderSystem.m_69465_();
            matrixStack.m_85849_();
        }
    }

    public static void drawFacingPlayer(PoseStack renderStack, int containerMouseX, int containerMouseY) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            UIHelper.drawFacingEntity((LivingEntity)player, renderStack, containerMouseX, containerMouseY);
        }
    }

    public static void drawFacingEntity(LivingEntity entity, PoseStack renderStack, int containerMouseX, int containerMouseY) {
        float xYaw = (float)Math.atan((float)containerMouseX / 40.0f);
        float yPitch = (float)Math.atan((float)containerMouseY / 40.0f);
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        modelViewStack.m_85837_(0.0, 0.0, 350.0);
        modelViewStack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.m_157182_();
        renderStack.m_85836_();
        renderStack.m_85841_(30.0f, 30.0f, 30.0f);
        Quaternion rotationZ = Vector3f.f_122227_.m_122240_(180.0f);
        Quaternion rotationX = Vector3f.f_122223_.m_122240_(yPitch * 20.0f);
        rotationZ.m_80148_(rotationX);
        renderStack.m_85845_(rotationZ);
        float yBodyRot = entity.f_20883_;
        float yRot = entity.m_146908_();
        float xRot = entity.m_146909_();
        float yHeadRotO = entity.f_20886_;
        float yHeadRot = entity.f_20885_;
        entity.f_20883_ = 180.0f + xYaw * 20.0f;
        entity.m_146922_(180.0f + xYaw * 40.0f);
        entity.m_146926_(-yPitch * 20.0f);
        entity.f_20885_ = entity.m_146908_();
        entity.f_20886_ = entity.m_146908_();
        RenderSystem.m_157450_((Vector3f)((Vector3f)Util.m_137469_((Object)new Vector3f(0.2f, -1.0f, -1.0f), Vector3f::m_122278_)), (Vector3f)((Vector3f)Util.m_137469_((Object)new Vector3f(0.0f, -0.5f, 1.0f), Vector3f::m_122278_)));
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        rotationX.m_80157_();
        entityRenderDispatcher.m_114412_(rotationX);
        entityRenderDispatcher.m_114468_(false);
        MultiBufferSource.BufferSource multiBufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.m_69890_(() -> entityRenderDispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, renderStack, (MultiBufferSource)multiBufferSource, 0xF000F0));
        multiBufferSource.m_109911_();
        entityRenderDispatcher.m_114468_(true);
        entity.f_20883_ = yBodyRot;
        entity.m_146922_(yRot);
        entity.m_146926_(xRot);
        entity.f_20886_ = yHeadRotO;
        entity.f_20885_ = yHeadRot;
        renderStack.m_85849_();
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
    }

    public static void renderContainerBorder(GuiComponent gui, PoseStack matrixStack, Rectangle screenBounds, int u, int v, int lw, int rw, int th, int bh, int contentColor) {
        int width = screenBounds.width;
        int height = screenBounds.height;
        UIHelper.renderContainerBorder(gui, matrixStack, screenBounds.x, screenBounds.y, width, height, u, v, lw, rw, th, bh, contentColor);
    }

    public static void renderContainerBorder(GuiComponent gui, PoseStack matrixStack, int x, int y, int width, int height, int u, int v, int lw, int rw, int th, int bh, int contentColor) {
        int horizontalGap = width - lw - rw;
        int verticalGap = height - th - bh;
        if (contentColor != 0) {
            GuiComponent.m_93172_((PoseStack)matrixStack, (int)(x + lw), (int)(y + th), (int)(x + lw + horizontalGap), (int)(y + th + verticalGap), (int)contentColor);
        }
        gui.m_93228_(matrixStack, x, y, u, v, lw, th);
        gui.m_93228_(matrixStack, x + lw + horizontalGap, y, u + lw + 3, v, rw, th);
        gui.m_93228_(matrixStack, x, y + th + verticalGap, u, v + th + 3, lw, bh);
        gui.m_93228_(matrixStack, x + lw + horizontalGap, y + th + verticalGap, u + lw + 3, v + th + 3, rw, bh);
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)(x + lw), (double)y, 0.0);
        matrixStack.m_85841_((float)horizontalGap, 1.0f, 1.0f);
        gui.m_93228_(matrixStack, 0, 0, u + lw + 1, v, 1, th);
        matrixStack.m_85837_(0.0, (double)(th + verticalGap), 0.0);
        gui.m_93228_(matrixStack, 0, 0, u + lw + 1, v + th + 3, 1, bh);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)x, (double)(y + th), 0.0);
        matrixStack.m_85841_(1.0f, (float)verticalGap, 1.0f);
        gui.m_93228_(matrixStack, 0, 0, u, v + th + 1, lw, 1);
        matrixStack.m_85837_((double)(lw + horizontalGap), 0.0, 0.0);
        gui.m_93228_(matrixStack, 0, 0, u + lw + 3, v + th + 1, rw, 1);
        matrixStack.m_85849_();
    }

    public static void renderLabelAtRight(GuiComponent gui, PoseStack matrixStack, String text, int x, int y) {
        Minecraft minecraft = Minecraft.m_91087_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)UI_RESOURCE);
        Font fontRenderer = minecraft.f_91062_;
        int textWidth = fontRenderer.m_92895_(text);
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)x, (double)y, 0.0);
        float scale = 0.75f;
        matrixStack.m_85841_(scale, scale, scale);
        matrixStack.m_85837_(-9.0, 0.0, 0.0);
        gui.m_93228_(matrixStack, 0, 0, 143, 36, 9, 24);
        int gap = 5;
        int remainingWidth = textWidth + 2 * gap;
        matrixStack.m_85837_((double)(-remainingWidth), 0.0, 0.0);
        while (remainingWidth > 0) {
            gui.m_93228_(matrixStack, 0, 0, 136, 36, 6, 24);
            matrixStack.m_85837_((double)Math.min(6, remainingWidth -= 6), 0.0, 0.0);
        }
        matrixStack.m_85837_((double)(-textWidth - 2 * gap - 6), 0.0, 0.0);
        gui.m_93228_(matrixStack, 0, 0, 121, 36, 14, 24);
        fontRenderer.m_92883_(matrixStack, text, (float)(14 + gap), 9.0f, -12305893);
        matrixStack.m_85849_();
    }

    public static int renderCenteredWrappedText(PoseStack matrixStack, Component text, int maxWidth, int padding) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font fontRenderer = minecraft.f_91062_;
        List<FormattedText> lines = UIHelper.getLines((Component)ComponentUtils.m_130750_((MutableComponent)text.m_6881_(), (Style)text.m_7383_()), maxWidth - 3 * padding);
        int length = lines.stream().mapToInt(arg_0 -> ((Font)fontRenderer).m_92852_(arg_0)).max().orElse(0);
        List processors = Language.m_128107_().m_128112_(lines);
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)((float)(-length) / 2.0f), 0.0, 0.0);
        for (int i = 0; i < processors.size(); ++i) {
            fontRenderer.m_92877_(matrixStack, (FormattedCharSequence)processors.get(i), (float)padding, (float)(10 * i + padding), -15130590);
        }
        matrixStack.m_85849_();
        return processors.size();
    }

    public static int renderWrappedText(PoseStack matrixStack, Component text, int maxWidth, int padding) {
        return UIHelper.renderWrappedText(matrixStack, text, maxWidth, padding, -15130590);
    }

    public static int renderWrappedText(PoseStack matrixStack, Component text, int maxWidth, int padding, int color) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font fontRenderer = minecraft.f_91062_;
        List<FormattedText> lines = UIHelper.getLines((Component)ComponentUtils.m_130750_((MutableComponent)text.m_6881_(), (Style)text.m_7383_()), maxWidth - 3 * padding);
        List processors = Language.m_128107_().m_128112_(lines);
        for (int i = 0; i < processors.size(); ++i) {
            fontRenderer.m_92877_(matrixStack, (FormattedCharSequence)processors.get(i), (float)padding, (float)(10 * i + padding), color);
        }
        return processors.size();
    }

    public static int renderCenteredWrappedCenterAlignText(PoseStack matrixStack, Component text, int maxWidth, int padding) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font fontRenderer = minecraft.f_91062_;
        List<FormattedText> lines = UIHelper.getLines((Component)ComponentUtils.m_130750_((MutableComponent)text.m_6881_(), (Style)text.m_7383_()), maxWidth - 3 * padding);
        int length = lines.stream().mapToInt(arg_0 -> ((Font)fontRenderer).m_92852_(arg_0)).max().orElse(0);
        List processors = Language.m_128107_().m_128112_(lines);
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)((float)(-length) / 2.0f), 0.0, 0.0);
        for (int i = 0; i < processors.size(); ++i) {
            FormattedCharSequence line = (FormattedCharSequence)processors.get(i);
            int lineWidth = fontRenderer.m_92724_(line);
            float xOffset = (float)(maxWidth - 3 * padding - lineWidth) / 2.0f;
            fontRenderer.m_92877_(matrixStack, line, (float)padding + xOffset, (float)(10 * i + padding), -15130590);
        }
        matrixStack.m_85849_();
        return processors.size();
    }

    public static int renderCenteredWrappedRightAlignText(PoseStack matrixStack, Component text, int maxWidth, int padding) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font fontRenderer = minecraft.f_91062_;
        List<FormattedText> lines = UIHelper.getLines((Component)ComponentUtils.m_130750_((MutableComponent)text.m_6881_(), (Style)text.m_7383_()), maxWidth - 3 * padding);
        int length = lines.stream().mapToInt(arg_0 -> ((Font)fontRenderer).m_92852_(arg_0)).max().orElse(0);
        List processors = Language.m_128107_().m_128112_(lines);
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)((float)(-length) / 2.0f), 0.0, 0.0);
        for (int i = 0; i < processors.size(); ++i) {
            FormattedCharSequence line = (FormattedCharSequence)processors.get(i);
            int lineWidth = fontRenderer.m_92724_(line);
            float xOffset = maxWidth - 3 * padding - lineWidth;
            fontRenderer.m_92877_(matrixStack, line, (float)padding + xOffset, (float)(10 * i + padding), -15130590);
        }
        matrixStack.m_85849_();
        return processors.size();
    }

    public static List<FormattedText> getLines(Component component, int maxWidth) {
        Minecraft minecraft = Minecraft.m_91087_();
        StringSplitter charactermanager = minecraft.f_91062_.m_92865_();
        List list = null;
        float f = Float.MAX_VALUE;
        for (int i : LINE_BREAK_VALUES) {
            List list1 = charactermanager.m_92414_((FormattedText)component, maxWidth - i, Style.f_131099_);
            float f1 = Math.abs(UIHelper.getTextWidth(charactermanager, list1) - (float)maxWidth);
            if (f1 <= 10.0f) {
                return list1;
            }
            if (!(f1 < f)) continue;
            f = f1;
            list = list1;
        }
        return list;
    }

    private static float getTextWidth(StringSplitter manager, List<FormattedText> text) {
        return (float)text.stream().mapToDouble(arg_0 -> ((StringSplitter)manager).m_92384_(arg_0)).max().orElse(0.0);
    }

    public static String formatTimeString(long remainingTicks) {
        long seconds = remainingTicks / 20L % 60L;
        long minutes = remainingTicks / 20L / 60L % 60L;
        long hours = remainingTicks / 20L / 60L / 60L;
        return hours > 0L ? String.format("%02d:%02d:%02d", hours, minutes, seconds) : String.format("%02d:%02d", minutes, seconds);
    }

    private static enum OverflowHiddenMode {
        DEPTH,
        STENCIL;

    }
}

