/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import iskallia.vault.VaultMod;
import iskallia.vault.client.ClientAbilityData;
import iskallia.vault.client.atlas.AtlasBufferPosColorTex;
import iskallia.vault.client.atlas.ITextureAtlas;
import iskallia.vault.client.gui.helper.ScreenDrawHelper;
import iskallia.vault.client.render.HudPosition;
import iskallia.vault.client.render.IVaultOptions;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModShaders;
import iskallia.vault.init.ModTextureAtlases;
import iskallia.vault.mana.Mana;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.ability.effect.spi.core.Cooldown;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.util.CooldownGuiOption;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;

@OnlyIn(value=Dist.CLIENT)
public class AbilitiesOverlay
implements IIngameOverlay {
    private static final TextRenderMode TEXT_RENDER_MODE = TextRenderMode.MINECRAFT;
    private static final ResourceLocation ABILITY_TRAY_BG = VaultMod.id("gui/abilities/overlay_tray_bg");
    private static final ResourceLocation ABILITY_TRAY_MANA_ONLY_BG = VaultMod.id("gui/abilities/overlay_tray_mana_only_bg");
    private static final ResourceLocation ABILITY_TRAY_MANA_BAR = VaultMod.id("gui/abilities/overlay_tray_mana_bar");
    private static final ResourceLocation ABILITY_TRAY_MANA_BAR_FX_0 = VaultMod.id("gui/abilities/overlay_tray_mana_bar_fx_0");
    private static final ResourceLocation ABILITY_TRAY_MANA_BAR_FX_1 = VaultMod.id("gui/abilities/overlay_tray_mana_bar_fx_1");
    private static final ResourceLocation ABILITY_TRAY_MANA_BAR_FX_2 = VaultMod.id("gui/abilities/overlay_tray_mana_bar_fx_2");
    private static final ResourceLocation ABILITY_TRAY_MANA_FONT = VaultMod.id("gui/abilities/overlay_tray_mana_font");
    private static final ResourceLocation ABILITY_TRAY_COOLDOWN = VaultMod.id("gui/abilities/overlay_tray_cooldown");
    private static final ResourceLocation ABILITY_TRAY_SELECTED = VaultMod.id("gui/abilities/overlay_tray_selected");
    private static final ResourceLocation ABILITY_TRAY_SELECTED_ACTIVE = VaultMod.id("gui/abilities/overlay_tray_selected_active");
    private static final ResourceLocation ABILITY_TRAY_SELECTED_COOLDOWN = VaultMod.id("gui/abilities/overlay_tray_selected_cooldown");
    private static final Minecraft minecraft = Minecraft.m_91087_();
    public static List<ResourceLocation> GUI_ELEMENTS = List.of(ABILITY_TRAY_BG, ABILITY_TRAY_MANA_ONLY_BG, ABILITY_TRAY_MANA_BAR, ABILITY_TRAY_MANA_BAR_FX_0, ABILITY_TRAY_MANA_BAR_FX_1, ABILITY_TRAY_MANA_BAR_FX_2, ABILITY_TRAY_MANA_FONT, ABILITY_TRAY_COOLDOWN, ABILITY_TRAY_SELECTED, ABILITY_TRAY_SELECTED_ACTIVE, ABILITY_TRAY_SELECTED_COOLDOWN);
    private static final AtlasBufferPosColorTex BUFFER = new AtlasBufferPosColorTex(new BufferBuilder(256));
    private static final int LAYER_BG = 0;
    private static final int LAYER_MANA = 1;
    private static final int LAYER_MANA_FX = 2;
    private static final int LAYER_MANA_TEXT = 10;
    private static final int LAYER_COOLDOWNS = 1;
    private static final int LAYER_ICONS = 2;
    private static final int LAYER_SELECTION = 10;
    private static final float[] MANA_FX_LAYER_POSITION_X = new float[]{0.0f, 23.0f, 37.0f};
    private static final float[] MANA_FX_LAYER_POSITION_Y = new float[]{0.0f, 3.0f, 7.0f};
    private static final AtlasBufferPosColorTex.Bounds BOUNDS = new AtlasBufferPosColorTex.Bounds();
    public static final AbilityData ABILITY_DATA = new AbilityData();

    public void render(ForgeIngameGui gui, PoseStack matrixStack, float partialTick, int width, int height) {
        ABILITY_DATA.update();
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        IVaultOptions opts = (IVaultOptions)minecraft.f_91066_;
        if (!opts.isShowAbilitiesWithManaBar()) {
            AbilitiesOverlay.ABILITY_DATA.shouldRender = false;
        }
        if (player == null) {
            return;
        }
        minecraft.m_91307_().m_6180_("abilityBar");
        ITextureAtlas atlas = ModTextureAtlases.ABILITIES.get();
        TextureAtlasSprite spriteTrayBg = AbilitiesOverlay.ABILITY_DATA.shouldRender ? atlas.getSprite(ABILITY_TRAY_BG) : atlas.getSprite(ABILITY_TRAY_MANA_ONLY_BG);
        TextureAtlasSprite spriteTrayManaBar = atlas.getSprite(ABILITY_TRAY_MANA_BAR);
        TextureAtlasSprite[] spriteTrayManaBarFX = new TextureAtlasSprite[]{atlas.getSprite(ABILITY_TRAY_MANA_BAR_FX_0), atlas.getSprite(ABILITY_TRAY_MANA_BAR_FX_1), atlas.getSprite(ABILITY_TRAY_MANA_BAR_FX_2)};
        TextureAtlasSprite spriteTrayCooldown = atlas.getSprite(ABILITY_TRAY_COOLDOWN);
        TextureAtlasSprite spriteTraySelected = atlas.getSprite(ABILITY_TRAY_SELECTED);
        TextureAtlasSprite spriteTraySelectedActive = atlas.getSprite(ABILITY_TRAY_SELECTED_ACTIVE);
        TextureAtlasSprite spriteTraySelectedCooldown = atlas.getSprite(ABILITY_TRAY_SELECTED_COOLDOWN);
        HudPosition abilityAnchor = opts.getHudPositions().getOrDefault("ability_bar", AbilitiesOverlay.defAbilityPos(minecraft));
        int sw = minecraft.m_91268_().m_85445_();
        int sh = minecraft.m_91268_().m_85446_();
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)abilityAnchor.getScaledX(sw), (double)abilityAnchor.getScaledY(sh), 0.0);
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        if (!BUFFER.getBuilder().m_85732_()) {
            BUFFER.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        }
        float mana = Mana.get((Player)player);
        float manaMax = Mana.getMax((Player)player);
        float percentMana = manaMax <= 0.0f ? 0.0f : Mth.m_14036_((float)(mana / manaMax), (float)0.0f, (float)1.0f);
        float manaFillWidth = (float)spriteTrayManaBar.m_118405_() * percentMana;
        RenderSystem.m_69482_();
        RenderSystem.m_69478_();
        BUFFER.add(matrix, 0, 0, 0, spriteTrayBg);
        AbilitiesOverlay.renderManaBar(matrix, spriteTrayManaBar, percentMana, manaFillWidth);
        AbilitiesOverlay.renderManaBarFX(matrix, spriteTrayManaBarFX, mana, manaMax, manaFillWidth, partialTick, Mana.getRegenPerSecond((Player)player), spriteTrayManaBar.m_118405_(), spriteTrayManaBar.m_118408_());
        if (TEXT_RENDER_MODE == TextRenderMode.CUSTOM) {
            minecraft.m_91307_().m_6180_("text");
            AbilitiesOverlay.renderManaCustomText(matrix, mana, spriteTrayManaBar.m_118405_(), atlas.getSprite(ABILITY_TRAY_MANA_FONT));
            minecraft.m_91307_().m_7238_();
        }
        ArrayList<RemainingCooldownPositions> cooldownTimesToRender = new ArrayList<RemainingCooldownPositions>();
        if (AbilitiesOverlay.ABILITY_DATA.shouldRender) {
            AbilitiesOverlay.renderAbilities(matrix, (Player)player, ABILITY_DATA, atlas, spriteTrayCooldown, spriteTraySelected, spriteTraySelectedActive, spriteTraySelectedCooldown, cooldownTimesToRender);
        }
        HudPosition cooldownAnchor = opts.getHudPositions().getOrDefault("cooldowns", AbilitiesOverlay.defCooldownPos(minecraft));
        AbilitiesOverlay.renderAbilitiesOnCooldown(matrix, (Player)player, ClientAbilityData.getLearnedAbilities(), atlas, spriteTrayCooldown, cooldownTimesToRender, abilityAnchor, cooldownAnchor);
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)atlas.getAtlasResourceLocation());
        BUFFER.end();
        if (TEXT_RENDER_MODE == TextRenderMode.MINECRAFT) {
            minecraft.m_91307_().m_6180_("text");
            AbilitiesOverlay.renderManaText(minecraft, spriteTrayManaBar, matrixStack, (int)mana);
            minecraft.m_91307_().m_7238_();
        }
        this.renderCooldownTimes(matrixStack, cooldownTimesToRender);
        RenderSystem.m_69465_();
        matrixStack.m_85849_();
        minecraft.m_91307_().m_7238_();
    }

    private void renderCooldownTimes(PoseStack matrixStack, List<RemainingCooldownPositions> cooldownTimesToRender) {
        cooldownTimesToRender.forEach(cooldown -> AbilitiesOverlay.renderCooldownTimes(matrixStack, cooldown.remainingTicks, cooldown.abilityIconX + 16, cooldown.abilityIconY + 8));
    }

    private static void renderCooldownTimes(PoseStack matrixStack, int remainingTicks, int x, int y) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, 100.0);
        String text = String.valueOf((int)Math.ceil((float)remainingTicks / 20.0f));
        float width = AbilitiesOverlay.minecraft.f_91062_.m_92895_(text);
        AbilitiesOverlay.minecraft.f_91062_.m_92883_(matrixStack, text, (float)x - width, (float)y, Color.WHITE.getRGB());
        matrixStack.m_85849_();
    }

    private static void renderAbilities(Matrix4f matrix, Player player, AbilityData abilityData, ITextureAtlas atlas, TextureAtlasSprite spriteTrayCooldown, TextureAtlasSprite spriteTraySelected, TextureAtlasSprite spriteTraySelectedActive, TextureAtlasSprite spriteTraySelectedCooldown, List<RemainingCooldownPositions> cooldownTimesToRender) {
        TextureAtlasSprite spriteAbilityFocused = AbilitiesOverlay.getAbilityNodeSprite(abilityData.selectAbilityNode.getParent(), atlas);
        TextureAtlasSprite spriteAbilityPrevious = AbilitiesOverlay.getAbilityNodeSprite(abilityData.previousAbilityNode.getParent(), atlas);
        TextureAtlasSprite spriteAbilityNext = AbilitiesOverlay.getAbilityNodeSprite(abilityData.nextAbilityNode.getParent(), atlas);
        Cooldown selectedCooldown = abilityData.selectAbilityNode.getCooldown().orElse(null);
        Cooldown previousCooldown = abilityData.previousAbilityNode.getCooldown().orElse(null);
        Cooldown nextCooldown = abilityData.nextAbilityNode.getCooldown().orElse(null);
        AbilitiesOverlay.renderAbilityCooldowns(matrix, spriteTrayCooldown, cooldownTimesToRender, selectedCooldown, previousCooldown, nextCooldown);
        AbilitiesOverlay.renderAbilityIcons(matrix, spriteAbilityFocused, spriteAbilityPrevious, spriteAbilityNext, selectedCooldown, previousCooldown, nextCooldown);
        AbilitiesOverlay.renderAbilitySelection(matrix, spriteTraySelected, spriteTraySelectedActive, spriteTraySelectedCooldown, selectedCooldown);
    }

    private static void renderAbilitiesOnCooldown(Matrix4f matrix, Player player, List<TieredSkill> abilities, ITextureAtlas atlas, TextureAtlasSprite spriteTrayCooldown, List<RemainingCooldownPositions> cooldownTimesToRender, HudPosition abilityAnchor, HudPosition cooldownAnchor) {
        IVaultOptions options = (IVaultOptions)Minecraft.m_91087_().f_91066_;
        if (options.getCooldownOption() == CooldownGuiOption.OFF) {
            return;
        }
        if (abilities.size() > 0) {
            int sw = Minecraft.m_91087_().m_91268_().m_85445_();
            int sh = Minecraft.m_91087_().m_91268_().m_85446_();
            int baseX = cooldownAnchor.getScaledX(sw) - abilityAnchor.getScaledX(sw);
            int baseY = cooldownAnchor.getScaledY(sh) - abilityAnchor.getScaledY(sh);
            int x = baseX;
            int y = baseY;
            int count = 0;
            for (TieredSkill skill : abilities) {
                Ability ability = (Ability)skill.getChild();
                TextureAtlasSprite spriteAbilityFocused = AbilitiesOverlay.getAbilityNodeSprite(ability.getParent(), atlas);
                Cooldown cooldown = skill.getTreeCooldown().orElse(null);
                if (cooldown == null || cooldown.getRemainingTicks() <= 0) continue;
                int cooldownHeight = AbilitiesOverlay.getCooldownHeight(cooldown.getRemainingTicks(), cooldown.getMaxTicks());
                BUFFER.add(matrix, 3 + x, -20 + y + cooldownHeight, 1, 16, 16 - cooldownHeight, 1.0f, 1.0f, 1.0f, 0.3f, spriteTrayCooldown);
                RenderSystem.m_157456_((int)0, (ResourceLocation)atlas.getAtlasResourceLocation());
                AbilitiesOverlay.renderAbilityIcon(matrix, spriteAbilityFocused, cooldown.getRemainingTicks() > 0, 3 + x, -20 + y, 2);
                cooldownTimesToRender.add(new RemainingCooldownPositions(cooldown.getRemainingTicks(), 3 + x, -20 + y));
                x += 18;
                x += 18;
                if (++count % 4 != 0) continue;
                y -= 18;
                x = baseX;
            }
        }
    }

    private static HudPosition defAbilityPos(Minecraft mc) {
        int w = mc.m_91268_().m_85445_();
        int h = mc.m_91268_().m_85446_();
        return HudPosition.fromPixels(10, h - 36, w, h);
    }

    private static HudPosition defCooldownPos(Minecraft mc) {
        int w = mc.m_91268_().m_85445_();
        int h = mc.m_91268_().m_85446_();
        HudPosition ability = AbilitiesOverlay.defAbilityPos(mc);
        return HudPosition.fromPixels(ability.getScaledX(w) + 3, ability.getScaledY(h) - 20, w, h);
    }

    private static void renderAbilitySelection(Matrix4f matrix, TextureAtlasSprite spriteTraySelected, TextureAtlasSprite spriteTraySelectedActive, TextureAtlasSprite spriteTraySelectedCooldown, Cooldown selectedCooldown) {
        if (selectedCooldown != null && selectedCooldown.getRemainingTicks() > 0) {
            BUFFER.add(matrix, 19, 13, 10, spriteTraySelectedCooldown);
        } else {
            Ability selected = ClientAbilityData.getSelectedAbility();
            if (selected != null && selected.isActive()) {
                BUFFER.add(matrix, 19, 13, 10, spriteTraySelectedActive);
            } else {
                BUFFER.add(matrix, 19, 13, 10, spriteTraySelected);
            }
        }
    }

    private static void renderAbilityIcons(Matrix4f matrix, TextureAtlasSprite spriteAbilityFocused, TextureAtlasSprite spriteAbilityPrevious, TextureAtlasSprite spriteAbilityNext, Cooldown selectedCooldown, Cooldown previousCooldown, Cooldown nextCooldown) {
        ITextureAtlas atlas = ModTextureAtlases.ABILITIES.get();
        RenderSystem.m_157456_((int)0, (ResourceLocation)atlas.getAtlasResourceLocation());
        AbilitiesOverlay.renderAbilityIcon(matrix, spriteAbilityFocused, selectedCooldown != null && selectedCooldown.getRemainingTicks() > 0, 23, 17, 2);
        AbilitiesOverlay.renderAbilityIcon(matrix, spriteAbilityPrevious, previousCooldown != null && previousCooldown.getRemainingTicks() > 0, 43, 17, 2);
        AbilitiesOverlay.renderAbilityIcon(matrix, spriteAbilityNext, nextCooldown != null && nextCooldown.getRemainingTicks() > 0, 3, 17, 2);
    }

    private static void renderAbilityIcon(Matrix4f matrix, TextureAtlasSprite sprite, boolean grayscaled, int x, int y, int z) {
        if (grayscaled) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            ModShaders.getGrayscalePositionTexShader().withGrayscale(1.0f).withBrightness(0.5f).enable();
        } else {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
        }
        ScreenDrawHelper.draw(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_, buffer -> {
            buffer.m_85982_(matrix, (float)x, (float)(y + sprite.m_118408_()), (float)z).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_5752_();
            buffer.m_85982_(matrix, (float)(x + sprite.m_118405_()), (float)(y + sprite.m_118408_()), (float)z).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_5752_();
            buffer.m_85982_(matrix, (float)(x + sprite.m_118405_()), (float)y, (float)z).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_5752_();
            buffer.m_85982_(matrix, (float)x, (float)y, (float)z).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_5752_();
        });
    }

    private static void renderAbilityCooldowns(Matrix4f matrix, TextureAtlasSprite spriteTrayCooldown, List<RemainingCooldownPositions> cooldownTimesToRender, Cooldown selectedCooldown, Cooldown previousCooldown, Cooldown nextCooldown) {
        int cooldownHeight;
        if (selectedCooldown != null && selectedCooldown.getRemainingTicks() > 0) {
            cooldownHeight = AbilitiesOverlay.getCooldownHeight(selectedCooldown.getRemainingTicks(), selectedCooldown.getMaxTicks());
            BUFFER.add(matrix, 23, 17 + cooldownHeight, 1, 16, 16 - cooldownHeight, 1.0f, 1.0f, 1.0f, 0.3f, spriteTrayCooldown);
            cooldownTimesToRender.add(new RemainingCooldownPositions(selectedCooldown.getRemainingTicks(), 23, 17));
        }
        if (previousCooldown != null && previousCooldown.getRemainingTicks() > 0) {
            cooldownHeight = AbilitiesOverlay.getCooldownHeight(previousCooldown.getRemainingTicks(), previousCooldown.getMaxTicks());
            BUFFER.add(matrix, 43, 17 + cooldownHeight, 1, 16, 16 - cooldownHeight, 1.0f, 1.0f, 1.0f, 0.3f, spriteTrayCooldown);
            cooldownTimesToRender.add(new RemainingCooldownPositions(previousCooldown.getRemainingTicks(), 43, 17));
        }
        if (nextCooldown != null && nextCooldown.getRemainingTicks() > 0) {
            cooldownHeight = AbilitiesOverlay.getCooldownHeight(nextCooldown.getRemainingTicks(), nextCooldown.getMaxTicks());
            BUFFER.add(matrix, 3, 17 + cooldownHeight, 1, 16, 16 - cooldownHeight, 1.0f, 1.0f, 1.0f, 0.3f, spriteTrayCooldown);
            cooldownTimesToRender.add(new RemainingCooldownPositions(nextCooldown.getRemainingTicks(), 3, 17));
        }
    }

    private static void renderManaText(Minecraft minecraft, TextureAtlasSprite spriteTrayManaBar, PoseStack matrixStack, int mana) {
        matrixStack.m_85836_();
        String manaString = String.valueOf(mana);
        float pX = 4.0f + ((float)spriteTrayManaBar.m_118405_() - (float)minecraft.f_91062_.m_92895_(manaString) * 0.5f) * 0.5f;
        float f = spriteTrayManaBar.m_118408_();
        Objects.requireNonNull(minecraft.f_91062_);
        float pY = 4.0f + (f - 9.0f * 0.5f) * 0.5f;
        matrixStack.m_85837_((double)pX, (double)pY, 10.0);
        matrixStack.m_85841_(0.5f, 0.5f, 1.0f);
        minecraft.f_91062_.m_92750_(matrixStack, manaString, 0.0f, 0.0f, Color.CYAN.getRGB());
        matrixStack.m_85849_();
    }

    private static void renderManaBar(Matrix4f matrix, TextureAtlasSprite spriteTrayManaBar, float percentMana, float manaFillWidth) {
        int x = 4;
        int y = 4;
        int height = spriteTrayManaBar.m_118408_();
        float u0 = spriteTrayManaBar.m_118409_();
        float u1 = u0 + (spriteTrayManaBar.m_118410_() - u0) * percentMana;
        float v0 = spriteTrayManaBar.m_118411_();
        float v1 = spriteTrayManaBar.m_118412_();
        BufferBuilder builder = BUFFER.getBuilder();
        builder.m_85982_(matrix, 4.0f, (float)(4 + height), 1.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u0, v1).m_5752_();
        builder.m_85982_(matrix, 4.0f + manaFillWidth, (float)(4 + height), 1.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u1, v1).m_5752_();
        builder.m_85982_(matrix, 4.0f + manaFillWidth, 4.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u1, v0).m_5752_();
        builder.m_85982_(matrix, 4.0f, 4.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u0, v0).m_5752_();
    }

    private static void renderManaBarFX(Matrix4f matrix, TextureAtlasSprite[] spriteTrayManaBarFX, float mana, float manaMax, float manaFillWidth, float partialTicks, float regenPerSecond, int manaBarWidth, int manaBarHeight) {
        boolean isManaRegen = !Mth.m_14033_((float)regenPerSecond, (float)0.0f) && !Mth.m_14033_((float)mana, (float)manaMax);
        int trailSize = isManaRegen ? 3 : 1;
        float horizontalSpeedScalar = isManaRegen ? Math.max(0.0f, regenPerSecond) : 0.0f;
        float verticalSpeedScalar = isManaRegen ? 0.0f : 1.0f;
        BOUNDS.set(4.0f, 4.0f, 4.0f + manaFillWidth, 4 + manaBarHeight);
        for (int layer = 0; layer < spriteTrayManaBarFX.length; ++layer) {
            int n = layer;
            MANA_FX_LAYER_POSITION_X[n] = (float)((double)MANA_FX_LAYER_POSITION_X[n] + (double)partialTicks * Math.pow(0.005f, (double)layer * 0.25 + 1.0) * 30.0 * (double)horizontalSpeedScalar);
            int n2 = layer;
            MANA_FX_LAYER_POSITION_Y[n2] = (float)((double)MANA_FX_LAYER_POSITION_Y[n2] - (double)partialTicks * Math.pow(0.002f, (double)layer * 0.25 + 1.0) * 30.0 * (double)verticalSpeedScalar);
            for (int trail = 0; trail < trailSize; ++trail) {
                TextureAtlasSprite sprite = spriteTrayManaBarFX[layer];
                float alpha = (float)Math.pow(0.4f - 0.1f * (float)layer, (double)trail * 0.5 + 1.0);
                int negX = 4 + (int)(MANA_FX_LAYER_POSITION_X[layer] - (float)spriteTrayManaBarFX[layer].m_118405_()) - trail - 1;
                int posX = 4 + (int)MANA_FX_LAYER_POSITION_X[layer] - trail;
                int negY = 4 + (int)(MANA_FX_LAYER_POSITION_Y[layer] - (float)spriteTrayManaBarFX[layer].m_118408_()) - 1;
                int posY = 4 + (int)MANA_FX_LAYER_POSITION_Y[layer];
                int z = 2 + layer;
                int spriteWidth = sprite.m_118405_();
                int spriteHeight = sprite.m_118408_();
                BUFFER.addBounded(matrix, negX, posY, z, spriteWidth, spriteHeight, 0.0f, 1.0f, 1.0f, alpha, sprite, BOUNDS);
                BUFFER.addBounded(matrix, posX, posY, z, spriteWidth, spriteHeight, 0.0f, 1.0f, 1.0f, alpha, sprite, BOUNDS);
                BUFFER.addBounded(matrix, negX, negY, z, spriteWidth, spriteHeight, 0.0f, 1.0f, 1.0f, alpha, sprite, BOUNDS);
                BUFFER.addBounded(matrix, posX, negY, z, spriteWidth, spriteHeight, 0.0f, 1.0f, 1.0f, alpha, sprite, BOUNDS);
            }
            if (MANA_FX_LAYER_POSITION_X[layer] > (float)manaBarWidth) {
                int n3 = layer;
                MANA_FX_LAYER_POSITION_X[n3] = MANA_FX_LAYER_POSITION_X[n3] - (float)manaBarWidth;
            }
            if (!(MANA_FX_LAYER_POSITION_Y[layer] < 0.0f)) continue;
            int n4 = layer;
            MANA_FX_LAYER_POSITION_Y[n4] = MANA_FX_LAYER_POSITION_Y[n4] + (float)manaBarHeight;
        }
    }

    private static void renderManaCustomText(Matrix4f matrix, float mana, int manaBarWidth, TextureAtlasSprite spriteTrayManaFont) {
        int fontWidth = 5;
        BufferBuilder builder = BUFFER.getBuilder();
        String text = String.valueOf((int)Math.floor(mana));
        float textOriginX = 4.0f + (float)(manaBarWidth - text.length() * 5) * 0.5f;
        float uWidth = (spriteTrayManaFont.m_118410_() - spriteTrayManaFont.m_118409_()) * 0.1f;
        for (int i = 0; i < text.length(); ++i) {
            int intValue = Integer.parseInt(text.substring(i, i + 1));
            float uOffset = spriteTrayManaFont.m_118409_() + uWidth * (float)intValue;
            float textX = textOriginX + (float)(5 * i);
            builder.m_85982_(matrix, textX, 12.0f, 10.0f).m_85950_(0.0f, 1.0f, 1.0f, 1.0f).m_7421_(uOffset, spriteTrayManaFont.m_118412_()).m_5752_();
            builder.m_85982_(matrix, textX + 5.0f, 12.0f, 10.0f).m_85950_(0.0f, 1.0f, 1.0f, 1.0f).m_7421_(uOffset + uWidth, spriteTrayManaFont.m_118412_()).m_5752_();
            builder.m_85982_(matrix, textX + 5.0f, 5.0f, 10.0f).m_85950_(0.0f, 1.0f, 1.0f, 1.0f).m_7421_(uOffset + uWidth, spriteTrayManaFont.m_118411_()).m_5752_();
            builder.m_85982_(matrix, textX, 5.0f, 10.0f).m_85950_(0.0f, 1.0f, 1.0f, 1.0f).m_7421_(uOffset, spriteTrayManaFont.m_118411_()).m_5752_();
        }
    }

    private static int getCooldownHeight(float cooldown, int cooldownMax) {
        float cooldownPercent = 1.0f - cooldown / (float)Math.max(1, cooldownMax);
        return (int)(16.0f * cooldownPercent);
    }

    private static TextureAtlasSprite getAbilityNodeSprite(Skill node, ITextureAtlas atlas) {
        String styleKey = node.getId();
        return atlas.getSprite(ModConfigs.ABILITIES_GUI.getIcon(styleKey));
    }

    public static class AbilityData {
        private Ability selectAbilityNode;
        private Ability previousAbilityNode;
        private Ability nextAbilityNode;
        public boolean shouldRender;

        private void update() {
            List<TieredSkill> abilities = ClientAbilityData.getLearnedAbilities();
            if (abilities.isEmpty()) {
                this.shouldRender = false;
                return;
            }
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                this.shouldRender = false;
                return;
            }
            this.selectAbilityNode = ClientAbilityData.getSelectedAbility();
            if (this.selectAbilityNode == null) {
                this.shouldRender = false;
                return;
            }
            int selectedAbilityIndex = ClientAbilityData.getIndexOf(this.selectAbilityNode.getParent().getId());
            if (selectedAbilityIndex == -1) {
                this.shouldRender = false;
                return;
            }
            int previousIndex = selectedAbilityIndex - 1;
            if (previousIndex < 0) {
                previousIndex += abilities.size();
            }
            this.previousAbilityNode = (Ability)abilities.get(previousIndex).getChild();
            int nextIndex = selectedAbilityIndex + 1;
            if (nextIndex >= abilities.size()) {
                nextIndex -= abilities.size();
            }
            this.nextAbilityNode = (Ability)abilities.get(nextIndex).getChild();
            this.shouldRender = true;
        }
    }

    private static enum TextRenderMode {
        MINECRAFT,
        CUSTOM;

    }

    private record RemainingCooldownPositions(int remainingTicks, int abilityIconX, int abilityIconY) {
    }
}

