/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import iskallia.vault.client.ClientAbilityData;
import iskallia.vault.client.atlas.AtlasBufferPosColorTex;
import iskallia.vault.client.atlas.ITextureAtlas;
import iskallia.vault.client.gui.helper.ScreenDrawHelper;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModShaders;
import iskallia.vault.init.ModTextureAtlases;
import iskallia.vault.skill.ability.effect.spi.AbstractBonkAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.TieredSkill;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;

@OnlyIn(value=Dist.CLIENT)
public class BonkOverlay
implements IIngameOverlay {
    private static final Minecraft minecraft = Minecraft.m_91087_();
    private static final AtlasBufferPosColorTex BUFFER = new AtlasBufferPosColorTex(new BufferBuilder(256));
    private static final int LAYER_MANA_TEXT = 10;
    private static final int LAYER_ICONS = 2;

    public void render(ForgeIngameGui gui, PoseStack matrixStack, float partialTick, int width, int height) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        MobEffectInstance battleCry = player.m_21124_(ModEffects.BATTLE_CRY);
        if (battleCry == null && (battleCry = player.m_21124_(ModEffects.BATTLE_CRY_SPECTRAL_STRIKE)) == null && (battleCry = player.m_21124_(ModEffects.BATTLE_CRY_LUCKY_STRIKE)) == null) {
            return;
        }
        minecraft.m_91307_().m_6180_("abilityBar");
        ITextureAtlas atlas = ModTextureAtlases.ABILITIES.get();
        matrixStack.m_85836_();
        if (!BUFFER.getBuilder().m_85732_()) {
            BUFFER.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        }
        RenderSystem.m_69482_();
        RenderSystem.m_69478_();
        List<TieredSkill> abilities = ClientAbilityData.getLearnedAbilities();
        BonkOverlay.renderBonk(matrixStack, battleCry, abilities, atlas);
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)atlas.getAtlasResourceLocation());
        BUFFER.end();
        minecraft.m_91307_().m_6180_("text");
        BonkOverlay.renderBonkText(minecraft, matrixStack, battleCry, abilities);
        minecraft.m_91307_().m_7238_();
        RenderSystem.m_69465_();
        matrixStack.m_85849_();
        minecraft.m_91307_().m_7238_();
    }

    private static void renderBonk(PoseStack matrixStack, MobEffectInstance battleCry, List<TieredSkill> abilities, ITextureAtlas atlas) {
        for (TieredSkill skill : abilities) {
            matrixStack.m_85836_();
            Ability ability = (Ability)skill.getChild();
            if (!(ability instanceof AbstractBonkAbility)) continue;
            int x = 0;
            int y = 0;
            int screenWidth = minecraft.m_91268_().m_85445_();
            int screenHeight = minecraft.m_91268_().m_85446_();
            TextureAtlasSprite spriteAbilityFocused = BonkOverlay.getAbilityNodeSprite(ability.getParent(), atlas);
            RenderSystem.m_157456_((int)0, (ResourceLocation)atlas.getAtlasResourceLocation());
            Matrix4f matrix = matrixStack.m_85850_().m_85861_();
            matrixStack.m_85837_(1.5, 0.0, 0.0);
            BonkOverlay.renderAbilityIcon(matrix, spriteAbilityFocused, x += screenWidth / 2 - 9, y += screenHeight / 2 + 10, 2);
            matrixStack.m_85849_();
        }
    }

    private static void renderAbilityIcon(Matrix4f matrix, TextureAtlasSprite sprite, int x, int y, int z) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        ModShaders.getGrayscalePositionTexShader().withGrayscale(0.5f).withBrightness(0.5f).enable();
        ScreenDrawHelper.draw(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_, buffer -> {
            buffer.m_85982_(matrix, (float)x, (float)(y + sprite.m_118408_()), (float)z).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_5752_();
            buffer.m_85982_(matrix, (float)(x + sprite.m_118405_()), (float)(y + sprite.m_118408_()), (float)z).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_5752_();
            buffer.m_85982_(matrix, (float)(x + sprite.m_118405_()), (float)y, (float)z).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_5752_();
            buffer.m_85982_(matrix, (float)x, (float)y, (float)z).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_5752_();
        });
    }

    private static void renderBonkText(Minecraft minecraft, PoseStack matrixStack, MobEffectInstance battleCry, List<TieredSkill> abilities) {
        for (TieredSkill skill : abilities) {
            Ability ability = (Ability)skill.getChild();
            if (!(ability instanceof AbstractBonkAbility)) continue;
            AbstractBonkAbility bonkAbility = (AbstractBonkAbility)ability;
            matrixStack.m_85836_();
            String stacks = String.valueOf(battleCry.m_19564_() + 1);
            int x = 0;
            int y = 0;
            int screenWidth = minecraft.m_91268_().m_85445_();
            int screenHeight = minecraft.m_91268_().m_85446_();
            int max = bonkAbility.getMaxStacksTotal();
            float f = Math.max(0.0f, (float)(battleCry.m_19564_() + 1) / (float)max);
            matrixStack.m_85837_((double)((float)(x += screenWidth / 2 + 2) - (float)minecraft.f_91062_.m_92895_(stacks) / 2.0f), (double)(y += screenHeight / 2 + 10 + 16), 10.0);
            matrixStack.m_85841_(0.75f, 0.75f, 1.0f);
            minecraft.f_91062_.m_92756_(matrixStack, stacks, 0.0f, 0.0f, Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)0.25f), true);
            matrixStack.m_85849_();
        }
    }

    private static TextureAtlasSprite getAbilityNodeSprite(Skill node, ITextureAtlas atlas) {
        String styleKey = node.getId();
        return atlas.getSprite(ModConfigs.ABILITIES_GUI.getIcon(styleKey));
    }
}

