/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.VaultMod;
import iskallia.vault.bounty.Bounty;
import iskallia.vault.bounty.BountyList;
import iskallia.vault.bounty.client.ClientBountyData;
import iskallia.vault.bounty.task.CompletionTask;
import iskallia.vault.bounty.task.ItemDiscoveryTask;
import iskallia.vault.bounty.task.ItemSubmissionTask;
import iskallia.vault.bounty.task.KillEntityTask;
import iskallia.vault.bounty.task.MiningTask;
import iskallia.vault.bounty.task.Task;
import iskallia.vault.bounty.task.properties.CompletionProperties;
import iskallia.vault.bounty.task.properties.ItemDiscoveryProperties;
import iskallia.vault.bounty.task.properties.ItemSubmissionProperties;
import iskallia.vault.bounty.task.properties.KillEntityProperties;
import iskallia.vault.bounty.task.properties.MiningProperties;
import iskallia.vault.bounty.task.properties.TaskProperties;
import iskallia.vault.client.gui.screen.bounty.BountyScreen;
import iskallia.vault.client.gui.screen.bounty.element.BountyElement;
import iskallia.vault.init.ModKeybinds;
import iskallia.vault.util.GroupUtils;
import iskallia.vault.util.TextUtil;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.registries.ForgeRegistries;

public class BountyProgressOverlay
implements IIngameOverlay {
    protected static final ResourceLocation BOUNTY_PROGRESS_LOCATION = VaultMod.id("textures/gui/bounty_progress.png");
    private HashMap<UUID, Set<String>> killEntityTargets = new HashMap();
    long time = 1000L;
    long deltaTime;
    HashMap<UUID, Integer> currentIndex = new HashMap();

    public void render(ForgeIngameGui gui, PoseStack poseStack, float partialTick, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_) {
            return;
        }
        if (ClientBountyData.INSTANCE.getBounties().isEmpty()) {
            return;
        }
        this.updateTime();
        if (ModKeybinds.bountyStatusKey.m_90857_()) {
            this.renderBounties(gui, poseStack, partialTick, width, height);
        }
    }

    private void renderBounties(ForgeIngameGui gui, PoseStack poseStack, float partialTick, int width, int height) {
        int startY;
        Minecraft mc = Minecraft.m_91087_();
        ProfilerFiller profiler = mc.m_91307_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        profiler.m_6180_("BountyProgressOverlay");
        int midX = mc.m_91268_().m_85445_() / 2;
        int midY = mc.m_91268_().m_85446_() / 2;
        int bountyHeight = 50;
        BountyList bounties = ClientBountyData.INSTANCE.getBounties();
        this.clearCompletedTargets(bounties);
        int y = startY = midY - bounties.size() * bountyHeight / 2;
        for (Bounty bounty : bounties) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)BOUNTY_PROGRESS_LOCATION);
            this.renderBounty(bounty, gui, poseStack, midX, y);
            y += bountyHeight + 5;
        }
        if (this.time <= 0L) {
            this.time = 1000L;
        }
        profiler.m_7238_();
    }

    private void clearCompletedTargets(BountyList bounties) {
        HashSet<UUID> completedTargets = new HashSet<UUID>();
        for (UUID uuid : this.killEntityTargets.keySet()) {
            if (bounties.contains(uuid)) continue;
            completedTargets.add(uuid);
        }
        completedTargets.forEach(this.killEntityTargets::remove);
    }

    private void updateTime() {
        long currentTime = System.currentTimeMillis();
        if (this.deltaTime == 0L) {
            this.deltaTime = currentTime;
        }
        if (currentTime > this.deltaTime) {
            this.time -= currentTime - this.deltaTime;
        }
        this.deltaTime = currentTime;
    }

    private void updateIndex(UUID bountyId) {
        int current;
        Set targets = this.killEntityTargets.getOrDefault(bountyId, Set.of());
        if (targets.isEmpty()) {
            this.currentIndex.remove(bountyId);
            return;
        }
        int n = current = this.currentIndex.get(bountyId) == null ? 0 : this.currentIndex.get(bountyId);
        current = current + 1 >= targets.size() ? 0 : ++current;
        this.currentIndex.put(bountyId, current);
    }

    private void renderBounty(Bounty bounty, ForgeIngameGui gui, PoseStack poseStack, int midX, int startY) {
        int iconX;
        TextComponent target;
        ChatFormatting color;
        Task<?> task = bounty.getTask();
        int width = 130;
        int iconY = 62;
        int iconWidth = 14;
        int iconHeight = 16;
        BountyElement.Status status = ((TaskProperties)task.getProperties()).getRewardPool().equalsIgnoreCase("legendary") ? BountyElement.Status.LEGENDARY : BountyElement.Status.ACTIVE;
        ChatFormatting chatFormatting = color = status == BountyElement.Status.LEGENDARY ? ChatFormatting.YELLOW : ChatFormatting.GREEN;
        if (task instanceof KillEntityTask) {
            KillEntityTask killEntityTask = (KillEntityTask)task;
            this.killEntityTargets.computeIfAbsent(bounty.getId(), id -> GroupUtils.getEntityNamesAsString(((KillEntityProperties)killEntityTask.getProperties()).getFilter()));
            if (this.time <= 0L) {
                this.updateIndex(bounty.getId());
            }
            List components = List.copyOf((Collection)this.killEntityTargets.get(bounty.getId()));
            target = new TextComponent((String)components.get(this.currentIndex.get(bounty.getId())));
            iconX = 0;
        } else if (task instanceof CompletionTask) {
            CompletionTask completionTask = (CompletionTask)task;
            target = BountyScreen.OBJECTIVE_NAME.getOrDefault(((CompletionProperties)completionTask.getProperties()).getId(), new TextComponent("Empty - Report to Dev"));
            iconX = 14;
        } else if (task instanceof ItemSubmissionTask) {
            ItemSubmissionTask itemSubmissionTask = (ItemSubmissionTask)task;
            item = (Item)ForgeRegistries.ITEMS.getValue(((ItemSubmissionProperties)itemSubmissionTask.getProperties()).getItemId());
            target = item == null ? TextUtil.formatLocationPathAsProperNoun(((ItemSubmissionProperties)itemSubmissionTask.getProperties()).getItemId()) : new TextComponent(item.m_41466_().getString());
            iconX = 28;
        } else if (task instanceof ItemDiscoveryTask) {
            ItemDiscoveryTask itemDiscoveryTask = (ItemDiscoveryTask)task;
            item = (Item)ForgeRegistries.ITEMS.getValue(((ItemDiscoveryProperties)itemDiscoveryTask.getProperties()).getItemId());
            target = item == null ? TextUtil.formatLocationPathAsProperNoun(((ItemDiscoveryProperties)itemDiscoveryTask.getProperties()).getItemId()) : new TextComponent(item.m_41466_().getString());
            iconX = 42;
        } else if (task instanceof MiningTask) {
            MiningTask miningTask = (MiningTask)task;
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(((MiningProperties)miningTask.getProperties()).getBlockId());
            target = block == null ? TextUtil.formatLocationPathAsProperNoun(((MiningProperties)miningTask.getProperties()).getBlockId()) : new TextComponent(block.m_49954_().getString());
            iconX = 56;
        } else {
            return;
        }
        target.m_7383_().m_131157_(color);
        int headerX = 0;
        int headerY = 14;
        int headerWidth = width;
        int headerHeight = 22;
        int y = startY;
        int x = 1;
        gui.m_93228_(poseStack, x + 3, y + 23, 20, 36, 124, 15);
        gui.m_93228_(poseStack, x, y + 2, headerX, headerY, headerWidth, headerHeight);
        int iconBoxX = 0;
        int iconBoxY = 36;
        int iconBoxWidth = 20;
        int iconBoxHeight = 26;
        gui.m_93228_(poseStack, x + 4, y, iconBoxX, iconBoxY, iconBoxWidth, iconBoxHeight);
        gui.m_93228_(poseStack, x + 7, y + 5, iconX, iconY, iconWidth, iconHeight);
        gui.m_93228_(poseStack, x + 5, y + 28, 0, 0, 120, 7);
        float progress = (float)(task.getAmountObtained() / ((TaskProperties)task.getProperties()).getAmount());
        gui.m_93228_(poseStack, x + 5, y + 28, 0, 7, (int)(120.0f * progress), 7);
        DecimalFormat df = new DecimalFormat("0");
        TextComponent progressComponent = new TextComponent(df.format(task.getAmountObtained()) + "/" + df.format(((TaskProperties)task.getProperties()).getAmount()));
        int progressX = x + headerWidth / 2 - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)progressComponent) / 2;
        GuiComponent.m_93243_((PoseStack)poseStack, (Font)Minecraft.m_91087_().f_91062_, (Component)target, (int)(x + 25), (int)(y + 9), (int)color.m_126665_());
        GuiComponent.m_93243_((PoseStack)poseStack, (Font)Minecraft.m_91087_().f_91062_, (Component)progressComponent, (int)progressX, (int)(y + 27), (int)0xFFFFFF);
    }
}

