/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import iskallia.vault.VaultMod;
import iskallia.vault.core.vault.ClientVaults;
import iskallia.vault.entity.entity.FloatingItemEntity;
import iskallia.vault.item.CompanionEggItem;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;

@OnlyIn(value=Dist.CLIENT)
public class CompanionEggHuntOverlay
implements IIngameOverlay {
    private static final ResourceLocation VIGNETTE = VaultMod.id("textures/gui/egg_vignette.png");
    private static final float MAX_DISTANCE = 128.0f;

    public void render(ForgeIngameGui gui, PoseStack matrixStack, float partialTick, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || ClientVaults.getActive().isEmpty()) {
            return;
        }
        Vec3 pos = player.m_20182_();
        AABB box = new AABB(pos.f_82479_ - 128.0, pos.f_82480_ - 128.0, pos.f_82481_ - 128.0, pos.f_82479_ + 128.0, pos.f_82480_ + 128.0, pos.f_82481_ + 128.0);
        List eggs = player.f_19853_.m_6443_(FloatingItemEntity.class, box, e -> e.m_32055_().m_41720_() instanceof CompanionEggItem);
        if (eggs.isEmpty()) {
            return;
        }
        double distance = Math.sqrt(eggs.stream().mapToDouble(e -> e.m_20280_((Entity)player)).min().orElse(Double.MAX_VALUE));
        ItemStack nearestEgg = eggs.stream().min(Comparator.comparingDouble(a -> a.m_20280_((Entity)player))).map(ItemEntity::m_32055_).orElse(ItemStack.f_41583_);
        float alphaFactor = (float)Mth.m_14008_((double)(distance / 128.0), (double)0.0, (double)1.0);
        float alpha = 0.65f - (alphaFactor = (float)Mth.m_14008_((double)(Math.exp(alphaFactor) - 1.0), (double)0.0, (double)1.0));
        if (alpha <= 0.0f) {
            return;
        }
        this.renderVignette(TextColor.m_131266_((int)5800135), alpha, matrixStack, width, height);
    }

    private void renderVignette(TextColor color, float alpha, PoseStack matrixStack, int width, int height) {
        RenderSystem.m_69465_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        int colorValue = color.m_131265_();
        float r = (float)(colorValue >> 16 & 0xFF) / 255.0f;
        float g = (float)(colorValue >> 8 & 0xFF) / 255.0f;
        float b = (float)(colorValue & 0xFF) / 255.0f;
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)alpha);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)VIGNETTE);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_5483_(0.0, (double)height, -90.0).m_7421_(0.0f, 1.0f).m_5752_();
        buffer.m_5483_((double)width, (double)height, -90.0).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_5483_((double)width, 0.0, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_5483_(0.0, 0.0, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69482_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69453_();
    }
}

