/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import iskallia.vault.VaultMod;
import iskallia.vault.client.render.IVaultOptions;
import iskallia.vault.init.ModEffects;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;

public class HarmfulPotionOverlay
implements IIngameOverlay {
    protected static final ResourceLocation VIGNETTE_LOCATION = VaultMod.id("textures/gui/vignette.png");
    private static final int MAX_ALPHA_DURATION = 300;
    private static final Map<MobEffect, BiFunction<Integer, Integer, Float>> EFFECT_ALPHA = Map.of(MobEffects.f_19614_, (duration, amplifier) -> Float.valueOf((float)Math.min(duration, 300) / 300.0f * 0.75f), MobEffects.f_19615_, (duration, amplifier) -> Float.valueOf((float)Math.min(duration, 300) / 300.0f * 1.0f), ModEffects.BLEED, (duration, amplifier) -> Float.valueOf((float)Math.min(duration, 3) * (float)amplifier.intValue() / 20.0f));

    public void render(ForgeIngameGui gui, PoseStack matrixStack, float partialTick, int width, int height) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null || minecraft.m_91288_() != minecraft.f_91074_ || ((IVaultOptions)minecraft.f_91066_).doVanillaPotionDamageEffects()) {
            return;
        }
        for (Map.Entry<MobEffect, BiFunction<Integer, Integer, Float>> entry : EFFECT_ALPHA.entrySet()) {
            if (!minecraft.f_91074_.m_21023_(entry.getKey())) continue;
            this.renderEffect(width, height, entry.getKey(), minecraft.f_91074_, entry.getValue());
            break;
        }
    }

    private void renderEffect(int width, int height, MobEffect effect, LocalPlayer player, BiFunction<Integer, Integer, Float> getAlpha) {
        MobEffectInstance effectInstance = player.m_21124_(effect);
        if (effectInstance == null) {
            return;
        }
        float alpha = getAlpha.apply(effectInstance.m_19557_(), effectInstance.m_19564_()).floatValue();
        this.render(effect.m_19484_(), width, height, VIGNETTE_LOCATION, alpha);
    }

    protected void render(int color, int width, int height, ResourceLocation vignetteLocation, float alpha) {
        this.renderVignette(color, alpha, width, height, vignetteLocation);
    }

    protected void renderVignette(int color, float alpha, int width, int height, ResourceLocation texture) {
        RenderSystem.m_69465_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        float b = (float)(color & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)alpha);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_5483_(0.0, (double)height, -90.0).m_7421_(0.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_((double)width, (double)height, -90.0).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_((double)width, 0.0, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder.m_5483_(0.0, 0.0, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69482_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69453_();
    }
}

