/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.helper.FontHelper;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;

@OnlyIn(value=Dist.CLIENT)
public class PlayerAbsorptionOverlay
implements IIngameOverlay {
    private static final int HEART_ROW_LENGTH = 10;
    private static final int HEART_ICON_SPACING = 8;
    private static final int OVERLAY_HEIGHT = 10;

    public void render(ForgeIngameGui gui, PoseStack poseStack, float partialTick, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_ || !gui.shouldDrawSurvivalElements()) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        float absorptionAmount = player.m_6103_();
        if (absorptionAmount <= 0.0f) {
            return;
        }
        gui.setupOverlayRenderState(true, false);
        RenderSystem.m_69478_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
        int left = width / 2 - 91;
        int top = height - gui.left_height;
        PlayerAbsorptionOverlay.renderHeartRow(poseStack, left, top, absorptionAmount);
        float hearts = absorptionAmount / 2.0f;
        if (hearts >= 10.0f) {
            String heartsText = PlayerAbsorptionOverlay.formatHeartsText(hearts);
            FontHelper.drawStringWithBorder(poseStack, heartsText, (float)(left + 80 + 2), (float)(top + 1), -7316, -16777216);
        }
        gui.left_height += 10;
        RenderSystem.m_69461_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
        gui.setupOverlayRenderState(true, false);
    }

    private static void renderHeartRow(PoseStack poseStack, int left, int top, float hearts) {
        boolean hasHalf = hearts % 1.0f != 0.0f;
        int i = 0;
        while ((double)i < Math.floor(Math.min(10.0f, hearts))) {
            int x = left + i * 8;
            GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)top, (float)Gui.HeartType.CONTAINER.m_168734_(false, false), (float)0.0f, (int)9, (int)9, (int)256, (int)256);
            GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)top, (float)Gui.HeartType.ABSORBING.m_168734_(false, false), (float)0.0f, (int)9, (int)9, (int)256, (int)256);
            ++i;
        }
        if (hearts > 10.0f && hearts % 1.0f != 0.0f) {
            int x = left + 80;
            GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)top, (float)Gui.HeartType.CONTAINER.m_168734_(false, false), (float)0.0f, (int)9, (int)9, (int)256, (int)256);
            GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)top, (float)Gui.HeartType.ABSORBING.m_168734_(true, false), (float)0.0f, (int)9, (int)9, (int)256, (int)256);
        }
    }

    private static String formatHeartsText(float hearts) {
        int wholeHearts = Mth.m_14143_((float)hearts);
        if (Mth.m_14033_((float)hearts, (float)wholeHearts)) {
            return Integer.toString(wholeHearts);
        }
        return String.format(Locale.ROOT, "%.1f", Float.valueOf(hearts));
    }
}

