/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.VaultMod;
import iskallia.vault.client.render.HudPosition;
import iskallia.vault.client.render.IVaultOptions;
import iskallia.vault.init.ModEffects;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class PotionStatusOverlay {
    private static final String HUD_KEY = "potions";
    private static final int ICON_SIZE = 24;
    private static final int EFFECT_SIZE = 18;
    private static final int ICON_OFFSET = 3;
    private static final GuiComponent GUI_HELPER = new GuiComponent(){};
    private static final Map<MobEffect, Integer> maxDurations = new HashMap<MobEffect, Integer>();
    private static final Map<MobEffect, EffectInfo> effectInfos = new HashMap<MobEffect, EffectInfo>();
    private static int lastPlayerTick = -1;
    private static final int REFRESH_CYCLE_THRESHOLD = 3;

    public static void render(PoseStack pose) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        List<MobEffectInstance> raw = player.m_21220_().stream().filter(e -> {
            ResourceLocation id = ForgeRegistries.MOB_EFFECTS.getKey((IForgeRegistryEntry)e.m_19544_());
            if (id == null) {
                return false;
            }
            if (id.m_135827_().contains("xaero")) {
                return false;
            }
            return e.m_19575_() || e.m_19572_();
        }).toList();
        if (raw.isEmpty()) {
            maxDurations.clear();
            return;
        }
        IVaultOptions opts = (IVaultOptions)mc.f_91066_;
        float potionScale = opts.getPotionScale();
        HudPosition anchor = opts.getHudPositions().getOrDefault(HUD_KEY, PotionStatusOverlay.defPos(mc));
        ArrayList<MobEffectInstance> list = new ArrayList<MobEffectInstance>(raw);
        list.sort(Comparator.comparingInt(e -> MobEffect.m_19459_((MobEffect)e.m_19544_())));
        boolean newTick = player.f_19797_ != lastPlayerTick;
        lastPlayerTick = player.f_19797_;
        for (MobEffectInstance effect2 : list) {
            MobEffect mobEffect = effect2.m_19544_();
            int currentDuration = effect2.m_19557_();
            Integer maxDuration = maxDurations.get(mobEffect);
            if (maxDuration == null || currentDuration > maxDuration) {
                maxDurations.put(mobEffect, currentDuration);
            }
            EffectInfo info = effectInfos.computeIfAbsent(mobEffect, m -> new EffectInfo(currentDuration));
            if (newTick) {
                if (currentDuration < info.lastDuration) {
                    info.decreased = true;
                } else if (currentDuration > info.lastDuration && info.decreased) {
                    ++info.cycles;
                    info.decreased = false;
                    if (info.cycles == 3) {
                        VaultMod.LOGGER.debug("Hiding duration bar for {} due to repeated refresh", (Object)mobEffect.m_19482_().getString());
                    }
                }
                info.lastDuration = currentDuration;
            }
            info.hide = PotionStatusOverlay.isInfiniteDuration(effect2) || info.cycles >= 3;
        }
        maxDurations.keySet().removeIf(effect -> list.stream().noneMatch(e -> e.m_19544_() == effect));
        effectInfos.keySet().removeIf(effect -> list.stream().noneMatch(e -> e.m_19544_() == effect));
        int x = anchor.getScaledX(mc.m_91268_().m_85445_());
        int y = anchor.getScaledY(mc.m_91268_().m_85446_());
        int w = Minecraft.m_91087_().m_91268_().m_85445_();
        boolean rightToLeft = x > w / 2;
        int iconsPerRow = Math.min(10, Math.round(6.0f / potionScale));
        x = (int)((float)x / potionScale);
        y = (int)((float)y / potionScale);
        for (int i = 0; i < list.size(); ++i) {
            pose.m_85836_();
            int row = i / iconsPerRow;
            int col = i % iconsPerRow;
            pose.m_85841_(potionScale, potionScale, 1.0f);
            int drawX = rightToLeft ? x - col * 26 : x + col * 26;
            int drawY = y + row * 26;
            PotionStatusOverlay.draw(pose, drawX, drawY, (MobEffectInstance)list.get(i));
            pose.m_85849_();
        }
    }

    private static boolean isInfiniteDuration(MobEffectInstance effect) {
        return effect.m_19557_() == Integer.MAX_VALUE;
    }

    private static void draw(PoseStack pose, int x, int y, MobEffectInstance effectInstance) {
        MobEffect effect = effectInstance.m_19544_();
        int duration = effectInstance.m_19557_();
        float alpha = 1.0f;
        if (!ModEffects.PREVENT_DURATION_FLASH.contains(effectInstance.m_19544_()) && duration <= 200) {
            int k = 10 - duration / 20;
            alpha = Mth.m_14036_((float)((float)duration / 10.0f / 5.0f * 0.5f), (float)0.0f, (float)0.5f) + Mth.m_14089_((float)((float)duration * (float)Math.PI / 5.0f)) * Mth.m_14036_((float)((float)k / 10.0f * 0.25f), (float)0.0f, (float)0.25f);
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)AbstractContainerScreen.f_97725_);
        if (effectInstance.m_19571_()) {
            GUI_HELPER.m_93228_(pose, x, y, 165, 166, 24, 24);
        } else {
            GUI_HELPER.m_93228_(pose, x, y, 141, 166, 24, 24);
        }
        TextureAtlasSprite sprite = Minecraft.m_91087_().m_91306_().m_118732_(effect);
        RenderSystem.m_157456_((int)0, (ResourceLocation)sprite.m_118414_().m_118330_());
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GuiComponent.m_93200_((PoseStack)pose, (int)(x + 3), (int)(y + 3), (int)0, (int)18, (int)18, (TextureAtlasSprite)sprite);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PotionStatusOverlay.drawDurationBar(pose, x, y + 22, 24, 2, effect, duration);
        int amplifier = effectInstance.m_19564_();
        if (amplifier > 0) {
            Font font = Minecraft.m_91087_().f_91062_;
            String ampText = String.valueOf(amplifier + 1);
            pose.m_85836_();
            pose.m_85841_(0.75f, 0.75f, 1.0f);
            int textX = (int)((float)(x + 24 - 1) / 0.75f) - font.m_92895_(ampText);
            int textY = (int)((float)(y + 1) / 0.75f);
            font.m_92750_(pose, ampText, (float)textX, (float)textY, 0xFFFFFF);
            pose.m_85849_();
        }
    }

    private static void drawDurationBar(PoseStack pose, int x, int y, int width, int height, MobEffect effect, int duration) {
        EffectInfo info = effectInfos.get(effect);
        if (info != null && info.hide) {
            return;
        }
        Integer maxDuration = maxDurations.get(effect);
        if (maxDuration == null) {
            return;
        }
        float scale = Math.max(0.0f, Math.min(1.0f, (float)duration / (float)maxDuration.intValue()));
        int fillWidth = PotionStatusOverlay.getBarSize(scale, width);
        PotionStatusOverlay.fill(pose, x - 1, y - 1, x + width + 1, y + height + 1, -16777216);
        PotionStatusOverlay.fill(pose, x, y, x + width, y + height, -11184811);
        if (fillWidth > 0) {
            int fillColor = PotionStatusOverlay.getBarColor(scale);
            PotionStatusOverlay.fill(pose, x, y, x + fillWidth, y + height, fillColor);
            int highlightColor = PotionStatusOverlay.brightenColor(fillColor, 0.3f);
            PotionStatusOverlay.fill(pose, x, y, x + fillWidth, y + 1, highlightColor);
        }
    }

    private static int getBarSize(float scale, int maxWidth) {
        return Math.max(1, (int)(scale * (float)maxWidth));
    }

    private static int getBarColor(float scale) {
        if (scale < 0.2f) {
            return -48060;
        }
        if (scale < 0.4f) {
            float factor = (scale - 0.2f) / 0.2f;
            int red = 255;
            int green = (int)(68.0f + 187.0f * factor);
            return 0xFF000000 | red << 16 | green << 8;
        }
        if (scale < 0.6f) {
            float factor = (scale - 0.4f) / 0.2f;
            int red = (int)(255.0f - 55.0f * factor);
            int green = 255;
            return 0xFF000000 | red << 16 | green << 8;
        }
        float factor = (scale - 0.6f) / 0.4f;
        int red = (int)(200.0f * (1.0f - factor));
        int green = 255;
        return 0xFF000000 | red << 16 | green << 8;
    }

    private static int brightenColor(int color, float factor) {
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        red = Math.min(255, (int)((float)red + (float)(255 - red) * factor));
        green = Math.min(255, (int)((float)green + (float)(255 - green) * factor));
        blue = Math.min(255, (int)((float)blue + (float)(255 - blue) * factor));
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    private static void fill(PoseStack pose, int x1, int y1, int x2, int y2, int color) {
        GuiComponent.m_93172_((PoseStack)pose, (int)x1, (int)y1, (int)x2, (int)y2, (int)color);
    }

    private static HudPosition defPos(Minecraft mc) {
        int w = mc.m_91268_().m_85445_();
        return new HudPosition(w / 2 - 35, 4.0f);
    }

    private static class EffectInfo {
        int lastDuration;
        boolean decreased;
        int cycles;
        boolean hide;

        EffectInfo(int duration) {
            this.lastDuration = duration;
        }
    }
}

