/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.helper.UIHelper;
import iskallia.vault.core.vault.ClientVaults;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.core.vault.objective.PvPObjective;
import iskallia.vault.core.vault.player.Runner;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;

public class PvPCountdownOverlay
implements IIngameOverlay {
    public void render(ForgeIngameGui gui, PoseStack poseStack, float partialTick, int width, int height) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || Minecraft.m_91087_().f_91066_.f_92062_) {
            return;
        }
        if (ClientVaults.getActive().isEmpty()) {
            return;
        }
        Vault vault = ClientVaults.getActive().get();
        if (!VaultUtils.isPvPVault(vault)) {
            return;
        }
        List<PvPObjective> objs = vault.get(Vault.OBJECTIVES).getAll(PvPObjective.class);
        if (objs.isEmpty()) {
            return;
        }
        PvPObjective objective = objs.get(0);
        Font font = Minecraft.m_91087_().f_91062_;
        poseStack.m_85836_();
        if (!objective.has(PvPObjective.START_TICK)) {
            long runners = vault.get(Vault.LISTENERS).getAll(Runner.class).size();
            if (runners == 1L) {
                String text = "Waiting for at least 1 more player...";
                int x = (width - font.m_92895_(text)) / 2;
                poseStack.m_85837_((double)x, 10.0, 0.0);
                font.m_92750_(poseStack, text, 0.0f, 0.0f, 0xFFFFFF);
            }
        } else if (!objective.has(PvPObjective.COUNTDOWN_FINISHED)) {
            long elapsed = player.f_19853_.m_46467_() - objective.get(PvPObjective.START_TICK);
            long remaining = 2400L - elapsed;
            if (remaining < 0L) {
                remaining = 0L;
            }
            String text = UIHelper.formatTimeString(remaining);
            int x = (int)((float)(width - font.m_92895_(text) * 2) / 2.0f);
            poseStack.m_85837_((double)x, 10.0, 0.0);
            poseStack.m_85841_(2.0f, 2.0f, 2.0f);
            font.m_92750_(poseStack, text, 0.0f, 0.0f, 0xFFFFFF);
        } else {
            int ticks = objective.getGraceTicks(player.m_142081_());
            if (ticks > 0) {
                String text = "Grace period ends in %d seconds".formatted((ticks + 19) / 20);
                int x = (width - font.m_92895_(text)) / 2;
                int y = height - 60;
                poseStack.m_85837_((double)x, (double)y, 0.0);
                font.m_92750_(poseStack, text, 0.0f, 0.0f, 0xFFFFFF);
            }
        }
        poseStack.m_85849_();
    }
}

