/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.init.ModAttributes;
import iskallia.vault.init.ModEffects;
import java.util.List;
import java.util.function.ToIntFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.ForgeIngameGui;

@OnlyIn(value=Dist.CLIENT)
public class SpecialHealthOverlay {
    public static final ResourceLocation VAULT_HUD_SPRITE = new ResourceLocation("the_vault", "textures/gui/vault_hud.png");
    private static final List<HeartRenderInfo> HEART_RENDER_INFOS = List.of(new HeartRenderInfo(126, 2, -1, -1, player -> {
        AttributeInstance healthAttribute = player.m_21051_(Attributes.f_22276_);
        if (healthAttribute == null) {
            return 0;
        }
        AttributeModifier corruptionAttribute = healthAttribute.m_22111_(ModEffects.CORRUPTION_HEALTH_MODIFIER_ID);
        return corruptionAttribute != null ? (int)Math.abs(corruptionAttribute.m_22218_()) : 0;
    }), new HeartRenderInfo(135, 2, -1, -1, player -> {
        AttributeInstance manaShieldAttribute = player.m_21051_(ModAttributes.MANA_SHIELD);
        return manaShieldAttribute == null ? 0 : (int)manaShieldAttribute.m_22135_();
    }));

    public static int getSpecialHealthPoints(Player player) {
        return HEART_RENDER_INFOS.stream().mapToInt(heartRenderInfo -> heartRenderInfo.getHealthPoints().applyAsInt(player)).sum();
    }

    public static void renderSpecialHearts(PoseStack poseStack, Player player, int left, int top, int rowHeight, int regen, float healthMax, int health, int healthLast, int absorb, boolean highlight) {
        int currentRow;
        if (player == null) {
            return;
        }
        int maxHearts = Mth.m_14165_((double)((double)healthMax / 2.0));
        int absorbtionHearts = Mth.m_14165_((double)((double)absorb / 2.0));
        int currentIndex = maxHearts + absorbtionHearts;
        int vanillaHealthRows = currentRow = currentIndex / 10;
        for (HeartRenderInfo heartRenderInfo : HEART_RENDER_INFOS) {
            int indexInRow = currentIndex % 10;
            int x = left + indexInRow * 8;
            int y = top - currentRow * rowHeight;
            int healthPoints = heartRenderInfo.getHealthPoints().applyAsInt(player);
            if (healthPoints <= 0) continue;
            for (int j = 0; j < healthPoints / 2; ++j) {
                SpecialHealthOverlay.renderHeart(poseStack, x, y, heartRenderInfo);
                currentRow = ++currentIndex / 10;
                indexInRow = currentIndex % 10;
                x = left + indexInRow * 8;
                y = top - currentRow * rowHeight;
            }
            if (healthPoints % 2 != 1) continue;
            SpecialHealthOverlay.renderHeartLeftHalf(poseStack, x, y, heartRenderInfo);
            ++currentIndex;
        }
        ((ForgeIngameGui)Minecraft.m_91087_().f_91065_).left_height += (currentRow - vanillaHealthRows) * rowHeight;
    }

    private static void renderHeart(PoseStack poseStack, int x, int y, HeartRenderInfo heartRenderInfo) {
        SpecialHealthOverlay.setupShaderAndTexture();
        if (heartRenderInfo.containerU() > -1 && heartRenderInfo.containerV() > -1) {
            GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)heartRenderInfo.containerU(), (float)heartRenderInfo.containerV(), (int)9, (int)9, (int)256, (int)256);
        }
        if (heartRenderInfo.heartU() > -1 && heartRenderInfo.heartV() > -1) {
            GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)heartRenderInfo.heartU(), (float)heartRenderInfo.heartV(), (int)9, (int)9, (int)256, (int)256);
        }
    }

    private static void renderHeartLeftHalf(PoseStack poseStack, int x, int y, HeartRenderInfo heartRenderInfo) {
        SpecialHealthOverlay.setupShaderAndTexture();
        if (heartRenderInfo.containerU() > -1 && heartRenderInfo.containerV() > -1) {
            GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)heartRenderInfo.containerU(), (float)heartRenderInfo.containerV(), (int)5, (int)9, (int)256, (int)256);
        }
        if (heartRenderInfo.heartU() > -1 && heartRenderInfo.heartV() > -1) {
            GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)heartRenderInfo.heartU(), (float)heartRenderInfo.heartV(), (int)5, (int)9, (int)256, (int)256);
        }
    }

    private static void setupShaderAndTexture() {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)VAULT_HUD_SPRITE);
    }

    private record HeartRenderInfo(int containerU, int containerV, int heartU, int heartV, ToIntFunction<Player> getHealthPoints) {
    }
}

