/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import iskallia.vault.VaultMod;
import iskallia.vault.client.ClientPartyData;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.helper.UIHelper;
import iskallia.vault.client.gui.screen.accessibility.MinimapPositionEditScreen;
import iskallia.vault.client.render.HudPosition;
import iskallia.vault.client.render.IVaultOptions;
import iskallia.vault.core.vault.ClientVaults;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.core.vault.WaypointsList;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.vault.objective.HeraldObjective;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.stat.DiscoveredRoomStat;
import iskallia.vault.core.vault.stat.DiscoveredTunnelStat;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.vault.stat.StatsCollector;
import iskallia.vault.core.world.generator.GridGenerator;
import iskallia.vault.core.world.generator.VaultGenerator;
import iskallia.vault.entity.renderer.PlayerSkinUpdater;
import iskallia.vault.event.InputEvents;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModKeybinds;
import iskallia.vault.init.ModTextureAtlases;
import iskallia.vault.util.VectorHelper;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import org.jetbrains.annotations.Nullable;

public class VaultMapOverlay
implements IIngameOverlay {
    private static final PlayerSkinUpdater PLAYER_SKIN_UPDATER = new PlayerSkinUpdater();
    public static boolean showLargeOverlay = false;

    public static Vec2 getWaypointOffset(Direction facing) {
        Vec2 baseOffset = new Vec2(0.0f, 0.0f);
        switch (facing) {
            case NORTH: {
                return new Vec2(-0.5f, -1.0f);
            }
            case EAST: {
                return new Vec2(-5.0f, -0.5f);
            }
            case SOUTH: {
                return new Vec2(-7.0f, -6.0f);
            }
            case WEST: {
                return new Vec2(-1.5f, -6.5f);
            }
        }
        return baseOffset;
    }

    public static Vec2 getTunnelOffset(ResourceLocation id, Direction facing) {
        boolean isXTunnel = id.m_135815_().contains("tunnel_x");
        Vec2 baseOffset = isXTunnel ? new Vec2(6.0f, -7.0f) : new Vec2(7.0f, 7.0f);
        switch (facing) {
            case NORTH: {
                if (isXTunnel) {
                    return new Vec2(baseOffset.f_82470_ + 1.0f, baseOffset.f_82471_ + 13.0f);
                }
                return baseOffset;
            }
            case EAST: {
                if (isXTunnel) {
                    return new Vec2(baseOffset.f_82470_ + -12.0f, baseOffset.f_82471_ + 14.0f);
                }
                return new Vec2(baseOffset.f_82470_ - 14.0f, baseOffset.f_82471_);
            }
            case SOUTH: {
                if (isXTunnel) {
                    return new Vec2(baseOffset.f_82470_ - 13.0f, baseOffset.f_82471_ + 1.0f);
                }
                return new Vec2(baseOffset.f_82470_ - 14.0f, baseOffset.f_82471_ - 14.0f);
            }
            case WEST: {
                if (isXTunnel) {
                    return baseOffset;
                }
                return new Vec2(baseOffset.f_82470_, baseOffset.f_82471_ - 14.0f);
            }
        }
        return baseOffset;
    }

    public void render(ForgeIngameGui gui, PoseStack poseStack, float partialTick, int width, int height) {
        @Nullable LocalPlayer player = Minecraft.m_91087_().f_91074_;
        IVaultOptions options = (IVaultOptions)Minecraft.m_91087_().f_91066_;
        if (Minecraft.m_91087_().f_91080_ instanceof MinimapPositionEditScreen) {
            return;
        }
        if (player == null) {
            return;
        }
        if (options.getMapVisibilityOption().equals((Object)MapVisibilityOption.NEVER)) {
            return;
        }
        Optional<Vault> vaultOpt = ClientVaults.getActive();
        if (vaultOpt.isEmpty()) {
            return;
        }
        Vault vault = vaultOpt.get();
        Direction facing = vault.getOptional(Vault.WORLD).map(manager -> manager.getOr(WorldManager.FACING, Direction.NORTH)).orElse(Direction.NORTH);
        if (!vault.get(Vault.OBJECTIVES).getAll(HeraldObjective.class).isEmpty()) {
            return;
        }
        Optional<StatsCollector> stats = vault.getOptional(Vault.STATS);
        if (stats.isEmpty()) {
            return;
        }
        if (stats.get().getMap() == null) {
            return;
        }
        StatCollector stat = stats.get().get(player.m_142081_());
        if (stat == null) {
            return;
        }
        DiscoveredRoomStat discoveredRoomStat = stat.get(StatCollector.ROOMS_DISCOVERED);
        DiscoveredTunnelStat discoveredTunnelStat = stat.get(StatCollector.DISCOVERED_TUNNELS);
        if (discoveredRoomStat == null || discoveredRoomStat.isEmpty()) {
            return;
        }
        if ((ModKeybinds.holdVaultMap.m_90857_() || showLargeOverlay) && player.m_150109_().m_18949_(Set.of(ModItems.OPEN_MAP))) {
            this.renderIngameLargeMapOverlay(poseStack, vault, discoveredRoomStat, discoveredTunnelStat);
        }
        if (options.getMapVisibilityOption() == MapVisibilityOption.XAEROS || options.getMapVisibilityOption() == MapVisibilityOption.TAB && !InputEvents.isIsTabDown()) {
            return;
        }
        poseStack.m_85836_();
        HudPosition minimapPos = options.getMinimapPosition();
        int sw = Minecraft.m_91087_().m_91268_().m_85445_();
        int sh = Minecraft.m_91087_().m_91268_().m_85446_();
        poseStack.m_85837_((double)minimapPos.getScaledX(sw), (double)minimapPos.getScaledY(sh), 0.0);
        float mapScale = options.getMapScale();
        poseStack.m_85841_(mapScale, mapScale, 1.0f);
        UIHelper.renderOverflowHidden(poseStack, bgStack -> ForgeIngameGui.m_93172_((PoseStack)bgStack, (int)0, (int)0, (int)62, (int)62, (int)-15658735), innerStack -> {
            ClientPacketListener netHandler;
            float relZ;
            float relX;
            BlockPos pos;
            innerStack.m_85836_();
            float rotationOffset = 180.0f - facing.m_122435_();
            float rotation = player.m_146908_() + 180.0f + rotationOffset;
            int arrowTextureSize = 17;
            int arrowRenderSize = 5;
            int arrowX = 34 - arrowTextureSize / 2 - arrowRenderSize / 2;
            int arrowY = 34 - arrowTextureSize / 2 - arrowRenderSize / 2;
            float arrowScale = 0.75f * options.getMapZoom();
            innerStack.m_85837_((double)(arrowX + arrowTextureSize / 2 + 2), (double)(arrowY + arrowTextureSize / 2 + 1), 10.0);
            innerStack.m_85845_(Quaternion.m_175228_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(rotation))));
            innerStack.m_85841_(arrowScale, arrowScale, 1.0f);
            innerStack.m_85837_((double)(-(arrowTextureSize / 2)), (double)(-(arrowTextureSize / 2)), 0.0);
            ScreenRenderers.getImmediate().render(ScreenTextures.MINIMAP_ARROW, (PoseStack)innerStack, (IPosition)Spatials.positionXYZ(0, 0, 10).size(arrowTextureSize, arrowTextureSize));
            innerStack.m_85849_();
            BlockPos playerPos = player.m_142538_();
            VaultGenerator patt8750$temp = vault.get(Vault.WORLD).get(WorldManager.GENERATOR);
            if (!(patt8750$temp instanceof GridGenerator)) {
                return;
            }
            GridGenerator generator = (GridGenerator)patt8750$temp;
            float exactXPlayer = playerPos.m_123341_() - generator.get(GridGenerator.CELL_X) / 2;
            float exactZPlayer = playerPos.m_123343_() - generator.get(GridGenerator.CELL_Z) / 2;
            float interpX = exactXPlayer / 47.0f;
            float interpZ = exactZPlayer / 47.0f;
            Vec2 playerOffset = VectorHelper.rotateDegrees(new Vec2(interpX, interpZ), rotationOffset);
            float zoom = options.getMapZoom();
            innerStack.m_85836_();
            innerStack.m_85837_((double)(34.0f - 4.0f * zoom - playerOffset.f_82470_ * 8.0f * zoom), (double)(34.0f - 4.0f * zoom - playerOffset.f_82471_ * 8.0f * zoom), 0.0);
            innerStack.m_85841_(zoom, zoom, 1.0f);
            for (Map.Entry entry : discoveredRoomStat.entrySet()) {
                TextureAtlasRegion atlasRegion;
                pos = (BlockPos)entry.getKey();
                ResourceLocation roomId = (ResourceLocation)entry.getValue();
                relX = pos.m_123341_() * 8;
                relZ = pos.m_123343_() * 8;
                String path = roomId.m_135815_();
                if (path.contains("start")) {
                    int rotationSteps = Math.round(rotationOffset / 90.0f) % 4;
                    if (rotationSteps < 0) {
                        rotationSteps += 4;
                    }
                    Direction effectiveFacing = facing;
                    for (int i = 0; i < rotationSteps; ++i) {
                        effectiveFacing = effectiveFacing.m_122427_();
                    }
                    switch (effectiveFacing) {
                        case NORTH: {
                            atlasRegion = ScreenTextures.MAP_ROOM_START_NORTH;
                            break;
                        }
                        case SOUTH: {
                            atlasRegion = ScreenTextures.MAP_ROOM_START_SOUTH;
                            break;
                        }
                        case WEST: {
                            atlasRegion = ScreenTextures.MAP_ROOM_START_WEST;
                            break;
                        }
                        case EAST: {
                            atlasRegion = ScreenTextures.MAP_ROOM_START_EAST;
                            break;
                        }
                        default: {
                            atlasRegion = ScreenTextures.MAP_ROOM_START;
                            break;
                        }
                    }
                } else {
                    Optional<ResourceLocation> customIcon = ModConfigs.VAULT_MAP_ICONS.getIconForRoom(roomId);
                    atlasRegion = customIcon.isPresent() ? TextureAtlasRegion.of(ModTextureAtlases.VAULT_MAP, customIcon.get()) : (path.contains("omega") ? ScreenTextures.MAP_ROOM_OMEGA : (path.contains("challenge") ? ScreenTextures.MAP_ROOM_CHALLENGE : (path.contains("raw") ? ScreenTextures.MAP_ROOM_RAW : (path.contains("special") ? ScreenTextures.MAP_ROOM_BOSS : (path.contains("/ore") ? ScreenTextures.MAP_ROOM_ORE : ScreenTextures.MAP_ROOM_COMMON)))));
                }
                Vec2 rotatedRoom = VectorHelper.rotateDegrees(new Vec2(relX, relZ), rotationOffset);
                relX = rotatedRoom.f_82470_;
                relZ = rotatedRoom.f_82471_;
                float iconSize = 8.0f;
                IMutableSpatial iconSpatial = Spatials.positionXYZ((int)(relX - iconSize / 2.0f), (int)(relZ - iconSize / 2.0f), 1).size((int)iconSize, (int)iconSize);
                ScreenRenderers.getImmediate().render(atlasRegion, (PoseStack)innerStack, (IPosition)iconSpatial);
            }
            if (discoveredTunnelStat != null) {
                for (Map.Entry entry : discoveredTunnelStat.entrySet()) {
                    pos = (BlockPos)entry.getKey();
                    ResourceLocation id = (ResourceLocation)entry.getValue();
                    relX = (float)pos.m_123341_() * 8.0f;
                    relZ = (float)pos.m_123343_() * 8.0f;
                    Vec2 tunnelOffset = VaultMapOverlay.getTunnelOffset(id, facing);
                    Vec2 rotatedPosition = VectorHelper.rotateDegrees(new Vec2(relX, relZ), rotationOffset);
                    Vec2 rotatedOffset = VectorHelper.rotateDegrees(tunnelOffset, rotationOffset);
                    relX = rotatedPosition.f_82470_ + rotatedOffset.f_82470_;
                    relZ = rotatedPosition.f_82471_ + rotatedOffset.f_82471_;
                    boolean xTunnel = id.m_135815_().contains("tunnel_x");
                    if (Math.abs(Math.round(rotationOffset / 90.0f)) % 2 == 1) {
                        xTunnel = !xTunnel;
                    }
                    TextureAtlasRegion tex = xTunnel ? ScreenTextures.MAP_TUNNEL_X : ScreenTextures.MAP_TUNNEL_Z;
                    float iconSize = 8.0f;
                    IMutableSpatial s = Spatials.positionXYZ((int)(relX - iconSize / 2.0f), (int)(relZ - iconSize / 2.0f) + (id.m_135815_().contains("tunnel_x") ? 1 : 0), 1).size((int)iconSize, (int)iconSize);
                    ScreenRenderers.getImmediate().render(tex, (PoseStack)innerStack, (IPosition)s);
                }
            }
            if (vault.get(Vault.MAP_WAYPOINTS) != null) {
                innerStack.m_85836_();
                innerStack.m_85837_(0.0, 0.0, 3.0);
                for (Map.Entry entry : vault.get(Vault.MAP_WAYPOINTS).entrySet()) {
                    pos = (BlockPos)entry.getKey();
                    float relX2 = (float)pos.m_123341_() / 47.0f * 8.0f;
                    float relZ2 = (float)pos.m_123343_() / 47.0f * 8.0f;
                    Vec2 waypointOffset = VaultMapOverlay.getWaypointOffset(facing);
                    Vec2 rotatedPosition = VectorHelper.rotateDegrees(new Vec2(relX2, relZ2), rotationOffset);
                    Vec2 rotatedOffset = VectorHelper.rotateDegrees(waypointOffset, rotationOffset);
                    relX2 = rotatedPosition.f_82470_ + rotatedOffset.f_82470_;
                    relZ2 = rotatedPosition.f_82471_ + rotatedOffset.f_82471_;
                    TextureAtlasRegion tex = TextureAtlasRegion.of(ModTextureAtlases.VAULT_MAP, VaultMod.id("gui/map/marker"));
                    float iconSize = 5.0f;
                    IMutableSpatial s = Spatials.positionXYZ((int)(relX2 - iconSize / 2.0f), (int)(relZ2 - iconSize / 2.0f), 1).size((int)iconSize, (int)iconSize);
                    int colour = ((WaypointsList.Waypoint)entry.getValue()).getColour();
                    float r = (float)(colour >> 16 & 0xFF) / 255.0f;
                    float g = (float)(colour >> 8 & 0xFF) / 255.0f;
                    float b = (float)(colour & 0xFF) / 255.0f;
                    float a = (float)(colour >> 24 & 0xFF) / 255.0f;
                    RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)a);
                    ScreenRenderers.getImmediate().render(tex, (PoseStack)innerStack, (IPosition)s);
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                innerStack.m_85849_();
            }
            if (!VaultUtils.isPvPVault(vault) && vault.get(Vault.LISTENERS) != null && Minecraft.m_91087_().f_91073_ != null && (netHandler = Minecraft.m_91087_().m_91403_()) != null) {
                for (Listener listener : vault.get(Vault.LISTENERS).getAll()) {
                    double relZ3;
                    double relX3;
                    UUID playerId = listener.getId();
                    if (playerId.equals(player.m_142081_())) continue;
                    Player otherPlayer = Minecraft.m_91087_().f_91073_.m_46003_(playerId);
                    if (otherPlayer != null && otherPlayer != player) {
                        double exactX = otherPlayer.m_20185_() - (double)((float)generator.get(GridGenerator.CELL_X).intValue() / 2.0f);
                        double exactZ = otherPlayer.m_20189_() - (double)((float)generator.get(GridGenerator.CELL_Z).intValue() / 2.0f);
                        relX3 = exactX / 47.0 * 8.0;
                        relZ3 = exactZ / 47.0 * 8.0;
                    } else {
                        ClientPartyData.PartyMember member = ClientPartyData.getCachedMember(playerId);
                        if (member == null) continue;
                        double exactX = member.posX - (double)((float)generator.get(GridGenerator.CELL_X).intValue() / 2.0f);
                        double exactZ = member.posZ - (double)((float)generator.get(GridGenerator.CELL_Z).intValue() / 2.0f);
                        relX3 = exactX / 47.0 * 8.0;
                        relZ3 = exactZ / 47.0 * 8.0;
                    }
                    Vec2 rotatedPlayer = VectorHelper.rotateDegrees(new Vec2((float)relX3, (float)relZ3), rotationOffset);
                    relX3 = rotatedPlayer.f_82470_;
                    relZ3 = rotatedPlayer.f_82471_;
                    PlayerInfo info = netHandler.m_104949_(playerId);
                    if (info == null) continue;
                    ResourceLocation skinLocation = info.m_105337_();
                    innerStack.m_85836_();
                    innerStack.m_85837_((double)((float)relX3), (double)((float)relZ3), 2.0);
                    VaultMapOverlay.render2DHead(innerStack, skinLocation, 8);
                    innerStack.m_85849_();
                }
            }
            innerStack.m_85849_();
        });
        new NineSliceElement(Spatials.positionXY(0, 0).size(62, 62), ScreenTextures.INSET_DARK_GREY_OUTLINE).render(ScreenRenderers.getImmediate(), poseStack, 0, 0, partialTick);
        poseStack.m_85849_();
    }

    public static void render2DHead(PoseStack matrixStack, ResourceLocation skin, int size) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)skin);
        int u1 = 8;
        int v1 = 8;
        int u2 = 40;
        int v2 = 8;
        int w = 8;
        int h = 8;
        GuiComponent.m_93160_((PoseStack)matrixStack, (int)0, (int)0, (int)size, (int)size, (float)u1, (float)v1, (int)w, (int)h, (int)64, (int)64);
        GuiComponent.m_93160_((PoseStack)matrixStack, (int)0, (int)0, (int)size, (int)size, (float)u2, (float)v2, (int)w, (int)h, (int)64, (int)64);
    }

    private void renderIngameLargeMapOverlay(PoseStack poseStack, Vault vault, DiscoveredRoomStat room, DiscoveredTunnelStat tunnels) {
        ClientPacketListener netHandler;
        float relZ;
        float relX;
        BlockPos pos;
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        IVaultOptions options = (IVaultOptions)minecraft.f_91066_;
        if (player == null) {
            return;
        }
        Direction facing = vault.getOptional(Vault.WORLD).map(manager -> manager.getOr(WorldManager.FACING, Direction.NORTH)).orElse(Direction.NORTH);
        float rotationOffset = 180.0f - facing.m_122435_();
        VaultGenerator vaultGenerator = vault.get(Vault.WORLD).get(WorldManager.GENERATOR);
        if (!(vaultGenerator instanceof GridGenerator)) {
            return;
        }
        GridGenerator generator = (GridGenerator)vaultGenerator;
        BlockPos playerPos = player.m_142538_();
        float exactXPlayer = playerPos.m_123341_() - generator.get(GridGenerator.CELL_X) / 2;
        float exactZPlayer = playerPos.m_123343_() - generator.get(GridGenerator.CELL_Z) / 2;
        float interpX = exactXPlayer / 47.0f;
        float interpZ = exactZPlayer / 47.0f;
        Vec2 centerOffset = VectorHelper.rotateDegrees(new Vec2(interpX, interpZ), rotationOffset);
        poseStack.m_85836_();
        HudPosition overlayPos = options.mapOverlayPosition();
        int sw = minecraft.m_91268_().m_85445_();
        int sh = minecraft.m_91268_().m_85446_();
        if (options.getMapOverlayScale().equals((Object)IVaultOptions.ScaleMode.SMALL)) {
            poseStack.m_85841_(0.5f, 0.5f, 1.0f);
            poseStack.m_85837_((double)((float)overlayPos.getScaledX(sw) / 0.5f), (double)((float)overlayPos.getScaledY(sh) / 0.5f), 0.0);
        } else if (options.getMapOverlayScale().equals((Object)IVaultOptions.ScaleMode.TINY)) {
            poseStack.m_85841_(0.25f, 0.25f, 1.0f);
            poseStack.m_85837_((double)((float)overlayPos.getScaledX(sw) / 0.25f), (double)((float)overlayPos.getScaledY(sh) / 0.25f), 0.0);
        } else {
            poseStack.m_85837_((double)overlayPos.getScaledX(sw), (double)overlayPos.getScaledY(sh), 0.0);
        }
        float scaleFactor = 8.0f;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)options.getMapOverlayOpacity());
        poseStack.m_85836_();
        poseStack.m_85837_((double)(-(centerOffset.f_82470_ * scaleFactor)), (double)(-(centerOffset.f_82471_ * scaleFactor)), 0.0);
        for (Map.Entry entry : room.entrySet()) {
            TextureAtlasRegion atlasRegion;
            pos = (BlockPos)entry.getKey();
            ResourceLocation roomId = (ResourceLocation)entry.getValue();
            relX = (float)pos.m_123341_() * scaleFactor;
            relZ = (float)pos.m_123343_() * scaleFactor;
            Vec2 rotatedRoom = VectorHelper.rotateDegrees(new Vec2(relX, relZ), rotationOffset);
            relX = rotatedRoom.f_82470_;
            relZ = rotatedRoom.f_82471_;
            String path = roomId.m_135815_();
            if (path.contains("start")) {
                int rotationSteps = Math.round(rotationOffset / 90.0f) % 4;
                if (rotationSteps < 0) {
                    rotationSteps += 4;
                }
                Direction effectiveFacing = facing;
                for (int i = 0; i < rotationSteps; ++i) {
                    effectiveFacing = effectiveFacing.m_122427_();
                }
                switch (effectiveFacing) {
                    case NORTH: {
                        atlasRegion = ScreenTextures.MAP_ROOM_START_NORTH;
                        break;
                    }
                    case SOUTH: {
                        atlasRegion = ScreenTextures.MAP_ROOM_START_SOUTH;
                        break;
                    }
                    case WEST: {
                        atlasRegion = ScreenTextures.MAP_ROOM_START_WEST;
                        break;
                    }
                    case EAST: {
                        atlasRegion = ScreenTextures.MAP_ROOM_START_EAST;
                        break;
                    }
                    default: {
                        atlasRegion = ScreenTextures.MAP_ROOM_START;
                        break;
                    }
                }
            } else {
                Optional<ResourceLocation> customIcon = ModConfigs.VAULT_MAP_ICONS.getIconForRoom(roomId);
                atlasRegion = customIcon.isPresent() ? TextureAtlasRegion.of(ModTextureAtlases.VAULT_MAP, customIcon.get()) : (path.contains("omega") ? ScreenTextures.MAP_ROOM_OMEGA : (path.contains("challenge") ? ScreenTextures.MAP_ROOM_CHALLENGE : (path.contains("raw") ? ScreenTextures.MAP_ROOM_RAW : (path.contains("special") ? ScreenTextures.MAP_ROOM_BOSS : (path.contains("/ore") ? ScreenTextures.MAP_ROOM_ORE : ScreenTextures.MAP_ROOM_COMMON)))));
            }
            float iconSize = 8.0f;
            IMutableSpatial iconSpatial = Spatials.positionXYZ((int)(relX - iconSize / 2.0f), (int)(relZ - iconSize / 2.0f), 1).size((int)iconSize, (int)iconSize);
            ScreenRenderers.getImmediate().render(atlasRegion, poseStack, (IPosition)iconSpatial);
        }
        if (tunnels != null) {
            for (Map.Entry entry : tunnels.entrySet()) {
                pos = (BlockPos)entry.getKey();
                ResourceLocation id = (ResourceLocation)entry.getValue();
                relX = (float)pos.m_123341_() * scaleFactor;
                relZ = (float)pos.m_123343_() * scaleFactor;
                Vec2 tunnelOffset = VaultMapOverlay.getTunnelOffset(id, facing);
                Vec2 rotatedPosition = VectorHelper.rotateDegrees(new Vec2(relX, relZ), rotationOffset);
                Vec2 rotatedOffset = VectorHelper.rotateDegrees(tunnelOffset, rotationOffset);
                relX = rotatedPosition.f_82470_ + rotatedOffset.f_82470_;
                relZ = rotatedPosition.f_82471_ + rotatedOffset.f_82471_;
                boolean xTunnel = id.m_135815_().contains("tunnel_x");
                if (Math.abs(Math.round(rotationOffset / 90.0f)) % 2 == 1) {
                    xTunnel = !xTunnel;
                }
                TextureAtlasRegion tex = xTunnel ? ScreenTextures.MAP_TUNNEL_X : ScreenTextures.MAP_TUNNEL_Z;
                float iconSize = 8.0f;
                IMutableSpatial s = Spatials.positionXYZ((int)(relX - iconSize / 2.0f), (int)(relZ - iconSize / 2.0f) + (id.m_135815_().contains("tunnel_x") ? 1 : 0), 1).size((int)iconSize, (int)iconSize);
                ScreenRenderers.getImmediate().render(tex, poseStack, (IPosition)s);
            }
        }
        for (Map.Entry entry : vault.get(Vault.MAP_WAYPOINTS).entrySet()) {
            pos = (BlockPos)entry.getKey();
            float relX2 = (float)pos.m_123341_() / 47.0f * scaleFactor;
            float relZ2 = (float)pos.m_123343_() / 47.0f * scaleFactor;
            Vec2 waypointOffset = VaultMapOverlay.getWaypointOffset(facing);
            waypointOffset = new Vec2(waypointOffset.f_82470_ * scaleFactor / 8.0f, waypointOffset.f_82471_ * scaleFactor / 8.0f);
            Vec2 rotatedPosition = VectorHelper.rotateDegrees(new Vec2(relX2, relZ2), rotationOffset);
            Vec2 rotatedOffset = VectorHelper.rotateDegrees(waypointOffset, rotationOffset);
            relX2 = rotatedPosition.f_82470_ + rotatedOffset.f_82470_;
            relZ2 = rotatedPosition.f_82471_ + rotatedOffset.f_82471_;
            TextureAtlasRegion tex = TextureAtlasRegion.of(ModTextureAtlases.VAULT_MAP, VaultMod.id("gui/map/marker"));
            int colour = ((WaypointsList.Waypoint)entry.getValue()).getColour();
            float r = (float)(colour >> 16 & 0xFF) / 255.0f;
            float g = (float)(colour >> 8 & 0xFF) / 255.0f;
            float b = (float)(colour & 0xFF) / 255.0f;
            RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)options.getMapOverlayOpacity());
            ScreenRenderers.getImmediate().render(tex, poseStack, (IPosition)Spatials.positionXYZ((int)(relX2 - 2.0f), (int)(relZ2 - 2.0f), 10));
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (!VaultUtils.isPvPVault(vault) && vault.get(Vault.LISTENERS) != null && Minecraft.m_91087_().f_91073_ != null && (netHandler = Minecraft.m_91087_().m_91403_()) != null) {
            for (Listener listener : vault.get(Vault.LISTENERS).getAll()) {
                double relZ2;
                double relX2;
                UUID playerId = listener.getId();
                if (playerId.equals(player.m_142081_())) continue;
                Player otherPlayer = Minecraft.m_91087_().f_91073_.m_46003_(playerId);
                if (otherPlayer != null && otherPlayer != player) {
                    double exactX = otherPlayer.m_20185_() - (double)((float)generator.get(GridGenerator.CELL_X).intValue() / 2.0f);
                    double exactZ = otherPlayer.m_20189_() - (double)((float)generator.get(GridGenerator.CELL_Z).intValue() / 2.0f);
                    double relX3 = exactX / 47.0 * (double)scaleFactor;
                    double relZ3 = exactZ / 47.0 * (double)scaleFactor;
                } else {
                    ClientPartyData.PartyMember member = ClientPartyData.getCachedMember(playerId);
                    if (member == null) continue;
                    double exactX = member.posX - (double)((float)generator.get(GridGenerator.CELL_X).intValue() / 2.0f);
                    double exactZ = member.posZ - (double)((float)generator.get(GridGenerator.CELL_Z).intValue() / 2.0f);
                    relX2 = exactX / 47.0 * (double)scaleFactor;
                    relZ2 = exactZ / 47.0 * (double)scaleFactor;
                }
                Vec2 rotatedPlayer = VectorHelper.rotateDegrees(new Vec2((float)relX2, (float)relZ2), rotationOffset);
                relX2 = rotatedPlayer.f_82470_;
                relZ2 = rotatedPlayer.f_82471_;
                PlayerInfo info = netHandler.m_104949_(playerId);
                if (info == null) continue;
                ResourceLocation skinLocation = info.m_105337_();
                poseStack.m_85836_();
                poseStack.m_85837_(relX2, relZ2, 2.0);
                VaultMapOverlay.render2DHead(poseStack, skinLocation, 8);
                poseStack.m_85849_();
            }
        }
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(-4.0, -4.25, 2.0);
        float rotation = player.m_146908_() + 180.0f + rotationOffset;
        int n = 17;
        float arrowScale = 0.75f;
        poseStack.m_85837_((double)(n / 2), (double)(n / 2), 0.0);
        poseStack.m_85845_(Quaternion.m_175228_((float)0.0f, (float)0.0f, (float)((float)Math.toRadians(rotation))));
        poseStack.m_85841_(arrowScale, arrowScale, 1.0f);
        poseStack.m_85837_((double)(-(n / 2)), (double)(-(n / 2)), 0.0);
        ScreenRenderers.getImmediate().render(ScreenTextures.MINIMAP_ARROW, poseStack, (IPosition)Spatials.positionXYZ(0, 0, 0).size(n, n));
        poseStack.m_85849_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    public static enum MapVisibilityOption {
        ALWAYS,
        TAB,
        XAEROS,
        NEVER;


        public String getSerializedName() {
            return this.name().toLowerCase();
        }

        public static MapVisibilityOption fromString(String string) {
            for (MapVisibilityOption option : MapVisibilityOption.values()) {
                if (!option.getSerializedName().equalsIgnoreCase(string)) continue;
                return option;
            }
            return NEVER;
        }

        public MapVisibilityOption cycle() {
            MapVisibilityOption[] values = MapVisibilityOption.values();
            int nextOrdinal = (this.ordinal() + 1) % values.length;
            return values[nextOrdinal];
        }

        public String getSerializedNameUpper() {
            if (this == NEVER) {
                return "Hidden";
            }
            return this.name().substring(0, 1).toUpperCase() + this.name().substring(1).toLowerCase();
        }
    }

    public static enum WaypointSymbol {
        SYMBOL_1,
        SYMBOL_2;

    }
}

