/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.ClientActiveEternalData;
import iskallia.vault.client.ClientPartyData;
import iskallia.vault.client.gui.helper.FontHelper;
import iskallia.vault.config.EternalAuraConfig;
import iskallia.vault.core.vault.ClientVaults;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.entity.eternal.ActiveEternalData;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModShaders;
import iskallia.vault.world.data.VaultPartyData;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class VaultPartyOverlay
implements IIngameOverlay {
    public static final ResourceLocation VAULT_HUD_SPRITE = new ResourceLocation("the_vault", "textures/gui/vault_hud.png");

    public void render(ForgeIngameGui gui, PoseStack matrixStack, float partialTick, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        float offsetY = Math.max((float)height / 3.0f, 45.0f);
        offsetY += (float)VaultPartyOverlay.renderPartyHUD(matrixStack, offsetY, width);
        offsetY += (float)VaultPartyOverlay.renderEternalHUD(matrixStack, offsetY, width);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
    }

    private static int renderEternalHUD(PoseStack matrixStack, float offsetY, int right) {
        Set<ActiveEternalData.ActiveEternal> eternals = ClientActiveEternalData.getActiveEternals();
        if (eternals.isEmpty()) {
            return 0;
        }
        int height = 0;
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)(right - 5), (double)offsetY, 0.0);
        matrixStack.m_85836_();
        matrixStack.m_85841_(0.8f, 0.8f, 1.0f);
        MutableComponent vpText = new TextComponent("Eternals").m_130940_(ChatFormatting.GOLD);
        FontHelper.drawTextComponent(matrixStack, (Component)vpText, true);
        matrixStack.m_85849_();
        height += 8;
        matrixStack.m_85837_(0.0, 8.0, -50.0);
        matrixStack.m_85841_(0.7f, 0.7f, 1.0f);
        for (ActiveEternalData.ActiveEternal eternal : eternals) {
            int eternalHeight = VaultPartyOverlay.renderEternalSection(matrixStack, eternal) + 4;
            matrixStack.m_85837_(0.0, (double)eternalHeight, 0.0);
            height = (int)((float)height + (float)eternalHeight * 0.7f);
        }
        matrixStack.m_85849_();
        return height + 6;
    }

    private static int renderEternalSection(PoseStack matrixStack, ActiveEternalData.ActiveEternal eternal) {
        EternalAuraConfig.AuraConfig cfg;
        int textSize = 8;
        int headSize = 16;
        int gap = 2;
        boolean dead = eternal.getHealth() <= 0.0f;
        ResourceLocation skin = eternal.getSkin().getLocationSkin();
        TextComponent txt = new TextComponent("");
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)(-headSize), 0.0, 0.0);
        VaultPartyOverlay.render2DHead(matrixStack, skin, headSize, dead);
        matrixStack.m_85837_((double)(-gap), (double)((float)(headSize - textSize) / 2.0f), 0.0);
        if (dead) {
            txt.m_7220_((Component)new TextComponent("Unalived").m_130940_(ChatFormatting.RED));
        } else {
            int heartSize = 9;
            int heartU = 86;
            int heartV = 2;
            matrixStack.m_85837_((double)(-heartSize), 0.0, 0.0);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)VAULT_HUD_SPRITE);
            GuiComponent.m_93133_((PoseStack)matrixStack, (int)0, (int)0, (float)heartU, (float)heartV, (int)heartSize, (int)heartSize, (int)256, (int)256);
            matrixStack.m_85837_((double)(-gap), 0.0, 0.0);
            txt.m_7220_((Component)new TextComponent((int)eternal.getHealth() + "x").m_130940_(ChatFormatting.WHITE));
        }
        int width = FontHelper.drawTextComponent(matrixStack, (Component)txt, true);
        if (eternal.getAbilityName() != null && (cfg = ModConfigs.ETERNAL_AURAS.getByName(eternal.getAbilityName())) != null) {
            matrixStack.m_85837_((double)(-(width + 18)), -4.0, 0.0);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation(cfg.getIconPath()));
            GuiComponent.m_93133_((PoseStack)matrixStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        }
        matrixStack.m_85849_();
        return headSize;
    }

    private static int renderPartyHUD(PoseStack matrixStack, float offsetY, int right) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        VaultPartyData.Party thisParty = ClientPartyData.getParty(player.m_142081_());
        if (thisParty == null) {
            return 0;
        }
        int height = 0;
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)(right - 5), (double)offsetY, 0.0);
        matrixStack.m_85836_();
        matrixStack.m_85841_(0.8f, 0.8f, 1.0f);
        MutableComponent vpText = new TextComponent("Vault Party").m_130940_(ChatFormatting.GREEN);
        FontHelper.drawTextComponent(matrixStack, (Component)vpText, true);
        matrixStack.m_85849_();
        height += 8;
        matrixStack.m_85837_(0.0, 8.0, -50.0);
        matrixStack.m_85841_(0.7f, 0.7f, 1.0f);
        ClientPacketListener netHandler = Minecraft.m_91087_().m_91403_();
        if (netHandler != null) {
            for (UUID uuid : thisParty.getMembers()) {
                PlayerInfo info = netHandler.m_104949_(uuid);
                int playerHeight = VaultPartyOverlay.renderPartyPlayerSection(matrixStack, thisParty, uuid, info) + 4;
                matrixStack.m_85837_(0.0, (double)playerHeight, 0.0);
                height = (int)((float)height + (float)playerHeight * 0.7f);
            }
        }
        matrixStack.m_85849_();
        return height + 6;
    }

    private static int renderPartyPlayerSection(PoseStack matrixStack, VaultPartyData.Party party, UUID playerUUID, PlayerInfo info) {
        int textSize = 8;
        int headSize = 16;
        int gap = 2;
        boolean offline = info == null;
        ClientPartyData.PartyMember member = offline ? null : ClientPartyData.getCachedMember(info.m_105312_().getId());
        ResourceLocation skin = offline ? DefaultPlayerSkin.m_118626_() : info.m_105337_();
        String prefix = playerUUID.equals(party.getLeader()) ? "\u2b50 " : "";
        MutableComponent txt = new TextComponent(prefix).m_130940_(ChatFormatting.GOLD);
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)(-headSize), 0.0, 0.0);
        VaultPartyOverlay.render2DHead(matrixStack, skin, headSize, offline);
        matrixStack.m_85837_((double)(-gap), (double)((float)(headSize - textSize) / 2.0f), 0.0);
        int heartSize = 9;
        if (offline) {
            txt.m_7220_((Component)new TextComponent(prefix + "OFFLINE").m_130940_(ChatFormatting.GRAY));
        } else if (!VaultPartyOverlay.shouldHideHearts(Minecraft.m_91087_().f_91074_)) {
            int heartU = 86;
            int heartV = 2;
            matrixStack.m_85837_((double)(-heartSize), 0.0, 0.0);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)VAULT_HUD_SPRITE);
            ClientPartyData.PartyMember.Status status = member == null ? ClientPartyData.PartyMember.Status.NORMAL : member.status;
            GuiComponent.m_93133_((PoseStack)matrixStack, (int)0, (int)0, (float)(heartU + VaultPartyOverlay.getPartyPlayerStatusOffset(status)), (float)heartV, (int)heartSize, (int)heartSize, (int)256, (int)256);
            matrixStack.m_85837_((double)(-gap), 0.0, 0.0);
            txt.m_7220_((Component)new TextComponent((String)(member == null ? "-" : (int)member.healthPts + "x")).m_130940_(ChatFormatting.WHITE));
        }
        FontHelper.drawTextComponent(matrixStack, (Component)txt, true);
        if (Minecraft.m_91087_().f_91065_.m_93088_().f_94524_) {
            if (offline) {
                matrixStack.m_85837_((double)(-heartSize - gap), 0.0, 0.0);
            }
            VaultPartyOverlay.renderObjectives(matrixStack, playerUUID);
        }
        matrixStack.m_85849_();
        return headSize;
    }

    private static boolean shouldHideHearts(@Nullable LocalPlayer player) {
        if (player == null) {
            return false;
        }
        return VaultUtils.getVault(player.f_19853_).map(VaultUtils::isPvPVault).orElse(false);
    }

    private static void renderObjectives(PoseStack matrixStack, UUID playerUUID) {
        ClientVaults.getActive().ifPresent(vault -> {
            if (!vault.get(Vault.LISTENERS).contains(playerUUID)) {
                return;
            }
            vault.get(Vault.OBJECTIVES).forEach(Objective.class, objective -> {
                objective.renderPartyInfo(matrixStack, playerUUID);
                return true;
            });
        });
    }

    private static int getPartyPlayerStatusOffset(ClientPartyData.PartyMember.Status status) {
        switch (status) {
            case POISONED: {
                return 10;
            }
            case WITHERED: {
                return 20;
            }
            case DEAD: {
                return 30;
            }
        }
        return 0;
    }

    private static void render2DHead(PoseStack matrixStack, ResourceLocation skin, int size, boolean grayscaled) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)skin);
        int u1 = 8;
        int v1 = 8;
        int u2 = 40;
        int v2 = 8;
        int w = 8;
        int h = 8;
        if (grayscaled) {
            ModShaders.getGrayscalePositionTexShader().withGrayscale(0.0f).withBrightness(1.0f).enable();
        }
        GuiComponent.m_93160_((PoseStack)matrixStack, (int)0, (int)0, (int)size, (int)size, (float)u1, (float)v1, (int)w, (int)h, (int)64, (int)64);
        GuiComponent.m_93160_((PoseStack)matrixStack, (int)0, (int)0, (int)size, (int)size, (float)u2, (float)v2, (int)w, (int)h, (int)64, (int)64);
    }
}

