/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import iskallia.vault.VaultMod;
import iskallia.vault.config.AbilitiesVignetteConfig;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModEffects;
import iskallia.vault.util.PlayerRageHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;

public class VignetteOverlay
implements IIngameOverlay {
    protected static final ResourceLocation VIGNETTE_LOCATION = VaultMod.id("textures/gui/vignette.png");
    protected static final ResourceLocation POWDER_SNOW_OUTLINE = new ResourceLocation("textures/misc/powder_snow_outline.png");

    public void render(ForgeIngameGui gui, PoseStack matrixStack, float partialTick, int width, int height) {
        if (!ModConfigs.ABILITIES_VIGNETTE.ENABLED) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null) {
            return;
        }
        if (minecraft.f_91074_.m_21023_(ModEffects.GHOST_WALK)) {
            this.render(ModConfigs.ABILITIES_VIGNETTE.GHOST_WALK, matrixStack, width, height, VIGNETTE_LOCATION);
        } else if (minecraft.f_91074_.m_21023_((MobEffect)ModEffects.EMPOWER)) {
            this.render(ModConfigs.ABILITIES_VIGNETTE.EMPOWER, matrixStack, width, height, VIGNETTE_LOCATION);
        } else if (minecraft.f_91074_.m_21023_((MobEffect)ModEffects.EMPOWER_ICE_ARMOUR)) {
            this.render(ModConfigs.ABILITIES_VIGNETTE.EMPOWER_ICE_ARMOUR, matrixStack, width, height, VIGNETTE_LOCATION);
        } else if (minecraft.f_91074_.m_21023_((MobEffect)ModEffects.SHELL_PORCUPINE)) {
            this.render(ModConfigs.ABILITIES_VIGNETTE.SHELL_PORCUPINE, matrixStack, width, height, VIGNETTE_LOCATION);
        } else if (minecraft.f_91074_.m_21023_(ModEffects.MANA_SHIELD)) {
            this.render(ModConfigs.ABILITIES_VIGNETTE.MANA_SHIELD, matrixStack, width, height, VIGNETTE_LOCATION);
        } else if (minecraft.f_91074_.m_21023_(ModEffects.MANA_SHIELD_RETRIBUTION)) {
            this.render(ModConfigs.ABILITIES_VIGNETTE.MANA_SHIELD_RETRIBUTION, matrixStack, width, height, VIGNETTE_LOCATION);
        } else if (minecraft.f_91074_.m_21023_((MobEffect)ModEffects.RAMPAGE)) {
            this.render(ModConfigs.ABILITIES_VIGNETTE.RAMPAGE, matrixStack, width, height, VIGNETTE_LOCATION);
        } else if (minecraft.f_91074_.m_21023_((MobEffect)ModEffects.RAMPAGE_LEECH)) {
            this.render(ModConfigs.ABILITIES_VIGNETTE.RAMPAGE_LEECH, matrixStack, width, height, VIGNETTE_LOCATION);
        } else if (minecraft.f_91074_.m_21023_((MobEffect)ModEffects.RAMPAGE_CHAIN)) {
            this.render(ModConfigs.ABILITIES_VIGNETTE.RAMPAGE_CHAIN, matrixStack, width, height, VIGNETTE_LOCATION);
        } else if (minecraft.f_91074_.m_21023_((MobEffect)ModEffects.RAGE)) {
            int rage = PlayerRageHelper.getCurrentRage((LivingEntity)minecraft.f_91074_);
            if (rage > 0) {
                AbilitiesVignetteConfig.VignetteData data = ModConfigs.ABILITIES_VIGNETTE.RAGE;
                this.render(data.color, data.alpha * ((float)rage / 100.0f), data.style, matrixStack, width, height, VIGNETTE_LOCATION);
            }
        } else if (minecraft.f_91074_.m_21023_(ModEffects.STONEFALL)) {
            this.render(ModConfigs.ABILITIES_VIGNETTE.STONEFALL, matrixStack, width, height, VIGNETTE_LOCATION);
        } else if (minecraft.f_91074_.m_21023_(ModEffects.STONEFALL_COLD)) {
            this.render(ModConfigs.ABILITIES_VIGNETTE.STONEFALL_COLD, matrixStack, width, height, VIGNETTE_LOCATION);
        } else if (minecraft.f_91074_.m_21023_(ModEffects.STONEFALL_SHOCKWAVE)) {
            this.render(ModConfigs.ABILITIES_VIGNETTE.STONEFALL_SHOCKWAVE, matrixStack, width, height, VIGNETTE_LOCATION);
        }
    }

    protected void render(AbilitiesVignetteConfig.VignetteData config, PoseStack matrixStack, int width, int height, ResourceLocation vignetteLocation) {
        this.render(config.color, config.alpha, config.style, matrixStack, width, height, vignetteLocation);
    }

    protected void render(TextColor color, float alpha, AbilitiesVignetteConfig.VignetteStyle style, PoseStack matrixStack, int width, int height, ResourceLocation vignetteLocation) {
        if (style == AbilitiesVignetteConfig.VignetteStyle.FILL) {
            this.renderFill(color, alpha, matrixStack, width, height);
        } else if (style == AbilitiesVignetteConfig.VignetteStyle.VIGNETTE) {
            this.renderVignette(color, alpha, matrixStack, width, height, vignetteLocation);
        }
    }

    protected void renderFill(TextColor color, float alpha, PoseStack matrixStack, int width, int height) {
        int colorValue = (int)(alpha * 255.0f) << 24 | 0xFFFFFF & color.m_131265_();
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)0, (int)0, (int)width, (int)height, (int)colorValue);
    }

    protected void renderVignette(TextColor color, float alpha, PoseStack matrixStack, int width, int height, ResourceLocation texture) {
        RenderSystem.m_69465_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        int colorValue = color.m_131265_();
        float b = (float)(colorValue & 0xFF) / 255.0f;
        float g = (float)(colorValue >> 8 & 0xFF) / 255.0f;
        float r = (float)(colorValue >> 16 & 0xFF) / 255.0f;
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)alpha);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_5483_(0.0, (double)height, -90.0).m_7421_(0.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_((double)width, (double)height, -90.0).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_((double)width, 0.0, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder.m_5483_(0.0, 0.0, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69482_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69453_();
    }
}

