/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Either;
import iskallia.vault.antique.Antique;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ButtonElement;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.TextureAtlasElement;
import iskallia.vault.client.gui.framework.element.spi.AbstractSpatialElement;
import iskallia.vault.client.gui.framework.element.spi.IRenderedElement;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.render.Tooltips;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.render.spi.ITooltipRenderer;
import iskallia.vault.client.gui.framework.screen.AbstractElementContainerScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.helper.ScreenDrawHelper;
import iskallia.vault.config.AntiquesConfig;
import iskallia.vault.container.inventory.AntiqueCollectorBookContainer;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.AntiqueItem;
import iskallia.vault.item.AntiqueStampCollectorBook;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class AntiqueCollectorBookScreen
extends AbstractElementContainerScreen<AntiqueCollectorBookContainer> {
    private final ButtonElement<?> btnPrev;
    private final ButtonElement<?> btnNext;

    public AntiqueCollectorBookScreen(AntiqueCollectorBookContainer container, Inventory inventory, Component title) {
        super(container, inventory, title, ScreenRenderers.getImmediate(), ScreenTooltipRenderer::create);
        this.setGuiSize(Spatials.size(288, 246));
        this.addElement((TextureAtlasElement)new TextureAtlasElement(this.getGuiSpatial(), ScreenTextures.ANTIQUE_COLLECTOR_BOOK_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui).size(Spatials.copy(gui))));
        MutableComponent inventoryName = inventory.m_5446_().m_6881_();
        inventoryName.m_130948_(Style.f_131099_.m_178520_(-12632257));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(63, 153), (Component)inventoryName, LabelTextStyle.defaultStyle()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        this.btnPrev = new ButtonElement(Spatials.positionXY(25, 123), ScreenTextures.ANTIQUE_COLLECTOR_BOOK_NAV_LEFT, () -> this.setActivePage(((AntiqueCollectorBookContainer)this.m_6262_()).getActivePage() - 1));
        this.addElement(this.btnPrev).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
        this.btnNext = new ButtonElement(Spatials.positionXY(245, 123), ScreenTextures.ANTIQUE_COLLECTOR_BOOK_NAV_RIGHT, () -> this.setActivePage(((AntiqueCollectorBookContainer)this.m_6262_()).getActivePage() + 1));
        this.addElement(this.btnNext).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui));
        this.addElement((AntiqueTitleElement)new AntiqueTitleElement(this.getTooltipRenderer(), ((AntiqueCollectorBookContainer)this.m_6262_()).getStoredAntiquesSupplier(), ((AntiqueCollectorBookContainer)this.m_6262_()).getAntiqueSlots()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.positionXY(gui)));
        this.setActivePage(0);
    }

    private void setActivePage(int activePage) {
        ((AntiqueCollectorBookContainer)this.m_6262_()).setActivePage(activePage);
        boolean hasPreviousPage = activePage > 0;
        boolean hasNextPage = activePage < ((AntiqueCollectorBookContainer)this.m_6262_()).getPages() - 1;
        this.btnPrev.setEnabled(hasPreviousPage);
        this.btnPrev.setVisible(hasPreviousPage);
        this.btnNext.setEnabled(hasNextPage);
        this.btnNext.setVisible(hasNextPage);
        if (Minecraft.m_91087_().f_91074_ != null) {
            Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_11713_, 1.0f, 1.0f);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key key = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (keyCode == 256 || Minecraft.m_91087_().f_91066_.f_92092_.isActiveAndMatches(key)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    @SubscribeEvent
    public static void gatherAntiqueTooltip(RenderTooltipEvent.GatherComponents event) {
        ItemStack stack = event.getItemStack();
        if (!stack.m_150930_((Item)ModItems.ANTIQUE)) {
            return;
        }
        Antique antique = AntiqueItem.getAntique(stack);
        if (antique == null) {
            return;
        }
        AntiquesConfig.Entry cfg = antique.getConfig();
        if (cfg == null) {
            return;
        }
        Screen openScreen = Minecraft.m_91087_().f_91080_;
        if (!(openScreen instanceof AntiqueCollectorBookScreen)) {
            return;
        }
        AntiqueCollectorBookScreen bookScreen = (AntiqueCollectorBookScreen)openScreen;
        if (!(bookScreen.f_97734_ instanceof AntiqueCollectorBookContainer.AntiqueCollectorBookSlot)) {
            return;
        }
        AntiqueStampCollectorBook.StoredAntiques antiques = ((AntiqueCollectorBookContainer)bookScreen.m_6262_()).getStoredAntiquesSupplier().get();
        List<Component> discoveryClues = AntiqueCollectorBookScreen.getAntiqueTooltipComponents(antiques, antique);
        if (!discoveryClues.isEmpty()) {
            event.getTooltipElements().add(Either.left((Object)TextComponent.f_131282_));
            discoveryClues.forEach(element -> event.getTooltipElements().add(Either.left((Object)element)));
        }
    }

    public static List<Component> getAntiqueTooltipComponents(AntiqueStampCollectorBook.StoredAntiques antiques, Antique antique) {
        AntiquesConfig.Entry cfg = antique.getConfig();
        if (cfg == null) {
            return Collections.emptyList();
        }
        AntiqueStampCollectorBook.StoredAntiqueInfo info = antiques.getInfo(antique);
        if (!info.hasDiscoveredAntique()) {
            return Collections.emptyList();
        }
        List<MutableComponent> displayLines = cfg.getCondition().collectConditionDisplay();
        if (displayLines.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Component> tooltip = new ArrayList<Component>();
        Style style = Style.f_131099_.m_131140_(ChatFormatting.GRAY);
        tooltip.add((Component)new TextComponent("Discovery Clues:").m_130948_(style));
        int lines = info.getProgressRevealCount();
        for (int displayIndex = 0; displayIndex < displayLines.size(); ++displayIndex) {
            MutableComponent display = displayLines.get(displayIndex);
            display = displayIndex >= lines ? new TextComponent("- ").m_6270_(style).m_7220_((Component)new TextComponent("Unknown").m_6270_(style.m_178524_(Boolean.valueOf(true)))) : new TextComponent("- ").m_6270_(style).m_7220_((Component)display.m_6881_().m_6270_(style));
            tooltip.add((Component)display);
        }
        return tooltip;
    }

    public static class AntiqueTitleElement
    extends AbstractSpatialElement<AntiqueTitleElement>
    implements IRenderedElement {
        private final ITooltipRenderer tooltipRenderer;
        private final Supplier<AntiqueStampCollectorBook.StoredAntiques> storedAntiquesSupplier;
        private final List<AntiqueCollectorBookContainer.AntiqueCollectorBookSlot> antiqueSlots;
        private boolean visible = true;

        public AntiqueTitleElement(ITooltipRenderer tooltipRenderer, Supplier<AntiqueStampCollectorBook.StoredAntiques> storedAntiquesSupplier, List<AntiqueCollectorBookContainer.AntiqueCollectorBookSlot> antiqueSlots) {
            super(Spatials.zero());
            this.tooltipRenderer = tooltipRenderer;
            this.storedAntiquesSupplier = storedAntiquesSupplier;
            this.antiqueSlots = antiqueSlots;
        }

        @Override
        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        @Override
        public boolean isVisible() {
            return this.visible;
        }

        @Override
        public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            TextureManager mgr = Minecraft.m_91087_().m_91097_();
            LabelTextStyle textStyle = LabelTextStyle.defaultStyle().center().wrap().build();
            int fontHeight = textStyle.getLabelHeight((Component)new TextComponent("A"), 1) / 2;
            int textWidth = 30;
            int xOffset = (textWidth - 16) / 2;
            int yOffset = 4;
            AntiqueStampCollectorBook.StoredAntiques antiques = this.storedAntiquesSupplier.get();
            for (AntiqueCollectorBookContainer.AntiqueCollectorBookSlot slot : this.antiqueSlots) {
                if (!slot.m_6659_()) continue;
                AntiqueStampCollectorBook.StoredAntiqueInfo antiqueInfo = antiques.getInfo(slot.getAntique());
                ResourceLocation antiqueTexture = ModDynamicModels.Antiques.getItemTextureId(slot.getAntique());
                if (!slot.m_6657_() && antiqueInfo.hasDiscoveredAntique()) {
                    List<Component> discoveryClues;
                    TextureAtlasSprite tas = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(antiqueTexture);
                    mgr.m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
                    RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    float tasPxDim = (tas.m_118410_() - tas.m_118409_()) / 16.0f;
                    ScreenDrawHelper.draw(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_, buf -> ScreenDrawHelper.rect((VertexConsumer)buf, poseStack).at(this.worldSpatial.x() + slot.f_40220_ + 3, this.worldSpatial.y() + slot.f_40221_ + 3).zLevel(this.worldSpatial.z() + 1).dim(10.0f, 10.0f).tex(tas.m_118409_() + tasPxDim * 3.0f, tas.m_118411_() + tasPxDim * 3.0f, tasPxDim * 10.0f, tasPxDim * 10.0f).drawGrayscale(0.9f, 0.7f));
                    if (slot.f_40220_ + this.worldSpatial.x() <= mouseX && slot.f_40220_ + this.worldSpatial.x() + 16 >= mouseX && slot.f_40221_ + this.worldSpatial.y() <= mouseY && slot.f_40221_ + this.worldSpatial.y() + 16 >= mouseY && !(discoveryClues = AntiqueCollectorBookScreen.getAntiqueTooltipComponents(antiques, slot.getAntique())).isEmpty()) {
                        Tooltips.multi(() -> discoveryClues).onHoverTooltip(this.tooltipRenderer, poseStack, mouseX, mouseY, (TooltipFlag)TooltipFlag.Default.NORMAL);
                    }
                }
                Component text = (Component)Optional.of(slot.getAntique()).map(Antique::getConfig).map(cfg -> cfg.getInfo().getName()).map(TextComponent::new).orElse(new TextComponent(slot.getAntique().getRegistryName().m_135815_()));
                text = new TextComponent("").m_7220_(text).m_130940_(ChatFormatting.GRAY);
                int lines = textStyle.calculateLines(text, textWidth * 2);
                poseStack.m_85836_();
                poseStack.m_85837_((double)(slot.f_40220_ + this.worldSpatial.x() - xOffset), (double)(slot.f_40221_ + this.worldSpatial.y() - yOffset - lines * fontHeight), (double)(this.worldSpatial.z() + 1));
                poseStack.m_85841_(0.5f, 0.5f, 0.5f);
                textStyle.textBorder().render(renderer, poseStack, text, textStyle.textWrap(), textStyle.textAlign(), 0, 0, 0, textWidth * 2);
                poseStack.m_85849_();
            }
        }
    }
}

