/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.SlotsElement;
import iskallia.vault.client.gui.framework.element.ThreeSliceHorizontalElement;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.render.ThreeSliceHorizontal;
import iskallia.vault.client.gui.framework.screen.AbstractElementContainerScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.screen.block.TooltipContainerElement;
import iskallia.vault.container.inventory.CardDeckContainer;
import iskallia.vault.container.inventory.CardDeckContainerMenu;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.CardDeckItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CardDeckScreen
extends AbstractElementContainerScreen<CardDeckContainerMenu>
implements MenuAccess<CardDeckContainerMenu> {
    private static final ResourceLocation CONTAINER_BACKGROUND = new ResourceLocation("textures/gui/container/generic_54.png");
    private final TooltipContainerElement tooltip;

    public CardDeckScreen(CardDeckContainerMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title, ScreenRenderers.getImmediate(), ScreenTooltipRenderer::create);
        String titleStr;
        MutableComponent cardDeckTitle;
        Font font;
        int titleWidth;
        this.f_96546_ = false;
        this.setGuiSize(Spatials.size(menu.getTotalWidth(), menu.getTotalHeight()));
        this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionXY((menu.getTotalWidth() - menu.getInventoryWidth()) / 2, menu.getTotalHeight() - menu.getInventoryHeight()).size(menu.getInventoryWidth(), menu.getInventoryHeight()), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionXY((menu.getTotalWidth() - menu.getDeckWidth()) / 2, 0).size(menu.getDeckWidth(), menu.getDeckHeight()), ScreenTextures.CARD_DECK_BACKGROUND_9).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        this.addElement((SlotsElement)new SlotsElement(Spatials.zero(), ((CardDeckContainerMenu)this.m_6262_()).getPlayerSlots()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.positionXY(gui)));
        this.addElement((SlotsElement)new SlotsElement((IPosition)Spatials.zero(), ((CardDeckContainerMenu)this.m_6262_()).getCardSlots(), ScreenTextures.INSET_CARD_SLOT_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.positionXY(gui)));
        this.addElement((SlotsElement)new SlotsElement((IPosition)Spatials.zero(), ((CardDeckContainerMenu)this.m_6262_()).getModifiedCardSlots(), ScreenTextures.INSET_CARD_SLOT_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.positionXY(gui)));
        this.tooltip = this.addElement((TooltipContainerElement)new TooltipContainerElement((ISpatial)Spatials.positionXY(-139, 0).height(120).width(130), ItemStack.f_41583_).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXYZ(gui)));
        this.addElement((NineSliceElement)new NineSliceElement(this.tooltip.getWorldSpatial(), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui).translateX(-5).translateY(-5).translateZ(-10).width(this.tooltip.width() + 10).height(this.tooltip.height() + 10)));
        ThreeSliceHorizontal.TextureRegion titleIcon = ScreenTextures.CARD_DECK_TITLE_LARGE_3;
        if (menu.getContainer().getDeckWidth() <= 3) {
            titleIcon = ScreenTextures.CARD_DECK_TITLE_SMALL_3;
        }
        if ((titleWidth = (font = Minecraft.m_91087_().f_91062_).m_92852_((FormattedText)(cardDeckTitle = new TextComponent(titleStr = ModConfigs.CARD_DECK.getName(CardDeckItem.getId(menu.getDeckStack(playerInventory.f_35978_))).orElse("Card Deck")).m_130940_(ChatFormatting.DARK_GRAY)))) % 2 == 1) {
            --titleWidth;
        }
        int titleX = (menu.getTotalWidth() - titleWidth) / 2;
        int titleY = 5;
        int elementWidth = titleWidth + titleIcon.slices().left() + titleIcon.slices().right();
        this.addElement(new ThreeSliceHorizontalElement(Spatials.positionXY(titleX - titleIcon.slices().left(), titleY).size(elementWidth, 12), titleIcon)).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXYZ(gui));
        this.addElement(new LabelElement((IPosition)Spatials.positionXY(titleX, titleY + 2), (Component)cardDeckTitle, LabelTextStyle.defaultStyle())).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXYZ(gui));
    }

    @Override
    public void m_6305_(PoseStack matrixStack, int pMouseX, int pMouseY, float pPartialTick) {
        CardDeckContainerMenu.DeckSlot deckSlot;
        this.tooltip.refresh(((CardDeckContainerMenu)this.f_97732_).getDeckStack((Player)Minecraft.m_91087_().f_91074_));
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, pMouseX, pMouseY, pPartialTick);
        this.renderMatchingNeighbors(matrixStack);
        long window = Minecraft.m_91087_().m_91268_().m_85439_();
        if (!InputConstants.m_84830_((long)window, (int)341) || !(this.getSlotUnderMouse() instanceof CardDeckContainerMenu.DeckSlot)) {
            this.m_7025_(matrixStack, pMouseX, pMouseY);
        }
        for (Slot slot : ((CardDeckContainerMenu)this.f_97732_).f_38839_) {
            if (!(slot instanceof CardDeckContainerMenu.DeckSlot)) continue;
            deckSlot = (CardDeckContainerMenu.DeckSlot)slot;
            if (((CardDeckContainerMenu)this.f_97732_).getContainer().isCardActive(deckSlot.f_40219_)) continue;
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 0.0, 200.0);
            CardDeckScreen.renderSlotHighlight((PoseStack)matrixStack, (int)(slot.f_40220_ + this.f_97735_), (int)(slot.f_40221_ + this.f_97736_), (int)0, (int)0x70FF0000);
            matrixStack.m_85849_();
        }
        for (Slot slot : ((CardDeckContainerMenu)this.f_97732_).getModifiedCardSlots()) {
            if (!(slot instanceof CardDeckContainerMenu.DeckSlot)) continue;
            deckSlot = (CardDeckContainerMenu.DeckSlot)slot;
            ItemStack stack = deckSlot.m_7993_();
            if (!stack.m_41619_()) {
                CardDeckScreen.renderSlotHighlight((PoseStack)matrixStack, (int)(slot.f_40220_ + this.f_97735_), (int)(slot.f_40221_ + this.f_97736_), (int)0, (int)1890944759);
                continue;
            }
            CardDeckScreen.renderSlotHighlight((PoseStack)matrixStack, (int)(slot.f_40220_ + this.f_97735_), (int)(slot.f_40221_ + this.f_97736_), (int)0, (int)0x20FF0000);
        }
    }

    private void renderMatchingNeighbors(PoseStack matrixStack) {
        Slot slot;
        if (((CardDeckContainerMenu)this.f_97732_).m_142621_().m_41619_() && (slot = this.getSlotUnderMouse()) instanceof CardDeckContainerMenu.DeckSlot) {
            CardDeckContainerMenu.DeckSlot deckSlot = (CardDeckContainerMenu.DeckSlot)slot;
            List<CardDeckContainer.SlotColor> matchingNeighbors = ((CardDeckContainerMenu)this.f_97732_).getContainer().getMatchingNeighbors(deckSlot.f_40219_);
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 0.0, 500.0);
            matchingNeighbors.forEach(matchingNeighbor -> {
                Slot slot = ((CardDeckContainerMenu)this.f_97732_).m_38853_(matchingNeighbor.slotIndex());
                if (slot != null) {
                    CardDeckScreen.renderSlotHighlight((PoseStack)matrixStack, (int)(slot.f_40220_ + this.f_97735_), (int)(slot.f_40221_ + this.f_97736_), (int)0, (int)(matchingNeighbor.color() | 0x77000000));
                }
            });
            matrixStack.m_85849_();
        }
    }

    public List<Component> m_96555_(ItemStack stack) {
        List tooltip = super.m_96555_(stack);
        if (this.getSlotUnderMouse() instanceof CardDeckContainerMenu.DeckSlot) {
            tooltip.add(new TextComponent("Hold <CTRL> to hide tooltip").m_130940_(ChatFormatting.DARK_GRAY));
        }
        return tooltip;
    }

    @Override
    protected void renderTooltips(@NotNull PoseStack poseStack, int mouseX, int mouseY) {
    }
}

