/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.framework.element.spi.AbstractSpatialElement;
import iskallia.vault.client.gui.framework.element.spi.IRenderedElement;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.item.CompanionItem;
import iskallia.vault.util.LegendaryScreenParticle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import org.jetbrains.annotations.NotNull;

public class CompanionHeadElement
extends AbstractSpatialElement<CompanionHeadElement>
implements IRenderedElement {
    private ItemStack companionStack;
    private boolean visible = true;
    private final List<LegendaryScreenParticle> particles = new ArrayList<LegendaryScreenParticle>();
    private long lastTick = -1L;

    public CompanionHeadElement(ISpatial spatial, ItemStack companionStack) {
        super(spatial);
        this.companionStack = companionStack;
        this.particles.add(new LegendaryScreenParticle().angleRange(0.0f, 360.0f).quantityRange(1, 2).lifespanRange(20, 40).spawnedPosition(0, 0).spawnedWidthHeight(spatial.width(), spatial.height()).sizeRange(2, 4).speedRange(0.1f, 0.3f));
    }

    public void setCompanionStack(ItemStack stack) {
        this.companionStack = stack;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (!this.visible) {
            return;
        }
        long tick = System.currentTimeMillis() / 50L;
        boolean ticked = tick != this.lastTick;
        this.lastTick = tick;
        poseStack.m_85836_();
        poseStack.m_85837_((double)this.worldSpatial.x(), (double)this.worldSpatial.y(), (double)this.worldSpatial.z());
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, -10.0);
        for (LegendaryScreenParticle p : this.particles) {
            if (ticked) {
                p.pop();
                p.tick();
            }
            p.render(poseStack, partialTick);
        }
        poseStack.m_85849_();
        CompanionHeadElement.renderPlayerHead(poseStack, 0, 0, this.worldSpatial.width(), this.companionStack);
        poseStack.m_85849_();
    }

    public static void renderPlayerHead(PoseStack poseStack, int x, int y, int size, ItemStack stack) {
        SkinManager skinManager;
        Map textures;
        Optional<GameProfile> profileOpt = CompanionItem.getUserProfile(stack);
        if (profileOpt.isEmpty()) {
            return;
        }
        GameProfile profile = profileOpt.get();
        CompoundTag tag = stack.m_41784_();
        if (!(profile.getProperties().containsKey((Object)"textures") || tag.m_128441_("updatingSkin") || tag.m_128441_("defaultSkin"))) {
            tag.m_128379_("updatingSkin", true);
            SkullBlockEntity.m_155738_((GameProfile)profile, updated -> {
                CompanionItem.setUserProfile(stack, updated);
                CompoundTag t = stack.m_41784_();
                if (!updated.getProperties().containsKey((Object)"textures")) {
                    t.m_128379_("defaultSkin", true);
                }
                t.m_128473_("updatingSkin");
            });
            return;
        }
        if (profile.getId() == null) {
            return;
        }
        ResourceLocation skin = DefaultPlayerSkin.m_118627_((UUID)profile.getId());
        if (!tag.m_128441_("defaultSkin") && profile.getProperties().containsKey((Object)"textures") && (textures = (skinManager = Minecraft.m_91087_().m_91109_()).m_118815_(profile)).containsKey(MinecraftProfileTexture.Type.SKIN)) {
            MinecraftProfileTexture texture = (MinecraftProfileTexture)textures.get(MinecraftProfileTexture.Type.SKIN);
            skin = skinManager.m_118825_(texture, MinecraftProfileTexture.Type.SKIN);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)skin);
        GuiComponent.m_93160_((PoseStack)poseStack, (int)x, (int)y, (int)size, (int)size, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
        GuiComponent.m_93160_((PoseStack)poseStack, (int)x, (int)y, (int)size, (int)size, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
    }
}

