/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.VaultMod;
import iskallia.vault.client.ClientDiscoveredEntriesData;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.animation.ElementAnimator;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ButtonElement;
import iskallia.vault.client.gui.framework.element.EntityModelElement;
import iskallia.vault.client.gui.framework.element.HorizontalNumberedProgressBarElement;
import iskallia.vault.client.gui.framework.element.HorizontalProgressBarElement;
import iskallia.vault.client.gui.framework.element.ItemStackDisplayElement;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.NineSliceButtonElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.SlotsElement;
import iskallia.vault.client.gui.framework.element.TextureAtlasElement;
import iskallia.vault.client.gui.framework.element.spi.AbstractSpatialElement;
import iskallia.vault.client.gui.framework.element.spi.ElementStore;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.render.Tooltips;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.render.spi.ITooltipRenderFunction;
import iskallia.vault.client.gui.framework.render.spi.ITooltipRenderer;
import iskallia.vault.client.gui.framework.screen.AbstractElementContainerScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.helper.UIHelper;
import iskallia.vault.client.gui.screen.summary.element.StatLabelListElement;
import iskallia.vault.container.CompanionHomeContainer;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.entity.entity.PetEntity;
import iskallia.vault.entity.entity.pet.PetHelper;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModEntities;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModTextureAtlases;
import iskallia.vault.item.CompanionItem;
import iskallia.vault.item.CompanionParticleTrailItem;
import iskallia.vault.item.CompanionPetManager;
import iskallia.vault.item.CompanionSeries;
import iskallia.vault.network.message.ServerboundCompanionRelicRemoveMessage;
import iskallia.vault.network.message.ServerboundCompanionVariantChangeMessage;
import iskallia.vault.util.CoinDefinition;
import iskallia.vault.util.InventoryUtil;
import iskallia.vault.util.StringUtils;
import iskallia.vault.util.Tween;
import iskallia.vault.util.function.Memo;
import iskallia.vault.www.Reward;
import iskallia.vault.www.RewardsManager;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CompanionHomeScreen
extends AbstractElementContainerScreen<CompanionHomeContainer> {
    private int companionHearts;
    private int maxCompanionHearts;
    private ItemStack companionStack;
    private static final int RELIC_SLOTS = 4;
    private static final int COSMETIC_SLOTS = 3;
    private List<PetHelper.PetVariant> variants = new ArrayList<PetHelper.PetVariant>();
    private int variantIndex;
    private LabelElement<?> nameLabel;
    private final ElementAnimator openVariationsAnimation = new ElementAnimator(false, ElementAnimator.Playback.HOLD_ON_LAST_FRAME).addFrame(ElementAnimator.Property.X, 0.0f, -25.0f, Tween.EASE_INOUT_QUADRATIC).addFrame(ElementAnimator.Property.X, 20.0f, 0.0f, Tween.EASE_INOUT_QUADRATIC);
    private final ElementStore variantButtons = new ElementStore();
    private static final Cache<UUID, LivingEntity> CACHED_COMPANIONS = CacheBuilder.newBuilder().maximumSize(10L).expireAfterAccess(2L, TimeUnit.MINUTES).build();

    public CompanionHomeScreen(CompanionHomeContainer menu, Inventory inv, Component title) {
        super(menu, inv, title, ScreenRenderers.getImmediate(), ScreenTooltipRenderer::create);
        this.setGuiSize(Spatials.size(176, 185));
        this.companionStack = menu.getCompanionStack();
        this.companionHearts = CompanionItem.getCompanionHearts(this.companionStack);
        this.maxCompanionHearts = CompanionItem.getCompanionMaxHearts(this.companionStack);
        this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionXY(0, 0).size(this.getGuiSpatial()), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout(this.translateWorldSpatial()));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXYZ(7, menu.m_38853_((int)7).f_40221_ - 11, 2), (Component)inv.m_5446_().m_6881_().m_130948_(Style.f_131099_.m_178520_(-12632257)), LabelTextStyle.defaultStyle().left()).layout(this.translateWorldSpatial()));
        this.addElement((SlotsElement)new SlotsElement((IPosition)Spatials.zero(), (List<Slot>)menu.f_38839_, slot -> {
            CompanionHomeContainer.TrailSlot trail;
            CompanionHomeContainer.RelicSlot relic;
            if (slot instanceof CompanionHomeContainer.RelicSlot && !(relic = (CompanionHomeContainer.RelicSlot)((Object)slot)).isUnlocked()) {
                return ScreenTextures.ITEM_SLOT_COMPANION_SLOT_DISABLED;
            }
            if (slot instanceof CompanionHomeContainer.TrailSlot && !(trail = (CompanionHomeContainer.TrailSlot)((Object)slot)).isUnlocked()) {
                return ScreenTextures.ITEM_SLOT_RELIC_SLOT_DISABLED;
            }
            return ScreenTextures.INSET_ITEM_SLOT_BACKGROUND;
        }).layout(this.translateWorldSpatial()));
        this.initialiseElements();
    }

    private void initialiseElements() {
        block12: {
            int y;
            CompanionSeries series;
            block11: {
                Optional modifierOptional;
                series = CompanionItem.getPetSeries(this.companionStack);
                PetHelper.PetModelType modelType = PetHelper.getModel(CompanionItem.getPetType(this.companionStack)).orElse(null);
                String companionName = CompanionItem.getPetName(this.companionStack);
                if (companionName == null || companionName.isEmpty()) {
                    companionName = "Companion";
                }
                this.nameLabel = (LabelElement)new LabelElement((IPosition)Spatials.positionXYZ(7, 7, 1), (Component)new TextComponent(companionName).m_130948_(Style.f_131099_.m_178520_(-12632257)), LabelTextStyle.left()).layout(this.translateWorldSpatial());
                this.addElement(this.nameLabel);
                this.addElement((EntityModelElement)new EntityModelElement((IPosition)Spatials.positionXY(25, 18), (ISize)Spatials.size(54, 72), this::getCachedCompanion, Spatials.positionXY(0, -10), 1.0f).layout(this.translateWorldSpatial()));
                int x = 27;
                for (int i = 0; i < CompanionItem.getCompanionMaxHearts(this.companionStack); ++i) {
                    boolean isFull = i < CompanionItem.getCompanionHearts(this.companionStack);
                    this.addElement((TextureAtlasElement)new TextureAtlasElement(Spatials.positionXYZ(x, 20, 5), isFull ? ScreenTextures.FULL_HEART : ScreenTextures.EMPTY_HEART).layout(this.translateWorldSpatial()));
                    x += 9;
                }
                this.addElement((HorizontalNumberedProgressBarElement)((HorizontalNumberedProgressBarElement)new HorizontalNumberedProgressBarElement(Spatials.positionXYZ(31, 80, 300), ScreenTextures.COMPANION_HOME_XP_BAR, ScreenTextures.COMPANION_HOME_XP_BAR_PROGRESS, () -> Float.valueOf((float)CompanionItem.getCompanionXP(this.companionStack) / (float)Math.max(1, CompanionItem.getXPRequiredForNextLevel(this.companionStack))), HorizontalProgressBarElement.Direction.LEFT_TO_RIGHT, () -> CompanionItem.getCompanionLevel(this.companionStack), String::valueOf, TextColor.m_131266_((int)16772397), LabelTextStyle.border4(TextColor.m_131266_((int)4658443)), HorizontalNumberedProgressBarElement.Style.CENTER, Spatials.positionY(4).positionZ(5)).layout(this.translateWorldSpatial())).tooltip(this.getCompanionLevelTooltip()));
                this.addElement((ButtonElement)((ButtonElement)new ButtonElement(Spatials.positionXYZ(this.getGuiSpatial().width() - 16, 5, 1000), ScreenTextures.CYCLE_BUTTONS, () -> {
                    if (this.openVariationsAnimation.isFinished()) {
                        this.openVariationsAnimation.backwards(!this.openVariationsAnimation.isBackwards()).start();
                    } else {
                        this.openVariationsAnimation.start();
                    }
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                }).layout(this.translateWorldSpatial())).tooltip(Tooltips.single(() -> new TextComponent("Change Variant"))));
                if (CompanionItem.getTemporalModifier(this.companionStack).isPresent() && (modifierOptional = VaultModifierRegistry.getOpt(CompanionItem.getTemporalModifier(this.companionStack).get())).isPresent() && ((VaultModifier)modifierOptional.get()).getIcon().isPresent()) {
                    this.addElement((TextureAtlasElement)((TextureAtlasElement)new TextureAtlasElement(Spatials.positionXYZ(116, 20, 5), Spatials.size(32, 32), TextureAtlasRegion.of(ModTextureAtlases.MODIFIERS, ((VaultModifier)modifierOptional.get()).getIcon().get())).scale(2.0f, 2.0f).tooltip(Tooltips.multi(() -> List.of(new TextComponent(((VaultModifier)modifierOptional.get()).getDisplayName()).m_130948_(Style.f_131099_.m_131148_(((VaultModifier)modifierOptional.get()).getDisplayTextColor())), new TextComponent("Duration: " + UIHelper.formatTimeString(CompanionItem.getTemporalDuration(this.companionStack))))))).layout(this.translateWorldSpatial()));
                }
                ArrayList stats = new ArrayList();
                stats.add(StatLabelListElement.Stat.builder().iconAtlas(ScreenTextures.COMPANION_VAULTS_ICON).value(() -> CompanionItem.getVaultRuns(this.companionStack)).valueFormatter(number -> number + " vaults").build());
                stats.add(StatLabelListElement.Stat.builder().iconAtlas(ScreenTextures.COMPANION_AGE_ICON).value(() -> {
                    long days = 0L;
                    try {
                        LocalDate date = LocalDate.parse(CompanionItem.getHatchedDate(this.companionStack));
                        days = ChronoUnit.DAYS.between(date, LocalDate.now());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return days;
                }).valueFormatter(number -> number + " days").build());
                stats.add(StatLabelListElement.Stat.builder().iconAtlas(ScreenTextures.COMPANION_COOLDOWN_ICON).value(() -> CompanionItem.getCurrentCooldown(this.companionStack)).valueFormatter(number -> number > 0 ? UIHelper.formatTimeString(number * 20) : "Ready").description(() -> {
                    int level = CompanionItem.getCompanionLevel(this.companionStack);
                    float multiplier = ModConfigs.COMPANIONS.getCooldownMultiplier();
                    int base = CompanionItem.getBaseCooldown(this.companionStack);
                    int totalCooldown = base + Math.round((float)base * multiplier * (float)(level - 1));
                    return List.of(new TextComponent("Remaining cooldown of companion"), new TextComponent(""), new TextComponent("Total Cooldown: " + totalCooldown + " minutes"));
                }).build());
                this.addElement((StatLabelListElement)((AbstractSpatialElement)StatLabelListElement.builder().addStats(stats).spatial(Spatials.positionXYZ(100, 60, 5).width(this.getGuiSpatial().width() - 30 - 54 - 16 - 6)).textColor(TextColor.m_131266_((int)0x484848)).build()).layout(this.translateWorldSpatial()));
                if (modelType == null) break block11;
                y = 5;
                List<PetHelper.PetVariant> variants = modelType.getVariants(Minecraft.m_91087_().f_91074_.m_142081_());
                int i = 0;
                while (i < variants.size()) {
                    final PetHelper.PetVariant variant = variants.get(i);
                    final int finalI = i++;
                    this.addElement(((AbstractSpatialElement)new NineSliceButtonElement(Spatials.positionXYZ(this.getGuiSpatial().width() + 1, y, -1000).size(18, 18), ScreenTextures.BUTTON_EMPTY_GRAY_TEXTURES, () -> this.changeVariant(variant.type())){

                        @Override
                        public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
                            poseStack.m_85836_();
                            poseStack.m_85837_((double)CompanionHomeScreen.this.openVariationsAnimation.get(ElementAnimator.Property.X, (float)(finalI * 3)), (double)CompanionHomeScreen.this.openVariationsAnimation.get(ElementAnimator.Property.Y, (float)(finalI * 3)), 0.0);
                            super.render(renderer, poseStack, mouseX, mouseY, partialTick);
                            poseStack.m_85849_();
                        }

                        @Override
                        public boolean isDisabled() {
                            return super.isDisabled() || CompanionHomeScreen.this.openVariationsAnimation.get(ElementAnimator.Property.X, (float)(finalI * 3)) != 0.0f || variant.type().equalsIgnoreCase(CompanionItem.getPetType(CompanionHomeScreen.this.companionStack)) || variant.requiresRewards() && !RewardsManager.getInstance().getRewardData(Minecraft.m_91087_().f_91074_.m_142081_()).hasModel(Reward.ArmorPiece.COMPANION, VaultMod.id(variant.type())) || variant.requiresUnlock() && !ClientDiscoveredEntriesData.CompanionVariants.isUnlocked(variant.type());
                        }

                        @Override
                        public boolean renderTooltip(ITooltipRenderer tooltipRenderer, @NotNull PoseStack poseStack, int mouseX, int mouseY) {
                            if (CompanionHomeScreen.this.openVariationsAnimation.get(ElementAnimator.Property.X, (float)(finalI * 3)) != 0.0f) {
                                return false;
                            }
                            return super.renderTooltip(tooltipRenderer, poseStack, mouseX, mouseY);
                        }
                    }.layout(this.translateWorldSpatial())).tooltip(Tooltips.single(() -> new TextComponent(variant.displayName()))));
                    this.addElement(new ItemStackDisplayElement(Spatials.positionXYZ(this.getGuiSpatial().width() + 2, y + 1, -900), variant.displayItem()){

                        @Override
                        public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
                            poseStack.m_85836_();
                            poseStack.m_85837_((double)CompanionHomeScreen.this.openVariationsAnimation.get(ElementAnimator.Property.X, (float)(finalI * 3)), (double)CompanionHomeScreen.this.openVariationsAnimation.get(ElementAnimator.Property.Y, (float)(finalI * 3)), 0.0);
                            super.render(renderer, poseStack, mouseX, mouseY, partialTick);
                            poseStack.m_85849_();
                        }
                    }.setUsePrevPose(true).layout(this.translateWorldSpatial()));
                    y += 20;
                }
                break block12;
            }
            if (!series.equals((Object)CompanionSeries.LEGEND)) break block12;
            y = 5;
            int i = 0;
            while (i < 4) {
                final String variant = switch (i) {
                    case 0 -> "eternal";
                    case 1 -> "giant";
                    case 2 -> "minion";
                    case 3 -> "antlion";
                    default -> null;
                };
                final int finalI = i++;
                this.addElement(((AbstractSpatialElement)((AbstractSpatialElement)new NineSliceButtonElement(Spatials.positionXYZ(this.getGuiSpatial().width() + 1, y, -1000).size(18, 18), ScreenTextures.BUTTON_EMPTY_GRAY_TEXTURES, () -> this.changeVariant(variant)){

                    @Override
                    public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
                        poseStack.m_85836_();
                        poseStack.m_85837_((double)CompanionHomeScreen.this.openVariationsAnimation.get(ElementAnimator.Property.X, (float)(finalI * 3)), (double)CompanionHomeScreen.this.openVariationsAnimation.get(ElementAnimator.Property.Y, (float)(finalI * 3)), 0.0);
                        super.render(renderer, poseStack, mouseX, mouseY, partialTick);
                        poseStack.m_85849_();
                    }

                    @Override
                    public boolean isDisabled() {
                        return super.isDisabled() || CompanionHomeScreen.this.openVariationsAnimation.get(ElementAnimator.Property.X, (float)(finalI * 3)) != 0.0f || variant.equalsIgnoreCase(CompanionItem.getPetType(CompanionHomeScreen.this.companionStack));
                    }

                    @Override
                    public boolean renderTooltip(ITooltipRenderer tooltipRenderer, @NotNull PoseStack poseStack, int mouseX, int mouseY) {
                        if (CompanionHomeScreen.this.openVariationsAnimation.get(ElementAnimator.Property.X, (float)(finalI * 3)) != 0.0f) {
                            return false;
                        }
                        return super.renderTooltip(tooltipRenderer, poseStack, mouseX, mouseY);
                    }
                }.label(() -> new TextComponent(variant.substring(0, 1).toUpperCase()))).layout(this.translateWorldSpatial())).tooltip(Tooltips.single(() -> new TextComponent(StringUtils.convertToTitleCase(variant)))));
                y += 20;
            }
        }
    }

    private LivingEntity getCachedCompanion() {
        UUID uuid = CompanionItem.getCompanionUUID(this.companionStack);
        if (uuid == null) {
            return null;
        }
        Object entity = (LivingEntity)CACHED_COMPANIONS.getIfPresent((Object)uuid);
        if (entity != null) {
            return entity;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return null;
        }
        CompanionSeries series = CompanionItem.getPetSeries(this.companionStack);
        String type = CompanionItem.getPetType(this.companionStack);
        EntityType<PetEntity> entityType = series == CompanionSeries.PET ? PetHelper.getVariant(type).map(PetHelper.PetVariant::entityType).orElse(ModEntities.PET) : ModEntities.PET;
        PetEntity pet = (PetEntity)entityType.m_20615_((Level)level);
        if (pet == null) {
            return null;
        }
        if (series == CompanionSeries.PET) {
            PetHelper.getVariant(type).ifPresent(variant -> {
                if (variant.traits() != null) {
                    variant.traits().apply(pet);
                }
            });
        } else {
            pet.setCompanionData(this.companionStack);
        }
        CompoundTag spawnData = CompanionItem.getSpawnData(this.companionStack);
        if (spawnData != null) {
            pet.setVanillaEntityData(spawnData);
        }
        List<Integer> cols = CompanionItem.getAllCosmeticColours(this.companionStack);
        List<CompanionParticleTrailItem.TrailType> types = CompanionItem.getAllCosmeticTrailTypes(this.companionStack);
        ArrayList<Integer> validCols = new ArrayList<Integer>();
        ArrayList<CompanionParticleTrailItem.TrailType> validTypes = new ArrayList<CompanionParticleTrailItem.TrailType>();
        for (int i = 0; i < cols.size(); ++i) {
            if (i >= types.size() || cols.get(i) == -1) continue;
            validCols.add(cols.get(i));
            validTypes.add(types.get(i));
        }
        pet.setParticleColours(validCols);
        pet.setParticleTrailTypes(validTypes);
        CompanionPetManager.applySkinsToEntity(pet, this.companionStack);
        entity = pet;
        CACHED_COMPANIONS.put((Object)uuid, entity);
        return entity;
    }

    private void changeVariant(String variantType) {
        if (CompanionItem.getPetSeries(this.companionStack).equals((Object)CompanionSeries.PET)) {
            String companionName;
            PetHelper.PetVariant variant = PetHelper.getVariant(variantType).orElse(null);
            if (variant == null) {
                return;
            }
            String previousType = CompanionItem.getPetType(this.companionStack);
            Optional<PetHelper.PetVariant> previousVariant = PetHelper.getVariant(previousType);
            if (previousVariant.isPresent() && ((companionName = CompanionItem.getPetName(this.companionStack)) == null || companionName.equalsIgnoreCase(previousVariant.get().displayName()))) {
                CompanionItem.setPetName(this.companionStack, variant.displayName());
                this.nameLabel.set((Component)new TextComponent(variant.displayName()).m_130948_(Style.f_131099_.m_178520_(-12632257)));
            }
        }
        CompanionItem.setPetType(this.companionStack, variantType);
        ModNetwork.CHANNEL.sendToServer((Object)new ServerboundCompanionVariantChangeMessage(variantType, ((CompanionHomeContainer)this.f_97732_).getPos()));
        CACHED_COMPANIONS.invalidate((Object)CompanionItem.getCompanionUUID(this.companionStack));
    }

    @Override
    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void m_181908_() {
        super.m_181908_();
        this.openVariationsAnimation.tick(1.0f);
    }

    @Override
    protected boolean renderHoveredSlotTooltips(@NotNull PoseStack stack, int mouseX, int mouseY) {
        CompanionHomeContainer.TrailSlot trail;
        CompanionHomeContainer.RelicSlot relic;
        Slot slot = this.f_97734_;
        if (slot instanceof CompanionHomeContainer.RelicSlot && !(relic = (CompanionHomeContainer.RelicSlot)slot).isUnlocked()) {
            this.m_169388_(stack, relic.getUnlockTooltip(), Optional.empty(), mouseX, mouseY);
            return true;
        }
        slot = this.f_97734_;
        if (slot instanceof CompanionHomeContainer.TrailSlot && !(trail = (CompanionHomeContainer.TrailSlot)slot).isUnlocked()) {
            this.m_169388_(stack, trail.getUnlockTooltip(), Optional.empty(), mouseX, mouseY);
            return true;
        }
        return super.renderHoveredSlotTooltips(stack, mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        CompanionHomeContainer.RelicSlot relic;
        Slot slot;
        if (button == 0 && CompanionHomeScreen.m_96638_() && (slot = this.f_97734_) instanceof CompanionHomeContainer.RelicSlot && (relic = (CompanionHomeContainer.RelicSlot)slot).m_6657_() && relic.isUnlocked() && CompanionItem.getCompanionHearts(this.companionStack) > 0) {
            ModNetwork.CHANNEL.sendToServer((Object)new ServerboundCompanionRelicRemoveMessage(relic.f_40219_, ((CompanionHomeContainer)this.f_97732_).getPos()));
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public List<Component> m_96555_(ItemStack stack) {
        CompanionHomeContainer.RelicSlot relic;
        List tooltip = super.m_96555_(stack);
        Slot slot = this.f_97734_;
        if (slot instanceof CompanionHomeContainer.RelicSlot && (relic = (CompanionHomeContainer.RelicSlot)slot).isUnlocked() && relic.m_6657_()) {
            tooltip.add(TextComponent.f_131282_);
            if (CompanionItem.getCompanionHearts(this.companionStack) <= 0) {
                tooltip.add(new TextComponent("You cannot take this relic out").m_130940_(ChatFormatting.RED));
            } else {
                int cost = ModConfigs.COMPANIONS.getRelicRemovalCost();
                boolean hasEnough = CoinDefinition.hasEnoughCurrency(InventoryUtil.findAllItems((Player)Minecraft.m_91087_().f_91074_), new ItemStack((ItemLike)ModBlocks.VAULT_GOLD, cost));
                tooltip.add(new TextComponent("Removal Cost: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)new TextComponent(cost + " Vault Gold").m_130940_(hasEnough ? ChatFormatting.GREEN : ChatFormatting.RED)));
                tooltip.add(TextComponent.f_131282_);
                tooltip.add(new TextComponent("Shift left click to remove relic").m_130940_(ChatFormatting.GRAY));
            }
        }
        return tooltip;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key key = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (keyCode == 256 || Minecraft.m_91087_().f_91066_.f_92092_.isActiveAndMatches(key)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    @NotNull
    private ITooltipRenderFunction getCompanionLevelTooltip() {
        return Tooltips.shift(Tooltips.multi(Memo.of(() -> List.of(new TextComponent("Companion Experience"), Tooltips.DEFAULT_HOLD_SHIFT_COMPONENT))), Tooltips.multi(() -> List.of(new TextComponent("Companion Experience"), new TextComponent("Experience: " + CompanionItem.getCompanionXP(this.companionStack) + "/" + CompanionItem.getXPRequiredForNextLevel(this.companionStack)).m_130940_(ChatFormatting.GRAY), new TextComponent("Level: " + CompanionItem.getCompanionLevel(this.companionStack)).m_130940_(ChatFormatting.GRAY))));
    }

    private void renderHearts(PoseStack poseStack) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_93098_);
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, 10.0);
        int guiX = this.getGuiLeft();
        int guiY = this.getGuiTop();
        int x = guiX + 7;
        int y = guiY + 17;
        for (int i = 0; i < this.maxCompanionHearts; ++i) {
            GuiComponent.m_93133_((PoseStack)poseStack, (int)(x + i * 8), (int)y, (float)16.0f, (float)0.0f, (int)9, (int)9, (int)256, (int)256);
            if (i >= this.companionHearts) continue;
            GuiComponent.m_93133_((PoseStack)poseStack, (int)(x + i * 8), (int)y, (float)52.0f, (float)0.0f, (int)9, (int)9, (int)256, (int)256);
        }
        int separatorX = x + this.maxCompanionHearts * 8 + 2;
        int textX = separatorX + 6;
        int textY = y + 1;
        Minecraft.m_91087_().f_91062_.m_92883_(poseStack, " | ", (float)separatorX, (float)textY, 0x333333);
        int current = CompanionItem.getCurrentCooldown(this.companionStack);
        if (this.companionHearts <= 0) {
            Minecraft.m_91087_().f_91062_.m_92750_(poseStack, " Retired", (float)textX, (float)textY, 0xFFFFFF);
        } else if (current <= 0) {
            Minecraft.m_91087_().f_91062_.m_92750_(poseStack, " Ready", (float)textX, (float)y, 9629275);
        } else {
            Minecraft.m_91087_().f_91062_.m_92883_(poseStack, " Resting " + UIHelper.formatTimeString((long)current * 20L), (float)textX, (float)textY, 0x333333);
        }
        poseStack.m_85849_();
    }
}

