/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.TextureAtlasElement;
import iskallia.vault.client.gui.framework.element.spi.AbstractSpatialElement;
import iskallia.vault.client.gui.framework.element.spi.IRenderedElement;
import iskallia.vault.client.gui.framework.render.TooltipDirection;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.render.spi.ITooltipRenderer;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.init.ModTextureAtlases;
import iskallia.vault.util.LegendaryScreenParticle;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class CompanionModifierElement
extends AbstractSpatialElement<CompanionModifierElement>
implements IRenderedElement {
    private final TextureAtlasElement<?> modifierTexture;
    private final Component name;
    private final String description;
    @Nullable
    private final LabelElement<?> amountLabel;
    @Nullable
    private final LegendaryScreenParticle screenParticle;
    private long lastTickTime = 0L;
    private static final int BASE_TEXTURE_SIZE = 16;

    public CompanionModifierElement(ISpatial spatial, ResourceLocation modifierIcon, int amount, boolean legendary, Component name, String description) {
        super(spatial);
        int desiredSize = spatial.width();
        float scale = (float)desiredSize / 16.0f;
        this.modifierTexture = new TextureAtlasElement(Spatials.positionXY(0, 0), TextureAtlasRegion.of(ModTextureAtlases.MODIFIERS, modifierIcon));
        if (legendary) {
            name = new TextComponent("\u2726 ").m_130940_(ChatFormatting.GOLD).m_7220_(name);
        }
        this.name = name;
        this.description = description;
        if (amount > 1) {
            int labelX = (int)((float)(amount < 10 ? 4 : 0) * scale);
            int labelY = (int)(8.0f * scale);
            this.amountLabel = new LabelElement((IPosition)Spatials.positionXYZ(labelX, labelY, 1), (Component)new TextComponent("x" + amount).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.WHITE)), LabelTextStyle.left().shadow());
        } else {
            this.amountLabel = null;
        }
        if (legendary) {
            int particleSize = (int)(8.0f * scale);
            int particleOffset = (int)(2.0f * scale);
            this.screenParticle = new LegendaryScreenParticle().angleRange(0.0f, 360.0f).quantityRange(1, 3).delayRange(0, 2).lifespanRange(10, 30).sizeRange(1, 3).speedRange(0.2f, 0.3f).spawnedPosition(particleOffset, particleOffset).spawnedWidthHeight(particleSize, particleSize);
        } else {
            this.screenParticle = null;
        }
        this.tooltip((ITooltipRenderer tooltipRenderer, PoseStack poseStack, int mouseX, int mouseY, TooltipFlag tooltipFlag) -> {
            List<MutableComponent> components = List.of(this.name, new TextComponent(this.description).m_130940_(ChatFormatting.DARK_GRAY));
            tooltipRenderer.renderTooltip(poseStack, components, mouseX, mouseY, ItemStack.f_41583_, TooltipDirection.RIGHT);
            return false;
        });
    }

    @Override
    public void setVisible(boolean b) {
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)this.worldSpatial.x(), (double)this.worldSpatial.y(), (double)this.worldSpatial.z());
        if (this.screenParticle != null) {
            if (this.lastTickTime != System.currentTimeMillis() / 50L) {
                this.lastTickTime = System.currentTimeMillis() / 50L;
                this.screenParticle.pop();
                this.screenParticle.tick();
            }
            this.screenParticle.render(poseStack, partialTick);
        }
        poseStack.m_85836_();
        float scale = (float)this.worldSpatial.width() / 16.0f;
        poseStack.m_85841_(scale, scale, 1.0f);
        this.modifierTexture.render(renderer, poseStack, mouseX, mouseY, partialTick);
        if (this.amountLabel != null) {
            this.amountLabel.render(renderer, poseStack, mouseX, mouseY, partialTick);
        }
        poseStack.m_85849_();
        poseStack.m_85849_();
    }
}

