/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.VaultMod;
import iskallia.vault.init.ModGameRules;
import iskallia.vault.world.SpectatorMode;
import iskallia.vault.world.VaultCrystalMode;
import iskallia.vault.world.VaultCrystalRecipeScaling;
import iskallia.vault.world.VaultExperience;
import iskallia.vault.world.VaultLoot;
import iskallia.vault.world.VaultMode;
import iskallia.vault.world.VaultPartyExpSharing;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EditVaultGameRulesScreen
extends Screen {
    private final Consumer<Optional<GameRules>> exitCallback;
    private RuleList rules;
    private final Set<RuleEntry> invalidEntries = Sets.newHashSet();
    private Button doneButton;
    @Nullable
    private List<FormattedCharSequence> tooltip;
    private final GameRules gameRules;

    public EditVaultGameRulesScreen(GameRules pGameRules, Consumer<Optional<GameRules>> pExitCallback) {
        super((Component)new TranslatableComponent("editVaultGamerule.title"));
        this.gameRules = pGameRules;
        this.exitCallback = pExitCallback;
    }

    protected void m_7856_() {
        this.f_96541_.f_91068_.m_90926_(true);
        super.m_7856_();
        this.rules = new RuleList(this.gameRules);
        this.m_7787_((GuiEventListener)this.rules);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 155 + 160, this.f_96544_ - 29, 150, 20, CommonComponents.f_130656_, p_101073_ -> this.exitCallback.accept(Optional.empty())));
        this.doneButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 155, this.f_96544_ - 29, 150, 20, CommonComponents.f_130655_, p_101059_ -> this.exitCallback.accept(Optional.of(this.gameRules))));
    }

    public void m_7861_() {
        this.f_96541_.f_91068_.m_90926_(false);
    }

    public void m_7379_() {
        this.exitCallback.accept(Optional.empty());
    }

    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.tooltip = null;
        this.rules.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        EditVaultGameRulesScreen.m_93215_((PoseStack)pPoseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)20, (int)0xFFFFFF);
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        if (this.tooltip != null) {
            this.m_96617_(pPoseStack, this.tooltip, pMouseX, pMouseY);
        }
    }

    void setTooltip(@Nullable List<FormattedCharSequence> pTooltip) {
        this.tooltip = pTooltip;
    }

    private void updateDoneButton() {
        this.doneButton.f_93623_ = this.invalidEntries.isEmpty();
    }

    void markInvalid(RuleEntry pRuleEntry) {
        this.invalidEntries.add(pRuleEntry);
        this.updateDoneButton();
    }

    void clearInvalid(RuleEntry pRuleEntry) {
        this.invalidEntries.remove((Object)pRuleEntry);
        this.updateDoneButton();
    }

    @OnlyIn(value=Dist.CLIENT)
    public class RuleList
    extends ContainerObjectSelectionList<RuleEntry> {
        public RuleList(GameRules pGameRules) {
            super(EditVaultGameRulesScreen.this.f_96541_, EditVaultGameRulesScreen.this.f_96543_, EditVaultGameRulesScreen.this.f_96544_, 43, EditVaultGameRulesScreen.this.f_96544_ - 32, 24);
            EditVaultGameRulesScreen editVaultGameRulesScreen = EditVaultGameRulesScreen.this;
            Objects.requireNonNull(editVaultGameRulesScreen);
            this.m_7085_((AbstractSelectionList.Entry)editVaultGameRulesScreen.new CategoryRuleEntry((Component)new TranslatableComponent("gamerule.category.vault").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GOLD})));
            this.addBooleanRule(pGameRules, ModGameRules.FINAL_VAULT_ALLOW_PARTY);
            this.addBooleanRule(pGameRules, ModGameRules.JOIN_REQUIRE_PARTY);
            this.addBooleanRule(pGameRules, ModGameRules.ALLOW_WAYPOINTS);
            this.addBooleanRule(pGameRules, ModGameRules.NO_OP_DIFFICULTY);
            this.addBooleanRule(pGameRules, ModGameRules.PRINT_SAVE_DATA_TIMING);
            this.addBooleanRule(pGameRules, ModGameRules.BOOST_PENALTY);
            this.addBooleanRule(pGameRules, ModGameRules.QUEST_EXPERT_MODE);
            this.addBooleanRule(pGameRules, ModGameRules.NO_RESEARCH_TEAM_PENALTY);
            this.addBooleanRule(pGameRules, ModGameRules.ALLOW_MENTOR_BREW);
            this.addBooleanRule(pGameRules, ModGameRules.ALLOW_KNOWLEDGE_BREW);
            this.addBooleanRule(pGameRules, ModGameRules.WEIGHTED_ARTIFACTS);
            this.addBooleanRule(pGameRules, ModGameRules.SPECTATOR_PARTY_ONLY);
            this.addBooleanRule(pGameRules, ModGameRules.PARTY_MAP_SHARING);
            this.addBooleanRule(pGameRules, ModGameRules.LOCKER);
            this.addIntegerRule(pGameRules, ModGameRules.HERALD_MIN_LEVEL);
            this.addIntegerRule(pGameRules, ModGameRules.TEMPLATE_CACHE_SIZE);
            this.addIntegerRule(pGameRules, ModGameRules.VAULT_TIMER);
            this.addIntegerRule(pGameRules, ModGameRules.LEVEL_LOCK);
            this.m_7085_((AbstractSelectionList.Entry)this.createVaultModeEntry(pGameRules));
            this.m_7085_((AbstractSelectionList.Entry)this.createVaultLootEntry(pGameRules));
            this.m_7085_((AbstractSelectionList.Entry)this.createVaultExperienceEntry(pGameRules));
            this.m_7085_((AbstractSelectionList.Entry)this.createVaultCrystalModeEntry(pGameRules));
            this.m_7085_((AbstractSelectionList.Entry)this.createVaultCrystalRecipeScalingEntry(pGameRules));
            this.m_7085_((AbstractSelectionList.Entry)this.createVaultPartyExpSharingEntry(pGameRules));
            this.m_7085_((AbstractSelectionList.Entry)this.createSpectatorModeEntry(pGameRules));
        }

        private void addBooleanRule(GameRules gameRules, GameRules.Key<GameRules.BooleanValue> key) {
            TranslatableComponent label = new TranslatableComponent(key.m_46331_());
            String description = key.m_46331_() + ".description";
            List<FormattedCharSequence> tooltip = this.createTooltip(key, ((GameRules.BooleanValue)gameRules.m_46170_(key)).m_5831_());
            EditVaultGameRulesScreen editVaultGameRulesScreen = EditVaultGameRulesScreen.this;
            Objects.requireNonNull(editVaultGameRulesScreen);
            this.m_7085_((AbstractSelectionList.Entry)editVaultGameRulesScreen.new BooleanRuleEntry((Component)label, tooltip, description, (GameRules.BooleanValue)gameRules.m_46170_(key)));
        }

        private void addIntegerRule(GameRules gameRules, GameRules.Key<GameRules.IntegerValue> key) {
            TranslatableComponent label = new TranslatableComponent(key.m_46331_());
            String description = key.m_46331_() + ".description";
            List<FormattedCharSequence> tooltip = this.createTooltip(key, ((GameRules.IntegerValue)gameRules.m_46170_(key)).m_5831_());
            EditVaultGameRulesScreen editVaultGameRulesScreen = EditVaultGameRulesScreen.this;
            Objects.requireNonNull(editVaultGameRulesScreen);
            this.m_7085_((AbstractSelectionList.Entry)editVaultGameRulesScreen.new IntegerRuleEntry((Component)label, tooltip, description, (GameRules.IntegerValue)gameRules.m_46170_(key)));
        }

        private List<FormattedCharSequence> createTooltip(GameRules.Key<?> key, String defaultValue) {
            MutableComponent keyComponent = new TextComponent(key.m_46328_()).m_130940_(ChatFormatting.YELLOW);
            MutableComponent defaultComponent = new TranslatableComponent("editGamerule.default", new Object[]{new TextComponent(defaultValue)}).m_130940_(ChatFormatting.GRAY);
            String descriptionKey = key.m_46331_() + ".description";
            if (I18n.m_118936_((String)descriptionKey)) {
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.add((Object)keyComponent.m_7532_());
                TranslatableComponent descriptionComponent = new TranslatableComponent(descriptionKey);
                EditVaultGameRulesScreen.this.f_96547_.m_92923_((FormattedText)descriptionComponent, 150).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
                return builder.add((Object)defaultComponent.m_7532_()).build();
            }
            return ImmutableList.of((Object)keyComponent.m_7532_(), (Object)defaultComponent.m_7532_());
        }

        private RuleEntry createSpectatorModeEntry(GameRules gameRules) {
            GameRules.Key<SpectatorMode.GameRuleValue> key = ModGameRules.SPECTATOR_MODE;
            TranslatableComponent label = new TranslatableComponent(key.m_46331_());
            List<FormattedCharSequence> tooltip = this.createTooltip(key, ((SpectatorMode.GameRuleValue)gameRules.m_46170_(key)).m_5831_());
            EditVaultGameRulesScreen editVaultGameRulesScreen = EditVaultGameRulesScreen.this;
            Objects.requireNonNull(editVaultGameRulesScreen);
            return editVaultGameRulesScreen.new EnumRuleEntry<SpectatorMode>((Component)label, tooltip, key.m_46331_() + ".description", (SpectatorMode.GameRuleValue)gameRules.m_46170_(key), Arrays.asList(SpectatorMode.values()), SpectatorMode.OFF, mode -> new TextComponent(mode.name()), selectedMode -> ((SpectatorMode.GameRuleValue)gameRules.m_46170_(key)).setMode((SpectatorMode)((Object)selectedMode), null));
        }

        private RuleEntry createVaultModeEntry(GameRules gameRules) {
            GameRules.Key<VaultMode.GameRuleValue> key = ModGameRules.MODE;
            TranslatableComponent label = new TranslatableComponent(key.m_46331_());
            List<FormattedCharSequence> tooltip = this.createTooltip(key, ((VaultMode.GameRuleValue)gameRules.m_46170_(key)).m_5831_());
            EditVaultGameRulesScreen editVaultGameRulesScreen = EditVaultGameRulesScreen.this;
            Objects.requireNonNull(editVaultGameRulesScreen);
            return editVaultGameRulesScreen.new EnumRuleEntry<VaultMode>((Component)label, tooltip, key.m_46331_() + ".description", (VaultMode.GameRuleValue)gameRules.m_46170_(key), Arrays.asList(VaultMode.values()), VaultMode.NORMAL, mode -> new TextComponent(mode.name()), selectedMode -> ((VaultMode.GameRuleValue)gameRules.m_46170_(key)).setMode((VaultMode)((Object)selectedMode), null));
        }

        private RuleEntry createVaultLootEntry(GameRules gameRules) {
            GameRules.Key<VaultLoot.GameRuleValue> key = ModGameRules.LOOT;
            TranslatableComponent label = new TranslatableComponent(key.m_46331_());
            List<FormattedCharSequence> tooltip = this.createTooltip(key, ((VaultLoot.GameRuleValue)gameRules.m_46170_(key)).m_5831_());
            EditVaultGameRulesScreen editVaultGameRulesScreen = EditVaultGameRulesScreen.this;
            Objects.requireNonNull(editVaultGameRulesScreen);
            return editVaultGameRulesScreen.new EnumRuleEntry<VaultLoot>((Component)label, tooltip, key.m_46331_() + ".description", (VaultLoot.GameRuleValue)gameRules.m_46170_(key), Arrays.asList(VaultLoot.values()), VaultLoot.NORMAL, mode -> new TextComponent(mode.name()), selectedMode -> ((VaultLoot.GameRuleValue)gameRules.m_46170_(key)).setMode((VaultLoot)((Object)selectedMode), null));
        }

        private RuleEntry createVaultExperienceEntry(GameRules gameRules) {
            GameRules.Key<VaultExperience.GameRuleValue> key = ModGameRules.EXPERIENCE;
            TranslatableComponent label = new TranslatableComponent(key.m_46331_());
            List<FormattedCharSequence> tooltip = this.createTooltip(key, ((VaultExperience.GameRuleValue)gameRules.m_46170_(key)).m_5831_());
            EditVaultGameRulesScreen editVaultGameRulesScreen = EditVaultGameRulesScreen.this;
            Objects.requireNonNull(editVaultGameRulesScreen);
            return editVaultGameRulesScreen.new EnumRuleEntry<VaultExperience>((Component)label, tooltip, key.m_46331_() + ".description", (VaultExperience.GameRuleValue)gameRules.m_46170_(key), Arrays.asList(VaultExperience.values()), VaultExperience.NORMAL, mode -> new TextComponent(mode.name()), selectedMode -> ((VaultExperience.GameRuleValue)gameRules.m_46170_(key)).setMode((VaultExperience)((Object)selectedMode), null));
        }

        private RuleEntry createVaultCrystalModeEntry(GameRules gameRules) {
            GameRules.Key<VaultCrystalMode.GameRuleValue> key = ModGameRules.CRYSTAL_MODE;
            TranslatableComponent label = new TranslatableComponent(key.m_46331_());
            List<FormattedCharSequence> tooltip = this.createTooltip(key, ((VaultCrystalMode.GameRuleValue)gameRules.m_46170_(key)).m_5831_());
            EditVaultGameRulesScreen editVaultGameRulesScreen = EditVaultGameRulesScreen.this;
            Objects.requireNonNull(editVaultGameRulesScreen);
            return editVaultGameRulesScreen.new EnumRuleEntry<VaultCrystalMode>((Component)label, tooltip, key.m_46331_() + ".description", (VaultCrystalMode.GameRuleValue)gameRules.m_46170_(key), Arrays.asList(VaultCrystalMode.values()), VaultCrystalMode.NORMAL, mode -> new TextComponent(mode.name()), selectedMode -> ((VaultCrystalMode.GameRuleValue)gameRules.m_46170_(key)).setMode((VaultCrystalMode)((Object)selectedMode), null));
        }

        private RuleEntry createVaultCrystalRecipeScalingEntry(GameRules gameRules) {
            GameRules.Key<VaultCrystalRecipeScaling.GameRuleValue> key = ModGameRules.CRYSTAL_RECIPE_SCALING;
            TranslatableComponent label = new TranslatableComponent(key.m_46331_());
            List<FormattedCharSequence> tooltip = this.createTooltip(key, ((VaultCrystalRecipeScaling.GameRuleValue)gameRules.m_46170_(key)).m_5831_());
            EditVaultGameRulesScreen editVaultGameRulesScreen = EditVaultGameRulesScreen.this;
            Objects.requireNonNull(editVaultGameRulesScreen);
            return editVaultGameRulesScreen.new EnumRuleEntry<VaultCrystalRecipeScaling>((Component)label, tooltip, key.m_46331_() + ".description", (VaultCrystalRecipeScaling.GameRuleValue)gameRules.m_46170_(key), Arrays.asList(VaultCrystalRecipeScaling.values()), VaultCrystalRecipeScaling.NORMAL, mode -> new TextComponent(mode.name()), selectedMode -> ((VaultCrystalRecipeScaling.GameRuleValue)gameRules.m_46170_(key)).setMode((VaultCrystalRecipeScaling)((Object)selectedMode), null));
        }

        private RuleEntry createVaultPartyExpSharingEntry(GameRules gameRules) {
            GameRules.Key<VaultPartyExpSharing.GameRuleValue> key = ModGameRules.PARTY_EXP_SHARING;
            TranslatableComponent label = new TranslatableComponent(key.m_46331_());
            List<FormattedCharSequence> tooltip = this.createTooltip(key, ((VaultPartyExpSharing.GameRuleValue)gameRules.m_46170_(key)).m_5831_());
            EditVaultGameRulesScreen editVaultGameRulesScreen = EditVaultGameRulesScreen.this;
            Objects.requireNonNull(editVaultGameRulesScreen);
            return editVaultGameRulesScreen.new EnumRuleEntry<VaultPartyExpSharing>((Component)label, tooltip, key.m_46331_() + ".description", (VaultPartyExpSharing.GameRuleValue)gameRules.m_46170_(key), Arrays.asList(VaultPartyExpSharing.values()), VaultPartyExpSharing.DISABLED, mode -> new TextComponent(mode.name()), selectedMode -> ((VaultPartyExpSharing.GameRuleValue)gameRules.m_46170_(key)).setMode((VaultPartyExpSharing)((Object)selectedMode), null));
        }

        public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
            super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
            RuleEntry hovered = (RuleEntry)this.m_168795_();
            if (hovered != null) {
                EditVaultGameRulesScreen.this.setTooltip(hovered.tooltip);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class EnumRuleEntry<T>
    extends GameRuleEntry {
        private final CycleButton<T> cycleButton;

        public <V extends GameRules.Value<V>> EnumRuleEntry(Component pLabel, List<FormattedCharSequence> pTooltip, String p_101103_, V value, List<T> options, T defaultValue, Function<T, Component> nameGetter, Consumer<T> setter) {
            super(pTooltip, pLabel);
            Object currentValue = defaultValue;
            try {
                Method getMethod = value.getClass().getMethod("get", new Class[0]);
                Object result = getMethod.invoke(value, new Object[0]);
                if (result != null) {
                    currentValue = result;
                }
            }
            catch (Exception e) {
                VaultMod.LOGGER.error("Failed to get current value: " + e.getMessage());
            }
            this.cycleButton = CycleButton.m_168894_(nameGetter).m_168950_(options).m_168948_(currentValue).m_168929_().m_168959_(p_170219_ -> p_170219_.m_168904_().m_130946_("\n").m_130946_(p_101103_)).m_168936_(10, 5, 80, 20, pLabel, (button, newValue) -> setter.accept(newValue));
            this.children.add(this.cycleButton);
        }

        public void m_6311_(PoseStack pPoseStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            this.renderLabel(pPoseStack, pTop, pLeft);
            this.cycleButton.f_93620_ = pLeft + pWidth - 81;
            this.cycleButton.f_93621_ = pTop;
            this.cycleButton.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class IntegerRuleEntry
    extends GameRuleEntry {
        private final EditBox input;

        public IntegerRuleEntry(Component pLabel, List<FormattedCharSequence> pTooltip, String p_101177_, GameRules.IntegerValue p_101178_) {
            super(pTooltip, pLabel);
            this.input = new EditBox(((EditVaultGameRulesScreen)EditVaultGameRulesScreen.this).f_96541_.f_91062_, 10, 5, 42, 20, (Component)pLabel.m_6881_().m_130946_("\n").m_130946_(p_101177_).m_130946_("\n"));
            this.input.m_94144_(Integer.toString(p_101178_.m_46288_()));
            this.input.m_94151_(p_101181_ -> {
                if (p_101178_.m_46314_(p_101181_)) {
                    this.input.m_94202_(0xE0E0E0);
                    EditVaultGameRulesScreen.this.clearInvalid(this);
                } else {
                    this.input.m_94202_(0xFF0000);
                    EditVaultGameRulesScreen.this.markInvalid(this);
                }
            });
            this.children.add(this.input);
        }

        public void m_6311_(PoseStack pPoseStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            this.renderLabel(pPoseStack, pTop, pLeft);
            this.input.f_93620_ = pLeft + pWidth - 44;
            this.input.f_93621_ = pTop;
            this.input.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class BooleanRuleEntry
    extends GameRuleEntry {
        private final CycleButton<Boolean> checkbox;

        public BooleanRuleEntry(Component pLabel, List<FormattedCharSequence> pTooltip, String p_101103_, GameRules.BooleanValue p_101104_) {
            super(pTooltip, pLabel);
            this.checkbox = CycleButton.m_168916_((boolean)p_101104_.m_46223_()).m_168929_().m_168959_(p_170219_ -> p_170219_.m_168904_().m_130946_("\n").m_130946_(p_101103_)).m_168936_(10, 5, 44, 20, pLabel, (p_170215_, p_170216_) -> p_101104_.m_46246_(p_170216_.booleanValue(), null));
            this.children.add(this.checkbox);
        }

        public void m_6311_(PoseStack pPoseStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            this.renderLabel(pPoseStack, pTop, pLeft);
            this.checkbox.f_93620_ = pLeft + pWidth - 45;
            this.checkbox.f_93621_ = pTop;
            this.checkbox.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract class GameRuleEntry
    extends RuleEntry {
        private final List<FormattedCharSequence> label;
        protected final List<AbstractWidget> children;

        public GameRuleEntry(List<FormattedCharSequence> pTooltip, Component pLabel) {
            super(pTooltip);
            this.children = Lists.newArrayList();
            this.label = ((EditVaultGameRulesScreen)EditVaultGameRulesScreen.this).f_96541_.f_91062_.m_92923_((FormattedText)pLabel, 175);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return this.children;
        }

        public List<? extends NarratableEntry> m_142437_() {
            return this.children;
        }

        protected void renderLabel(PoseStack pPoseStack, int pX, int pY) {
            if (this.label.size() == 1) {
                ((EditVaultGameRulesScreen)EditVaultGameRulesScreen.this).f_96541_.f_91062_.m_92877_(pPoseStack, this.label.get(0), (float)pY, (float)(pX + 5), 0xFFFFFF);
            } else if (this.label.size() >= 2) {
                ((EditVaultGameRulesScreen)EditVaultGameRulesScreen.this).f_96541_.f_91062_.m_92877_(pPoseStack, this.label.get(0), (float)pY, (float)pX, 0xFFFFFF);
                ((EditVaultGameRulesScreen)EditVaultGameRulesScreen.this).f_96541_.f_91062_.m_92877_(pPoseStack, this.label.get(1), (float)pY, (float)(pX + 10), 0xFFFFFF);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class CategoryRuleEntry
    extends RuleEntry {
        final Component label;

        public CategoryRuleEntry(Component pLabel) {
            super(null);
            this.label = pLabel;
        }

        public void m_6311_(PoseStack pPoseStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            GuiComponent.m_93215_((PoseStack)pPoseStack, (Font)((EditVaultGameRulesScreen)EditVaultGameRulesScreen.this).f_96541_.f_91062_, (Component)this.label, (int)(pLeft + pWidth / 2), (int)(pTop + 5), (int)0xFFFFFF);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of();
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(NarrationElementOutput p_170225_) {
                    p_170225_.m_169146_(NarratedElementType.TITLE, CategoryRuleEntry.this.label);
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class RuleEntry
    extends ContainerObjectSelectionList.Entry<RuleEntry> {
        @Nullable
        final List<FormattedCharSequence> tooltip;

        public RuleEntry(@Nullable List<FormattedCharSequence> pTooltip) {
            this.tooltip = pTooltip;
        }
    }
}

