/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.ClientPatreonDisplayData;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ButtonElement;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.NineSliceButtonElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.spi.AbstractSpatialElement;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.screen.AbstractElementScreen;
import iskallia.vault.client.gui.framework.screen.layout.ScreenLayout;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.PatreonDisplaySettingsMessage;
import iskallia.vault.world.data.PlayerPatreonDisplayData;
import iskallia.vault.www.patreon.PatreonManager;
import iskallia.vault.www.patreon.PatreonTier;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import org.jetbrains.annotations.NotNull;

public class PatreonDisplaySettingsScreen
extends AbstractElementScreen {
    private final PlayerPatreonDisplayData.PatreonDisplay data;
    private ToggleButton colourToggleButton;
    private ToggleButton emblemToggleButton;
    private Map<PatreonTier, NineSliceButtonElement<?>> tierButtons = new LinkedHashMap();

    public PatreonDisplaySettingsScreen() {
        super((Component)new TextComponent("Patreon Display Settings"), ScreenRenderers.getBuffered(), ScreenTooltipRenderer::create);
        this.setGuiSize(Spatials.size(150, 160));
        this.data = ClientPatreonDisplayData.getData();
        this.addElement((NineSliceElement)new NineSliceElement(Spatials.size(150, 160), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout(this.translateWorldSpatial()));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, 8), (Component)new TextComponent("Patreon Display Settings").m_130940_(ChatFormatting.DARK_GRAY), LabelTextStyle.defaultStyle()).layout(this.translateWorldSpatial()));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, 26), (Component)new TextComponent("Colour Name").m_130940_(ChatFormatting.DARK_GRAY), LabelTextStyle.defaultStyle()).layout(this.translateWorldSpatial()));
        this.colourToggleButton = (ToggleButton)new ToggleButton((IPosition)Spatials.positionXY(8 + Minecraft.m_91087_().f_91062_.m_92895_("Show Colour") + 4, 26), () -> this.updateColourState(!this.data.enableColour), this.data.enableColour).layout(this.translateWorldSpatial());
        this.addElement(this.colourToggleButton);
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, 44), (Component)new TextComponent("Show Emblem").m_130940_(ChatFormatting.DARK_GRAY), LabelTextStyle.defaultStyle()).layout(this.translateWorldSpatial()));
        this.emblemToggleButton = (ToggleButton)new ToggleButton((IPosition)Spatials.positionXY(8 + Minecraft.m_91087_().f_91062_.m_92895_("Show Emblem") + 4, 44), () -> this.updateEmblemState(!this.data.enableEmblem), this.data.enableEmblem).layout(this.translateWorldSpatial());
        this.addElement(this.emblemToggleButton);
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, 62), (Component)new TextComponent("Display Patreon Tier").m_130940_(ChatFormatting.DARK_GRAY), LabelTextStyle.defaultStyle()).layout(this.translateWorldSpatial()));
        int y = 0;
        for (PatreonTier tier : PatreonManager.getInstance().getPatreonTiers(Minecraft.m_91087_().f_91074_.m_142081_())) {
            NineSliceButtonElement btn = (NineSliceButtonElement)((AbstractSpatialElement)((NineSliceButtonElement)new NineSliceButtonElement(Spatials.positionXYZ(8, 74 + y, 10).size(100, 15), ScreenTextures.BUTTON_EMPTY_GREEN_TEXTURES, () -> this.updateSelectedDisplayTier(tier)).setDisabled(tier == this.data.displayTier)).label(() -> tier.getPrefix().m_130946_(" ").m_7220_((Component)new TextComponent(tier.name().substring(0, 1).toUpperCase() + tier.name().substring(1).toLowerCase())))).layout(this.translateWorldSpatial());
            this.addElement(btn);
            this.tierButtons.put(tier, btn);
            y += 20;
        }
    }

    private void updateColourState(boolean isEnabled) {
        this.data.enableColour = isEnabled;
        ModNetwork.CHANNEL.sendToServer((Object)new PatreonDisplaySettingsMessage.C2S(this.data));
        this.colourToggleButton.setEnabled(isEnabled);
    }

    private void updateEmblemState(boolean isEnabled) {
        this.data.enableEmblem = isEnabled;
        ModNetwork.CHANNEL.sendToServer((Object)new PatreonDisplaySettingsMessage.C2S(this.data));
        this.emblemToggleButton.setEnabled(isEnabled);
    }

    private void updateSelectedDisplayTier(PatreonTier state) {
        this.data.displayTier = state;
        ModNetwork.CHANNEL.sendToServer((Object)new PatreonDisplaySettingsMessage.C2S(this.data));
        this.tierButtons.forEach((t, b) -> b.setDisabled(t == this.data.displayTier));
        ScreenLayout.requestLayout();
    }

    @Override
    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public boolean m_7043_() {
        return false;
    }

    private static class ToggleButton
    extends ButtonElement<ToggleButton> {
        private boolean isEnabled;

        public ToggleButton(IPosition position, Runnable onClick, boolean isEnabled) {
            super(position, ScreenTextures.LANDSCAPE_BUTTON_TOGGLE_OFF_TEXTURES, onClick);
            this.isEnabled = isEnabled;
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.isEnabled = enabled;
        }

        @Override
        public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            ButtonElement.ButtonTextures textures = this.isEnabled ? ScreenTextures.LANDSCAPE_BUTTON_TOGGLE_ON_TEXTURES : ScreenTextures.LANDSCAPE_BUTTON_TOGGLE_OFF_TEXTURES;
            TextureAtlasRegion texture = textures.selectTexture(this.isDisabled(), this.containsMouse(mouseX, mouseY), false);
            renderer.render(texture, poseStack, (IPosition)this.worldSpatial);
        }
    }
}

