/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.ClientPrestigePowersData;
import iskallia.vault.client.gui.widget.PrestigeSelectionWidget;
import iskallia.vault.init.ModKeybinds;
import iskallia.vault.network.message.ServerboundPrestigePowerToggleMessage;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.prestige.core.ActivatePrestigePower;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public class PrestigePowerSelectionScreen
extends Screen {
    public static final ResourceLocation HUD_RESOURCE = new ResourceLocation("the_vault", "textures/gui/vault_hud.png");

    public PrestigePowerSelectionScreen() {
        super((Component)new TextComponent(""));
    }

    private List<PrestigeSelectionWidget> getPrestigeWidgets() {
        LinkedList<PrestigeSelectionWidget> widgets = new LinkedList<PrestigeSelectionWidget>();
        Minecraft minecraft = Minecraft.m_91087_();
        float midX = (float)minecraft.m_91268_().m_85445_() / 2.0f;
        float midY = (float)minecraft.m_91268_().m_85446_() / 2.0f;
        float radius = 60.0f;
        List<TieredSkill> learned = ClientPrestigePowersData.getLearnedActivatablePrestigeNodes();
        if (learned.isEmpty()) {
            return widgets;
        }
        double clickableAngle = Math.PI * 2 / (double)learned.size();
        for (int i = 0; i < learned.size(); ++i) {
            TieredSkill prestige = learned.get(i);
            double angle = (double)i * (Math.PI * 2 / (double)learned.size()) - 1.5707963267948966;
            double x = (double)radius * Math.cos(angle) + (double)midX;
            double y = (double)radius * Math.sin(angle) + (double)midY;
            widgets.add(new PrestigeSelectionWidget((int)x, (int)y, prestige, clickableAngle / 2.0));
        }
        return widgets;
    }

    public boolean m_6913_() {
        return false;
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        for (PrestigeSelectionWidget widget : this.getPrestigeWidgets()) {
            if (!widget.m_5953_(mouseX, mouseY)) continue;
            this.requestToggle(widget.getPrestige());
            this.m_7379_();
            return true;
        }
        this.m_7379_();
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == ModKeybinds.prestigeActivationScreenKey.getKey().m_84873_()) {
            Minecraft minecraft = Minecraft.m_91087_();
            double guiScaleFactor = minecraft.m_91268_().m_85449_();
            double mouseX = minecraft.f_91067_.m_91589_() / guiScaleFactor;
            double mouseY = minecraft.f_91067_.m_91594_() / guiScaleFactor;
            for (PrestigeSelectionWidget widget : this.getPrestigeWidgets()) {
                if (!widget.m_5953_(mouseX, mouseY)) continue;
                this.requestToggle(widget.getPrestige());
                break;
            }
            this.m_7379_();
            return true;
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    private void requestToggle(TieredSkill prestige) {
        LearnableSkill learnableSkill = prestige.getChild();
        if (!(learnableSkill instanceof ActivatePrestigePower)) {
            return;
        }
        ActivatePrestigePower power = (ActivatePrestigePower)learnableSkill;
        boolean newState = !power.isActive();
        ServerboundPrestigePowerToggleMessage.send(prestige.getId(), newState);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        Minecraft minecraft = Minecraft.m_91087_();
        float midX = (float)minecraft.m_91268_().m_85445_() / 2.0f;
        float midY = (float)minecraft.m_91268_().m_85446_() / 2.0f;
        float radius = 60.0f;
        List<PrestigeSelectionWidget> widgets = this.getPrestigeWidgets();
        boolean focusRendered = false;
        for (PrestigeSelectionWidget widget : widgets) {
            widget.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            if (focusRendered || !widget.m_5953_(mouseX, mouseY)) continue;
            String powerName = widget.getPrestige().getName();
            int nameWidth = minecraft.f_91062_.m_92895_(powerName);
            minecraft.f_91062_.m_92750_(matrixStack, powerName, midX - (float)nameWidth / 2.0f, midY - (radius + 35.0f), 0xFFFFFF);
            String state = widget.m_142518_() ? "Active" : "Inactive";
            int stateWidth = minecraft.f_91062_.m_92895_(state);
            minecraft.f_91062_.m_92750_(matrixStack, state, midX - (float)stateWidth / 2.0f, midY - (radius + 25.0f), (widget.m_142518_() ? ChatFormatting.GREEN.m_126665_() : ChatFormatting.RED.m_126665_()).intValue());
            focusRendered = true;
        }
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }
}

