/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.NineSliceButtonElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.spi.AbstractSpatialElement;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.screen.AbstractElementScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.RequestSpectatorListMessage;
import iskallia.vault.network.message.StartSpectatingPlayerMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class SpectatorSelectionScreen
extends AbstractElementScreen {
    private static ListTag cachedList;
    private final List<Entry> entries = new ArrayList<Entry>();

    public static void open(ListTag list) {
        cachedList = list;
        Minecraft.m_91087_().m_91152_((Screen)new SpectatorSelectionScreen());
    }

    private SpectatorSelectionScreen() {
        super((Component)new TextComponent("Spectate Player"), ScreenRenderers.getImmediate(), ScreenTooltipRenderer::create);
        this.setGuiSize(Spatials.size(150, 200));
        if (cachedList != null) {
            for (int i = 0; i < cachedList.size(); ++i) {
                CompoundTag tag = cachedList.m_128728_(i);
                this.entries.add(new Entry(UUID.fromString(tag.m_128461_("uuid")), tag.m_128461_("name")));
            }
        }
        this.addElement((NineSliceElement)new NineSliceElement(Spatials.positionXY(0, 0).size(this.imageWidth, this.imageHeight), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout(this.translateWorldSpatial()));
        TextComponent inventoryName = new TextComponent("Vault Spectator List");
        inventoryName.m_130948_(Style.f_131099_.m_178520_(-12632257));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXYZ(8, 8, 2), (Component)inventoryName, LabelTextStyle.defaultStyle()).layout(this.translateWorldSpatial()));
        int y = 40;
        int width = 120;
        for (Entry e : this.entries) {
            this.addElement((PlayerButton)new PlayerButton(Spatials.positionXY(this.imageWidth / 2 - width / 2, y).size(width, 20), e).layout(this.translateWorldSpatial()));
            y += 24;
        }
        this.addElement((NineSliceButtonElement)((AbstractSpatialElement)new NineSliceButtonElement(Spatials.positionXY(this.imageWidth / 2 - 50, this.imageHeight - 25).size(100, 20), ScreenTextures.BUTTON_EMPTY_TEXTURES, () -> ModNetwork.CHANNEL.sendToServer((Object)new RequestSpectatorListMessage())).label(() -> new TextComponent("Reload"))).layout(this.translateWorldSpatial()));
    }

    private static void renderHead(PoseStack poseStack, ResourceLocation skin, int size) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)skin);
        int u1 = 8;
        int v1 = 8;
        int u2 = 40;
        int v2 = 8;
        GuiComponent.m_93160_((PoseStack)poseStack, (int)0, (int)0, (int)size, (int)size, (float)u1, (float)v1, (int)8, (int)8, (int)64, (int)64);
        GuiComponent.m_93160_((PoseStack)poseStack, (int)0, (int)0, (int)size, (int)size, (float)u2, (float)v2, (int)8, (int)8, (int)64, (int)64);
    }

    public boolean m_7043_() {
        return false;
    }

    private record Entry(UUID uuid, String name) {
    }

    private static class PlayerButton
    extends NineSliceButtonElement<PlayerButton> {
        private final Entry entry;

        public PlayerButton(ISpatial spatial, Entry entry) {
            super(spatial, ScreenTextures.BUTTON_EMPTY_TEXTURES, () -> ModNetwork.CHANNEL.sendToServer((Object)new StartSpectatingPlayerMessage(entry.uuid)));
            this.entry = entry;
            this.label(() -> new TextComponent(entry.name));
        }

        @Override
        public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            super.render(renderer, poseStack, mouseX, mouseY, partialTick);
            PlayerInfo info = Minecraft.m_91087_().m_91403_().m_104949_(this.entry.uuid);
            ResourceLocation skin = info != null ? info.m_105337_() : DefaultPlayerSkin.m_118627_((UUID)this.entry.uuid);
            poseStack.m_85836_();
            poseStack.m_85837_((double)(this.x() + 2), (double)(this.y() + 2), 0.0);
            SpectatorSelectionScreen.renderHead(poseStack, skin, 16);
            poseStack.m_85849_();
        }
    }
}

