/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.VaultMod;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.GearModelPreviewElement;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.VerticalScrollClipContainer;
import iskallia.vault.client.gui.framework.element.spi.AbstractSpatialElement;
import iskallia.vault.client.gui.framework.element.spi.ILayoutStrategy;
import iskallia.vault.client.gui.framework.element.spi.IRenderedElement;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.render.Tooltips;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.screen.AbstractElementScreen;
import iskallia.vault.client.gui.framework.spatial.Padding;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.helper.UIHelper;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.util.function.Memo;
import iskallia.vault.www.patreon.PatreonManager;
import iskallia.vault.www.patreon.PatreonTier;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class SupportersCreditsScreen
extends AbstractElementScreen {
    private static final ResourceLocation LOGO_LOCATION = VaultMod.id("textures/gui/title/logo.png");
    private static final ResourceLocation BACKGROUND_LOCATION = VaultMod.id("textures/gui/title/bg.png");
    private final Runnable onFinished;

    public SupportersCreditsScreen(Runnable onFinished) {
        super((Component)new TextComponent("Supporters Credits"), ScreenRenderers.getBuffered(), ScreenTooltipRenderer::create);
        this.onFinished = onFinished;
        Window window = Minecraft.m_91087_().m_91268_();
        this.setGuiSize(Spatials.size(window.m_85445_(), window.m_85446_()));
        int headerHeight = 10;
        int footerHeight = 50;
        int tileCount = PatreonTier.values().length;
        int innerWidth = window.m_85445_() - (80 + 50 / tileCount);
        int tileWidth = innerWidth / tileCount;
        int tileHeight = window.m_85446_() - headerHeight - footerHeight - 50;
        int tileY = headerHeight + 25;
        int tileX = 25;
        for (PatreonTier tier : PatreonTier.values()) {
            this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXYZ(tileX + tileWidth / 2 - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)tier.getPrefix().m_130946_(" ").m_7220_((Component)new TextComponent(tier.getName().replace("Vault ", "")).m_130948_(Style.f_131099_.m_131148_(tier.getColor())))) / 2, 9 + headerHeight, 2), (Component)tier.getPrefix().m_130946_(" ").m_7220_((Component)new TextComponent(tier.getName().replace("Vault ", "")).m_130948_(Style.f_131099_.m_131148_(tier.getColor()))), LabelTextStyle.defaultStyle().center()).layout(this.translateWorldSpatial()));
            this.addElement((PatreonTierElement)new PatreonTierElement((ISpatial)Spatials.positionXYZ(tileX, tileY, 1).size(tileWidth, tileHeight), tier, this).layout(this.translateWorldSpatial()));
            tileX += tileWidth + 50 / tileCount;
        }
        this.addElement((HorizontalScrollingNamesElement)new HorizontalScrollingNamesElement(Spatials.positionXYZ(0, window.m_85446_() - footerHeight, 1).size(window.m_85445_(), footerHeight), PatreonManager.getInstance().getAllPlayers().keySet().stream().toList()).layout(this.translateWorldSpatial()));
        TextComponent supporters = new TextComponent("Special Thanks to all our supporters!");
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXYZ(window.m_85445_() / 2 - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)supporters) / 2, window.m_85446_() - (footerHeight + 5), 2), (Component)supporters, LabelTextStyle.defaultStyle()).layout(this.translateWorldSpatial()));
    }

    public void m_96624_() {
        super.m_96624_();
        PatreonManager.getInstance().getAllPlayers();
    }

    public void m_7333_(PoseStack pPoseStack) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND_LOCATION);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        SupportersCreditsScreen.m_93133_((PoseStack)pPoseStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)this.f_96543_, (int)this.f_96544_, (int)((int)(1920.0 / Minecraft.m_91087_().m_91268_().m_85449_())), (int)((int)(1080.0 / Minecraft.m_91087_().m_91268_().m_85449_())));
    }

    @Override
    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public static class PatreonTierElement
    extends VerticalScrollClipContainer<PatreonTierElement> {
        private final PatreonTier tier;
        private final SupportersCreditsScreen parent;

        public PatreonTierElement(ISpatial spatial, PatreonTier tier, SupportersCreditsScreen parent) {
            super(spatial, Padding.ZERO, ScreenTextures.INSET_BLACK_BACKGROUND);
            this.tier = tier;
            this.parent = parent;
            this.initialise();
        }

        private void initialise() {
            int linesOffset = 0;
            for (int i = 0; i < this.tier.getModelRewards().size(); ++i) {
                ResourceLocation model = this.tier.getModelRewards().get(i);
                if (model == null) continue;
                int modelCount = this.tier.getModelRewards().size();
                int row = i / 2;
                int posInRow = i % 2;
                boolean isFullWidth = posInRow == 0 && (i == modelCount - 1 || i + 1 >= modelCount || this.tier.getModelRewards().get(i + 1) == null);
                int elementWidth = isFullWidth ? this.innerWidth() - 10 : (this.innerWidth() - 10) / 2;
                int elementX = isFullWidth ? 5 : 5 + elementWidth * posInRow;
                int elementY = 5 + row * 72;
                if (posInRow == 0) {
                    linesOffset += 72;
                }
                this.addElement((GearModelPreviewElement)((GearModelPreviewElement)new GearModelPreviewElement(Spatials.positionXYZ(elementX, elementY, 4), Spatials.size(elementWidth, 72), Memo.reactive(() -> this.getItemStack(model), () -> model), null).tooltip(Tooltips.multi(() -> this.getItemStack(model).m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)TooltipFlag.Default.NORMAL)))).layout(this.translateWorldSpatial()));
            }
            List<FormattedText> lines = UIHelper.getLines((Component)new TextComponent("- " + String.join((CharSequence)"\n\n- ", this.tier.getPerks())), this.innerWidth() - 20);
            for (int i = 0; i < lines.size(); ++i) {
                this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXYZ(5, linesOffset + 30 + i * 10, 2), (Component)new TextComponent(lines.get(i).getString()), LabelTextStyle.defaultStyle()).layout(this.translateWorldSpatial()));
            }
        }

        @NotNull
        protected ILayoutStrategy translateWorldSpatial() {
            return (screen, gui, parent, world) -> {};
        }

        private ItemStack getItemStack(ResourceLocation model) {
            ItemStack displayStack = model.toString().contains("sword") ? new ItemStack((ItemLike)ModItems.SWORD) : (model.toString().contains("shield") ? new ItemStack((ItemLike)ModItems.SHIELD) : (model.toString().contains("wand") ? new ItemStack((ItemLike)ModItems.WAND) : (model.toString().contains("focus") ? new ItemStack((ItemLike)ModItems.FOCUS) : (model.toString().contains("helmet") ? new ItemStack((ItemLike)ModItems.HELMET) : (model.toString().contains("chestplate") ? new ItemStack((ItemLike)ModItems.CHESTPLATE) : (model.toString().contains("leggings") ? new ItemStack((ItemLike)ModItems.LEGGINGS) : (model.toString().contains("boots") ? new ItemStack((ItemLike)ModItems.BOOTS) : (model.toString().contains("axe") ? new ItemStack((ItemLike)ModItems.AXE) : new ItemStack((ItemLike)ModItems.ERROR_ITEM)))))))));
            VaultGearData gearData = VaultGearData.read(displayStack);
            gearData.setState(VaultGearState.IDENTIFIED);
            gearData.setRarity(VaultGearRarity.OMEGA);
            gearData.createOrReplaceAttributeValue(ModGearAttributes.GEAR_MODEL, model);
            gearData.write(displayStack);
            return displayStack;
        }
    }

    public static class HorizontalScrollingNamesElement
    extends AbstractSpatialElement<HorizontalScrollingNamesElement>
    implements IRenderedElement {
        private boolean visible = true;
        private final List<String> names;
        private float scrollPosition = 0.0f;

        public HorizontalScrollingNamesElement(ISpatial spatial, List<String> names) {
            super(spatial);
            this.names = names;
            this.visible = true;
        }

        @Override
        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        @Override
        public boolean isVisible() {
            return this.visible;
        }

        @Override
        public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            if (!this.visible || this.names.isEmpty()) {
                return;
            }
            Minecraft minecraft = Minecraft.m_91087_();
            Font font = minecraft.f_91062_;
            int SPACING = 20;
            float totalWidth = 0.0f;
            for (String name : this.names) {
                totalWidth += (float)(font.m_92895_(name) + 20);
            }
            this.scrollPosition += 30.0f * partialTick / 20.0f;
            if (this.scrollPosition > totalWidth) {
                this.scrollPosition = 0.0f;
            }
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            float elementWidth = this.worldSpatial.width();
            float elementHeight = this.worldSpatial.height();
            float startX = this.worldSpatial.x();
            float f = this.worldSpatial.y();
            Objects.requireNonNull(font);
            float startY = f + (elementHeight - 9.0f) / 2.0f;
            float currentX = startX - this.scrollPosition;
            for (int i = 0; i < 2; ++i) {
                for (String name : this.names) {
                    int nameWidth = font.m_92895_(name);
                    if (currentX + (float)nameWidth > startX && currentX < startX + elementWidth) {
                        int color = 0xFFFFFF;
                        font.m_92883_(poseStack, name, currentX, startY, color);
                    }
                    currentX += (float)(nameWidth + 20);
                }
                if (i != 0) continue;
                currentX = startX - (this.scrollPosition - totalWidth);
            }
            RenderSystem.m_69461_();
        }
    }
}

