/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.animation.ElementAnimator;
import iskallia.vault.client.gui.animation.IAnimatedElement;
import iskallia.vault.client.gui.animation.KeyframeAnimation;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.spi.AbstractSpatialElement;
import iskallia.vault.client.gui.framework.element.spi.IElement;
import iskallia.vault.client.gui.framework.element.spi.IGuiEventElement;
import iskallia.vault.client.gui.framework.element.spi.IRenderedElement;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.screen.AbstractElementContainerScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.helper.ScreenDrawHelper;
import iskallia.vault.client.gui.helper.UIHelper;
import iskallia.vault.client.gui.screen.player.legacy.widget.AbilityNodeTextures;
import iskallia.vault.config.RoyalePresetConfig;
import iskallia.vault.config.entry.SkillStyle;
import iskallia.vault.container.RoyaleDraftContainer;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.core.vault.objective.RoyaleObjective;
import iskallia.vault.gear.trinket.TrinketEffectRegistry;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.init.ModTextureAtlases;
import iskallia.vault.item.gear.TrinketItem;
import iskallia.vault.network.message.ServerboundRoyaleSelectLootMessage;
import iskallia.vault.network.message.ServerboundRoyaleSelectTrinketMessage;
import iskallia.vault.network.message.ServerboundSelectPresetMessage;
import iskallia.vault.util.Tween;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class TommyTradeScreen
extends AbstractElementContainerScreen<RoyaleDraftContainer> {
    private final UUID uuid;
    int lootModifier = 1;
    private boolean trinketAnimationActive = false;
    private ItemStack animTrinket = ItemStack.f_41583_;
    private ElementAnimator xAnimator;
    private KeyframeAnimation textFade;
    private TrinketSelect animatingSelect;
    private float animY;
    private int animTicks = 0;
    private static final int ANIM_DURATION = 100;

    public TommyTradeScreen(RoyaleDraftContainer screenContainer, Inventory inv, Component title) {
        super(screenContainer, inv, (Component)new TextComponent("Tommy's Deals"), ScreenRenderers.getImmediate(), ScreenTooltipRenderer::create);
        Vault vault;
        Window window = Minecraft.m_91087_().m_91268_();
        this.setGuiSize(Spatials.size(window.m_85445_(), window.m_85446_()));
        this.uuid = Minecraft.m_91087_().f_91074_.m_142081_();
        this.recreateElements();
        if (VaultUtils.isVaultLevel(inv.f_35978_.f_19853_) && VaultUtils.isRoyaleVault(vault = (Vault)VaultUtils.getVault(inv.f_35978_.f_19853_).orElse(null))) {
            this.lootModifier = vault.get(Vault.OBJECTIVES).getAll(RoyaleObjective.class).get(0).getOr(RoyaleObjective.LOOT_MULTIPLIER, 1);
        }
    }

    public void recreateElements() {
        this.removeAllElements();
        if (((RoyaleDraftContainer)this.m_6262_()).getTab(this.uuid) == 0) {
            int padding = 0;
            int componentWidth = this.f_97726_ / ((RoyaleDraftContainer)this.m_6262_()).getSkillPreset().size() - padding * (((RoyaleDraftContainer)this.m_6262_()).getSkillPreset().size() - 1);
            int x = 0;
            for (int i = 0; i < ((RoyaleDraftContainer)this.m_6262_()).getSkillPreset().size(); ++i) {
                RoyalePresetConfig.SkillPreset preset = ((RoyaleDraftContainer)this.m_6262_()).getSkillPreset().get(i);
                Map<String, Integer> presetData = ((RoyaleDraftContainer)this.m_6262_()).getGeneratedPresetData(preset.name);
                this.addElement((PresetElement)new PresetElement(Spatials.positionXY(x, 0).size(componentWidth, Minecraft.m_91087_().m_91268_().m_85446_() - Minecraft.m_91087_().m_91268_().m_85446_() / 3), 0, preset, presetData).layout(this.translateWorldSpatial()));
                x += componentWidth + padding;
            }
            this.addElement((BarePresetElement)new BarePresetElement(this, Spatials.positionXY(0, Minecraft.m_91087_().m_91268_().m_85446_() - Minecraft.m_91087_().m_91268_().m_85446_() / 3).size(Minecraft.m_91087_().m_91268_().m_85445_(), Minecraft.m_91087_().m_91268_().m_85446_() - Minecraft.m_91087_().m_91268_().m_85446_() / 3)).layout(this.translateWorldSpatial()));
        } else if (((RoyaleDraftContainer)this.m_6262_()).getTab(this.uuid) == 1) {
            int padding = 0;
            int componentWidth = this.f_97726_ / ((RoyaleDraftContainer)this.m_6262_()).getBlueTrinkets().size() - padding * (((RoyaleDraftContainer)this.m_6262_()).getBlueTrinkets().size() - 1);
            int x = 0;
            for (int i = 0; i < ((RoyaleDraftContainer)this.m_6262_()).getBlueTrinkets().size(); ++i) {
                ResourceLocation trinket = ((RoyaleDraftContainer)this.m_6262_()).getBlueTrinkets().get(i);
                ItemStack stack = TrinketItem.createBaseTrinket(TrinketEffectRegistry.getEffect(trinket));
                TrinketItem.setUses(stack, 1);
                this.addElement((TrinketSelect)new TrinketSelect(Spatials.positionXY(x, 0).size(componentWidth, Minecraft.m_91087_().m_91268_().m_85446_()), trinket, i, stack).layout(this.translateWorldSpatial()));
                x += componentWidth + padding;
            }
        } else if (((RoyaleDraftContainer)this.m_6262_()).getTab(this.uuid) == 2) {
            int padding = 0;
            int componentWidth = this.f_97726_ / ((RoyaleDraftContainer)this.m_6262_()).getRedTrinkets().size() - padding * (((RoyaleDraftContainer)this.m_6262_()).getRedTrinkets().size() - 1);
            int x = 0;
            for (int i = 0; i < ((RoyaleDraftContainer)this.m_6262_()).getRedTrinkets().size(); ++i) {
                ResourceLocation trinket = ((RoyaleDraftContainer)this.m_6262_()).getRedTrinkets().get(i);
                ItemStack stack = TrinketItem.createBaseTrinket(TrinketEffectRegistry.getEffect(trinket));
                TrinketItem.setUses(stack, 1);
                this.addElement((TrinketSelect)new TrinketSelect(Spatials.positionXY(x, 0).size(componentWidth, Minecraft.m_91087_().m_91268_().m_85446_()), trinket, i, stack).layout(this.translateWorldSpatial()));
                x += componentWidth + padding;
            }
        } else if (((RoyaleDraftContainer)this.m_6262_()).getTab(this.uuid) == 3) {
            List<List<ItemStack>> loot = ((RoyaleDraftContainer)this.m_6262_()).getLoot();
            int padding = 0;
            int componentWidth = this.f_97726_ / loot.size() - padding * (loot.size() - 1);
            int x = 0;
            for (List<ItemStack> lootList : loot) {
                this.addElement((RewardSelect)new RewardSelect(Spatials.positionXY(x, 0).size(componentWidth, Minecraft.m_91087_().m_91268_().m_85446_()), lootList, this.lootModifier).layout(this.translateWorldSpatial()));
                x += componentWidth + padding;
            }
            this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(this.f_97726_ / 2 - Minecraft.m_91087_().f_91062_.m_92895_("Select your rewards") / 2, 20), (Component)new TextComponent("Select your rewards"), LabelTextStyle.defaultStyle()).layout(this.translateWorldSpatial()));
        } else {
            TextComponent text = new TextComponent("Well off you pop then...");
            this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(this.f_97726_ / 2 - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)text) / 2, Minecraft.m_91087_().m_91268_().m_85446_() / 2), (Component)text, LabelTextStyle.defaultStyle()).layout(this.translateWorldSpatial()));
        }
    }

    private void startTrinketAnimation(TrinketSelect select) {
        this.trinketAnimationActive = true;
        this.animatingSelect = select;
        this.animTrinket = select.stack;
        float startX = select.getWorldSpatial().x();
        float targetX = (float)this.f_96543_ / 2.0f - (float)select.getWorldSpatial().width() / 2.0f;
        this.animY = select.getWorldSpatial().y();
        this.animTicks = 0;
        this.xAnimator = new ElementAnimator().addFrame(ElementAnimator.Property.X, 5.0f, startX, Tween.LINEAR).addFrame(ElementAnimator.Property.X, 20.0f, targetX, Tween.EASE_OUT_CUBIC);
        this.xAnimator.start();
        this.textFade = new KeyframeAnimation().addFrame(0.0f, 0.0f, Tween.LINEAR).addFrame(20.0f, 1.0f, Tween.EASE_INOUT_QUADRATIC);
        this.elementStore.getRenderedElementList().forEach(el -> {
            if (el instanceof TrinketSelect) {
                TrinketSelect ts = (TrinketSelect)el;
                if (ts == select) {
                    ts.getAnimation().addUniformScaleKeyframe(5.0f, 1.0f, Tween.EASE_INOUT_QUADRATIC).addUniformScaleKeyframe(10.0f, 2.0f, Tween.EASE_INOUT_QUADRATIC).addFrame("interactable", 0.0f, 0.0f, Tween.LINEAR).addFrame("interactable", 1.0f, 1.0f, Tween.LINEAR);
                } else {
                    ts.getAnimation().addFrame(ElementAnimator.Property.OPACITY, 0.0f, 1.0f, Tween.LINEAR).addFrame(ElementAnimator.Property.OPACITY, 10.0f, 0.0f, Tween.EASE_INOUT_QUADRATIC).addUniformScaleKeyframe(0.0f, 1.0f, Tween.LINEAR).addUniformScaleKeyframe(10.0f, 0.5f, Tween.EASE_INOUT_QUADRATIC).addFrame("interactable", 0.0f, 0.0f, Tween.LINEAR).addFrame("interactable", 1.0f, 1.0f, Tween.LINEAR);
                }
                ts.startAnimation();
            }
        });
    }

    private void finishTrinketAnimation() {
        this.trinketAnimationActive = false;
        if (((RoyaleDraftContainer)this.m_6262_()).getTab(this.uuid) == 1) {
            ((RoyaleDraftContainer)this.m_6262_()).setTab(2, this.uuid);
        } else {
            ((RoyaleDraftContainer)this.m_6262_()).setTab(3, this.uuid);
        }
        this.recreateElements();
    }

    @Override
    protected void m_181908_() {
        super.m_181908_();
        if (this.trinketAnimationActive) {
            ++this.animTicks;
            if (this.xAnimator != null) {
                this.xAnimator.tick(1.0f);
            }
            if (this.animatingSelect != null) {
                this.animatingSelect.getAnimation().tick(1.0f);
            }
            this.elementStore.getRenderedElementList().forEach(el -> {
                TrinketSelect ts;
                if (el instanceof TrinketSelect && (ts = (TrinketSelect)el) != this.animatingSelect) {
                    ts.getAnimation().tick(1.0f);
                }
            });
            if (this.animTicks >= 10) {
                this.finishTrinketAnimation();
            }
        }
    }

    @Override
    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        if (this.trinketAnimationActive) {
            float t = (float)this.animTicks + partialTick;
            float alphaProgress = Mth.m_14036_((float)this.textFade.evaluate(t), (float)0.0f, (float)1.0f);
            int alpha = (int)(alphaProgress * 255.0f);
            TextComponent text = new TextComponent("Selected Trinket");
            int width = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)text);
            Minecraft.m_91087_().f_91062_.m_92889_(poseStack, (Component)text, (float)this.f_96543_ / 2.0f - (float)width / 2.0f, this.animY + 40.0f, alpha << 24 | 0xFFFFFF);
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public class PresetElement
    extends AbstractSpatialElement<PresetElement>
    implements IGuiEventElement,
    IRenderedElement,
    IAnimatedElement {
        private final int index;
        private final RoyalePresetConfig.SkillPreset preset;
        private boolean visible;
        private final Map<String, Integer> presetData;
        private final int cost;

        public PresetElement(ISpatial spatial, int index, RoyalePresetConfig.SkillPreset preset, Map<String, Integer> presetData) {
            super(spatial);
            this.visible = true;
            this.index = index;
            this.preset = preset;
            this.presetData = presetData;
            this.cost = RoyalePresetConfig.getLearnCost(preset.getName(), presetData);
        }

        @Override
        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        @Override
        public boolean isVisible() {
            return this.visible;
        }

        @Override
        public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            int tier;
            int y;
            int x;
            int col;
            int row;
            if (this.m_5953_(mouseX, mouseY) && this.isVisible()) {
                RenderSystem.m_69478_();
                ScreenDrawHelper.draw(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_, buf -> ScreenDrawHelper.rect((VertexConsumer)buf, poseStack).at(this.getWorldSpatial().x(), this.getWorldSpatial().y()).dim(this.getWorldSpatial().width(), this.getWorldSpatial().height()).color(0x22CCCCCC).drawColored());
            }
            float opacity = this.getAnimation().get(ElementAnimator.Property.OPACITY);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
            poseStack.m_85836_();
            poseStack.m_85837_((double)((float)this.getWorldSpatial().x() + (float)this.getWorldSpatial().width() / 2.0f), (double)((float)this.getWorldSpatial().y() + (float)this.getWorldSpatial().height() / 8.0f), 0.0);
            RenderSystem.m_157182_();
            String title = this.preset.name;
            TextComponent titleComponent = new TextComponent(title);
            int width = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)titleComponent);
            Minecraft.m_91087_().f_91062_.m_92889_(poseStack, (Component)titleComponent, (float)(-(width / 2)), 0.0f, -1);
            poseStack.m_85836_();
            poseStack.m_85841_(0.5f, 0.5f, 1.0f);
            String skillPointsText = String.format("%02d Skill Points Used", this.cost);
            Font font = Minecraft.m_91087_().f_91062_;
            int textWidth = font.m_92895_(skillPointsText);
            font.m_92883_(poseStack, skillPointsText, (float)(-textWidth / 2), 24.0f, -8355712);
            poseStack.m_85849_();
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 20.0, 0.0);
            poseStack.m_85841_(0.5f, 0.5f, 1.0f);
            UIHelper.renderCenteredWrappedCenterAlignText(poseStack, (Component)this.preset.description.getComponent(), this.getWorldSpatial().width() + 80, 0);
            poseStack.m_85849_();
            poseStack.m_85837_((double)(-((float)this.getWorldSpatial().width() / 2.0f) + 41.0f), 0.0, 0.0);
            int startY = 60;
            int itemsPerRow = 4;
            int itemSpacing = 34;
            int currentIndex = 0;
            int itemsWidth = itemsPerRow * itemSpacing;
            poseStack.m_85837_((double)((float)(this.getWorldSpatial().width() / 2) - ((float)(itemsWidth / 1) - 0.75f) / 2.0f), 20.0, 0.0);
            poseStack.m_85841_(0.8f, 0.8f, 1.0f);
            for (RoyalePresetConfig.SkillEntry ability : this.preset.abilities) {
                row = currentIndex / itemsPerRow;
                col = currentIndex % itemsPerRow;
                x = col * itemSpacing - (itemsPerRow - 1) * itemSpacing / 2;
                y = startY + row * 24;
                tier = this.presetData.getOrDefault(ability.id, 0);
                this.renderAbility(poseStack, ability.id, tier, x, y);
                ++currentIndex;
            }
            currentIndex = (currentIndex + itemsPerRow - 1) / itemsPerRow * itemsPerRow;
            for (RoyalePresetConfig.SkillEntry talent : this.preset.talents) {
                row = currentIndex / itemsPerRow;
                col = currentIndex % itemsPerRow;
                x = col * itemSpacing - (itemsPerRow - 1) * itemSpacing / 2;
                y = startY + row * 24;
                tier = this.presetData.getOrDefault(talent.id, 0);
                this.renderTalent(poseStack, talent.id, tier, x, y);
                ++currentIndex;
            }
            poseStack.m_85849_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        private void renderAbility(PoseStack poseStack, String abilityId, int tier, int x, int y) {
            ResourceLocation icon = ModConfigs.ABILITIES_GUI.getIcon(abilityId);
            if (icon == null) {
                return;
            }
            TextureAtlasRegion abilityIcon = TextureAtlasRegion.of(ModTextureAtlases.ABILITIES, icon);
            TextureAtlasRegion background = ScreenTextures.ABILITY_BACKGROUND;
            TextureAtlasRegion levelBackground = AbilityNodeTextures.NODE_BACKGROUND_LEVEL;
            if (tier > 0) {
                levelBackground.blit(poseStack, x + 10, y + 3);
                Font font = Minecraft.m_91087_().f_91062_;
                String text = String.valueOf(tier);
                float f = (float)(x + 10) + (float)levelBackground.width() / 2.0f - (float)font.m_92895_(text) / 2.0f;
                float f2 = (float)(y + 3) + (float)levelBackground.height() / 2.0f;
                Objects.requireNonNull(font);
                font.m_92883_(poseStack, text, f, f2 - 9.0f / 2.0f + 1.0f, -1);
                RenderSystem.m_69482_();
            }
            background.blit(poseStack, x + 10 + levelBackground.width() - 4, y);
            abilityIcon.blit(poseStack, x + 10 + levelBackground.width() - 4 + 3, y + 3);
        }

        private void renderTalent(PoseStack poseStack, String talentId, int tier, int x, int y) {
            SkillStyle skillStyle = ModConfigs.TALENTS_GUI.getStyles().get(talentId);
            if (skillStyle == null) {
                return;
            }
            TextureAtlasRegion talentIcon = TextureAtlasRegion.of(ModTextureAtlases.SKILLS, skillStyle.icon);
            TextureAtlasRegion background = ScreenTextures.TALENT_BACKGROUND;
            TextureAtlasRegion levelBackground = AbilityNodeTextures.NODE_BACKGROUND_LEVEL;
            if (tier > 0) {
                levelBackground.blit(poseStack, x + 10, y + 3);
                Font font = Minecraft.m_91087_().f_91062_;
                String text = String.valueOf(tier);
                float f = (float)(x + 10) + (float)levelBackground.width() / 2.0f - (float)font.m_92895_(text) / 2.0f;
                float f2 = (float)(y + 3) + (float)levelBackground.height() / 2.0f;
                Objects.requireNonNull(font);
                font.m_92883_(poseStack, text, f, f2 - 9.0f / 2.0f + 1.0f, -1);
                RenderSystem.m_69482_();
            }
            background.blit(poseStack, x + 10 + levelBackground.width() - 4, y);
            talentIcon.blit(poseStack, x + 10 + levelBackground.width() - 4 + 3, y + 3);
        }

        @Override
        public boolean onMouseClicked(double mouseX, double mouseY, int buttonIndex) {
            if (this.m_5953_(mouseX, mouseY) && this.isVisible()) {
                this.onPress(this.presetData);
                return true;
            }
            return false;
        }

        public void onPress(Map<String, Integer> presetData) {
            ModNetwork.CHANNEL.sendToServer((Object)new ServerboundSelectPresetMessage(this.preset.getName(), presetData));
            ((RoyaleDraftContainer)TommyTradeScreen.this.m_6262_()).setTab(1, TommyTradeScreen.this.uuid);
            TommyTradeScreen.this.recreateElements();
            Minecraft.m_91087_().f_91074_.m_6330_(ModSounds.BOOSTER_PACK_SUCCESS_SFX, Minecraft.m_91087_().f_91074_.m_5720_(), 0.7f, 1.0f);
            for (IElement iElement : TommyTradeScreen.this.elementStore.getRenderedElementList()) {
                if (!(iElement instanceof PresetElement)) continue;
                PresetElement el = (PresetElement)iElement;
                el.getAnimation().start();
            }
        }

        @Override
        public ElementAnimator getAnimation() {
            return new ElementAnimator(false).addFrame(ElementAnimator.Property.OPACITY, 0.0f, 1.0f, Tween.LINEAR).addFrame(ElementAnimator.Property.OPACITY, 100.0f, 0.0f, Tween.EASE_INOUT_QUADRATIC);
        }
    }

    public class BarePresetElement
    extends AbstractSpatialElement<BarePresetElement>
    implements IGuiEventElement,
    IRenderedElement {
        private boolean visible;
        private final TommyTradeScreen screen;

        public BarePresetElement(TommyTradeScreen screen, ISpatial spatial) {
            super(spatial);
            this.visible = true;
            this.screen = screen;
        }

        @Override
        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        @Override
        public boolean isVisible() {
            return this.visible;
        }

        @Override
        public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            if (this.m_5953_(mouseX, mouseY) && this.isVisible()) {
                RenderSystem.m_69478_();
                ScreenDrawHelper.draw(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_, buf -> ScreenDrawHelper.rect((VertexConsumer)buf, poseStack).at(this.getWorldSpatial().x(), this.getWorldSpatial().y()).dim(this.getWorldSpatial().width(), this.getWorldSpatial().height()).color(0x22CCCCCC).drawColored());
            }
            poseStack.m_85836_();
            poseStack.m_85837_((double)((float)this.getWorldSpatial().x() + (float)this.getWorldSpatial().width() / 2.0f), (double)((float)this.getWorldSpatial().y() + (float)this.getWorldSpatial().height() / 8.0f), 0.0);
            RenderSystem.m_157182_();
            String title = "I don't want a loadout, I am going in bare!";
            TextComponent titleComponent = new TextComponent(title);
            int width = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)titleComponent);
            Minecraft.m_91087_().f_91062_.m_92889_(poseStack, (Component)titleComponent, (float)(-(width / 2)), 0.0f, -1);
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 12.0, 0.0);
            String difficulty = "(Very Difficult!)";
            TextComponent difficultyComponent = new TextComponent(difficulty);
            width = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)difficultyComponent);
            Minecraft.m_91087_().f_91062_.m_92889_(poseStack, (Component)difficultyComponent, (float)(-(width / 2)), 0.0f, -3421237);
            poseStack.m_85849_();
            poseStack.m_85849_();
        }

        @Override
        public boolean onMouseClicked(double mouseX, double mouseY, int buttonIndex) {
            if (this.m_5953_(mouseX, mouseY) && this.isVisible()) {
                ((RoyaleDraftContainer)this.screen.m_6262_()).setTab(1, TommyTradeScreen.this.uuid);
                this.screen.recreateElements();
                return true;
            }
            return false;
        }
    }

    public class TrinketSelect
    extends AbstractSpatialElement<TrinketSelect>
    implements IGuiEventElement,
    IRenderedElement,
    IAnimatedElement {
        private final int index;
        private final ItemStack stack;
        private final ResourceLocation trinket;
        private boolean visible;
        private final ElementAnimator animator;

        public TrinketSelect(ISpatial spatial, ResourceLocation trinket, int index, ItemStack stack) {
            super(spatial);
            this.visible = true;
            this.animator = new ElementAnimator();
            this.trinket = trinket;
            this.index = index;
            this.stack = stack;
        }

        @Override
        public boolean isVisible() {
            return this.visible;
        }

        @Override
        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        @Override
        public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            if (this.m_5953_(mouseX, mouseY)) {
                RenderSystem.m_69478_();
                ScreenDrawHelper.draw(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_, buf -> ScreenDrawHelper.rect((VertexConsumer)buf, poseStack).at(this.getWorldSpatial().x(), this.getWorldSpatial().y()).dim(this.getWorldSpatial().width(), this.getWorldSpatial().height()).color(0x22CCCCCC).drawColored());
            }
            float xOff = this.animator.get(ElementAnimator.Property.X);
            float yOff = this.animator.get(ElementAnimator.Property.Y);
            float alpha = Mth.m_14036_((float)this.animator.get(ElementAnimator.Property.OPACITY), (float)0.0f, (float)1.0f);
            float scaleX = Math.max(1.0f, this.animator.get(ElementAnimator.Property.SCALE_X));
            float scaleY = Math.max(1.0f, this.animator.get(ElementAnimator.Property.SCALE_Y));
            RenderSystem.m_69465_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            float scale = 2.0f;
            poseStack.m_85836_();
            poseStack.m_85837_((double)((float)this.getWorldSpatial().x() + xOff + (float)this.getWorldSpatial().width() / 2.0f), (double)((float)this.getWorldSpatial().y() + yOff + (float)this.getWorldSpatial().height() / 2.0f), 0.0);
            poseStack.m_85841_(scale * scaleX, scale * scaleY, 1.0f);
            poseStack.m_85837_(-8.0, -8.0, 0.0);
            PoseStack posestack = RenderSystem.m_157191_();
            posestack.m_85836_();
            posestack.m_166854_(poseStack.m_85850_().m_85861_());
            RenderSystem.m_157182_();
            Minecraft.m_91087_().m_91291_().m_115123_(this.stack, 0, 0);
            posestack.m_85849_();
            RenderSystem.m_157182_();
            poseStack.m_85849_();
            RenderSystem.m_69482_();
            RenderSystem.m_69461_();
            if (mouseX >= this.getWorldSpatial().x() && mouseX < this.getWorldSpatial().x() + this.getWorldSpatial().width() && mouseY >= this.getWorldSpatial().y() && mouseY < this.getWorldSpatial().y() + this.getWorldSpatial().height()) {
                TommyTradeScreen.this.m_6057_(poseStack, this.stack, mouseX, mouseY);
            }
        }

        public void onPress() {
            float interactable = this.animator.get("interactable");
            if (interactable >= 1.0f) {
                return;
            }
            ModNetwork.CHANNEL.sendToServer((Object)new ServerboundRoyaleSelectTrinketMessage(this.trinket, ((RoyaleDraftContainer)TommyTradeScreen.this.m_6262_()).getEntityId()));
            Minecraft.m_91087_().f_91074_.m_6330_(ModSounds.BOOSTER_PACK_SUCCESS_SFX, Minecraft.m_91087_().f_91074_.m_5720_(), 0.7f, 1.0f);
            TommyTradeScreen.this.startTrinketAnimation(this);
        }

        @Override
        public ElementAnimator getAnimation() {
            return this.animator;
        }

        @Override
        public boolean onMouseClicked(double mouseX, double mouseY, int buttonIndex) {
            if (this.m_5953_(mouseX, mouseY) && this.isVisible()) {
                this.onPress();
                return true;
            }
            return false;
        }
    }

    public class RewardSelect
    extends AbstractSpatialElement<RewardSelect>
    implements IGuiEventElement,
    IRenderedElement {
        protected final List<ItemStack> loot;
        private boolean visible;
        private int lootModifier;

        public RewardSelect(ISpatial spatial, List<ItemStack> loot, int lootModifier) {
            super(spatial);
            this.visible = true;
            this.lootModifier = 1;
            this.loot = loot;
            this.lootModifier = lootModifier;
        }

        @Override
        public boolean isVisible() {
            return this.visible;
        }

        @Override
        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        @Override
        public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            if (this.m_5953_(mouseX, mouseY)) {
                RenderSystem.m_69478_();
                ScreenDrawHelper.draw(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_, buf -> ScreenDrawHelper.rect((VertexConsumer)buf, poseStack).at(this.getWorldSpatial().x(), this.getWorldSpatial().y()).dim(this.getWorldSpatial().width(), this.getWorldSpatial().height()).color(0x22CCCCCC).drawColored());
            }
            poseStack.m_85836_();
            RenderSystem.m_157182_();
            int itemSpacing = 20;
            int itemsPerRow = 5;
            int itemsWidth = (itemsPerRow - 1) * itemSpacing;
            for (int i = 0; i < this.loot.size(); ++i) {
                ItemStack stack = this.loot.get(i);
                int row = i / itemsPerRow;
                int col = i % itemsPerRow;
                int x = col * itemSpacing;
                int y = row * itemSpacing;
                Minecraft.m_91087_().m_91291_().m_115123_(stack, this.getWorldSpatial().x() + (this.getWorldSpatial().width() / 2 - 8 + x - itemsWidth / 2), this.getWorldSpatial().y() + 50 + y);
                Minecraft.m_91087_().m_91291_().m_115169_(Minecraft.m_91087_().f_91062_, stack, this.getWorldSpatial().x() + (this.getWorldSpatial().width() / 2 - 8 + x - itemsWidth / 2), this.getWorldSpatial().y() + 50 + y);
                if (!this.m_5953_(mouseX, mouseY) || mouseX < this.getWorldSpatial().x() + (this.getWorldSpatial().width() / 2 - 8 + x - itemsWidth / 2) || mouseX >= this.getWorldSpatial().x() + (this.getWorldSpatial().width() / 2 - 8 + x - itemsWidth / 2 + 16) || mouseY < this.getWorldSpatial().y() + 50 + y || mouseY >= this.getWorldSpatial().y() + 50 + y + 16) continue;
                TommyTradeScreen.this.m_6057_(poseStack, stack, mouseX, mouseY);
            }
            poseStack.m_85849_();
            if (!this.loot.isEmpty() && !this.loot.get(0).m_150930_(ModItems.BOOST_MODIFICATION_STONE)) {
                String title = "x" + this.lootModifier;
                TextComponent titleComponent = new TextComponent(title);
                int width = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)titleComponent);
                poseStack.m_85836_();
                poseStack.m_85837_((double)((float)this.getWorldSpatial().x() + (float)this.getWorldSpatial().width() / 2.0f), (double)((float)this.getWorldSpatial().y() + (float)this.getWorldSpatial().height() / 8.0f), 0.0);
                RenderSystem.m_157182_();
                Minecraft.m_91087_().f_91062_.m_92889_(poseStack, (Component)titleComponent, (float)(-(width / 2)), (float)(this.height() - 100), -1);
                poseStack.m_85849_();
            }
        }

        public void onPress() {
            ModNetwork.CHANNEL.sendToServer((Object)new ServerboundRoyaleSelectLootMessage(this.loot));
            ((RoyaleDraftContainer)TommyTradeScreen.this.m_6262_()).setTab(-1, TommyTradeScreen.this.uuid);
            TommyTradeScreen.this.m_7379_();
            Minecraft.m_91087_().f_91074_.m_6330_(ModSounds.BOOSTER_PACK_SUCCESS_SFX, Minecraft.m_91087_().f_91074_.m_5720_(), 0.7f, 1.0f);
        }

        @Override
        public boolean onMouseClicked(double mouseX, double mouseY, int buttonIndex) {
            if (this.m_5953_(mouseX, mouseY) && this.isVisible()) {
                this.onPress();
                return true;
            }
            return false;
        }
    }
}

