/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen;

import com.mojang.blaze3d.platform.InputConstants;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ButtonElement;
import iskallia.vault.client.gui.framework.element.ClickableLabelElement;
import iskallia.vault.client.gui.framework.element.GearModelPreviewElement;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.TextureAtlasElement;
import iskallia.vault.client.gui.framework.element.spi.AbstractSpatialElement;
import iskallia.vault.client.gui.framework.element.spi.IElement;
import iskallia.vault.client.gui.framework.element.spi.ILayoutStrategy;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.render.Tooltips;
import iskallia.vault.client.gui.framework.screen.AbstractElementScreen;
import iskallia.vault.client.gui.framework.screen.layout.ScreenLayout;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.framework.text.TextAlign;
import iskallia.vault.client.gui.overlay.VaultBarOverlay;
import iskallia.vault.config.UniqueCodexConfig;
import iskallia.vault.config.UniqueGearConfig;
import iskallia.vault.config.gear.VaultGearTierConfig;
import iskallia.vault.gear.GearRollHelper;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeRegistry;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.util.function.Memo;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.LogicalSide;
import org.jetbrains.annotations.NotNull;

public class UniqueCodexScreen
extends AbstractElementScreen {
    private final ButtonElement<?> btnPrev;
    private final ButtonElement<?> btnNext;
    private int activePage = 0;
    private List<AbstractSpatialElement<?>> pageElements;
    private static final int HALF_PAGE_WIDTH = 120;
    private static final int PAGE_START_Y = 30;
    private static final int LINE_HEIGHT = 10;
    private static final int MAX_PAGE_HEIGHT = 190;
    private int introductionPageCount = 1;

    public UniqueCodexScreen() {
        super((Component)new TextComponent("Unique Codex"), ScreenRenderers.getImmediate(), ScreenTooltipRenderer::create);
        this.setGuiSize(Spatials.size(288, 246));
        this.pageElements = new ArrayList();
        this.addElement((TextureAtlasElement)new TextureAtlasElement(Spatials.size(288, 246), ScreenTextures.UNIQUE_CODEX_BACKGROUND).layout(this.translateWorldSpatial()));
        this.btnPrev = new ButtonElement(Spatials.positionXY(25, 213), ScreenTextures.UNIQUE_CODEX_NAV_LEFT, () -> this.setActivePage(this.getActivePage() - 1));
        this.addElement(this.btnPrev).layout(this.translateWorldSpatial());
        this.btnNext = new ButtonElement(Spatials.positionXY(245, 213), ScreenTextures.UNIQUE_CODEX_NAV_RIGHT, () -> this.setActivePage(this.getActivePage() + 1));
        this.addElement(this.btnNext).layout(this.translateWorldSpatial());
        this.setActivePage(0);
    }

    public int getActivePage() {
        return this.activePage;
    }

    public void setActivePage(int activePage) {
        if (Minecraft.m_91087_().f_91074_ != null && this.activePage != activePage) {
            Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_11713_, 1.0f, 1.0f);
        }
        this.activePage = activePage;
        boolean hasPreviousPage = activePage > 0;
        boolean hasNextPage = activePage < this.getPageCount();
        this.initPageElements(activePage);
        this.btnPrev.setEnabled(hasPreviousPage);
        this.btnPrev.setVisible(hasPreviousPage);
        this.btnNext.setEnabled(hasNextPage);
        this.btnNext.setVisible(hasNextPage);
        ScreenLayout.requestLayout();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key key = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (keyCode == 256 || Minecraft.m_91087_().f_91066_.f_92092_.isActiveAndMatches(key)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    protected void initPageElements(int activePage) {
        if (this.pageElements != null) {
            this.pageElements.forEach(x$0 -> this.removeElement((IElement)x$0));
        }
        this.pageElements = new ArrayList();
        if (activePage <= this.introductionPageCount) {
            this.renderIntroductionPage(activePage);
        } else {
            this.renderItemPages(activePage - this.introductionPageCount);
        }
        for (AbstractSpatialElement<?> element : this.pageElements) {
            this.addElement(element);
        }
    }

    private void renderIntroductionPage(int pageNum) {
        if (pageNum == 0 && this.introductionPageCount == 0) {
            this.calculateIntroductionPageCount();
        }
        UniqueCodexConfig.IntroductionPage intro = ModConfigs.UNIQUE_CODEX.getIntroduction();
        this.pageElements = new ArrayList();
        if (pageNum == 0) {
            this.pageElements.add((AbstractSpatialElement<?>)new LabelElement((IPosition)Spatials.positionXY(20, 20).size(240, 10), (Component)new TextComponent("Unique Codex").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)"#7D520E")).m_131136_(Boolean.valueOf(true))), LabelTextStyle.defaultStyle().align(TextAlign.CENTER)).layout(this.translateWorldSpatial()));
        }
        this.renderIndexEntries(intro.getIndex(), pageNum);
    }

    private void calculateIntroductionPageCount() {
        UniqueCodexConfig.IntroductionPage intro = ModConfigs.UNIQUE_CODEX.getIntroduction();
        Map<UniqueCodexConfig.IntroductionPage.SlotType, List<ResourceLocation>> index = intro.getIndex();
        int pageCount = 0;
        int currentY = 50;
        boolean isRightPage = false;
        for (Map.Entry<UniqueCodexConfig.IntroductionPage.SlotType, List<ResourceLocation>> entry : index.entrySet()) {
            if (entry.getKey() == null) continue;
            int categoryHeight = 10 + entry.getValue().size() * 10 + 5;
            if (!isRightPage && currentY + categoryHeight > 190) {
                isRightPage = true;
                currentY = 30;
            }
            if (isRightPage && currentY + categoryHeight > 190) {
                ++pageCount;
                isRightPage = false;
                currentY = 30;
            }
            currentY += categoryHeight;
        }
        this.introductionPageCount = pageCount + 1;
    }

    private void renderIndexEntries(Map<UniqueCodexConfig.IntroductionPage.SlotType, List<ResourceLocation>> index, int targetPageNum) {
        int categoryHeight;
        this.pageElements = new ArrayList();
        if (targetPageNum == 0) {
            this.pageElements.add((AbstractSpatialElement<?>)new LabelElement((IPosition)Spatials.positionXY(20, 20).size(240, 10), (Component)new TextComponent("Unique Codex").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)"#7D520E")).m_131136_(Boolean.valueOf(true))), LabelTextStyle.defaultStyle().align(TextAlign.CENTER)).layout(this.translateWorldSpatial()));
        }
        int currentPage = 0;
        int leftY = targetPageNum == 0 ? 50 : 30;
        int rightY = 30;
        boolean onRightSide = false;
        ArrayList<Map.Entry<UniqueCodexConfig.IntroductionPage.SlotType, List<ResourceLocation>>> categoriesToRender = new ArrayList<Map.Entry<UniqueCodexConfig.IntroductionPage.SlotType, List<ResourceLocation>>>();
        for (Map.Entry<UniqueCodexConfig.IntroductionPage.SlotType, List<ResourceLocation>> entry : index.entrySet()) {
            if (entry.getKey() == null) continue;
            categoryHeight = 10 + entry.getValue().size() * 10 + 5;
            if (!onRightSide && leftY + categoryHeight > 190) {
                onRightSide = true;
                rightY = 30;
            } else if (onRightSide && rightY + categoryHeight > 190) {
                ++currentPage;
                onRightSide = false;
                leftY = 30;
                rightY = 30;
            }
            if (currentPage == targetPageNum) {
                categoriesToRender.add(entry);
            }
            if (onRightSide) {
                rightY += categoryHeight;
                continue;
            }
            leftY += categoryHeight;
        }
        leftY = targetPageNum == 0 ? 50 : 30;
        rightY = 30;
        onRightSide = false;
        for (Map.Entry<UniqueCodexConfig.IntroductionPage.SlotType, List<Object>> entry : categoriesToRender) {
            categoryHeight = 10 + entry.getValue().size() * 10 + 5;
            if (!onRightSide && leftY + categoryHeight > 190) {
                onRightSide = true;
                rightY = 30;
            }
            int xPos = onRightSide ? 155 : 20;
            int yPos = onRightSide ? rightY : leftY;
            this.pageElements.add((AbstractSpatialElement<?>)new LabelElement((IPosition)Spatials.positionXY(xPos, yPos).size(110, 10), (Component)new TextComponent(this.formatSlotName(entry.getKey())).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)"#7D520E"))), LabelTextStyle.defaultStyle().align(TextAlign.LEFT)).layout(this.translateWorldSpatial()));
            int itemY = yPos + 10;
            for (ResourceLocation resourceLocation : entry.getValue()) {
                this.pageElements.add((AbstractSpatialElement<?>)new ClickableLabelElement(Spatials.positionXY(xPos, itemY).size(100, 10), (Component)new TextComponent("- " + this.getUniqueName(resourceLocation)).m_130940_(ChatFormatting.BLACK), TextColor.m_131270_((ChatFormatting)ChatFormatting.BLACK), TextColor.m_131270_((ChatFormatting)ChatFormatting.DARK_GRAY), TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY), LabelTextStyle.defaultStyle().align(TextAlign.LEFT), () -> {
                    int pageIndex = ModConfigs.UNIQUE_CODEX.getPageIndex(uniqueId);
                    if (pageIndex >= 0) {
                        int itemPageNumber = pageIndex / 2;
                        int actualPageNumber = this.introductionPageCount + itemPageNumber;
                        this.setActivePage(actualPageNumber + 1);
                    }
                }, true).layout(this.translateWorldSpatial()));
                itemY += 10;
            }
            if (onRightSide) {
                rightY = itemY + 5;
                continue;
            }
            leftY = itemY + 5;
        }
    }

    private void renderItemPages(int activePage) {
        UniqueCodexConfig.UniqueCodexPage leftPage = ModConfigs.UNIQUE_CODEX.getPage((activePage - 1) * 2);
        UniqueCodexConfig.UniqueCodexPage rightPage = ModConfigs.UNIQUE_CODEX.getPage((activePage - 1) * 2 + 1);
        if (leftPage != null) {
            this.renderItemPage(leftPage, true);
        }
        if (rightPage != null) {
            this.renderItemPage(rightPage, false);
        }
    }

    private void renderItemPage(UniqueCodexConfig.UniqueCodexPage page, boolean isLeftPage) {
        int xOffset = isLeftPage ? 20 : 155;
        MutableComponent text = page.getTitle();
        this.pageElements.add((AbstractSpatialElement<?>)new LabelElement((IPosition)Spatials.positionXY(xOffset, 30).size(100, 20), (Component)text, LabelTextStyle.defaultStyle().align(TextAlign.LEFT)).layout(this.translateWorldSpatial()));
        if (page.isNewInUpdate()) {
            int textWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)text);
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            this.pageElements.add((AbstractSpatialElement<?>)new TextureAtlasElement(Spatials.positionXY(xOffset, 35 - 9 - 10), ScreenTextures.NEW_BADGE).layout(this.translateWorldSpatial()));
        }
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = page::getUniqueId;
        Supplier<ItemStack> stackSupplier = Memo.reactive(() -> this.getItemStackForPage(page.getUniqueId()), supplierArray);
        Supplier[] supplierArray2 = new Supplier[1];
        supplierArray2[0] = page::getUniqueId;
        Supplier<List<Component>> tooltipSupplier = Memo.reactive(() -> this.createPossibleRollTooltip((ItemStack)stackSupplier.get(), page.getUniqueId()), supplierArray2);
        this.pageElements.add((AbstractSpatialElement<?>)((GearModelPreviewElement)new GearModelPreviewElement(Spatials.positionXY(xOffset, 45), Spatials.size(110, 62), stackSupplier, null).tooltip(Tooltips.multi(tooltipSupplier))).layout(this.translateWorldSpatial()));
        this.pageElements.add((AbstractSpatialElement<?>)new LabelElement((IPosition)Spatials.positionXY(xOffset, 113).width(100), (Component)page.getDescription(), LabelTextStyle.defaultStyle().wrap().left()).layout(this.restrictWidth(100)));
    }

    private List<Component> createPossibleRollTooltip(ItemStack stack, ResourceLocation uniqueId) {
        Optional<UniqueGearConfig.Entry> entryOpt = ModConfigs.UNIQUE_GEAR.getEntry(uniqueId);
        if (entryOpt.isEmpty()) {
            return List.of();
        }
        VaultGearTierConfig cfg = VaultGearTierConfig.getConfig(stack).orElse(null);
        if (cfg == null) {
            return List.of();
        }
        int level = VaultBarOverlay.vaultLevel;
        LinkedHashSet groups = new LinkedHashSet();
        UniqueGearConfig.Entry entry = entryOpt.get();
        entry.getModifierIdentifiers().forEach((affix, ids) -> ids.forEach(id -> {
            VaultGearTierConfig.ModifierTierGroup group = cfg.getTierGroup((ResourceLocation)id);
            if (group != null) {
                groups.add(group);
            }
        }));
        entry.getModifierTags().forEach(tag -> cfg.getGenericGroupsWithModifierTag((String)tag).forEach(tpl -> groups.add((VaultGearTierConfig.ModifierTierGroup)tpl.m_14419_())));
        ArrayList<Component> tooltip = new ArrayList<Component>();
        for (VaultGearTierConfig.ModifierTierGroup group : groups) {
            List<VaultGearTierConfig.ModifierTier<?>> tiers;
            VaultGearAttribute<?> attribute = VaultGearAttributeRegistry.getAttribute(group.getAttribute());
            if (attribute == null || (tiers = group.getModifiersForLevel(level)).isEmpty()) continue;
            VaultGearTierConfig.ModifierTier<?> min = tiers.get(0);
            VaultGearTierConfig.ModifierTier<?> max = tiers.get(0);
            for (VaultGearTierConfig.ModifierTier<?> tier : tiers) {
                if (tier.getMinLevel() < min.getMinLevel()) {
                    min = tier;
                }
                if (tier.getMinLevel() <= max.getMinLevel()) continue;
                max = tier;
            }
            Object minCfg = min.getModifierConfiguration();
            Object maxCfg = max.getModifierConfiguration();
            ConfigurableAttributeGenerator<?, ?> generator = attribute.getGenerator();
            MutableComponent range = generator.getConfigRangeDisplay(attribute.getReader(), minCfg, maxCfg);
            if (range == null) continue;
            MutableComponent cmp = attribute.getReader().formatConfigDisplay(LogicalSide.CLIENT, (Component)range);
            tooltip.add((Component)cmp);
        }
        return tooltip;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ItemStack getItemStackForPage(ResourceLocation uniqueId) {
        Optional<UniqueGearConfig.Entry> location = ModConfigs.UNIQUE_GEAR.getEntry(uniqueId);
        ItemStack stack = new ItemStack((ItemLike)ModItems.SWORD);
        if (!location.isPresent()) return new ItemStack((ItemLike)ModItems.ERROR_ITEM);
        if (location.get().getModel() == null) {
            stack = new ItemStack((ItemLike)ModItems.JEWEL);
            VaultGearData data = VaultGearData.read(stack);
            data.setRarity(VaultGearRarity.UNIQUE);
            data.createOrReplaceAttributeValue(ModGearAttributes.GEAR_ROLL_TYPE, location.get().getId().toString());
            data.createOrReplaceAttributeValue(ModGearAttributes.UNIQUE_ITEM_KEY, uniqueId);
            data.setItemLevel(VaultBarOverlay.vaultLevel);
            data.write(stack);
            GearRollHelper.initializeGear(stack, (Player)this.getMinecraft().f_91074_);
            return stack;
        }
        if (location.get().getModel().toString().contains("sword")) {
            stack = new ItemStack((ItemLike)ModItems.SWORD);
        } else if (location.get().getModel().toString().contains("shield")) {
            stack = new ItemStack((ItemLike)ModItems.SHIELD);
        } else if (location.get().getModel().toString().contains("wand")) {
            stack = new ItemStack((ItemLike)ModItems.WAND);
        } else if (location.get().getModel().toString().contains("focus")) {
            stack = new ItemStack((ItemLike)ModItems.FOCUS);
        } else if (location.get().getModel().toString().contains("helmet")) {
            stack = new ItemStack((ItemLike)ModItems.HELMET);
        } else if (location.get().getModel().toString().contains("chestplate")) {
            stack = new ItemStack((ItemLike)ModItems.CHESTPLATE);
        } else if (location.get().getModel().toString().contains("leggings")) {
            stack = new ItemStack((ItemLike)ModItems.LEGGINGS);
        } else if (location.get().getModel().toString().contains("boots")) {
            stack = new ItemStack((ItemLike)ModItems.BOOTS);
        } else {
            if (!location.get().getModel().toString().contains("axe")) return new ItemStack((ItemLike)ModItems.ERROR_ITEM);
            stack = new ItemStack((ItemLike)ModItems.AXE);
        }
        VaultGearData data = VaultGearData.read(stack);
        data.setRarity(VaultGearRarity.UNIQUE);
        data.createOrReplaceAttributeValue(ModGearAttributes.GEAR_ROLL_TYPE, location.get().getId().toString());
        data.createOrReplaceAttributeValue(ModGearAttributes.UNIQUE_ITEM_KEY, uniqueId);
        data.setItemLevel(VaultBarOverlay.vaultLevel);
        data.write(stack);
        GearRollHelper.initializeGear(stack, (Player)this.getMinecraft().f_91074_);
        return stack;
    }

    private String formatSlotName(UniqueCodexConfig.IntroductionPage.SlotType slot) {
        if (slot == null) {
            return "Unknown Type";
        }
        return switch (slot) {
            case UniqueCodexConfig.IntroductionPage.SlotType.HEAD -> "Helmets";
            case UniqueCodexConfig.IntroductionPage.SlotType.CHEST -> "Chestplates";
            case UniqueCodexConfig.IntroductionPage.SlotType.LEGS -> "Leggings";
            case UniqueCodexConfig.IntroductionPage.SlotType.FEET -> "Boots";
            case UniqueCodexConfig.IntroductionPage.SlotType.SWORD -> "Swords";
            case UniqueCodexConfig.IntroductionPage.SlotType.AXE -> "Axes";
            case UniqueCodexConfig.IntroductionPage.SlotType.OFFHAND -> "Shields/Wands/Foci";
            case UniqueCodexConfig.IntroductionPage.SlotType.SHIELD -> "Shields";
            case UniqueCodexConfig.IntroductionPage.SlotType.WAND -> "Wands";
            case UniqueCodexConfig.IntroductionPage.SlotType.FOCUS -> "Foci";
            case UniqueCodexConfig.IntroductionPage.SlotType.JEWEL -> "Jewels";
            default -> "Unknown";
        };
    }

    private String getUniqueName(ResourceLocation uniqueId) {
        return ModConfigs.UNIQUE_CODEX.getPages().stream().filter(page -> page.getUniqueId().equals((Object)uniqueId)).findFirst().map(page -> page.getTitle().getString()).orElse(uniqueId.m_135815_());
    }

    @NotNull
    protected ILayoutStrategy restrictWidth(int width) {
        return (screen, gui, parent, world) -> world.translateXY(this.getGuiSpatial()).width(width);
    }

    @NotNull
    protected ILayoutStrategy restrictHeight(int height) {
        return (screen, gui, parent, world) -> world.translateXY(this.getGuiSpatial()).height(height);
    }

    @NotNull
    protected ILayoutStrategy restrictSize(int width, int height) {
        return (screen, gui, parent, world) -> world.translateXY(this.getGuiSpatial()).size(width, height);
    }

    private int getPageCount() {
        int uniquePageCount = (ModConfigs.UNIQUE_CODEX.getPages().size() + 1) / 2;
        return this.introductionPageCount + uniquePageCount;
    }
}

