/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.ButtonElement;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.screen.AbstractElementScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.item.VaultCompassMode;
import iskallia.vault.network.message.ServerboundCompassModeSelectMessage;
import iskallia.vault.world.data.VaultPlayerCompassData;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class VaultCompassScreen
extends AbstractElementScreen {
    private static final int CIRCLE_RADIUS = 60;
    private static final int BUTTON_SIZE = 32;
    private VaultCompassMode hoveredMode = null;
    private VaultCompassMode currentMode;

    public VaultCompassScreen() {
        super((Component)new TextComponent("Vault Compass Mode"), ScreenRenderers.getBuffered(), ScreenTooltipRenderer::create);
        this.setGuiSize(Spatials.size(300, 300));
        this.currentMode = VaultPlayerCompassData.CLIENT.get(Minecraft.m_91087_().f_91074_.m_142081_()).getMode();
        this.createCircularLayout();
    }

    private void createCircularLayout() {
        VaultCompassMode[] modes = VaultCompassMode.values();
        int centerX = 150;
        int centerY = 150;
        int slotIndex = 0;
        for (VaultCompassMode mode : modes) {
            if (mode == VaultCompassMode.EXIT) continue;
            int adjustedSlot = slotIndex >= 4 ? slotIndex + 1 : slotIndex;
            double angle = (double)(adjustedSlot * 2) * Math.PI / (double)modes.length - 1.5707963267948966;
            int x = (int)((double)centerX + 60.0 * Math.cos(angle) - 16.0);
            int y = (int)((double)centerY + 60.0 * Math.sin(angle) - 16.0);
            CircularModeButton button = new CircularModeButton(Spatials.positionXY(x, y).size(32, 32), mode);
            this.addElement((CircularModeButton)button.layout(this.translateWorldSpatial()));
            ++slotIndex;
        }
        double exitAngle = 1.5707963267948966;
        int exitX = (int)((double)centerX + 60.0 * Math.cos(exitAngle) - 16.0);
        int exitY = (int)((double)centerY + 60.0 * Math.sin(exitAngle) - 16.0);
        CircularModeButton exitButton = new CircularModeButton(Spatials.positionXY(exitX, exitY).size(32, 32), VaultCompassMode.EXIT);
        this.addElement((CircularModeButton)exitButton.layout(this.translateWorldSpatial()));
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.renderCenterDisplay(poseStack, mouseX, mouseY);
    }

    private void renderCenterDisplay(PoseStack poseStack, int mouseX, int mouseY) {
        int centerX = this.getGuiLeft() + this.getGuiSpatial().width() / 2;
        int centerY = this.getGuiTop() + this.getGuiSpatial().height() / 2;
        if (this.hoveredMode != null) {
            VaultPlayerCompassData.CompassInfo compassInfo = VaultPlayerCompassData.CLIENT.get(Minecraft.m_91087_().f_91074_.m_142081_());
            boolean isUnlocked = compassInfo.isUnlocked(this.hoveredMode);
            int progress = compassInfo.getProgress(this.hoveredMode);
            int requirement = this.hoveredMode.getRequirement();
            int totalHeight = 0;
            if (!isUnlocked) {
                totalHeight += 15;
            }
            String modeName = this.hoveredMode.getDisplayName();
            int maxWidth = 95;
            List wrappedText = Minecraft.m_91087_().f_91062_.m_92865_().m_92414_((FormattedText)new TextComponent(modeName), maxWidth, Style.f_131099_);
            for (int i = 0; i < wrappedText.size(); ++i) {
                boolean isLast = i == wrappedText.size() - 1;
                totalHeight += isLast ? 15 : 12;
            }
            if (!isUnlocked) {
                totalHeight += 15;
            }
            if (isUnlocked && VaultUtils.isVaultLevel(Minecraft.m_91087_().f_91074_.f_19853_) && this.hoveredMode != this.currentMode) {
                totalHeight += 15;
            }
            int currentY = centerY - totalHeight / 2;
            if (!isUnlocked) {
                String lockedText = "Locked";
                int lockedWidth = Minecraft.m_91087_().f_91062_.m_92895_(lockedText);
                Minecraft.m_91087_().f_91062_.m_92750_(poseStack, lockedText, (float)centerX - (float)lockedWidth / 2.0f, (float)currentY, 0xFF0000);
                currentY += 15;
            }
            for (int i = 0; i < wrappedText.size(); ++i) {
                FormattedText line = (FormattedText)wrappedText.get(i);
                boolean isLast = i == wrappedText.size() - 1;
                int textWidth = Minecraft.m_91087_().f_91062_.m_92852_(line);
                Minecraft.m_91087_().f_91062_.m_92750_(poseStack, line.getString(), (float)centerX - (float)textWidth / 2.0f, (float)currentY, 0xFFFFFF);
                currentY += isLast ? 15 : 12;
            }
            if (!isUnlocked) {
                String progressText = requirement > 0 ? progress + "/" + requirement : "Unlocked";
                int progressWidth = Minecraft.m_91087_().f_91062_.m_92895_(progressText);
                int color = requirement > 0 && progress >= requirement ? 43520 : 0xFF0000;
                Minecraft.m_91087_().f_91062_.m_92750_(poseStack, progressText, (float)centerX - (float)progressWidth / 2.0f, (float)currentY, color);
                currentY += 15;
            }
            if (isUnlocked && VaultUtils.isVaultLevel(Minecraft.m_91087_().f_91074_.f_19853_) && this.hoveredMode != this.currentMode) {
                String penaltyText = "-10% max health";
                int penaltyWidth = Minecraft.m_91087_().f_91062_.m_92895_(penaltyText);
                Minecraft.m_91087_().f_91062_.m_92750_(poseStack, penaltyText, (float)centerX - (float)penaltyWidth / 2.0f, (float)currentY, 0xFF5555);
            }
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key key = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (keyCode == 256 || Minecraft.m_91087_().f_91066_.f_92092_.isActiveAndMatches(key)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private TextureAtlasRegion getModeTexture(VaultCompassMode mode) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case VaultCompassMode.CHALLENGE_ROOM -> ScreenTextures.COMPASS_ICON_CHALLENGE_ROOM;
            case VaultCompassMode.GOD_ALTAR -> ScreenTextures.COMPASS_ICON_GOD_ALTAR;
            case VaultCompassMode.OBJECTIVE_PILLAR -> ScreenTextures.COMPASS_ICON_OBJECTIVE_PILLAR;
            case VaultCompassMode.DUNGEON_DOOR -> ScreenTextures.COMPASS_ICON_DUNGEON_DOOR;
            case VaultCompassMode.TREASURE_DOOR -> ScreenTextures.COMPASS_ICON_TREASURE_DOOR;
            case VaultCompassMode.COMPANION_EGG -> ScreenTextures.COMPASS_ICON_COMPANION_EGG;
            case VaultCompassMode.ORE_ROOM -> ScreenTextures.COMPASS_ICON_ORE_ROOM;
            case VaultCompassMode.EXIT -> ScreenTextures.COMPASS_ICON_EXIT;
        };
    }

    private TextureAtlasRegion getModeTextureDisabled(VaultCompassMode mode) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case VaultCompassMode.CHALLENGE_ROOM -> ScreenTextures.COMPASS_ICON_CHALLENGE_ROOM_DISABLED;
            case VaultCompassMode.GOD_ALTAR -> ScreenTextures.COMPASS_ICON_GOD_ALTAR_DISABLED;
            case VaultCompassMode.OBJECTIVE_PILLAR -> ScreenTextures.COMPASS_ICON_OBJECTIVE_PILLAR_DISABLED;
            case VaultCompassMode.DUNGEON_DOOR -> ScreenTextures.COMPASS_ICON_DUNGEON_DOOR_DISABLED;
            case VaultCompassMode.TREASURE_DOOR -> ScreenTextures.COMPASS_ICON_TREASURE_DOOR_DISABLED;
            case VaultCompassMode.COMPANION_EGG -> ScreenTextures.COMPASS_ICON_COMPANION_EGG_DISABLED;
            case VaultCompassMode.ORE_ROOM -> ScreenTextures.COMPASS_ICON_ORE_ROOM_DISABLED;
            case VaultCompassMode.EXIT -> ScreenTextures.COMPASS_ICON_EXIT_DISABLED;
        };
    }

    public class CircularModeButton
    extends ButtonElement<CircularModeButton> {
        private final VaultCompassMode mode;
        private boolean isSelected;

        public CircularModeButton(ISpatial spatial, VaultCompassMode mode) {
            super(spatial, VaultCompassScreen.this.currentMode == mode ? new ButtonElement.ButtonTextures(ScreenTextures.COMPASS_TARGET_FRAME_ACTIVE, ScreenTextures.COMPASS_TARGET_FRAME_ACTIVE_HIGHLIGHT, ScreenTextures.COMPASS_TARGET_FRAME_ACTIVE_HIGHLIGHT, ScreenTextures.COMPASS_TARGET_HIGHLIGHTED) : ScreenTextures.COMPASS_TARGET_FRAME_TEXTURES, () -> {});
            this.mode = mode;
            this.isSelected = mode == VaultCompassScreen.this.currentMode;
            this.setDisabled(!this.isSelected && !VaultPlayerCompassData.CLIENT.get(Minecraft.m_91087_().f_91074_.m_142081_()).isUnlocked(mode));
        }

        @Override
        public void render(IElementRenderer renderer, PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            if (this.containsMouse(mouseX, mouseY)) {
                VaultCompassScreen.this.hoveredMode = this.mode;
            }
            super.render(renderer, poseStack, mouseX, mouseY, partialTick);
            int centerX = this.worldSpatial.x() + this.worldSpatial.width() / 2;
            int centerY = this.worldSpatial.y() + this.worldSpatial.height() / 2;
            TextureAtlasRegion region = (Boolean)this.disabled.get() == false ? VaultCompassScreen.this.getModeTexture(this.mode) : VaultCompassScreen.this.getModeTextureDisabled(this.mode);
            poseStack.m_85836_();
            poseStack.m_85837_((double)(this.worldSpatial.width() / 2 - region.width() / 2), (double)(this.worldSpatial.height() / 2 - region.height() / 2), 0.0);
            renderer.render(region, poseStack, (IPosition)this.worldSpatial);
            poseStack.m_85849_();
        }

        @Override
        public boolean onMouseReleased(double mouseX, double mouseY, int buttonIndex) {
            boolean res = super.onMouseReleased(mouseX, mouseY, buttonIndex);
            if (!this.isDisabled() && this.containsMouse(mouseX, mouseY) && buttonIndex == 0) {
                ServerboundCompassModeSelectMessage.send(this.mode);
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12210_, (float)1.0f, (float)0.6f));
                VaultCompassScreen.this.m_7379_();
            }
            return res;
        }

        public List<Component> getTooltip() {
            VaultPlayerCompassData.CompassInfo compassInfo = VaultPlayerCompassData.CLIENT.get(Minecraft.m_91087_().f_91074_.m_142081_());
            int progress = compassInfo.getProgress(this.mode);
            int requirement = this.mode.getRequirement();
            return List.of(new TextComponent(this.mode.getDisplayName()).m_130940_(ChatFormatting.WHITE), new TextComponent("Progress: " + progress + "/" + requirement).m_130940_(ChatFormatting.GRAY));
        }
    }
}

