/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.LabelElement;
import iskallia.vault.client.gui.framework.element.NineSliceElement;
import iskallia.vault.client.gui.framework.element.SlotsElement;
import iskallia.vault.client.gui.framework.element.spi.AbstractSpatialElement;
import iskallia.vault.client.gui.framework.element.spi.IRenderedElement;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.render.spi.ITooltipRenderer;
import iskallia.vault.client.gui.framework.screen.AbstractElementContainerScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IMutableSpatial;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISize;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.container.inventory.VaultKeyringContainer;
import iskallia.vault.container.slot.TreasureKeySlot;
import iskallia.vault.init.ModItems;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class VaultKeyringScreen
extends AbstractElementContainerScreen<VaultKeyringContainer> {
    public static Map<Item, TextureAtlasRegion> KEY_MAP = new HashMap<Item, TextureAtlasRegion>(){
        {
            this.put(ModItems.ISKALLIUM_KEY, ScreenTextures.KEY_ISKALLIUM);
            this.put(ModItems.GORGINITE_KEY, ScreenTextures.KEY_GORGINITE);
            this.put(ModItems.SPARKLETINE_KEY, ScreenTextures.KEY_SPARKLETINE);
            this.put(ModItems.ASHIUM_KEY, ScreenTextures.KEY_ASHIUM);
            this.put(ModItems.BOMIGNITE_KEY, ScreenTextures.KEY_BOMIGNITE);
            this.put(ModItems.TUBIUM_KEY, ScreenTextures.KEY_TUBIUM);
            this.put(ModItems.UPALINE_KEY, ScreenTextures.KEY_UPALINE);
            this.put(ModItems.PETZANITE_KEY, ScreenTextures.KEY_PETZANITE);
            this.put(ModItems.XENIUM_KEY, ScreenTextures.KEY_XENIUM);
        }
    };

    public VaultKeyringScreen(VaultKeyringContainer container, Inventory inventory, Component title) {
        super(container, inventory, title, ScreenRenderers.getImmediate(), ScreenTooltipRenderer::create);
        this.setGuiSize(Spatials.size(176, 164));
        this.addElement((NineSliceElement)new NineSliceElement(this.getGuiSpatial(), ScreenTextures.DEFAULT_WINDOW_BACKGROUND).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui).size(Spatials.copy(gui))));
        this.addElement((SlotsElement)new SlotsElement((MenuAccess<?>)this).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.positionXY(gui)));
        MutableComponent inventoryName = inventory.m_5446_().m_6881_();
        inventoryName.m_130948_(Style.f_131099_.m_178520_(-12632257));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, 71), (Component)inventoryName, LabelTextStyle.defaultStyle()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        MutableComponent treasureKeyRingTitle = new TextComponent("Treasure Keyring").m_130940_(ChatFormatting.DARK_GRAY);
        treasureKeyRingTitle.m_130948_(Style.f_131099_.m_178520_(-12632257));
        this.addElement((LabelElement)new LabelElement((IPosition)Spatials.positionXY(8, 7), (Component)treasureKeyRingTitle, LabelTextStyle.defaultStyle()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
        this.addElement((TreasureKeyBackgroundElement)new TreasureKeyBackgroundElement(Spatials.positionXY(-1, -1), container, this.getTooltipRenderer()).layout((ISize screen, ISpatial gui, ISpatial parent, IMutableSpatial world) -> world.translateXY(gui)));
    }

    @Override
    protected boolean renderHoveredSlotTooltips(@Nonnull PoseStack poseStack, int mouseX, int mouseY) {
        Slot slot;
        if (this.f_97734_ != null && (slot = this.f_97734_) instanceof TreasureKeySlot) {
            TreasureKeySlot keySlot = (TreasureKeySlot)slot;
            if (!this.f_97734_.m_6657_()) {
                this.m_6057_(poseStack, keySlot.getKeyStack(), mouseX, mouseY);
            }
        }
        return super.renderHoveredSlotTooltips(poseStack, mouseX, mouseY);
    }

    public static class TreasureKeyBackgroundElement
    extends AbstractSpatialElement<TreasureKeyBackgroundElement>
    implements IRenderedElement {
        private final ITooltipRenderer tooltipRenderer;
        private final VaultKeyringContainer container;

        public TreasureKeyBackgroundElement(ISpatial position, VaultKeyringContainer container, ITooltipRenderer tooltipRenderer) {
            super(position);
            this.tooltipRenderer = tooltipRenderer;
            this.container = container;
        }

        @Override
        public void setVisible(boolean visible) {
        }

        @Override
        public boolean isVisible() {
            return true;
        }

        @Override
        public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            TextureManager mgr = Minecraft.m_91087_().m_91097_();
            mgr.m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (TreasureKeySlot keySlot : this.container.getKeySlots()) {
                ItemStack emptyStack;
                TextureAtlasRegion tar;
                if (keySlot.m_6657_() || (tar = KEY_MAP.get((emptyStack = keySlot.getKeyStack()).m_41720_())) == null) continue;
                IMutableSpatial pos = Spatials.positionXY(this.worldSpatial.x() + keySlot.f_40220_ + 1, this.worldSpatial.y() + keySlot.f_40221_ + 1);
                renderer.render(tar, poseStack, (IPosition)pos);
            }
        }
    }
}

