/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.accessibility;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.element.ColorPickerElement;
import iskallia.vault.client.gui.framework.element.NineSliceButtonElement;
import iskallia.vault.client.gui.framework.element.ToggleButtonElement;
import iskallia.vault.client.gui.framework.element.spi.AbstractSpatialElement;
import iskallia.vault.client.gui.framework.element.spi.ILayoutStrategy;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.screen.AbstractElementScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.init.ModOptions;
import iskallia.vault.options.VaultOption;
import iskallia.vault.skill.ability.effect.spi.HunterAbility;
import iskallia.vault.util.GuiHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class HunterOptionsSubmenu
extends AbstractElementScreen {
    private final Screen lastScreen;
    private final GuiHelper guiHelper;
    private ToggleButtonElement hunterStyleButton;
    private ToggleButtonElement hunterOutlineModeButton;
    private ToggleButtonElement hunterOutlineThicknessButton;
    private ToggleButtonElement hunterParticleDensityButton;
    private ToggleButtonElement targetColorButton;
    private HunterAbility.Target selectedTarget;
    private ColorPickerElement colorPickerElement;
    private NineSliceButtonElement<?> resetColorButton;
    private NineSliceButtonElement<?> doneButton;
    private final List<AbstractSpatialElement<?>> offsetElements = new ArrayList();

    public HunterOptionsSubmenu(Screen lastScreen) {
        super((Component)new TextComponent("Hunter Options"), ScreenRenderers.getBuffered(), ScreenTooltipRenderer::create);
        Window window = Minecraft.m_91087_().m_91268_();
        this.setGuiSize(Spatials.size(window.m_85445_(), window.m_85446_()));
        this.lastScreen = lastScreen;
        this.guiHelper = new GuiHelper(this);
        this.selectedTarget = HunterAbility.Target.WOODEN;
        this.initializeElements();
    }

    private void initializeElements() {
        int padding = 4;
        int widgetWidth = 150;
        int widgetHeight = 20;
        int startX = widgetWidth / 2;
        int startY = 0;
        int x = startX;
        int y = startY;
        this.hunterStyleButton = this.guiHelper.createToggleButton(x, y, widgetWidth, widgetHeight, "Hunter Style", () -> ModOptions.HUNTER_PARTICLES.getValue() != false ? "Particles" : "Outlines", () -> {
            ModOptions.HUNTER_PARTICLES.setValue(ModOptions.HUNTER_PARTICLES.getValue() == false);
            if (ModOptions.HUNTER_PARTICLES.getValue().booleanValue()) {
                this.addElement((ToggleButtonElement)this.hunterParticleDensityButton.layout(this.translateWorldSpatial()));
                this.removeElement(this.hunterOutlineModeButton);
                this.removeElement(this.hunterOutlineThicknessButton);
            } else {
                this.removeElement(this.hunterParticleDensityButton);
                this.addElement((ToggleButtonElement)this.hunterOutlineModeButton.layout(this.translateWorldSpatial()));
                this.addElement((ToggleButtonElement)this.hunterOutlineThicknessButton.layout(this.translateWorldSpatial()));
            }
        });
        this.addElement((ToggleButtonElement)this.hunterStyleButton.layout(this.translateWorldSpatial()));
        this.hunterOutlineModeButton = this.guiHelper.createToggleButton(x, y += widgetHeight + padding, widgetWidth, widgetHeight, "Outline Mode", () -> ModOptions.HUNTER_OUTLINE_MODE.getValue().name(), () -> ModOptions.HUNTER_OUTLINE_MODE.setValue(ModOptions.HUNTER_OUTLINE_MODE.getValue().next()));
        this.hunterParticleDensityButton = this.guiHelper.createToggleButton(x, y, widgetWidth, widgetHeight, "Density", () -> ModOptions.HUNTER_PARTICLE_DENSITY.getValue().name(), () -> ModOptions.HUNTER_PARTICLE_DENSITY.setValue(ModOptions.HUNTER_PARTICLE_DENSITY.getValue().next()));
        this.hunterOutlineThicknessButton = this.guiHelper.createToggleButton(x, y += widgetHeight, widgetWidth, widgetHeight, "Outline Thickness", () -> ModOptions.HUNTER_OUTLINE_THICKNESS.getValue().name(), () -> ModOptions.HUNTER_OUTLINE_THICKNESS.setValue(ModOptions.HUNTER_OUTLINE_THICKNESS.getValue().next()));
        y += widgetHeight + padding;
        if (ModOptions.HUNTER_PARTICLES.getValue().booleanValue()) {
            this.addElement((ToggleButtonElement)this.hunterParticleDensityButton.layout(this.translateWorldSpatial()));
        } else {
            this.addElement((ToggleButtonElement)this.hunterOutlineModeButton.layout(this.translateWorldSpatial()));
            this.addElement((ToggleButtonElement)this.hunterOutlineThicknessButton.layout(this.translateWorldSpatial()));
        }
        this.targetColorButton = this.guiHelper.createToggleButton(x, y, widgetWidth, widgetHeight, "Hunter Color", () -> this.selectedTarget.name(), () -> {
            this.selectedTarget = this.selectedTarget.next();
            if (this.colorPickerElement != null) {
                this.colorPickerElement.updateFromColor(new Color(ModOptions.getHunterColor(this.selectedTarget, -1)));
            }
        });
        this.addElement((ToggleButtonElement)this.targetColorButton.layout(this.translateWorldSpatial()));
        int colorPickerHeight = widgetHeight * 4;
        this.colorPickerElement = new ColorPickerElement(Spatials.positionXY(x, y += widgetHeight).size(widgetWidth, colorPickerHeight), () -> new Color(ModOptions.getHunterColor(this.selectedTarget, -1)), this::updateColorFromPicker);
        this.addElement((ColorPickerElement)this.colorPickerElement.layout(this.translateWorldSpatial()));
        int colorPickerBottomY = y + colorPickerHeight;
        this.resetColorButton = this.guiHelper.createSimpleButton(x, colorPickerBottomY, widgetWidth, widgetHeight, "Reset Color", this::resetToDefaultColor, null, null, null, this.translateWorldSpatial());
        this.addElement(this.resetColorButton);
        this.doneButton = this.guiHelper.createSimpleButton(x, y += colorPickerHeight + widgetHeight + padding, widgetWidth, widgetHeight, "Done", this::saveAndClose, null, null, null, this.translateWorldSpatial());
        this.addElement(this.doneButton);
        this.offsetElements.add(this.targetColorButton);
        this.offsetElements.add(this.colorPickerElement);
        this.offsetElements.add(this.resetColorButton);
        this.offsetElements.add(this.doneButton);
    }

    private void resetToDefaultColor() {
        VaultOption<Integer> option = ModOptions.getHunterColorOption(this.selectedTarget);
        if (option != null) {
            option.resetToDefault();
        }
    }

    private void updateColorFromPicker(Color newColor) {
        VaultOption<Integer> option = ModOptions.getHunterColorOption(this.selectedTarget);
        if (option != null) {
            option.setValue(newColor.getRGB());
        }
    }

    private void saveAndClose() {
        this.f_96541_.m_91152_(this.lastScreen);
    }

    @Override
    @NotNull
    protected ILayoutStrategy translateWorldSpatial() {
        return (screen, gui, parent, world) -> world.translateXY(screen.width() / 2 - 150, 36);
    }

    @Override
    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
            this.m_7333_(poseStack);
        } else {
            this.m_96626_(0);
        }
        HunterOptionsSubmenu.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)20, (int)0xFFFFFF);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    @Override
    protected void renderBackgroundFill(@NotNull PoseStack poseStack) {
    }

    public void m_96626_(int pVOffset) {
        super.m_96626_(pVOffset);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_93096_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferbuilder.m_5483_(0.0, (double)this.f_96544_ - 32.0, 0.0).m_7421_(0.0f, (float)this.f_96544_ / 32.0f + (float)pVOffset).m_6122_(32, 32, 32, 255).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, (double)this.f_96544_ - 32.0, 0.0).m_7421_((float)this.f_96543_ / 32.0f, (float)this.f_96544_ / 32.0f + (float)pVOffset).m_6122_(32, 32, 32, 255).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, 32.0, 0.0).m_7421_((float)this.f_96543_ / 32.0f, (float)pVOffset).m_6122_(32, 32, 32, 255).m_5752_();
        bufferbuilder.m_5483_(0.0, 32.0, 0.0).m_7421_(0.0f, (float)pVOffset).m_6122_(32, 32, 32, 255).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69456_((int)515);
        RenderSystem.m_69465_();
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.m_69472_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_5483_(0.0, 36.0, 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, 36.0, 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, 32.0, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferbuilder.m_5483_(0.0, 32.0, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferbuilder.m_5483_(0.0, (double)(this.f_96544_ - 32), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, (double)(this.f_96544_ - 32), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, (double)(this.f_96544_ - 36), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        bufferbuilder.m_5483_(0.0, (double)(this.f_96544_ - 36), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        tesselator.m_85914_();
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.lastScreen);
    }
}

