/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.accessibility;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.VaultMod;
import iskallia.vault.client.render.HudPosition;
import iskallia.vault.client.render.IVaultOptions;
import iskallia.vault.config.VaultModifierOverlayConfig;
import iskallia.vault.core.vault.overlay.VaultOverlay;
import iskallia.vault.init.ModConfigs;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class InventoryHudEditScreen
extends Screen {
    private final Screen parent;
    private IVaultOptions vaultOptions;
    private String draggingKey = null;
    private int offsetX;
    private int offsetY;
    private final int GRID_SIZE = 8;

    public InventoryHudEditScreen(Screen parent) {
        super(Component.m_130674_((String)"Edit HUD Settings"));
        this.parent = parent;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.vaultOptions = (IVaultOptions)Minecraft.m_91087_().f_91066_;
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 60, 10, 50, 20, Component.m_130674_((String)"Done"), btn -> Minecraft.m_91087_().m_91152_(this.parent)));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 120, 10, 50, 20, Component.m_130674_((String)"Reset"), btn -> {
            for (String key : this.buildSlotKeys()) {
                this.vaultOptions.setHudPosition(key, this.computeDefaultPosition(key));
            }
        }));
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (InventoryHudEditScreen.m_96639_()) {
            this.renderGrid(poseStack);
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        List<String> keys = this.buildSlotKeys();
        LinkedHashMap<String, HudPosition> saved = new LinkedHashMap<String, HudPosition>(this.vaultOptions.getHudPositions());
        for (String key : keys) {
            HudPosition pos = saved.getOrDefault(key, this.computeDefaultPosition(key));
            this.renderHudIcon(poseStack, key, pos.getScaledX(this.f_96543_), pos.getScaledY(this.f_96544_));
        }
    }

    private void renderGrid(PoseStack poseStack) {
        int y;
        int x;
        int gridColor = 0x44FFFFFF;
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        for (x = centerX; x >= 0; x -= 8) {
            InventoryHudEditScreen.m_93172_((PoseStack)poseStack, (int)x, (int)0, (int)(x + 1), (int)this.f_96544_, (int)gridColor);
        }
        for (x = centerX + 8; x < this.f_96543_; x += 8) {
            InventoryHudEditScreen.m_93172_((PoseStack)poseStack, (int)x, (int)0, (int)(x + 1), (int)this.f_96544_, (int)gridColor);
        }
        for (y = centerY; y >= 0; y -= 8) {
            InventoryHudEditScreen.m_93172_((PoseStack)poseStack, (int)0, (int)y, (int)this.f_96543_, (int)(y + 1), (int)gridColor);
        }
        for (y = centerY + 8; y < this.f_96544_; y += 8) {
            InventoryHudEditScreen.m_93172_((PoseStack)poseStack, (int)0, (int)y, (int)this.f_96543_, (int)(y + 1), (int)gridColor);
        }
    }

    private void renderHudIcon(PoseStack poseStack, String key, int x, int y) {
        if ("potions".equals(key)) {
            int width = 48;
            int height = 16;
            InventoryHudEditScreen.m_93172_((PoseStack)poseStack, (int)(x - 1), (int)(y - 1), (int)(x + width + 1), (int)(y + height + 1), (int)-16777216);
            InventoryHudEditScreen.m_93172_((PoseStack)poseStack, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)-7644522);
            Font font = Minecraft.m_91087_().f_91062_;
            String text = "Effects";
            int textWidth = font.m_92895_(text);
            int textX = x + (width - textWidth) / 2;
            Objects.requireNonNull(font);
            int textY = y + (height - 9) / 2 + 1;
            font.m_92750_(poseStack, text, (float)textX, (float)textY, -1);
        } else if ("modifiers".equals(key)) {
            int width = 48;
            int height = 16;
            InventoryHudEditScreen.m_93172_((PoseStack)poseStack, (int)(x - 1), (int)(y - 1), (int)(x + width + 1), (int)(y + height + 1), (int)-16777216);
            InventoryHudEditScreen.m_93172_((PoseStack)poseStack, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)-7644522);
            Font font = Minecraft.m_91087_().f_91062_;
            String text = "Modifiers";
            int textWidth = font.m_92895_(text);
            int textX = x + (width - textWidth) / 2;
            Objects.requireNonNull(font);
            int textY = y + (height - 9) / 2 + 1;
            font.m_92750_(poseStack, text, (float)textX, (float)textY, -1);
        } else if ("ability_bar".equals(key)) {
            ResourceLocation bg = VaultMod.id("textures/gui/abilities/overlay_tray_bg.png");
            RenderSystem.m_157456_((int)0, (ResourceLocation)bg);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Gui.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)62, (int)36, (int)62, (int)36);
            RenderSystem.m_157456_((int)0, (ResourceLocation)Gui.f_93098_);
        } else if ("cooldowns".equals(key)) {
            int width = 48;
            int height = 16;
            InventoryHudEditScreen.m_93172_((PoseStack)poseStack, (int)(x - 1), (int)(y - 1), (int)(x + width + 1), (int)(y + height + 1), (int)-16777216);
            InventoryHudEditScreen.m_93172_((PoseStack)poseStack, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)-7644522);
            Font font = Minecraft.m_91087_().f_91062_;
            String text = "Cooldown";
            int textWidth = font.m_92895_(text);
            int textX = x + (width - textWidth) / 2;
            Objects.requireNonNull(font);
            int textY = y + (height - 9) / 2 + 1;
            font.m_92750_(poseStack, text, (float)textX, (float)textY, -1);
        } else if ("timer".equals(key)) {
            int width = 12;
            int height = 16;
            RenderSystem.m_157456_((int)0, (ResourceLocation)VaultOverlay.VAULT_HUD);
            Gui.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)1.0f, (float)36.0f, (int)width, (int)height, (int)256, (int)256);
            RenderSystem.m_157456_((int)0, (ResourceLocation)Gui.f_93098_);
        } else {
            ResourceLocation baseTexture = VaultMod.id("textures/gui/inventory_hud/" + key + "_base.png");
            ResourceLocation overlayTexture = VaultMod.id("textures/gui/inventory_hud/" + key + "_overlay.png");
            if ("trinket_1".equals(key)) {
                baseTexture = VaultMod.id("textures/gui/inventory_hud/red_trinket.png");
            } else if ("trinket_2".equals(key)) {
                baseTexture = VaultMod.id("textures/gui/inventory_hud/blue_trinket.png");
            } else if ("backpack".equals(key)) {
                baseTexture = VaultMod.id("textures/gui/inventory_hud/pouch_base.png");
                overlayTexture = VaultMod.id("textures/gui/inventory_hud/pouch_overlay.png");
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)baseTexture);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Gui.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            if (!key.contains("trinket")) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)overlayTexture);
                Gui.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)Gui.f_93098_);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return super.m_6375_(mouseX, mouseY, button);
        }
        for (String key : this.buildSlotKeys()) {
            int height;
            int width;
            HudPosition pos = this.vaultOptions.getHudPositions().getOrDefault(key, this.computeDefaultPosition(key));
            if ("potions".equals(key)) {
                width = 50;
                height = 18;
            } else if ("modifiers".equals(key)) {
                width = 50;
                height = 18;
            } else if ("ability_bar".equals(key)) {
                width = 62;
                height = 36;
            } else if ("cooldowns".equals(key)) {
                width = 50;
                height = 18;
            } else if ("timer".equals(key)) {
                width = 12;
                height = 16;
            } else {
                width = 16;
                height = 16;
            }
            int positionOrModifier = "potions".equals(key) || "modifiers".equals(key) ? 1 : 0;
            int left = pos.getScaledX(this.f_96543_) - positionOrModifier;
            int top = pos.getScaledY(this.f_96544_) - positionOrModifier;
            int right = left + width;
            int bottom = top + height;
            if (!(mouseX >= (double)left) || !(mouseX < (double)right) || !(mouseY >= (double)top) || !(mouseY < (double)bottom)) continue;
            this.draggingKey = key;
            this.offsetX = (int)mouseX - pos.getScaledX(this.f_96543_);
            this.offsetY = (int)mouseY - pos.getScaledY(this.f_96544_);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0 && this.draggingKey != null) {
            int newX = (int)(mouseX - (double)this.offsetX);
            int newY = (int)(mouseY - (double)this.offsetY);
            if (InventoryHudEditScreen.m_96639_()) {
                int centerX = Minecraft.m_91087_().m_91268_().m_85445_() / 2;
                int centerY = Minecraft.m_91087_().m_91268_().m_85446_() / 2;
                newX = centerX + (newX - centerX + 4) / 8 * 8;
                newY = centerY + (newY - centerY + 4) / 8 * 8;
            }
            this.vaultOptions.setHudPosition(this.draggingKey, HudPosition.fromPixels(newX, newY, this.f_96543_, this.f_96544_));
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.draggingKey != null) {
            this.draggingKey = null;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    private List<String> buildSlotKeys() {
        return List.of("helmet", "chestplate", "leggings", "boots", "trinket_1", "trinket_2", "void_stone", "god_charm", "magnet", "backpack", "potions", "modifiers", "ability_bar", "cooldowns", "timer");
    }

    private HudPosition computeDefaultPosition(String key) {
        int screenWidth = Minecraft.m_91087_().m_91268_().m_85445_();
        int screenHeight = Minecraft.m_91087_().m_91268_().m_85446_();
        int baseX = screenWidth / 2 + 91;
        int centerX = screenWidth / 2;
        return switch (key) {
            case "helmet" -> HudPosition.fromPixels(centerX - 163, screenHeight - 68, screenWidth, screenHeight);
            case "chestplate" -> HudPosition.fromPixels(centerX - 163, screenHeight - 52, screenWidth, screenHeight);
            case "leggings" -> HudPosition.fromPixels(centerX - 163, screenHeight - 36, screenWidth, screenHeight);
            case "boots" -> HudPosition.fromPixels(centerX - 163, screenHeight - 20, screenWidth, screenHeight);
            case "trinket_1" -> HudPosition.fromPixels(centerX + 91, screenHeight - 20, screenWidth, screenHeight);
            case "trinket_2" -> HudPosition.fromPixels(centerX + 91 + 18, screenHeight - 20, screenWidth, screenHeight);
            case "void_stone" -> HudPosition.fromPixels(centerX + 91 + 36, screenHeight - 20, screenWidth, screenHeight);
            case "god_charm" -> HudPosition.fromPixels(centerX + 91 + 54, screenHeight - 20, screenWidth, screenHeight);
            case "magnet" -> HudPosition.fromPixels(centerX + 91 + 72, screenHeight - 20, screenWidth, screenHeight);
            case "backpack" -> HudPosition.fromPixels(centerX + 91 + 90, screenHeight - 20, screenWidth, screenHeight);
            case "potions" -> HudPosition.fromPixels(screenWidth - 28, 4, screenWidth, screenHeight);
            case "modifiers" -> {
                VaultModifierOverlayConfig cfg = ModConfigs.VAULT_MODIFIER_OVERLAY;
                int x = screenWidth - cfg.rightMargin - cfg.size;
                int y = screenHeight - cfg.bottomMargin - cfg.size;
                yield HudPosition.fromPixels(x, y, screenWidth, screenHeight);
            }
            case "ability_bar" -> HudPosition.fromPixels(10, screenHeight - 36, screenWidth, screenHeight);
            case "cooldowns" -> {
                HudPosition ability = HudPosition.fromPixels(10, screenHeight - 36, screenWidth, screenHeight);
                yield HudPosition.fromPixels(ability.getScaledX(screenWidth) + 3, ability.getScaledY(screenHeight) - 20, screenWidth, screenHeight);
            }
            case "timer" -> HudPosition.fromPixels(92, screenHeight - 25, screenWidth, screenHeight);
            default -> HudPosition.fromPixels(0, 0, screenWidth, screenHeight);
        };
    }

    public boolean m_7043_() {
        return false;
    }
}

