/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.client.gui.screen.accessibility;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import iskallia.vault.client.gui.framework.ScreenRenderers;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.NineSliceButtonElement;
import iskallia.vault.client.gui.framework.element.SliderElement;
import iskallia.vault.client.gui.framework.element.ToggleButtonElement;
import iskallia.vault.client.gui.framework.element.spi.AbstractSpatialElement;
import iskallia.vault.client.gui.framework.element.spi.ILayoutStrategy;
import iskallia.vault.client.gui.framework.render.ScreenTooltipRenderer;
import iskallia.vault.client.gui.framework.screen.AbstractElementScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import iskallia.vault.client.gui.screen.accessibility.InventoryHudEditScreen;
import iskallia.vault.client.render.IVaultOptions;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class InventoryHudSettingsScreen
extends AbstractElementScreen {
    private final Screen lastScreen;
    private IVaultOptions options;

    public InventoryHudSettingsScreen(Screen parent) {
        super((Component)new TextComponent("HUD Settings"), ScreenRenderers.getBuffered(), ScreenTooltipRenderer::create);
        Window window = Minecraft.m_91087_().m_91268_();
        this.setGuiSize(Spatials.size(window.m_85445_(), window.m_85446_()));
        this.lastScreen = parent;
        this.options = (IVaultOptions)Minecraft.m_91087_().f_91066_;
        this.initializeElements();
    }

    private void initializeElements() {
        int padding = 4;
        int widgetWidth = 150;
        int widgetHeight = 20;
        int startX = 0;
        int startY = 0;
        int x = startX;
        int y = startY;
        this.addElement((ToggleButtonElement)new ToggleButtonElement(Spatials.positionXY(x, y).size(widgetWidth, widgetHeight), (Component)new TextComponent("Display Mode"), () -> this.options.isShowHudOnlyOnTab() ? "KEYBIND" : "ALWAYS", this.options::toggleHudShowOnlyOnTab).layout(this.translateWorldSpatial()));
        this.addElement((ToggleButtonElement)new ToggleButtonElement(Spatials.positionXY(x += widgetWidth + padding, y).size(widgetWidth, widgetHeight), (Component)new TextComponent("Percentage Display"), () -> this.options.getInventoryHudPercentageDisplayMode().getSerializedName(), this.options::cycleInventoryHudPercentageDisplayMode).layout(this.translateWorldSpatial()));
        x = startX;
        this.addElement((ToggleButtonElement)new ToggleButtonElement(Spatials.positionXY(x, y += widgetHeight + padding).size(widgetWidth, widgetHeight), (Component)new TextComponent("Gear Indicator"), () -> this.options.getGearVisibilityMode().getSerializedName().toUpperCase(), this.options::cycleGearVisibilityMode).layout(this.translateWorldSpatial()));
        this.addElement((ToggleButtonElement)new ToggleButtonElement(Spatials.positionXY(x += widgetWidth + padding, y).size(widgetWidth, widgetHeight), (Component)new TextComponent("Uses Items Indicator"), () -> this.options.getUsesVisibilityMode().getSerializedName().toUpperCase(), this.options::cycleUsesVisibilityMode).layout(this.translateWorldSpatial()));
        x = startX;
        this.addElement((ToggleButtonElement)new ToggleButtonElement(Spatials.positionXY(x, y += widgetHeight + padding).size(widgetWidth, widgetHeight), (Component)new TextComponent("Gear Display Mode"), () -> this.options.getInventoryHudMode().getSerializedName(), this.options::cycleInventoryHudDisplayMode).layout(this.translateWorldSpatial()));
        this.addElement((ToggleButtonElement)new ToggleButtonElement(Spatials.positionXY(x += widgetWidth + padding, y).size(widgetWidth, widgetHeight), (Component)new TextComponent("Uses Display Mode"), () -> this.options.getInventoryUsesHudMode().getSerializedName(), this.options::cycleInventoryUsesHudDisplayMode).layout(this.translateWorldSpatial()));
        x = startX;
        this.addElement((ToggleButtonElement)new ToggleButtonElement(Spatials.positionXY(x, y += widgetHeight + padding).size(widgetWidth, widgetHeight), (Component)new TextComponent("Uses Text Position"), () -> this.options.getUsesItemsTextPositionMode().getSerializedName(), this.options::cycleUsesItemsTextPositionMode).layout(this.translateWorldSpatial()));
        this.addElement((SliderElement)new SliderElement(Spatials.positionXY(x += widgetWidth + padding, y).size(widgetWidth, widgetHeight), () -> new TextComponent(String.format("HUD Size: %d%%", (int)(this.options.getInvHudScale() * 100.0f))), () -> Float.valueOf(this.options.getInvHudScale() - 0.5f), val -> this.options.setInvHudScale(0.5f + val.floatValue() * 1.0f)).hidePercentage(true).layout(this.translateWorldSpatial()));
        x = startX;
        this.addElement((ToggleButtonElement)new ToggleButtonElement(Spatials.positionXY(x, y += widgetHeight + padding).size(widgetWidth, widgetHeight), (Component)new TextComponent("Potion Visibility"), () -> this.options.getShowPotionVisibility() ? "ON" : "OFF", this.options::toggleShowPotionVisibility).layout(this.translateWorldSpatial()));
        this.addElement((SliderElement)new SliderElement(Spatials.positionXY(x += widgetWidth + padding, y).size(widgetWidth, widgetHeight), () -> new TextComponent(String.format("Potion Size: %d%%", (int)(this.options.getPotionScale() * 100.0f))), () -> Float.valueOf(this.options.getPotionScale() - 0.5f), val -> this.options.setPotionScale(0.5f + val.floatValue() * 1.0f)).hidePercentage(true).layout(this.translateWorldSpatial()));
        x = startX;
        this.addElement((ToggleButtonElement)new ToggleButtonElement(Spatials.positionXY(x, y += widgetHeight + padding).size(widgetWidth, widgetHeight), (Component)new TextComponent("Abilities with Mana Bar"), () -> this.options.isShowAbilitiesWithManaBar() ? "ON" : "OFF", this.options::toggleShowAbilitiesWithManaBar).layout(this.translateWorldSpatial()));
        this.addElement((SliderElement)new SliderElement(Spatials.positionXY(x += widgetWidth + padding, y).size(widgetWidth, widgetHeight), () -> new TextComponent(String.format("Modifier List Scale: %d%%", (int)(this.options.getModifierListScale() * 100.0f))), () -> Float.valueOf(this.options.getModifierListScale() - 0.5f), val -> this.options.setModifierListScale(0.5f + val.floatValue() * 1.0f)).hidePercentage(true).layout(this.translateWorldSpatial()));
        x = startX;
        this.addElement((ToggleButtonElement)new ToggleButtonElement(Spatials.positionXY(x, y += widgetHeight + padding).size(widgetWidth, widgetHeight), (Component)new TextComponent("Cooldown GUI"), () -> this.options.getCooldownOption().getSerializedNameUpper(), this.options::cycleCooldownGuiOption).layout(this.translateWorldSpatial()));
        this.addElement((NineSliceButtonElement)((AbstractSpatialElement)new NineSliceButtonElement(Spatials.positionXY(x += widgetWidth + padding, y).size(widgetWidth, widgetHeight), ScreenTextures.BUTTON_EMPTY_TEXTURES, () -> this.f_96541_.m_91152_((Screen)new InventoryHudEditScreen(this))).label(() -> new TextComponent("Edit HUD Positions"), LabelTextStyle.shadow().center())).layout(this.translateWorldSpatial()));
        x = startX;
        this.addElement((ToggleButtonElement)new ToggleButtonElement(Spatials.positionXY(x, y += widgetHeight + padding).size(widgetWidth, widgetHeight), (Component)new TextComponent("Backpack Display"), () -> this.options.getBackpackHudMode().getSerializedName(), this.options::cycleBackpackHudMode).layout(this.translateWorldSpatial()));
        x = startX + widgetWidth / 2;
        this.addElement((NineSliceButtonElement)((AbstractSpatialElement)new NineSliceButtonElement(Spatials.positionXY(x, y += widgetHeight + padding).size(widgetWidth, widgetHeight), ScreenTextures.BUTTON_EMPTY_TEXTURES, this::m_7379_).label(() -> new TextComponent("Done"), LabelTextStyle.shadow().center())).layout(this.translateWorldSpatial()));
    }

    @Override
    @NotNull
    public ILayoutStrategy translateWorldSpatial() {
        return (screen, gui, parent, world) -> world.translateXY(screen.width() / 2 - 150, 36);
    }

    @Override
    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
            this.m_7333_(poseStack);
        } else {
            this.m_96626_(0);
        }
        InventoryHudSettingsScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)20, (int)0xFFFFFF);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    @Override
    protected void renderBackgroundFill(@NotNull PoseStack poseStack) {
    }

    public void m_96626_(int pVOffset) {
        super.m_96626_(pVOffset);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_93096_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferbuilder.m_5483_(0.0, (double)this.f_96544_ - 32.0, 0.0).m_7421_(0.0f, (float)this.f_96544_ / 32.0f + (float)pVOffset).m_6122_(32, 32, 32, 255).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, (double)this.f_96544_ - 32.0, 0.0).m_7421_((float)this.f_96543_ / 32.0f, (float)this.f_96544_ / 32.0f + (float)pVOffset).m_6122_(32, 32, 32, 255).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, 32.0, 0.0).m_7421_((float)this.f_96543_ / 32.0f, (float)pVOffset).m_6122_(32, 32, 32, 255).m_5752_();
        bufferbuilder.m_5483_(0.0, 32.0, 0.0).m_7421_(0.0f, (float)pVOffset).m_6122_(32, 32, 32, 255).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69456_((int)515);
        RenderSystem.m_69465_();
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.m_69472_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_5483_(0.0, 36.0, 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, 36.0, 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, 32.0, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferbuilder.m_5483_(0.0, 32.0, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferbuilder.m_5483_(0.0, (double)(this.f_96544_ - 32), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, (double)(this.f_96544_ - 32), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        bufferbuilder.m_5483_((double)this.f_96543_, (double)(this.f_96544_ - 36), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        bufferbuilder.m_5483_(0.0, (double)(this.f_96544_ - 36), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
        tesselator.m_85914_();
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.lastScreen);
    }
}

